VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsReporteProceso"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 90

Private sTagWorker As String, sTagDepto As String
Private fView As lfQuickView, pProceso As clsProcesoNomina

Private qWorkersDepto As Integer, qWorkersTotal As Integer

Private TotalesDepartamento As Collection   ' of clsTotalesDepartamento
Private TotalesTrabajador As Collection     ' of clsTotalesDepartamento
Private TotalGeneral As Collection

Private totAsig As Currency, totDed As Currency, totAportes As Currency

Private Sub Encabezado()
    If fView.Linea > 1 Or fView.Pagina > 1 Then
        fView.PageBreak
    End If
    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Resumen de Nomina", vbCenter
    fView.Add "Proceso: " & pProceso.Referencia & ". Fecha de Cierre: " & Format(pProceso.FechaCierre, "Short Date"), vbCenter
    fView.Add ""
    fView.Add "Perodo comprendido entre el " & Format(pProceso.FechaInicio, "Short Date") & " y el " & Format(pProceso.FechaCierre, "Short Date")
    fView.Add "Tipo de proceso (script): " & pProceso.CodigoScript
    fView.Add ""
    fView.Add "Emisin: " & Format(Now, "General Date") & ".  OPERADOR: " & UsuarioActivo.Codigo

End Sub

Private Function TotalTipo(pCol As Collection, ByVal inTipo As Integer) As Currency
Dim n As Integer, vmAcum As Currency, pRover As clsTotalesDepartamento

    vmAcum = 0
    For Each pRover In pCol
        If pRover.Tipo = inTipo Then
            vmAcum = vmAcum + pRover.vmTotal
        End If
    Next

    TotalTipo = vmAcum

End Function

Private Sub SoltarLinea(istrCodigo As String, istrDescripcion As String, vmMonto As Currency, vmTotal As Currency)
Dim sOut As String

    sOut = stFullLength(istrCodigo, 8) & " " & stFullLength(istrDescripcion, 50) & " " & FormatNumero(vmMonto, "##,###,##0.00", 13) & " " & FormatNumero(vmTotal, "#,###,###,##0.00", 16)
    fView.Add sOut

End Sub

Private Sub SoltarSegmento(pSegmento As Collection)
      Dim pDetalle As clsTotalesDepartamento, icTipo As Integer
      Dim vmAsig As Currency, vmDed As Currency, vmAportes As Currency
      Dim sTemp As String, vmTemp As Currency

10      On Error GoTo ErrHandler

20        vmAsig = TotalTipo(pSegmento, TAD_ASIGNACION)
30        vmDed = TotalTipo(pSegmento, TAD_DEDUCCION)
40        vmAportes = TotalTipo(pSegmento, TAD_APORTE)

50        icTipo = -1
          
60        fView.Add String(AnchoReporte, "-")
70        fView.Add "Codigo   Concepto                                                   Monto          Totales"
80        fView.Add String(AnchoReporte, "-")
          
90        For Each pDetalle In pSegmento

100           If pDetalle.Tipo <> icTipo Then
110               If icTipo >= 0 Then
120                   Select Case icTipo
                      Case 0
130                       sTemp = "Total Asignaciones"
140                       vmTemp = vmAsig
150                   Case 1
160                       sTemp = "Total Deducciones"
170                       vmTemp = vmDed
180                   End Select
                      
190                   SoltarLinea "*", sTemp, 0, vmTemp
200                   If pDetalle.Tipo = 2 Then
210                       SoltarLinea "**", "Neto a pagar", 0, vmAsig - vmDed
220                   End If
230               End If
240               icTipo = pDetalle.Tipo
250           End If
              
260           SoltarLinea pDetalle.CodigoGrupo, ptCodigosReporte.Nombre(pDetalle.CodigoGrupo), pDetalle.vmTotal, 0
          
270       Next

280       If icTipo < 0 Then icTipo = pDetalle.Tipo

290       Select Case icTipo
          Case 0
300           sTemp = "Total Asignaciones"
310           vmTemp = vmAsig
320       Case 1
330           sTemp = "Total Deducciones"
340           vmTemp = vmDed
350       Case 2
360           sTemp = "Total Aportes Patronales"
370           vmTemp = vmAportes
380       End Select
390       SoltarLinea "*", sTemp, 0, vmTemp
400       If icTipo <> 2 Then
410           SoltarLinea "**", "Neto a pagar", 0, vmAsig - vmDed
420       End If
430       SoltarLinea "***", "Costo total", 0, vmAsig + vmAportes
440       fView.Add ""

ResumePoint:
450     Exit Sub

ErrHandler:
      Dim sErrD As String, nErrN As Long
460     sErrD = Err.Description: nErrN = Err.Number
470     Err.Clear
480     Err.Raise nErrN, "SoltarSegmento (ERL =" & Erl & ")", sErrD
490     Resume ResumePoint
End Sub
'----------------------------------------------------------------------------------------
'Codigo   Concepto                                                   Monto        Totales
'----------------------------------------------------------------------------------------
'XXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99.999.999,99 999.999.999,99

Private Sub SueltaTrabajador()
Dim nReqLines As Integer, icTipo As Integer
Dim pWorker As clsTrabajador, pDetalle As clsTotalesDepartamento
Dim vmAsig As Currency, vmDed As Currency, vmAportes As Currency
Dim sTemp As String, vmTemp As Currency


  On Error GoTo ErrHandler

    If sTagWorker = "" Then Exit Sub
    vmAsig = TotalTipo(TotalesTrabajador, TAD_ASIGNACION)
    vmDed = TotalTipo(TotalesTrabajador, TAD_DEDUCCION)
    vmAportes = TotalTipo(TotalesTrabajador, TAD_APORTE)

    nReqLines = TotalesTrabajador.Count
    If vmAsig + vmDed <> 0 Then nReqLines = nReqLines + 1
    If vmAsig <> 0 Then nReqLines = nReqLines + 1
    If vmDed <> 0 Then nReqLines = nReqLines + 1
    If vmAportes <> 0 Then nReqLines = nReqLines + 1
    nReqLines = nReqLines + 6

    If fView.Linea + nReqLines > fView.LineasPagina - 2 Then
        Encabezado
    End If
    
    qWorkersDepto = qWorkersDepto + 1

    Set pWorker = New clsTrabajador
    If Not pWorker.Load(sTagWorker) Then
        mAdvertencia "ERROR: Trabajador no localizado (" & sTagWorker & ")"
        Exit Sub
    End If
    fView.Add "Trabajador: " & pWorker.Nombre & " (" & sTagWorker & ")"
    fView.Add "Departamento: " & pWorker.Departamento
    Set pWorker = Nothing

    For Each pDetalle In TotalesTrabajador
        AcumTotales TotalesDepartamento, pDetalle.CodigoGrupo, pDetalle.Tipo, pDetalle.vmTotal
    Next

    SoltarSegmento TotalesTrabajador

    Set TotalesTrabajador = Nothing
    Set TotalesTrabajador = New Collection

ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  Err.Clear
  Err.Raise nErrN, "Suelta Trabajador (ERL =" & Erl & ")", sErrD
  Resume ResumePoint
End Sub

Private Sub SueltaTotales()
Dim nReqLines As Integer, icTipo As Integer
Dim pWorker As clsTrabajador, pDetalle As clsTotalesDepartamento
Dim vmAsig As Currency, vmDed As Currency, vmAportes As Currency
Dim sTemp As String, vmTemp As Currency

    If sTagDepto = "" Then Exit Sub
    vmAsig = TotalTipo(TotalesDepartamento, TAD_ASIGNACION)
    vmDed = TotalTipo(TotalesDepartamento, TAD_DEDUCCION)
    vmAportes = TotalTipo(TotalesDepartamento, TAD_APORTE)

    Encabezado

    fView.Add "Totales Generales"
    fView.Add "Trabajadores: " & qWorkersTotal

    SoltarSegmento TotalGeneral

End Sub

Private Sub SueltaDepartamento()
Dim nReqLines As Integer, icTipo As Integer
Dim pWorker As clsTrabajador, pDetalle As clsTotalesDepartamento
Dim vmAsig As Currency, vmDed As Currency, vmAportes As Currency
Dim sTemp As String, vmTemp As Currency

    If sTagDepto = "" Then Exit Sub
    vmAsig = TotalTipo(TotalesDepartamento, TAD_ASIGNACION)
    vmDed = TotalTipo(TotalesDepartamento, TAD_DEDUCCION)
    vmAportes = TotalTipo(TotalesDepartamento, TAD_APORTE)

    Encabezado

    fView.Add "Departamento: " & ptDepartamentos.Item(sTagDepto).Descripcion & " (" & sTagDepto & ")"
    fView.Add "Trabajadores: " & qWorkersDepto

    SoltarSegmento TotalesDepartamento

    For Each pDetalle In TotalesDepartamento
        AcumTotales TotalGeneral, pDetalle.CodigoGrupo, pDetalle.Tipo, pDetalle.vmTotal
    Next
    
    qWorkersTotal = qWorkersTotal + qWorkersDepto
    qWorkersDepto = 0
    Set TotalesDepartamento = Nothing
    Set TotalesDepartamento = New Collection

End Sub

Private Sub AcumTotales(pDestCol As Collection, istrCodGrup As String, nTipo As Integer, ivmValor As Currency)
Dim pSearch As clsTotalesDepartamento, n As Integer, isDone As Boolean

    isDone = False
    For n = 1 To pDestCol.Count

        Set pSearch = pDestCol.Item(n)
        If pSearch.CodigoGrupo = istrCodGrup And pSearch.Tipo = nTipo Then
            pSearch.vmTotal = pSearch.vmTotal + ivmValor
            isDone = True
            Exit For
        End If

        If (pSearch.Tipo > nTipo) Or (pSearch.Tipo = nTipo And pSearch.CodigoGrupo > istrCodGrup) Then
            Set pSearch = New clsTotalesDepartamento
            pSearch.CodigoGrupo = istrCodGrup
            pSearch.Tipo = nTipo
            pSearch.vmTotal = ivmValor
            pDestCol.Add pSearch, , n
            isDone = True
            Exit For
        End If

    Next

    If Not isDone Then
        Set pSearch = New clsTotalesDepartamento
        pSearch.Tipo = nTipo
        pSearch.CodigoGrupo = istrCodGrup
        pSearch.vmTotal = ivmValor
        pDestCol.Add pSearch
    End If

End Sub

Private Sub AddLinea(istrCodTrab As String, istrCodDepto As String, istrCodGrup As String, ByVal nTipo As Integer, ByVal ivmValor As Currency)
      Dim isFirstDepto As Boolean

10      On Error GoTo ErrHandler
20      If istrCodDepto <> sTagDepto Then
30        SueltaTrabajador
40        sTagWorker = istrCodTrab
          
50        isFirstDepto = (sTagDepto = "")
60        SueltaDepartamento
70        sTagDepto = istrCodDepto
80        If Not isFirstDepto Then Encabezado
90      End If
        
100     If istrCodTrab <> sTagWorker Then
110       SueltaTrabajador
120       sTagWorker = istrCodTrab
130     End If
        
140     AcumTotales TotalesTrabajador, istrCodGrup, nTipo, ivmValor

ResumePoint:
150     Exit Sub

ErrHandler:
      Dim nErrN As Long, sErrD As String, ErrSrce As String
160     nErrN = Err.Number: sErrD = Err.Description: ErrSrce = Err.Source
170     Err.Clear
180     mAdvertencia "Error (" & nErrN & ") " & sErrD & vbCrLf & "Trabajador = " & istrCodTrab & vbCrLf & "ERL= " & Erl & vbCrLf & "Source=" & ErrSrce
190     Err.Raise nErrN, "ReporteProceso::AddLinea", sErrD
End Sub

Public Sub Generar(istrUSrID As String, ipProceso As clsProcesoNomina)
Dim rs As Recordset

    Screen.MousePointer = vbHourglass
    Set pProceso = ipProceso
    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomTMPResumenProceso WHERE sUserID = " & StringDB(istrUSrID) & " ORDER BY sCodDept, sCodTrab, nTipo, sCodGrup", dbOpenForwardOnly)
    
    If Not rs.EOF Then
        
        Set TotalGeneral = New Collection
        Set TotalesDepartamento = New Collection
        Set TotalesTrabajador = New Collection

        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte

        Encabezado
        
        Do
            
            AddLinea GetStringFromVariant(rs.Fields("sCodTrab")), GetStringFromVariant(rs.Fields("sCodDept")), GetStringFromVariant(rs.Fields("sCodGrup")), GetNumeroFromVariant(rs.Fields("nTipo")), GetNumeroFromVariant(rs.Fields("vmValor"))
            rs.MoveNext

        Loop While Not rs.EOF
    
        SueltaTrabajador
        SueltaDepartamento
        SueltaTotales

        Screen.MousePointer = vbDefault
        ShowNonModal fView
        Unload fView
        Set fView = Nothing

        Set TotalesTrabajador = Nothing
        Set TotalesDepartamento = Nothing
        Set TotalGeneral = Nothing

    End If
    Set rs = Nothing
    Set pProceso = Nothing
    
    Screen.MousePointer = vbDefault

    dbHandle.Execute "DELETE * FROM nomTMPResumenProceso WHERE sUserID = " & StringDB(istrUSrID), dbFailOnError

End Sub

' Poblamiento del reporte...
Public Sub AddDetalle(istrUSrID As String, istrCodTrab As String, istrCodDept As String, istrCodGrup As String, inTipo As Integer, ivmMonto As Currency)
Dim sQuery As String

    If istrCodGrup = "" Then Exit Sub   ' No se incluye en el reporte

    sQuery = "UPDATE nomTMPResumenProceso SET vmValor = vmValor + " & NumeroDB(ivmMonto) & " WHERE "
    sQuery = sQuery & "sUserID = " & StringDB(istrUSrID) & " AND "
    sQuery = sQuery & "sCodDept = " & StringDB(istrCodDept) & " AND "
    sQuery = sQuery & "sCodTrab = " & StringDB(istrCodTrab) & " AND "
    sQuery = sQuery & "nTipo = " & NumeroDB(inTipo) & " AND "
    sQuery = sQuery & "sCodGrup = " & StringDB(istrCodGrup)
    dbHandle.Execute sQuery, dbFailOnError

    If dbHandle.RecordsAffected = 0 Then
        sQuery = "INSERT INTO nomTMPResumenProceso (sUserID, sCodTrab, sCodDept, sCodGrup, nTipo, vmValor) SELECT "
        sQuery = sQuery & StringDB(istrUSrID) & ", "
        sQuery = sQuery & StringDB(istrCodTrab) & ", "
        sQuery = sQuery & StringDB(istrCodDept) & ", "
        sQuery = sQuery & StringDB(istrCodGrup) & ", "
        sQuery = sQuery & NumeroDB(inTipo) & ", "
        sQuery = sQuery & NumeroDB(ivmMonto)
        dbHandle.Execute sQuery, dbFailOnError
    End If

End Sub

'Borrador: eliminado temporalmente
'Dim fSelect As frmDefinirReporte, lnGrupos As Long
'    Set rs = dbHandle.OpenRecordset("SELECT Count(sCodGrup) AS qGrupos FROM (Select DISTINCT sCodGrup From nomTMPResumenProceso WHERE sUserID = " & StringDB(istrUSrID) & ")", dbOpenForwardOnly)
'    If rs.EOF Then
'        lnGrupos = 0
'    Else
'        lnGrupos = GetNumeroFromVariant(rs!qGrupos)
'    End If
'    Set rs = Nothing
'
'    Set fSelect = New frmDefinirReporte
'    fSelect.lblqConceptos.Caption = lnGrupos
'    ShowNonModal fSelect
'
'    Unload fSelect
'    Set fSelect = Nothing


