VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsReimpresionRecibo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Numero As Long
Private Operador As String
Private CodigoScript As String
Private FechaInicio As Date
Private FechaFin As Date
Private FechaCierre As Date

Private NumeroRecibo As Long

Private pScript As clsScript
Private pInterprete As Object
Private pTrabajador As clsTrabajador
Private pProceso As clsProcesoNomina
Private WithEvents pRecibo As clsRecibo
Attribute pRecibo.VB_VarHelpID = -1

Private Function Setup() As Boolean
Dim bRetVal As Boolean
Dim pAsigDed As clsAsigDed

    On Error GoTo ErrHandler
    bRetVal = True

    Set pInterprete = CreateObject("ScriptControl")
    pInterprete.Language = "VBScript"

    ResetGlobalScript
    pGlobalScript.AddObject "Proceso", pProceso
    pGlobalScript.AddObject "Trabajador", pTrabajador
    pGlobalScript.AddObject "Recibo", pRecibo
    pGlobalScript.AddObject "Script", pScript

    pInterprete.AddObject "Proceso", pProceso
    pInterprete.AddObject "Trabajador", pTrabajador
    pInterprete.AddObject "Recibo", pRecibo
    pInterprete.AddObject "Script", pScript
    pInterprete.AddObject "GlobalScript", mMain.pGlobalScript
    pInterprete.AddObject "Factoria", mMain.pFactoria

    pInterprete.AddCode pScript.codeBaseScript ' Contiene todas las definiciones globales del script
    
    pInterprete.Modules.Add "AsigDed"  ' Para separar las asignaciones/deducciones del cdigo general.
    For Each pAsigDed In pScript.AsigDed
10      pInterprete.Modules("AsigDed").AddCode _
            "Function " & pAsigDed.Codigo & vbCrLf & _
            pAsigDed.Formula & vbCrLf & _
            "End Function" & vbCrLf
    Next

ResumePoint:
    Setup = bRetVal
    Exit Function

ErrHandler:
Dim strErrText As String

    If InStr(1, Err.Source, "VBScript") Then
        strErrText = ":" & vbCrLf & pInterprete.Error.Text & " Linea: " & pInterprete.Error.Line
    Else
        strErrText = ""
    End If
    ReportarError False, Err.Number, Err.Description, Err.Source & " en clsReimpresionRecibo::Go" & strErrText
    bRetVal = False

    Resume ResumePoint

End Function

Private Sub Dale()
Dim pDetalleProceso As clsDetalleProceso
Dim pDatosRecibo As clsDatosRecibo
Dim CPrinter As CLinePrinter, sPrinterName As String
Dim colDetalles As Collection

    NumeroRecibo = 1
    
    If Not Setup Then
        Exit Sub
    End If

    Set colDetalles = pTrabajador.DetallesProceso(pProceso.Numero)
    For Each pDetalleProceso In colDetalles
        pRecibo.Acumular pDetalleProceso.CodigoRecibo, Abs(pDetalleProceso.Valor), pDetalleProceso.Tipo
    Next
        
    For Each pDatosRecibo In pScript.Recibos
        sPrinterName = Printer.DeviceName
        Set CPrinter = New CLinePrinter
        CPrinter.SetPrinter pDatosRecibo.NombrePrinter
        pRecibo.PrintRecibo CStr(pDatosRecibo.NombreArchivo), True
        CPrinter.SetPrinter sPrinterName
    Next

    ResetGlobalScript
    Exit Sub

End Sub

Private Sub pRecibo_RequestEvarVal(oResult As Boolean, istrVarID As String, ovRetBuff As Variant, ostrRetBuff As String)
Dim vRetVal As Variant
Dim sRetStr As String

    oResult = False
    Select Case UCase(istrVarID)
    Case "FECHAINICIO", "FECHADESDE"
        oResult = True
        ostrRetBuff = Format(pProceso.FechaInicio, "Short Date")
        ovRetBuff = pProceso.FechaInicio
    Case "FECHAFIN", "FECHAHASTA"
        oResult = True
        ostrRetBuff = Format(pProceso.FechaFin, "Short Date")
        ovRetBuff = pProceso.FechaFin
    Case "FECHACIERRE"
        oResult = True
        ostrRetBuff = Format(pProceso.FechaCierre, "Short Date")
        ovRetBuff = pProceso.FechaCierre
    Case "TIPOSCRIPT", "CODIGOPROCESO"
        oResult = True
        ostrRetBuff = pProceso.CodigoScript
        ovRetBuff = pProceso.CodigoScript
    Case "OPERADOR"
        oResult = True
        ostrRetBuff = pProceso.Operador
        ovRetBuff = pProceso.Operador
    Case "NUMERO"
        oResult = True
        ostrRetBuff = Format(pProceso.Numero, "00000")
        ovRetBuff = pProceso.Numero
    Case "REFERENCIA"
        oResult = True
        ostrRetBuff = pProceso.Referencia
        ovRetBuff = pProceso.Referencia
    Case "NUMERORECIBO"
        oResult = True
        ostrRetBuff = Format(NumeroRecibo, "0000")
        ovRetBuff = pProceso.Numero
    End Select
    If oResult Then Exit Sub    ' Ya pas... Request para el proceso

    oResult = True
    vRetVal = ReadVariableRecibo(pProceso.Numero, istrVarID, pTrabajador.Codigo)
    Select Case varType(vRetVal)
    Case vbBoolean
        ostrRetBuff = IIf(vRetVal, "VERDADERO", "FALSO")
    Case vbByte, vbInteger, vbLong
        ostrRetBuff = Format(vRetVal, "##,###,##0")
    Case vbCurrency, vbDecimal, vbDouble, vbSingle
        ostrRetBuff = Format(vRetVal, "###,###,##0.00")
    Case vbDate
        ostrRetBuff = Format(vRetVal, "Short Date")
    Case vbString, vbVariant
        ostrRetBuff = vRetVal
    Case Else
        oResult = False
    End Select
    ovRetBuff = vRetVal
    If oResult Then Exit Sub    ' Procesado por componente VBS del Proceso
    
    oResult = pTrabajador.EvalVar(CStr(istrVarID), ovRetBuff, sRetStr)
    If oResult Then
        ostrRetBuff = sRetStr
        Exit Sub
    End If                      ' Request para el Trabajador

    oResult = Empresa.EvalVar(CStr(istrVarID), ovRetBuff, sRetStr)
    If oResult Then
        ostrRetBuff = sRetStr
        Exit Sub
    End If                      ' Request para la Empresa

    oResult = True
    vRetVal = pInterprete.Eval(istrVarID)   ' Prueba para el componente VBS del Proceso
'    MsgBox "VarType(vRetVal) = " & VarType(vRetVal)
    Select Case varType(vRetVal)
    Case vbBoolean
        ostrRetBuff = IIf(vRetVal, "VERDADERO", "FALSO")
    Case vbByte, vbInteger, vbLong
        ostrRetBuff = Format(vRetVal, "##,###,##0")
    Case vbCurrency, vbDecimal, vbDouble, vbSingle
        ostrRetBuff = Format(vRetVal, "###,###,##0.00")
    Case vbDate
        ostrRetBuff = Format(vRetVal, "Short Date")
    Case vbString, vbVariant
        ostrRetBuff = vRetVal
    Case Else
        oResult = False
    End Select
    ovRetBuff = vRetVal
    If oResult Then Exit Sub    ' Procesado por componente VBS del Proceso

    oResult = True
    vRetVal = pGlobalScript.Eval(istrVarID)   ' Prueba para el componente VBS Global
    ovRetBuff = vRetVal
    Select Case varType(vRetVal)
    Case vbBoolean
        ostrRetBuff = IIf(vRetVal, "VERDADERO", "FALSO")
    Case vbByte, vbInteger, vbLong
        ostrRetBuff = Format(vRetVal, "##,###,##0")
    Case vbCurrency, vbDecimal, vbDouble, vbSingle
        ostrRetBuff = Format(vRetVal, "###,###,##0.00")
    Case vbDate
        ostrRetBuff = Format(vRetVal, "Short Date")
    Case vbString, vbVariant
        ostrRetBuff = vRetVal
    Case Else
        oResult = False
    End Select

End Sub

Private Sub pRecibo_RequestFormato(pDetalle As Variant, ostrDestBuffer As Variant)

    If scExisteIdentificador(pInterprete, "FormatearDetallesRecibo") Then
        pInterprete.Run "FormatearDetallesRecibo", pDetalle, ostrDestBuffer
        Exit Sub
    End If

    If scExisteIdentificador(pGlobalScript, "FormatearDetallesRecibo") Then
        pGlobalScript.Run "FormatearDetallesRecibo", pDetalle, ostrDestBuffer
        Exit Sub
    End If

End Sub

Public Sub ReimprimirRecibo(iNumProceso As Long, istrCodTrab As String)
Dim pPosicion As clsHistoriaTrabajador

    Set pTrabajador = New clsTrabajador
    If Not pTrabajador.Load(istrCodTrab) Then
        mAdvertencia "clsReimpresionRecibo: Trabajador " & istrCodTrab & " no registrado."
        Set pTrabajador = Nothing
        Exit Sub
    End If

    Set pProceso = New clsProcesoNomina
    If Not pProceso.Load(iNumProceso) Then
        mAdvertencia "clsReimpresionRecibo: Imposible cargar proceso " & iNumProceso
        Set pProceso = Nothing
        Set pTrabajador = Nothing
        Exit Sub
    End If

    Set pScript = New clsScript
    If Not pScript.Load(pProceso.CodigoScript) Then
        mAdvertencia "Imposible recuperar script " & pProceso.CodigoScript
        Set pProceso = Nothing
        Set pTrabajador = Nothing
        Set pScript = Nothing
        Exit Sub
    End If

    Set pRecibo = New clsRecibo
    
    Set pPosicion = pTrabajador.Posicion(pProceso.FechaFin)
    If pPosicion Is Nothing Then
        mAdvertencia "Imposible recuperar posicin del trabajador para el momento del proceso."
        Set pRecibo = Nothing
        Set pProceso = Nothing
        Set pTrabajador = Nothing
        Set pScript = Nothing
        Exit Sub
    End If
        
    With pTrabajador
    .Sueldo = pPosicion.Sueldo
    .BaseSueldo = pPosicion.Base
    .Cargo = pPosicion.Cargo
    .Departamento = pPosicion.Departamento
    End With
    Set pPosicion = Nothing

    Dale

    Set pRecibo = Nothing
    Set pProceso = Nothing
    Set pTrabajador = Nothing
    Set pScript = Nothing
    
End Sub
