VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsRecibo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' La funcin de los recibos es acumular las AsigDed POR recibo,
' y suministrar las variables necesarias para soportar la impresin
' (tarea a cargo del Script)

Public Event RequestFormato(pDetalle, ostrDestBuffer)
Public Event RequestEvarVal(oResult As Boolean, istrVarID As String, ovRetBuff As Variant, ostrRetBuff As String)

Public pScript As clsScript

Private NombreFormato As String
Private AcumuladorResultados As Collection

Public Sub PrintRecibo(istrFileName As String, bDoPreview As Boolean)
Dim pFormater As CFormatoDocumento

    NombreFormato = istrFileName
    Set pFormater = New CFormatoDocumento
    pFormater.SetDocumento Me, bDoPreview
    Set pFormater = Nothing

End Sub

Public Function NombreArchivoFormato() As String
    
    NombreArchivoFormato = NombreFormato

End Function

Public Function Detalles() As Collection

    Set Detalles = New Collection

End Function

Public Function Acumulado(iRubro, iTipo) As clsDetalleRecibo
Dim pRetVal As clsDetalleRecibo

    For Each pRetVal In AcumuladorResultados
        If pRetVal.Codigo = iRubro And pRetVal.Tipo = iTipo Then
            Set Acumulado = pRetVal
            Exit Function
        End If
    Next

    Set Acumulado = Nothing

End Function

Public Function MontoAcumulado(iRubro, iTipo) As Currency
Dim pRetVal As clsDetalleRecibo

    For Each pRetVal In AcumuladorResultados
        If pRetVal.Codigo = iRubro And pRetVal.Tipo = iTipo Then
            MontoAcumulado = pRetVal.Monto
            Exit Function
        End If
    Next

    MontoAcumulado = 0

End Function

Public Sub Acumular(iRubro, ivmMonto, iTipo)
Dim pRetVal As clsDetalleRecibo

'    If iTipo = 2 Then Exit Sub

  Set pRetVal = Acumulado(iRubro, iTipo)
  
  If pRetVal Is Nothing Then
      
    If (iTipo < 0 Or iTipo > 2) Then
      mAdvertencia "ERROR: Tipo invlido (" & iTipo & ") en clsRecibo::Acumular"
      Exit Sub
    End If
    
    If ptCodigosRecibo.Item(iRubro) Is Nothing Then
      mAdvertencia "ERROR: Cdigo de recibo invlido (" & iRubro & ") en clsRecibo::Acumular"
      Exit Sub
    End If

    Set pRetVal = New clsDetalleRecibo
    With pRetVal
    .Codigo = iRubro
    .Tipo = iTipo
    .Monto = 0
    End With
    AcumuladorResultados.Add pRetVal
  End If
  
  pRetVal.Monto = pRetVal.Monto + ivmMonto

End Sub

' EvalVar es llamada desde DocFormatter, de manera que tiene que mantener compatibilidad con los parmetros declarados all
Public Function EvalVar(istrVarID As String, ovRetBuff As Variant, ostrRetBuff As String) As Boolean
' istrVarID = [ASIG|DED "."]<codigo>["."<field>]
Dim sCopiaID As String, sAsigDed As String, sCodigo As String, sFieldID As String
Dim n As Integer, nTipo As Integer, sTemp As String
Dim pDetalle As clsDetalleRecibo, vmAcum As Currency
Dim bRetVal As Boolean, sOutString As String
Dim lVar As Variant

' 1.- Analisis sintctico del request:
   sAsigDed = "": sCodigo = "": sFieldID = ""
   sCopiaID = UCase(istrVarID)
   sTemp = strtok(sCopiaID, ".")
   If sTemp = "ASIG" Or sTemp = "DED" Or sTemp = "AP" Then
     sAsigDed = sTemp
   Else
     sCodigo = sTemp
   End If
   sTemp = strtok("", ".")
   If sTemp <> "" Then
       If sAsigDed <> "" Then
           sCodigo = sTemp
           sTemp = strtok("", ".")
       End If
       sFieldID = sTemp
   Else
       If sAsigDed <> "" Then
           sCodigo = sAsigDed
           sAsigDed = ""
       End If
   End If

' Definidos: sAsigDed, sCodigo, sFieldID

' 2.- Referencia a una Asignacin o Deduccin Concreta

   If sAsigDed <> "" Then
       nTipo = IIf(sAsigDed = "ASIG", 0, IIf(sAsigDed = "DED", 1, 2))
       Set pDetalle = Acumulado(sCodigo, nTipo)
       If pDetalle Is Nothing Then
           ovRetBuff = ""
           ostrRetBuff = ""
           EvalVar = True
           Exit Function
       End If

       If sFieldID = "" Then
           ostrRetBuff = stFullLength(pDetalle.Codigo, 8) & " " & stFullLength(ptCodigosRecibo.Item(pDetalle.Codigo).Descripcion, 40) & " " & FormatNumero(pDetalle.Monto, "##,###,##0.00", 13)
           RaiseEvent RequestFormato(pDetalle, ostrRetBuff)
           Set ovRetBuff = pDetalle
       Else
           Select Case sFieldID
           Case "CODIGO"
               ostrRetBuff = pDetalle.Codigo
               ovRetBuff = pDetalle.Codigo
           Case "DESCRIPCION"
               ostrRetBuff = ptCodigosRecibo.Item(pDetalle.Codigo).Descripcion
               ovRetBuff = ostrRetBuff
           Case "MONTO"
               ovRetBuff = pDetalle.Monto
               ostrRetBuff = FormatNumero(pDetalle.Monto, "##,###,##0.00", 13)
           Case Else
               ovRetBuff = "INVALIDO: " & istrVarID
               ostrRetBuff = "INVALIDO: " & istrVarID
           End Select
       End If
       
       EvalVar = True
       Exit Function
   End If

' 2.- Referencia a un campo de Acumulador (no asigDed)

   If sCodigo <> "" And sFieldID <> "" Then
       Select Case sFieldID
       Case "CODIGO"
           ostrRetBuff = sCodigo
           ovRetBuff = sCodigo
       Case "DESCRIPCION"
           ostrRetBuff = ptCodigosRecibo.Item(pDetalle.Codigo).Descripcion
           ovRetBuff = ostrRetBuff
       Case "MONTO"
           vmAcum = 0
           For Each pDetalle In AcumuladorResultados
               If pDetalle.Codigo = sCodigo Then
                   If pDetalle.Tipo Then
                       vmAcum = vmAcum + pDetalle.Monto
                   Else
                       vmAcum = vmAcum - pDetalle.Monto
                   End If
               End If
           Next
           ovRetBuff = vmAcum
           ostrRetBuff = FormatNumero(vmAcum, "##,###,##0.00", 13)
       Case Else
           ovRetBuff = "INVALIDO"
           ostrRetBuff = "INVALIDO"
           EvalVar = False
           Exit Function
       End Select
       
       EvalVar = True
       Exit Function
   End If
  
   bRetVal = True
   Select Case sCodigo
   Case "ASIGNACIONES", "ASIG"
       sOutString = ""
       For Each pDetalle In AcumuladorResultados
           If pDetalle.Tipo = 0 Then
               sTemp = stFullLength(pDetalle.Codigo, 8) & " " & stFullLength(ptCodigosRecibo.Item(pDetalle.Codigo).Descripcion, 40) & " " & FormatNumero(pDetalle.Monto, "##,###,##0.00", 13)
               RaiseEvent RequestFormato(pDetalle, sTemp)
               If sOutString <> "" Then sOutString = sOutString & vbCrLf
               sOutString = sOutString & sTemp
           End If
       Next
       ostrRetBuff = sOutString
       ovRetBuff = sOutString
   Case "DEDUCCIONES", "DED"
       sOutString = ""
       For Each pDetalle In AcumuladorResultados
           If pDetalle.Tipo = 1 Then
               sTemp = stFullLength(pDetalle.Codigo, 8) & " " & stFullLength(ptCodigosRecibo.Item(pDetalle.Codigo).Descripcion, 40) & " " & FormatNumero(pDetalle.Monto, "##,###,##0.00", 13)
               RaiseEvent RequestFormato(pDetalle, sTemp)
               If sOutString <> "" Then sOutString = sOutString & vbCrLf
               sOutString = sOutString & sTemp
           End If
       Next
       ostrRetBuff = sOutString
       ovRetBuff = sOutString
   
   Case "APORTES", "AP"
       sOutString = ""
       For Each pDetalle In AcumuladorResultados
           If pDetalle.Tipo = 3 Then
               sTemp = stFullLength(pDetalle.Codigo, 8) & " " & stFullLength(ptCodigosRecibo.Item(pDetalle.Codigo).Descripcion, 40) & " " & FormatNumero(pDetalle.Monto, "##,###,##0.00", 13)
               RaiseEvent RequestFormato(pDetalle, sTemp)
               If sOutString <> "" Then sOutString = sOutString & vbCrLf
               sOutString = sOutString & sTemp
           End If
       Next
       ostrRetBuff = sOutString
       ovRetBuff = sOutString
   
   Case "TOTASIG", "TOTASIGNACIONES", "TOTALASIG", "TOTALASIGNACIONES"
       vmAcum = 0
       For Each pDetalle In AcumuladorResultados
           If pDetalle.Tipo = 0 Then
               vmAcum = vmAcum + pDetalle.Monto
           End If
       Next
       ostrRetBuff = Format(vmAcum, "###,###,##0.00")
       ovRetBuff = vmAcum
   Case "TOTDED", "TOTDEDUCCIONES", "TOTALDED", "TOTALDEDUCCIONES"
       vmAcum = 0
       For Each pDetalle In AcumuladorResultados
           If pDetalle.Tipo = 1 Then
               vmAcum = vmAcum + pDetalle.Monto
           End If
       Next
       ostrRetBuff = Format(vmAcum, "###,###,##0.00")
       ovRetBuff = vmAcum
   Case "TOTAP", "TOTAPORTES", "TOTALAP", "TOTALAPORTES"
       vmAcum = 0
       For Each pDetalle In AcumuladorResultados
           If pDetalle.Tipo = 1 Then
               vmAcum = vmAcum + pDetalle.Monto
           End If
       Next
       ostrRetBuff = Format(vmAcum, "###,###,##0.00")
       ovRetBuff = vmAcum
   Case "SALDO"
       vmAcum = 0
       For Each pDetalle In AcumuladorResultados
           If pDetalle.Tipo = 0 Then
               vmAcum = vmAcum + pDetalle.Monto
           ElseIf pDetalle.Tipo = 1 Then
               vmAcum = vmAcum - pDetalle.Monto
           End If
       Next
       ostrRetBuff = Format(vmAcum, "###,###,##0.00")
       ovRetBuff = vmAcum
   Case Else
       bRetVal = False     ' Si no hay quien maneje el evento, la variable no se evala.
       RaiseEvent RequestEvarVal(bRetVal, istrVarID, lVar, ostrRetBuff)
       If bRetVal Then ovRetBuff = lVar
   End Select

   EvalVar = bRetVal

End Function

Public Sub Reinit()
  Set AcumuladorResultados = Nothing
  Set AcumuladorResultados = New Collection
End Sub

Private Sub Class_Initialize()
  Set AcumuladorResultados = New Collection
End Sub

Private Sub Class_Terminate()
  Set AcumuladorResultados = Nothing
End Sub
