VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsProcesoNomina"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Numero As Long
Public Operador As String
Public CodigoScript As String
Public FechaInicio As Date
Public FechaFin As Date
Public FechaCierre As Date

Private WithEvents pRecibo As clsRecibo
Attribute pRecibo.VB_VarHelpID = -1
Private pComprobante As clsBufferComprobante, _
        pScript As clsScript, _
        WithEvents pTrabajador As clsTrabajador
Attribute pTrabajador.VB_VarHelpID = -1
Private pInterprete As Object
Private colExcepciones As Collection

Public isCierre As Boolean  ' True: Cerrar (registrar cambios), False: Slo emitir reportes
Private NumeroRecibo As Long

Private rsIterador As Recordset
Private rsIteradorDetTrab As Recordset

Public Function IniciarIteradorDetallesTrabajador(istrCodigoTrabajador) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler

    Set rsIteradorDetTrab = dbHandle.OpenRecordset("SELECT * FROM nomDetallesProceso WHERE ProcessID = " & NumeroDB(Me.Numero) & " AND Trabajador = " & StringDB(CStr(istrCodigoTrabajador)), dbOpenForwardOnly)
    If rsIteradorDetTrab.EOF Then
        Set rsIteradorDetTrab = Nothing
        bRetVal = False
    Else
        bRetVal = True
    End If
    
ResumePoint:

    IniciarIteradorDetallesTrabajador = bRetVal
    Exit Function

ErrHandler:
    Set rsIteradorDetTrab = Nothing
    ReportarError False, Err.Number, Err.Description, "clsProcesoNomina::IniciarIteradorDetallesTrabajador"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function NextDetalleTrabajador() As clsDetalleProceso
Dim pDetalle As clsDetalleProceso

    If rsIteradorDetTrab Is Nothing Then
        Set pDetalle = Nothing
    ElseIf rsIteradorDetTrab.EOF Then
        Set rsIterador = Nothing
        Set pDetalle = Nothing
    Else
        Set pDetalle = New clsDetalleProceso
        pDetalle.LoadInstance rsIteradorDetTrab
        rsIteradorDetTrab.MoveNext
    End If

    Set NextDetalleTrabajador = pDetalle

End Function

Public Function IniciarIteradorDetalles() As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler

    Set rsIterador = dbHandle.OpenRecordset("SELECT * FROM nomDetallesProceso WHERE ProcessID = " & NumeroDB(Me.Numero) & " ORDER BY Departamento, Trabajador, Tipo, CodigoReporte", dbOpenForwardOnly)
    If rsIterador.EOF Then
        Set rsIterador = Nothing
        bRetVal = False
    Else
        bRetVal = True
    End If
    
ResumePoint:

    IniciarIteradorDetalles = bRetVal
    Exit Function

ErrHandler:
    Set rsIterador = Nothing
    ReportarError False, Err.Number, Err.Description, "clsProcesoNomina::IniciarIteradorDetalles"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function nextDetalle() As clsDetalleProceso
Dim pDetalle As clsDetalleProceso

    If rsIterador Is Nothing Then
        Set pDetalle = Nothing
    ElseIf rsIterador.EOF Then
        Set rsIterador = Nothing
        Set pDetalle = Nothing
    Else
        Set pDetalle = New clsDetalleProceso
        pDetalle.LoadInstance rsIterador
        rsIterador.MoveNext
    End If

    Set nextDetalle = pDetalle

End Function

Public Sub LoadInstance(rs As Recordset, Optional ipDest As clsProcesoNomina = Nothing)
Dim pDest As clsProcesoNomina

    If ipDest Is Nothing Then
        Set pDest = Me
    Else
        Set pDest = ipDest
    End If

    With rs
    pDest.Numero = GetNumeroFromVariant(.Fields("Numero"))
    pDest.Operador = GetStringFromVariant(.Fields("Operador"))
    pDest.CodigoScript = GetStringFromVariant(.Fields("codigoScript"))
    pDest.FechaInicio = GetDateFromVariant(.Fields("FechaInicioPeriodo"))
    pDest.FechaFin = GetDateFromVariant(.Fields("FechaFinPeriodo"))
    pDest.FechaCierre = GetDateFromVariant(.Fields("FechaCierre"))
    End With

End Sub

Public Function Load(ByVal lngNumero As Long) As Boolean
Dim rs As Recordset, bRetVal As Boolean

    On Error GoTo ErrHandler
    
    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomProcesos WHERE Numero = " & NumeroDB(lngNumero), dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs
    End If
    
ResumePoint:
    Set rs = Nothing
    Load = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsProcesoNomina::Load"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Referencia() As String

    If isCierre Then
        Referencia = "PRN-" & Format(Me.Numero, "000000")
    Else
        Referencia = "SIM " & Format(Date, "Short Date")
    End If

End Function

Public Function NumeroProximoProceso() As Long
Dim rs As Recordset, lRetVal As Long

    On Error GoTo ErrHandler
    Set rs = dbHandle.OpenRecordset("SELECT MAX(Numero) AS Ultimo FROM nomProcesos", dbOpenForwardOnly)
    If rs.EOF Then
        lRetVal = 1
    Else
        lRetVal = GetNumeroFromVariant(rs.Fields("Ultimo")) + 1
    End If

ResumePoint:
    Set rs = Nothing
    NumeroProximoProceso = lRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsProcesoNomina::NumeroProximoProceso"
    lRetVal = 0
    Resume ResumePoint

End Function

Public Sub Save()
Dim sQuery As String

    Me.Numero = NumeroProximoProceso
    sQuery = "INSERT INTO nomProcesos (Numero, Operador, CodigoScript, FechaInicioPeriodo, FechaFinPeriodo, FechaCierre) SELECT "
    sQuery = sQuery & NumeroDB(Numero) & ", " & StringDB(Operador) & ", "
    sQuery = sQuery & StringDB(CodigoScript) & ", " & FechaDB(FechaInicio) & ", "
    sQuery = sQuery & FechaDB(FechaFin) & ", " & FechaDB(FechaCierre)

    dbHandle.Execute sQuery, dbFailOnError
   
End Sub

Private Sub Class_Initialize()

    isCierre = True

End Sub

Private Function Setup() As Boolean
Dim bRetVal As Boolean
Dim pAsigDed As clsAsigDed

    On Error GoTo ErrHandler
    bRetVal = True

    Set pInterprete = CreateObject("ScriptControl")
    pInterprete.Language = "VBScript"

    pInterprete.AddObject "Proceso", Me
    pInterprete.AddObject "GlobalScript", mMain.pGlobalScript
    pInterprete.AddObject "Factoria", mMain.pFactoria
  
    pInterprete.AddCode "Function VerificarRestricciones" & vbCrLf & _
                         pScript.codeVerificarRestricciones & vbCrLf & _
                         "End Function" & vbCrLf
    
    If pInterprete.Eval("VerificarRestricciones") = False Then
        mAdvertencia "Las restricciones del script no son" & vbCrLf & "satisfechas por el proceso definido."
        pInterprete.Reset
        Set pInterprete = Nothing
        Set pScript = Nothing
        Exit Function
    End If
    pInterprete.Reset   ' Limpia el cdigo de verificar Restricciones, innecesario despues de la verificacion
    pInterprete.Language = "VBScript"

    Set pTrabajador = New clsTrabajador
    Set pRecibo = New clsRecibo
    Set pComprobante = New clsBufferComprobante

    ResetGlobalScript

    pGlobalScript.AddObject "Proceso", Me
    pGlobalScript.AddObject "Trabajador", pTrabajador
    pGlobalScript.AddObject "Recibo", pRecibo
    pGlobalScript.AddObject "Script", pScript
    pGlobalScript.AddObject "Comprobante", pComprobante

    pInterprete.AddObject "Proceso", Me
    pInterprete.AddObject "Trabajador", pTrabajador
    pInterprete.AddObject "Recibo", pRecibo
    pInterprete.AddObject "Script", pScript
    pInterprete.AddObject "GlobalScript", mMain.pGlobalScript
    pInterprete.AddObject "Factoria", mMain.pFactoria
    pInterprete.AddObject "Comprobante", pComprobante
    pInterprete.AddObject "VSLIB", VSLIB.VSLRTLIB, True

    pInterprete.AddCode pScript.codeBaseScript ' Contiene todas las definiciones globales del script
    
    pInterprete.AddCode "Sub PostTrabajador" & vbCrLf & _
                          pScript.codePostTrabajador & _
                          "End Sub" & vbCrLf

    pInterprete.AddCode "Function TrabajadorElegible" & vbCrLf & _
                          pScript.codeTrabajadorElegible & _
                          "End Function"

    pInterprete.Modules.Add "AsigDed"  ' Para separar las asignaciones/deducciones del cdigo general.
    For Each pAsigDed In pScript.AsigDed
10      pInterprete.Modules("AsigDed").AddCode _
            "Function " & pAsigDed.Codigo & vbCrLf & _
            pAsigDed.Formula & vbCrLf & _
            "End Function" & vbCrLf
    Next

15  If Not pInterprete.Procedures("Init") Is Nothing Then
      pInterprete.Run "Init"
    End If

ResumePoint:
    Setup = bRetVal
    Exit Function

ErrHandler:
Dim strErrText As String

  If Erl = 15 Then
    Err.Clear
    Resume ResumePoint
  End If
    
  If InStr(1, Err.Source, "VBScript") Then
    strErrText = ":" & vbCrLf & pInterprete.Error.Text & " Linea: " & pInterprete.Error.Line
  Else
    strErrText = ""
  End If
  ReportarError False, Err.Number, Err.Description, Err.Source & " en clsProcesoNomina::Go" & strErrText
  bRetVal = False

  Resume ResumePoint

End Function

Public Sub Go()
Dim pAsigDed As clsAsigDed, lpTrabajador As clsTrabajador, vmMontoAsigDed As Currency
Dim totAsig As Currency, totDed As Currency
Dim pDetalleProceso As clsDetalleProceso
Dim pExcepcion As clsExcepcion, vExcepcion As Variant, vNombreRecibo As Variant
Dim pReporte As clsReporteProceso
Dim pListaExcepciones As clsPresentadorExcep
Dim pDatosRecibo As clsDatosRecibo
Dim CPrinter As CLinePrinter, sPrinterName As String
Dim pPago As clsPagoNomina
Dim frmDefinirPago As frmDatosPagoNomina
Dim vmEfectivo As Currency
Dim doPreview As Boolean
Dim strErrText As String
Dim nErrNum As Long
Dim strErrSource As String

    If Me.isCierre Then
      doPreview = CBool(GetSetting(AppName, "Nomina", "PreviewRecibo", "-1"))
      Set frmDefinirPago = New frmDatosPagoNomina
      ShowNonModal frmDefinirPago
      Set pPago = frmDefinirPago.pPagos
      Unload frmDefinirPago
      If pPago Is Nothing Then Exit Sub
    End If

    On Error GoTo ErrHandler1

    NumeroRecibo = 1
    Set pScript = New clsScript
    If Not pScript.Load(CodigoScript) Then
      mAdvertencia "Cdigo de script invlido: " & CodigoScript
      Set pScript = Nothing
      Exit Sub
    End If

    If Not Setup Then
      Set pScript = Nothing
      Exit Sub
    End If

    Set pDetalleProceso = New clsDetalleProceso
    Set pExcepcion = New clsExcepcion
    Set pReporte = New clsReporteProceso

    Screen.MousePointer = vbHourglass
    pTrabajador.SetScript Me
    Set pListaExcepciones = New clsPresentadorExcep

    StartTransaction
    ' La nmina es un proceso LARGO, de manera que no se puede establecer un bloqueo GLOBAL...
    On Error GoTo ErrHandler2

    If pScript.StartIteradorTrabajadores Then
      If isCierre Then
        Me.Save
      End If

      pComprobante.StartComprobante Me.FechaCierre, "NOM-" & Me.Numero, "Proceso de nmina " & Me.Numero & ". Script: " & Me.CodigoScript & ". " & Format(Me.FechaCierre, "Short Date")
      Do
        Set lpTrabajador = pScript.NextTrabajador
        If Not lpTrabajador Is Nothing Then
          lpTrabajador.Clone pTrabajador  ' Copia el trabajador ledo al Script
          If pInterprete.Eval("TrabajadorElegible") Then
            Set colExcepciones = New Collection
            totAsig = 0: totDed = 0
            For Each pAsigDed In pScript.AsigDed
10            vmMontoAsigDed = pInterprete.Modules("AsigDed").Eval(pAsigDed.Codigo)
              
              If vmMontoAsigDed <> 0 Then
                If pAsigDed.CodigoRecibo <> "" Then
                  pRecibo.Acumular pAsigDed.CodigoRecibo, vmMontoAsigDed, pAsigDed.Tipo
                End If
                pReporte.AddDetalle UsuarioActivo.Codigo, lpTrabajador.Codigo, lpTrabajador.Departamento, pAsigDed.CodigoReporte, pAsigDed.Tipo, vmMontoAsigDed
                
                Select Case pAsigDed.Tipo
                Case 0  ' Asignacion
                  totAsig = totAsig + vmMontoAsigDed
                  pComprobante.AddDetalle pAsigDed.codigoCuenta, pAsigDed.Descripcion, vmMontoAsigDed, 0
                Case 1 ' Deduccion
                  totDed = totDed + vmMontoAsigDed
                  pComprobante.AddDetalle pAsigDed.codigoCuenta, pAsigDed.Descripcion, 0, vmMontoAsigDed
                Case 2 ' Aporte
                  pComprobante.AddDetalle pAsigDed.codigoCuenta, pAsigDed.Descripcion, vmMontoAsigDed, 0
                  pComprobante.AddDetalle pAsigDed.CodigoContrapartida, pAsigDed.Descripcion, 0, vmMontoAsigDed
                End Select
                
                If Me.isCierre Then
                  With pDetalleProceso
                  .ClaseLaboral = pAsigDed.ClaseLaboral
                  .codigoCuenta = pAsigDed.codigoCuenta
                  .CodigoContrapartida = pAsigDed.CodigoContrapartida
                  .CodigoRecibo = pAsigDed.CodigoRecibo
                  .CodigoReporte = pAsigDed.CodigoReporte
                  .CodigoAsigDed = pAsigDed.Codigo
                  .FechaCierre = Me.FechaCierre
                  .ProcessID = Me.Numero
                  .Tipo = pAsigDed.Tipo
                  .Trabajador = pTrabajador.Codigo
                  .Departamento = pTrabajador.Departamento
                  .Valor = IIf(pAsigDed.Tipo = 1, -vmMontoAsigDed, vmMontoAsigDed)
                  .Save
                  End With
                End If
              End If
            Next
            
            If Me.isCierre Then
              pPago.PasarPagoTrabajador pTrabajador, totAsig - totDed, Me, pComprobante, vmEfectivo
              For Each pDatosRecibo In pScript.Recibos
                sPrinterName = Printer.DeviceName
                Set CPrinter = New CLinePrinter
                CPrinter.SetPrinter pDatosRecibo.NombrePrinter
                pRecibo.PrintRecibo CStr(pDatosRecibo.NombreArchivo), doPreview
                CPrinter.SetPrinter sPrinterName
              Next
              pInterprete.Run "PostTrabajador"

              For Each vExcepcion In colExcepciones
                pExcepcion.RegistrarUso lpTrabajador.Codigo, CStr(vExcepcion), Me.FechaFin, pListaExcepciones
              Next
              NumeroRecibo = NumeroRecibo + 1
            End If

            Set colExcepciones = Nothing
            pRecibo.Reinit
          End If
        End If
      Loop While Not lpTrabajador Is Nothing

      If isCierre Then
        If vmEfectivo Then
          SesionActiva.RegistrarRetiro TR_PAGO, vmEfectivo, "Pagos de nmina, proceso " & Me.Numero
        End If
        pPago.Cierre Me, pComprobante
        pComprobante.Procesar
      End If

    End If
    
    Workspaces(0).CommitTrans dbForceOSFlush
    Screen.MousePointer = vbDefault
    If isCierre Then
    Dim pListaPagos As clsListaPagosReporte
        pListaExcepciones.Generar 1, False, "Excepciones Procesadas", "Proceso No. " & Format(Me.Numero, "00000")
        Set pListaPagos = New clsListaPagosReporte
        pListaPagos.Generar Me.Numero
        Set pListaPagos = Nothing
    End If

    Set pListaExcepciones = Nothing
    pReporte.Generar UsuarioActivo.Codigo, Me

ResumePoint:

    Screen.MousePointer = vbDefault
    
    ResetGlobalScript
    Set pExcepcion = Nothing
    Set pDetalleProceso = Nothing
    Set pComprobante = Nothing
    Set pRecibo = Nothing
    Set pTrabajador = Nothing
    Set pInterprete = Nothing
    Set pScript = Nothing
    Set pPago = Nothing

    Exit Sub

ErrHandler2:
    nErrNum = Err.Number
    strErrText = Err.Description
    strErrSource = Err.Source
    Err.Clear
    AbortTransaction

ErrHandler1:

  If nErrNum = 0 Then
    nErrNum = Err.Number
    strErrText = Err.Description
    strErrSource = Err.Source
  End If

  If pInterprete.Error.Number <> 0 Then
      strErrText = strErrText & ":" & vbCrLf & "Error en evaluacin de AsigDed " & pAsigDed.Codigo
  ElseIf InStr(1, Err.Source, "VBScript") Then
      strErrText = strErrText & ":" & vbCrLf & pInterprete.Error.Text & " Linea: " & pInterprete.Error.Line
  Else
      strErrText = ""
  End If
  ReportarError False, Err.Number, Err.Description, Err.Source & " en clsProcesoNomina::Go" & vbCrLf & strErrText
  Resume ResumePoint

End Sub

Private Sub pRecibo_RequestEvarVal(oResult As Boolean, istrVarID As String, ovRetBuff As Variant, ostrRetBuff As String)
Dim vRetVal As Variant
Dim sRetStr As String

    oResult = False
    Select Case UCase(istrVarID)
    Case "FECHAINICIO", "FECHADESDE"
        oResult = True
        ostrRetBuff = Format(Me.FechaInicio, "Short Date")
        ovRetBuff = Me.FechaInicio
    Case "FECHAFIN", "FECHAHASTA"
        oResult = True
        ostrRetBuff = Format(Me.FechaFin, "Short Date")
        ovRetBuff = Me.FechaFin
    Case "FECHACIERRE"
        oResult = True
        ostrRetBuff = Format(Me.FechaCierre, "Short Date")
        ovRetBuff = Me.FechaCierre
    Case "TIPOSCRIPT", "CODIGOPROCESO"
        oResult = True
        ostrRetBuff = Me.CodigoScript
        ovRetBuff = Me.CodigoScript
    Case "OPERADOR"
        oResult = True
        ostrRetBuff = Me.Operador
        ovRetBuff = Me.Operador
    Case "NUMERO"
        oResult = True
        ostrRetBuff = Format(Me.Numero, "00000")
        ovRetBuff = Me.Numero
    Case "REFERENCIA"
        oResult = True
        ostrRetBuff = Me.Referencia
        ovRetBuff = Me.Referencia
    Case "NUMERORECIBO"
        oResult = True
        ostrRetBuff = Format(Me.Numero, "0000")
        ovRetBuff = Me.Numero
    End Select
    If oResult Then Exit Sub    ' Ya pas... Request para el proceso

    oResult = pTrabajador.EvalVar(CStr(istrVarID), ovRetBuff, sRetStr)
    If oResult Then
    ' Guarda estado del trabajador para el momento del proceso... podra ser diferente para el momento de la reimpresin....
        SaveVariableRecibo Me.Numero, istrVarID, pTrabajador.Codigo, ovRetBuff
        ostrRetBuff = sRetStr
        Exit Sub
    End If                      ' Request para el Trabajador

    oResult = Empresa.EvalVar(CStr(istrVarID), ovRetBuff, sRetStr)
    If oResult Then
        ostrRetBuff = sRetStr
        Exit Sub
    End If                      ' Request para la Empresa

    oResult = True
    vRetVal = pInterprete.Eval(istrVarID)   ' Prueba para el componente VBS del Proceso
    Select Case varType(vRetVal)
    Case vbBoolean
        ostrRetBuff = IIf(vRetVal, "VERDADERO", "FALSO")
    Case vbByte, vbInteger, vbLong
        ostrRetBuff = Format(vRetVal, "##,###,##0")
    Case vbCurrency, vbDecimal, vbDouble, vbSingle
        ostrRetBuff = Format(vRetVal, "###,###,##0.00")
    Case vbDate
        ostrRetBuff = Format(vRetVal, "Short Date")
    Case vbString, vbVariant
        ostrRetBuff = vRetVal
    Case Else
        oResult = False
    End Select
    ovRetBuff = vRetVal
    
    If oResult Then
    ' En los componentes variables podra haber referencias a elementos que no estn disponibles en la reimpresion
      SaveVariableRecibo Me.Numero, istrVarID, pTrabajador.Codigo, ovRetBuff
      Exit Sub    ' Procesado por componente VBS del Proceso
    End If
    
    oResult = True
    vRetVal = pGlobalScript.Eval(istrVarID)   ' Prueba para el componente VBS Global
    ovRetBuff = vRetVal
    Select Case varType(vRetVal)
    Case vbBoolean
        ostrRetBuff = IIf(vRetVal, "VERDADERO", "FALSO")
    Case vbByte, vbInteger, vbLong
        ostrRetBuff = Format(vRetVal, "##,###,##0")
    Case vbCurrency, vbDecimal, vbDouble, vbSingle
        ostrRetBuff = Format(vRetVal, "###,###,##0.00")
    Case vbDate
        ostrRetBuff = Format(vRetVal, "Short Date")
    Case vbString, vbVariant
        ostrRetBuff = vRetVal
    Case Else
        oResult = False
    End Select

    If oResult Then
    ' GlobalScript tambien es un componente variable... de manera que hay que guardar las variables
      SaveVariableRecibo Me.Numero, istrVarID, pTrabajador.Codigo, ovRetBuff
    End If

End Sub

Private Sub pRecibo_RequestFormato(pDetalle As Variant, ostrDestBuffer As Variant)

    If scExisteIdentificador(pInterprete, "FormatearDetallesRecibo") Then
        pInterprete.Run "FormatearDetallesRecibo", pDetalle, ostrDestBuffer
        Exit Sub
    End If

    If scExisteIdentificador(pGlobalScript, "FormatearDetallesRecibo") Then
        pGlobalScript.Run "FormatearDetallesRecibo", pDetalle, ostrDestBuffer
        Exit Sub
    End If

End Sub

Private Sub pTrabajador_ExcepcionProcesada(strCodigoExcepcion As String)
Dim strSearch

    For Each strSearch In colExcepciones
        If strSearch = strCodigoExcepcion Then Exit Sub
    Next

    colExcepciones.Add strCodigoExcepcion

End Sub

