VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsPresentadorExcep"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Presentador de Excepciones...
' Los procesos de nmina ACTUALIZAN excepciones.
' Debe quedar un "hard copy" de las mismas, para poder verificar los resultados.
' esta copia forma parte de la documentacin de cada proceso realizado.

'Tipo          Fecha Operador             Valor Tipo Rec.   Valor Rec. Comentarios
'XXXXXXXX 99-99-9999 XXXXXXXXXXXX 99.999.999,99 XXXXXXXXXXX XXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

'Trabajador                Fecha Operador             Valor Tipo Rec.   Valor Rec. Comentarios
'XXXXXXXXXXXXXXXXXXXX 99-99-9999 XXXXXXXXXXXX 99.999.999,99 XXXXXXXXXXX XXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
Private AnchoReporte As Long
Private my_ID As Long           ' Identificador de cada reporte
Private nOrden As Integer       ' 1: Por trabajador, 2:Por Tipo
Private fView As lfQuickView
Private Subtitulo1 As String, Subtitulo2 As String
Private sTag As String
Private sName As String

Private Sub Class_Initialize()

    my_ID = 0

End Sub

Public Sub Encabezado()
Dim sOut As String

    If fView.Linea > 1 Then
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado de Excepciones", vbCenter
    fView.Add Subtitulo1, vbCenter
    If Subtitulo2 <> "" Then fView.Add Subtitulo2, vbCenter
    fView.Add ""
    sOut = "Emisin: " & Format(Now, "General Date") & ". OPERADOR: " & UsuarioActivo.Codigo
    sOut = sOut & Space(AnchoReporte - Len(sOut) - 11) & "Pgina " & Format(fView.Pagina, "0000")
    fView.Add sOut
    
    fView.Add String(AnchoReporte, "-")
    If nOrden = 1 Then
        sOut = "Tipo   "
    Else
        sOut = "Trabajador          "
    End If
    sOut = sOut & "       Fecha Operador             Valor Tipo Rec.   Valor Rec. Comentarios"
    fView.Add sOut
    fView.Add String(AnchoReporte, "-")
    
End Sub

Private Sub PasarLinea(pExcepcion As clsExcepcion)
Dim pTrabajador As clsTrabajador, pDescripcion As clsTablaCodigos
Dim sOut As String, vResto As Variant, i As Integer

    If nOrden = 1 Then
        If pExcepcion.CodTrabajador <> sTag Then
            sTag = pExcepcion.CodTrabajador
            Set pTrabajador = New clsTrabajador
            If pTrabajador.Load(sTag) Then
                sName = pTrabajador.Nombre
            Else
                sName = "TRABAJADOR NO ENCONTRADO"
            End If
            Set pTrabajador = Nothing

            If fView.Linea > fView.LineasPagina - 3 Then
                Encabezado
            End If
            fView.Add "Trabajador: " & sName & " (" & sTag & ")"
        End If
        sOut = stFullLength(pExcepcion.CodExcepcion, 8)
    Else
        If pExcepcion.CodExcepcion <> sTag Then
            sTag = pExcepcion.CodExcepcion
            Set pDescripcion = ptExcepciones.Item(sTag)
            If Not pDescripcion Is Nothing Then
                sName = pDescripcion.Descripcion
            Else
                sName = "EXCEPCION INDEFINIDA"
            End If
            
            If fView.Linea > fView.LineasPagina - 3 Then
                Encabezado
            End If
            fView.Add "Excepcion: " & sName & " (" & sTag & ")"
        End If
        sOut = stFullLength(pExcepcion.CodTrabajador, 10)
    End If
'Tipo          Fecha Operador             Valor Tipo Rec.   Valor Rec. Comentarios
'XXXXXXXX 99-99-9999 XXXXXXXXXXXX 99.999.999,99 XXXXXXXXXXX XXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
    vResto = Convert2Lines(pExcepcion.Notas, 40)
    
    If pExcepcion.Notas <> "" Then
        i = UBound(vResto)
    Else
        i = 0
    End If
    i = i + 1
    
    If fView.Linea + i > fView.LineasPagina - 2 Then
        Encabezado
        fView.Add IIf(nOrden = 1, "Trabajador: ", "Excepcion: ") & sName & " (" & sTag & ") [cont]"
    End If
    
    sOut = sOut & " "
    sOut = sOut & stRightAlign(Format(pExcepcion.Fecha, "Short Date"), 10) & " "
    sOut = sOut & stFullLength(pExcepcion.Operador, 12) & " "
    sOut = sOut & FormatNumero(pExcepcion.Valor, "##,###,##0.00", 13) & " "
    sOut = sOut & stFullLength(pExcepcion.ImagenTipoRecurrencia, 11) & " "
    sOut = sOut & stRightAlign(pExcepcion.ImagenValorRecurrencia, 11) & " "
    If pExcepcion.Notas <> "" Then
        sOut = sOut & vResto(1)
    End If
    fView.Add sOut

    If pExcepcion.Notas <> "" Then
        For i = 2 To UBound(vResto)
            sOut = Space(AnchoReporte - 39) & vResto(i)
            fView.Add sOut
        Next
    End If

End Sub

Private Function myID() As Long
Dim rs As Recordset

    If my_ID = 0 Then
        Set rs = dbHandle.OpenRecordset("SELECT Max(NumeroID) As Lst FROM nomTMPListaExcepciones", dbOpenForwardOnly)
        If rs.EOF Then
            my_ID = 0
        Else
            my_ID = GetNumeroFromVariant(rs.Fields("Lst"))
        End If
        Set rs = Nothing
        my_ID = my_ID + 1
    End If
    
    myID = my_ID

End Function

Public Sub AddExcepcion(ipExcepcion As clsExcepcion)
Dim sQuery As String

    sQuery = "INSERT INTO nomTMPListaExcepciones (NumeroId, CodTrabajador, CodExcepcion, Fecha, Valor, Notas, TipoRecurrencia, Recurrencia, Operador) SELECT "
    sQuery = sQuery & NumeroDB(myID) & ", "
    sQuery = sQuery & StringDB(ipExcepcion.CodTrabajador) & ", "
    sQuery = sQuery & StringDB(ipExcepcion.CodExcepcion) & ", "
    sQuery = sQuery & FechaDB(ipExcepcion.Fecha) & ", "
    sQuery = sQuery & NumeroDB(ipExcepcion.Valor) & ", "
    sQuery = sQuery & StringDB(Function2Field(ipExcepcion.Notas)) & ", "
    sQuery = sQuery & NumeroDB(ipExcepcion.TipoRecurrencia) & ", "
    sQuery = sQuery & NumeroDB(ipExcepcion.Recurrencia) & ", "
    sQuery = sQuery & StringDB(ipExcepcion.Operador)

    dbHandle.Execute sQuery, dbFailOnError

End Sub

Public Sub Generar(ByVal Orden As Integer, ByVal bAutoPrint As Boolean, istrSubtitulo1 As String, istrSubtitulo2 As String) ' 1: Orden por Trabajador, 2: Orden por tipo
Dim rs As Recordset, pExcepcion As clsExcepcion

    If my_ID = 0 Then
        mAdvertencia "clsPresentadorExcep::Generar: No hay datos para el reporte"
        Exit Sub
    End If

    nOrden = Orden
    Select Case nOrden
    Case 1
        AnchoReporte = 109
    Case 2
        AnchoReporte = 122
    Case Else
        nOrden = 1
        AnchoReporte = 109
    End Select

    Subtitulo1 = istrSubtitulo1
    Subtitulo2 = istrSubtitulo2

    sTag = ""
    Set fView = New lfQuickView
    
    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomTMPListaExcepciones WHERE NumeroID = " & NumeroDB(my_ID) & " ORDER BY " & IIf(nOrden = 1, "CodTrabajador, CodExcepcion", "CodExcepcion") & ", Fecha", dbOpenForwardOnly)
    Encabezado
    Set pExcepcion = New clsExcepcion
    Do While Not rs.EOF
    
        pExcepcion.LoadInstance rs
        PasarLinea pExcepcion
        rs.MoveNext
    
    Loop
    Set rs = Nothing

    If bAutoPrint Then
        fView.PrintListBox
    Else
        ShowNonModal fView
    End If

    Unload fView
    Set fView = Nothing

    dbHandle.Execute "DELETE * FROM nomTMPListaExcepciones WHERE NumeroID = " & NumeroDB(my_ID), dbFailOnError

End Sub
