VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsPagoNomina"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private parametrosBancos() As clsPagoBancoNomina
Private nParametrosBanco As Integer
Private ContinuarConEfectivo As Boolean
Private CodigoCuentaPasivo As String
Private nProximoBanco As Integer

Private pBanco As clsBancos

Public Sub AddPagoBanco(pDetalle As clsPagoBancoNomina)
    nParametrosBanco = nParametrosBanco + 1
    ReDim Preserve parametrosBancos(nParametrosBanco)
    Set parametrosBancos(nParametrosBanco) = pDetalle
End Sub

Public Property Let UsarEfectivo(bNuevoEfectivo As Boolean)
    ContinuarConEfectivo = bNuevoEfectivo
End Property

Public Property Let CuentaPasivo(strCodigo As String)
    CodigoCuentaPasivo = strCodigo
End Property

Public Sub PasarPagoTrabajador(pTrabajador As clsTrabajador, vmMontoPago As Currency, pProceso As clsProcesoNomina, pComprobante As clsBufferComprobante, ovmEfectivo As Currency)
Dim isOk As Boolean, sQuery As String
Dim strMedio As String, strCodigoBanco As String, strNumeroDocumento As String

    isOk = False
    Do While Not isOk And nProximoBanco <= nParametrosBanco

        With parametrosBancos(nProximoBanco)
        If pBanco.Codigo <> .CodigoBanco Then
            pBanco.Load .CodigoBanco
        End If

        If pBanco.Codigo = .CodigoBanco Then
            If .DelCheque = 0 Or (.DelCheque <= .AlCheque) Then
                If .AllowSG Or (.Acumulado + vmMontoPago <= pBanco.SaldoActual) Then
                    isOk = True
                End If
            End If
        End If

        If isOk Then
            If .DelCheque <> 0 Then
                pBanco.StartProcess
                pBanco.RegistrarMovimiento TMB_CHEQUE, pProceso.FechaCierre, "Pago de nmina. Proceso No." & pProceso.Numero, pTrabajador.Nombre, vmMontoPago, Format(.DelCheque, "0000000000"), pProceso.FechaCierre, pComprobante
                pBanco.EndProcess
                strMedio = "CH"
                strNumeroDocumento = Format(.DelCheque, "0000000000")
                .DelCheque = .DelCheque + 1
            Else
                .Acumulado = .Acumulado + vmMontoPago
                strMedio = "ND"
                strNumeroDocumento = pProceso.Referencia
            End If
            strCodigoBanco = .CodigoBanco
        End If
        End With ' parametrosBancos(nProximoBanco)

        If Not isOk Then
            nProximoBanco = nProximoBanco + 1
        End If

    Loop

    If Not isOk Then
        If ContinuarConEfectivo Then
            ovmEfectivo = ovmEfectivo + vmMontoPago
            strMedio = "EF"
            strNumeroDocumento = ""
            pComprobante.AddDetalle Empresa.CuentaCaja, "Pagos de nmina. Proceso " & pProceso.Numero, 0, vmMontoPago
            strCodigoBanco = ""
        Else
            strMedio = "XP"
            strNumeroDocumento = ""
            pComprobante.AddDetalle CodigoCuentaPasivo, "Pagos de nmina. Proceso " & pProceso.Numero, 0, vmMontoPago
            strCodigoBanco = CodigoCuentaPasivo
        End If
    End If

' Registro del pago en la historia de pagos de Nmina

    sQuery = "INSERT INTO nomPagosProceso (ProcessID, Trabajador, Fecha, Departamento, Cargo, MontoPagado, Medio, CodigoBanco, NumeroDocumento) SELECT "
    sQuery = sQuery & NumeroDB(pProceso.Numero) & ", "
    sQuery = sQuery & StringDB(pTrabajador.Codigo) & ", "
    sQuery = sQuery & FechaDB(pProceso.FechaCierre) & ", "
    sQuery = sQuery & StringDB(pTrabajador.Departamento) & ", "
    sQuery = sQuery & StringDB(pTrabajador.Cargo) & ", "
    sQuery = sQuery & NumeroDB(vmMontoPago) & ", "
    sQuery = sQuery & StringDB(strMedio) & ", "
    sQuery = sQuery & StringDB(strCodigoBanco) & ", "
    sQuery = sQuery & StringDB(strNumeroDocumento)

    On Error GoTo ErrHandler
    dbHandle.Execute sQuery, dbFailOnError
    Exit Sub

ErrHandler:
    ReportarError True, Err.Number, Err.Description, "clsPagoNomina::PasarPagoTrabajador"
    End

End Sub

Public Sub Cierre(pProceso As clsProcesoNomina, pComprobante As clsBufferComprobante)
Dim i As Integer
' Registra las TMB_MDB acumuladas durante el proceso.
    For i = 1 To nParametrosBanco
        With parametrosBancos(i)
        If .Acumulado > 0 Then
            pBanco.Load .CodigoBanco
            pBanco.StartProcess
            pBanco.RegistrarMovimiento TMB_NDB, pProceso.FechaCierre, "Pagos por transferencia. " & pProceso.Referencia, "", .Acumulado, pProceso.Referencia, pProceso.FechaCierre, pComprobante
            pBanco.EndProcess
        End If
        End With
    Next
End Sub

Private Sub Class_Initialize()
    Set pBanco = New clsBancos
    nProximoBanco = 1
End Sub

Private Sub Class_Terminate()
    Set pBanco = Nothing
End Sub
