VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsObservaciones"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Numero As Long
Public CodigoTrabajador As String
Public Fecha As Date
Public Operador As String
Public TipoObservacion As String
Public Observacion As String

Private rsIterador As Recordset

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsObservaciones)
Dim lpDest As clsObservaciones

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        Set lpDest = pDest
    End If

    With lpDest
    .Numero = GetNumeroFromVariant(rs.Fields("Numero"))
    .CodigoTrabajador = GetStringFromVariant(rs.Fields("CodigoTrabajador"))
    .Fecha = GetDateFromVariant(rs.Fields("Fecha"))
    .Operador = GetStringFromVariant(rs.Fields("Operador"))
    .TipoObservacion = GetStringFromVariant(rs.Fields("TipoObservacion"))
    .Observacion = Field2Function(GetStringFromVariant(rs.Fields("Observacion")))
    End With

End Sub

Private Function ProximaObservacion() As Long
Dim rs As Recordset, lngVal As Long

    Set rs = dbHandle.OpenRecordset("SELECT Max(Numero) AS Last FROM nomObservaciones", dbOpenForwardOnly)
    If rs.EOF Then
        lngVal = 0
    Else
        lngVal = GetNumeroFromVariant(rs.Fields("Last"))
    End If
    Set rs = Nothing
    ProximaObservacion = lngVal + 1

End Function

Public Sub UpdateObservacion(istrObservacion As String)
Dim sNotas As String

    On Error GoTo ErrHandler

    sNotas = StringDB(Function2Field(istrObservacion))
    dbHandle.Execute "UPDATE nomObservaciones SET Observacion = " & sNotas & " WHERE Numero = " & NumeroDB(Me.Numero), dbFailOnError
    Me.Observacion = istrObservacion
    
ResumePoint:
    Exit Sub

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsObservaciones::UpdateObservacion"
    Err.Clear
    Resume ResumePoint

End Sub

Public Function Save(istrCodigoTrabajador As String, istrOperador As String, istrTipoObservacion As String, istrObservacion As String) As Boolean
Dim sQuery As String, sNotas As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    With Me
    .Numero = ProximaObservacion
    .CodigoTrabajador = istrCodigoTrabajador
    .TipoObservacion = istrTipoObservacion
    .Operador = istrOperador
    .Fecha = Date
    .Observacion = istrObservacion
    End With
    
    sNotas = StringDB(Function2Field(istrObservacion))
    sQuery = "INSERT INTO nomObservaciones (Numero, CodigoTrabajador, Operador, TipoObservacion, Observacion) SELECT "
    sQuery = sQuery & NumeroDB(Me.Numero) & ", "
    sQuery = sQuery & StringDB(istrCodigoTrabajador) & ", "
    sQuery = sQuery & StringDB(istrOperador) & ", "
    sQuery = sQuery & StringDB(istrTipoObservacion) & ", "
    sQuery = sQuery & sNotas

    bRetVal = True
    dbHandle.Execute sQuery, dbFailOnError
    
ResumePoint:

    Save = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsObservaciones::Save"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Eliminar(ilngNumero As Long) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler

    bRetVal = True
    dbHandle.Execute "DELETE * FROM nomObservaciones WHERE  Numero = " & NumeroDB(ilngNumero), dbFailOnError

ResumePoint:
    Eliminar = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsObservaciones::Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function IniciarIteradorTrabajador(istrTrabajador As String, dtFechaDesde As Date) As Boolean

    Set rsIterador = dbHandle.OpenRecordset("SELECT * FROM nomObservaciones WHERE CodigoTrabajador = " & StringDB(istrTrabajador) & " AND Fecha >= " & FechaDB(dtFechaDesde) & " ORDER BY Fecha, Numero", dbOpenForwardOnly)
    If rsIterador.EOF Then
        Set rsIterador = Nothing
        IniciarIteradorTrabajador = False
        Exit Function
    End If
    
    IniciarIteradorTrabajador = True

End Function

Public Function NextItem() As clsObservaciones
Dim pRetVal As clsObservaciones

    If rsIterador Is Nothing Then
        Set pRetVal = Nothing
    ElseIf rsIterador.EOF Then
        Set rsIterador = Nothing
        Set pRetVal = Nothing
    Else
        Set pRetVal = New clsObservaciones
        LoadInstance rsIterador, pRetVal
        rsIterador.MoveNext
    End If

    Set NextItem = pRetVal

End Function

Public Function Load(nNumero As Long) As Boolean
Dim rs As Recordset, bRetVal As Boolean

    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomObservaciones WHERE Numero = " & NumeroDB(nNumero), dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs
    End If
    Set rs = Nothing

    Load = bRetVal

End Function
