VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaResumenIntervalo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private fView As lfQuickView
Private Totales(5) As Currency
Private SubTotales(5) As Currency
Private dtFechaDesde As Date, dtFechaHasta As Date
Private AnchoReporte As Integer
Private strTag1, strTag2

Private Sub EncabezadoResumen(inAgrupacion As Integer)
Dim str As String

    If fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Resumen de operaciones de nmina", vbCenter
    fView.Add "Entre el " & Format(dtFechaDesde, "Short Date") & " y el " & Format(dtFechaHasta, "Short Date"), vbCenter
    Select Case inAgrupacion
    Case 0
        fView.Add "Detallada por trabajador", vbCenter
    Case 1
        fView.Add "Totales por departamento", vbCenter
    Case 2
        fView.Add "Totales por cargo", vbCenter
    Case 3
        fView.Add "Totales por cargo/departamento", vbCenter
    End Select

    fView.Add ""
    str = "Emisin: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo
    str = str & Space(AnchoReporte - 12 - Len(str)) & "Pgina: " & Format(fView.Pagina, "0000")
    fView.Add str
    fView.Add String(fView.ReportWidth, "-")
    Select Case inAgrupacion
    Case 0
        fView.Add "Cod. del Trabajador    Asignaciones    Deducciones      Pago Neto   Aportes Pat.          Costo"
    Case 1, 3
        fView.Add "Cod. Departamento          Asignaciones    Deducciones      Pago Neto   Aportes Pat.          Costo"
    Case 2
        fView.Add "Cod. de Cargo              Asignaciones    Deducciones      Pago Neto   Aportes Pat.          Costo"
    End Select
    fView.Add String(fView.ReportWidth, "-")

End Sub

Private Sub PasarLinea(iCodigo As String, ivmAsig As Currency, ivmDed As Currency, ivmPago As Currency, ivmAportes As Currency, ivmCosto As Currency)
Dim sOut As String

    sOut = stFullLength(iCodigo, IIf(AnchoReporte = 95, 21, 25))
    sOut = sOut & FormatNumero(ivmAsig, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(ivmDed, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(ivmPago, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(ivmAportes, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(ivmCosto, "###,###,##0.00", 14) & " "
    fView.Add sOut

End Sub

Private Sub Ruptura(inOrden As Integer, inAgrupacion As Integer, sNewTag As String)
Dim str As String, i As Integer

    If strTag1 <> "" Then
        Select Case inOrden
        Case 1, 3
            str = "TOTAL DEPARTAMENTO"
        Case 2
            str = "TOTAL CARGO"
        End Select
    
        PasarLinea str, SubTotales(0), SubTotales(1), SubTotales(2), SubTotales(3), SubTotales(4)
        
        For i = 0 To 4
            SubTotales(i) = 0
        Next
    End If
    
    If fView.Linea > fView.LineasPagina - 5 Then
        EncabezadoResumen inAgrupacion
    End If

    If sNewTag <> "" Then
        Select Case inOrden
        Case 1, 3
            str = "DEPARTAMENTO: " & ptDepartamentos.Item(sNewTag).Descripcion & "(" & sNewTag & ")"
        Case 2
            str = "CARGO: " & ptCargos.Item(sNewTag).Descripcion & "(" & sNewTag & ")"
        End Select
        fView.Add str
    End If
    
End Sub

Private Sub PasarLineaResumen(inAgrupacion As Integer, inOrden As Integer, rs As Recordset)
Dim sOut As String, vmAsig As Currency, vmDed As Currency, vmAportes As Currency, vmPago As Currency, vmCosto As Currency
Dim sTagField As String, sTagField2 As String

    vmAsig = GetNumeroFromVariant(rs.Fields("[0]"))
    vmDed = GetNumeroFromVariant(rs.Fields("[1]"))
    vmAportes = GetNumeroFromVariant(rs.Fields("[2]"))
    vmPago = vmAsig - vmDed
    vmCosto = vmAsig + vmAportes
    
    Select Case inAgrupacion
        Case 0  ' Por Trabajador
            Select Case inOrden
            Case 1  ' Por Trabajador orden por Departamento
                sTagField = GetStringFromVariant(rs.Fields("Departamento"))
                If (sTagField <> strTag1) Then
                    Ruptura inOrden, inAgrupacion, sTagField
                    strTag1 = sTagField
                End If
            Case 2  ' Por Cargo
                sTagField = GetStringFromVariant(rs.Fields("Cargo"))
                If (sTagField <> strTag1) Then
                    Ruptura inOrden, inAgrupacion, sTagField
                    strTag1 = sTagField
                End If
            End Select
            
            If fView.Linea > fView.LineasPagina - 3 Then EncabezadoResumen inAgrupacion
            PasarLinea GetStringFromVariant(rs.Fields("Codigo")), vmAsig, vmDed, vmPago, vmAportes, vmCosto
        
        Case 1, 2  ' Por departamento
        
            If fView.Linea > fView.LineasPagina - 3 Then EncabezadoResumen inAgrupacion
            PasarLinea GetStringFromVariant(rs.Fields("Codigo")), vmAsig, vmDed, vmPago, vmAportes, vmCosto

        Case 3      ' Por cargo/departamento
            sTagField = GetStringFromVariant(rs.Fields("Departamento"))
            If (sTagField <> strTag1) Then
                Ruptura 3, inAgrupacion, sTagField
                strTag1 = sTagField
            End If
            If fView.Linea > fView.LineasPagina - 3 Then EncabezadoResumen inAgrupacion
            PasarLinea GetStringFromVariant(rs.Fields("Cargo")), vmAsig, vmDed, vmPago, vmAportes, vmCosto
            
    End Select

    SubTotales(0) = SubTotales(0) + vmAsig
    SubTotales(1) = SubTotales(1) + vmDed
    SubTotales(2) = SubTotales(2) + vmPago
    SubTotales(3) = SubTotales(3) + vmAportes
    SubTotales(4) = SubTotales(4) + vmCosto

    Totales(0) = Totales(0) + vmAsig
    Totales(1) = Totales(1) + vmDed
    Totales(2) = Totales(2) + vmPago
    Totales(3) = Totales(3) + vmAportes
    Totales(4) = Totales(4) + vmCosto

End Sub

Public Sub GenerarResumen(dtDesde As Date, dtHasta As Date, nAgrupacion As Integer, Optional ByVal nOrden As Integer = 0)
Dim sQuery As String, rs As Recordset, str As String

    dtFechaDesde = dtDesde: dtFechaHasta = dtHasta

    sQuery = "TRANSFORM Sum(Valor) "
    
    Select Case nAgrupacion
    Case 0  ' por trabajador
        sQuery = sQuery & "SELECT D.Trabajador As Codigo, T.Nombre, D.Departamento, D.Cargo "
        sQuery = sQuery & "FROM nomDetallesProceso AS D, nomTrabajadores AS T "
        sQuery = sQuery & "WHERE D.FechaCierre BETWEEN " & FechaDB(dtDesde) & " AND " & FechaDB(dtHasta) & " "
        sQuery = sQuery & "AND D.Trabajador = T.Codigo "
        sQuery = sQuery & "GROUP BY D.Trabajador, D.Cargo, D.Departamento, T.Nombre "
        Select Case nOrden
        Case 0
            sQuery = sQuery & "ORDER BY D.Trabajador "
        Case 1
            sQuery = sQuery & "ORDER BY D.Departamento "
        Case 2
            sQuery = sQuery & "ORDER BY D.Cargo "
        End Select
        sQuery = sQuery & "PIVOT Tipo IN (0, 1, 2)"
    
    Case 1, 2 ' Por departamento
        If nAgrupacion = 1 Then str = "Departamento" Else str = "Cargo"
        sQuery = sQuery & "SELECT " & str & " AS Codigo "
        sQuery = sQuery & "FROM nomDetallesProceso AS D "
        sQuery = sQuery & "WHERE D.FechaCierre BETWEEN " & FechaDB(dtDesde) & " AND " & FechaDB(dtHasta) & " "
        sQuery = sQuery & "GROUP BY D." & str & " "
        sQuery = sQuery & "ORDER BY D." & str & " "
        sQuery = sQuery & "PIVOT Tipo IN (0, 1, 2);"
    
    Case 3  ' Por Departamento | Cargo
        sQuery = sQuery & "SELECT D.Departamento, T2.Descripcion AS DescripcionDepto, D.Cargo, T1.Descripcion AS DescripcionCargo "
        sQuery = sQuery & "FROM nomDetallesProceso AS D, nomDescCargos AS T1, nomDepartamentos AS T2 "
        sQuery = sQuery & "WHERE D.FechaCierre BETWEEN " & FechaDB(dtDesde) & " AND " & FechaDB(dtHasta) & " "
        sQuery = sQuery & "AND D.Cargo = T1.Codigo "
        sQuery = sQuery & "AND D.Departamento = T2.Codigo "
        sQuery = sQuery & "GROUP BY D.Cargo, T1.Descripcion, D.Departamento, T2.Descripcion "
        sQuery = sQuery & "ORDER BY D.Departamento, D.Cargo "
        sQuery = sQuery & "PIVOT Tipo IN (0, 1, 2);"
    
    End Select

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    
    If rs.EOF Then
        mAdvertencia "No hay datos para el reporte"
        Set rs = Nothing
        Screen.MousePointer = vbDefault
        Exit Sub
    End If
    
    Set fView = New lfQuickView

    AnchoReporte = IIf(nAgrupacion = 0, 95, 99)
    fView.SetReportWidth AnchoReporte
    EncabezadoResumen nAgrupacion
    Do While Not rs.EOF
        PasarLineaResumen nAgrupacion, nOrden, rs
        rs.MoveNext
    Loop

    Select Case nAgrupacion
    Case 0
        If nOrden = 1 Or nOrden = 2 Then
            Ruptura nOrden, nAgrupacion, ""
        End If
    Case 3
        Ruptura 3, nAgrupacion, ""
    End Select
    
    PasarLinea "TOTAL", Totales(0), Totales(1), Totales(2), Totales(3), Totales(4)
    
    Set rs = Nothing
    Screen.MousePointer = vbDefault

    ShowNonModal fView
    
    Unload fView
    Set fView = Nothing

End Sub

