VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaPagosReporte"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Empresa
' Relacin Detallada de Pagos
' Proceso: 999. Tipo de Proceso: XXXXXXXX: Fecha de Cierre: 99-99-9999
'
'Fecha de Emisin: 999999. Operador: xxxxxxxxx.                                                                             Pgina: 9999
'-------------------------------------------------------------------------------------------------------------------------------------
'Cod.Trabajador       Departamento             Cargo                         Pago Neto Medio Codigo del Banco     Referencia
'-------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99    CH XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX

Private Const AnchoReporte = 133
Private fView As lfQuickView
Private pProceso As clsProcesoNomina
Private TotalPagado As Currency

Private Sub PasarLinea(istrCodigoTrabajador As String, istrDepartamento As String, istrCargo As String, ivmMontoPagado As Currency, istrMedio As String, istrCodigoBanco As String, istrNumeroDocumento As String)
Dim sOut As String

    sOut = stFullLength(istrCodigoTrabajador, 21) & _
           stFullLength(istrDepartamento, 25) & _
           stFullLength(istrCargo, 25) & _
           FormatNumero(ivmMontoPagado, "###,###,##0.00", 14) & _
           "    " & _
           stFullLength(istrMedio, 3) & _
           stFullLength(istrCodigoBanco, 21) & _
           stFullLength(istrNumeroDocumento, 20)
           
    fView.Add sOut
    
End Sub

Private Sub Encabezado()
Dim sEmision As String

    If fView.Linea > 1 Then
        PasarLinea "Van", "", "", TotalPagado, "", "", ""
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Relacion Detallada de Pagos", vbCenter
    fView.Add "Proceso de Nmina No. " & pProceso.Numero & ". Cierre: " & Format(pProceso.FechaCierre, "Short Date"), vbCenter
    fView.Add ""
    sEmision = "Emisin: " & Format(Now, "General Date") & ". OPERADOR: " & UsuarioActivo.Codigo
    sEmision = sEmision & Space(AnchoReporte - Len(sEmision) - 12) & "Pgina: " & Format(fView.Pagina, "0000")
    fView.Add sEmision
    fView.Add String(AnchoReporte, "-")
    fView.Add "Cod.Trabajador       Departamento             Cargo                         Pago Neto Medio Codigo del Banco     Referencia"
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
        PasarLinea "Vienen", "", "", TotalPagado, "", "", ""
    End If

End Sub

Private Sub AddLinea(istrCodigoTrabajador As String, istrDepartamento As String, istrCargo As String, ivmMontoPagado As Currency, istrMedio As String, istrCodigoBanco As String, istrNumeroDocumento As String)

    If fView.Linea > fView.LineasPagina - 3 Then
        Encabezado
    End If
    PasarLinea istrCodigoTrabajador, istrDepartamento, istrCargo, ivmMontoPagado, istrMedio, istrCodigoBanco, istrNumeroDocumento
    TotalPagado = TotalPagado + ivmMontoPagado

End Sub

Public Sub Generar(NumeroProceso As Long)
Dim sQuery As String, rs As Recordset

    Set pProceso = New clsProcesoNomina
    If Not pProceso.Load(NumeroProceso) Then
        mAdvertencia "Proceso " & NumeroProceso & " no registrado: clsListaPagosReporte::Generar"
        Set pProceso = Nothing
        Exit Sub
    End If

    sQuery = "SELECT * FROM nomPagosProceso WHERE ProcessID = " & NumeroDB(NumeroProceso) & " ORDER BY Trabajador"
    
    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte

        Encabezado
        Do While Not rs.EOF
            AddLinea GetStringFromVariant(rs.Fields("Trabajador")), _
                     GetStringFromVariant(rs.Fields("Departamento")), _
                     GetStringFromVariant(rs.Fields("Cargo")), _
                     GetNumeroFromVariant(rs.Fields("MontoPagado")), _
                     GetStringFromVariant(rs.Fields("Medio")), _
                     GetStringFromVariant(rs.Fields("CodigoBanco")), _
                     GetStringFromVariant(rs.Fields("NumeroDocumento"))
            rs.MoveNext
        Loop
        PasarLinea "TOTAL", "", "", TotalPagado, "", "", ""
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        Unload fView
        Set fView = Nothing
    End If
    Set rs = Nothing
    Screen.MousePointer = vbDefault
    Set pProceso = Nothing
    
End Sub
