VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaCategorias"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private fView As lfQuickView
Private Totales() As Currency
Private SubTotales() As Currency
Private dtFechaDesde As Date, dtFechaHasta As Date
Private AnchoReporte As Integer
Private strTag1 As String, strTag2 As String, strContenido As String

'--------------------------------------- ...  --------------
'CODIGO                   [   <VarTit1>] ...  [   <VarTitN>]
'XXXXXXXXXXXXXXXXXXXXXXXX ###,###,##0.00 ...  ###,###,##0.00
'----------------------------------- ...  --------------
'CODIGO               [   <VarTit1>] ...  [   <VarTitN>]
'XXXXXXXXXXXXXXXXXXXX ###,###,##0.00 ...  ###,###,##0.00

Private Sub Encabezado(inAgrupacion As Integer, rs As Recordset)
Dim str As String, i As Integer
Dim fOffset As Integer

    Select Case inAgrupacion
    Case 0
        fOffset = 2
    Case 1, 2
        fOffset = 0
    Case 3
        fOffset = 1
    End Select

    If fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Detalle de operaciones de nmina por " & strContenido, vbCenter
    fView.Add "Entre el " & Format(dtFechaDesde, "Short Date") & " y el " & Format(dtFechaHasta, "Short Date"), vbCenter
    Select Case inAgrupacion
    Case 0
        fView.Add "Detallada por trabajador", vbCenter
    Case 1
        fView.Add "Totales por departamento", vbCenter
    Case 2
        fView.Add "Totales por cargo", vbCenter
    Case 3
        fView.Add "Totales por cargo/departamento", vbCenter
    End Select

    fView.Add ""
    str = "Emisin: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo
    If AnchoReporte - 12 - Len(str) > 0 Then
        str = str & Space(AnchoReporte - 12 - Len(str)) & "Pgina: " & Format(fView.Pagina, "0000")
    Else
        str = str & "Pgina: " & Format(fView.Pagina, "0000")
    End If

    fView.Add str
    fView.Add String(fView.ReportWidth, "-")
    Select Case inAgrupacion
    Case 0
        str = stFullLength("Cod. del Trabajador", 20)
    Case 1, 3
        str = stFullLength("Cod. Departamento", 24)
    Case 2
        str = stFullLength("Cod. de Cargo", 24)
    End Select
    For i = fOffset + 1 To rs.Fields.Count - 1
        str = str & " " & stRightAlign(rs.Fields(i).Name, 14)
    Next
    fView.Add str
    fView.Add String(fView.ReportWidth, "-")

End Sub

Private Sub PasarLinea(istrTitulo As String, inAgrupacion As Integer, vmArray() As Currency)
Dim sOut As String, i As Integer

    sOut = stFullLength(istrTitulo, IIf(inAgrupacion = 0, 20, 24))
    For i = 1 To UBound(vmArray)
        sOut = sOut & " " & FormatNumero(vmArray(i), "###,###,##0.00", 14)
    Next
    fView.Add sOut

End Sub

Private Sub Ruptura(nOrden As Integer, nAgrupacion As Integer, sTagField As String)
Dim str As String, i As Integer

    If strTag1 <> "" Then
        Select Case nOrden
        Case 1, 3
            str = "TOTAL DEPARTAMENTO"
        Case 2
            str = "TOTAL CARGO"
        End Select
    
        PasarLinea str, nAgrupacion, SubTotales
        
        For i = 1 To UBound(SubTotales)
            SubTotales(i) = 0
        Next
    End If

    If sTagField <> "" Then
        Select Case nOrden
        Case 1, 3
            str = "DEPARTAMENTO: " & ptDepartamentos.Item(sTagField).Descripcion & "(" & sTagField & ")"
        Case 2
            str = "CARGO: " & ptCargos.Item(sTagField).Descripcion & "(" & sTagField & ")"
        End Select
        fView.Add str
    End If

End Sub

Private Sub PasarLineaDetalle(rs As Recordset, nOrden As Integer, nAgrupacion As Integer)
Dim vmArray() As Currency, i As Integer
Dim sTagField As String, sTagField2 As String
Dim fOffset As Integer

    ReDim vmArray(LBound(Totales) To UBound(Totales))
    Select Case nAgrupacion
    Case 0
        fOffset = 2
    Case 1, 2
        fOffset = 0
    Case 3
        fOffset = 1
    End Select

    For i = 1 To UBound(Totales)
        vmArray(i) = GetNumeroFromVariant(rs.Fields(i + fOffset).Value)
    Next

    Select Case nAgrupacion
        Case 0  ' Por Trabajador
            Select Case nOrden
            Case 1  ' Por Trabajador orden por Departamento
                sTagField = GetStringFromVariant(rs.Fields("Departamento"))
                If (sTagField <> strTag1) Then
                    Ruptura nOrden, nAgrupacion, sTagField
                    strTag1 = sTagField
                End If
            Case 2  ' Por Cargo
                sTagField = GetStringFromVariant(rs.Fields("Cargo"))
                If (sTagField <> strTag1) Then
                    Ruptura nOrden, nAgrupacion, sTagField
                    strTag1 = sTagField
                End If
            End Select

            If fView.Linea > fView.LineasPagina - 3 Then Encabezado nAgrupacion, rs
            PasarLinea GetStringFromVariant(rs.Fields("Codigo")), nAgrupacion, vmArray
        
        Case 1, 2  ' Por departamento
        
            If fView.Linea > fView.LineasPagina - 3 Then Encabezado nAgrupacion, rs
            PasarLinea GetStringFromVariant(rs.Fields("Codigo")), nAgrupacion, vmArray

        Case 3      ' Por cargo/departamento
            sTagField = GetStringFromVariant(rs.Fields("Departamento"))
            If (sTagField <> strTag1) Then
                Ruptura 3, nAgrupacion, sTagField
                strTag1 = sTagField
            End If
            If fView.Linea > fView.LineasPagina - 3 Then Encabezado nAgrupacion, rs
            PasarLinea GetStringFromVariant(rs.Fields("Cargo")), nAgrupacion, vmArray
            
    End Select


    For i = 1 To UBound(Totales)
        SubTotales(i) = SubTotales(i) + vmArray(i)
        Totales(i) = Totales(i) + vmArray(i)
    Next
    
    ReDim vmArray(0)

End Sub

Public Sub Generar(istrCodigoCampo As String, idtDesde As Date, idtHasta As Date, inAgrupacion As Integer, inOrdenamiento As Integer, pCategoriasSeleccionadas As Collection)
Dim sQuery As String, sFieldList As String, v As Variant, str As String, rs As Recordset

    strContenido = istrCodigoCampo
    dtFechaDesde = idtDesde: dtFechaHasta = idtHasta
    
    sFieldList = ""
    For Each v In pCategoriasSeleccionadas  ' Para especificar columnas
        If sFieldList = "" Then
            sFieldList = "("
        Else
            sFieldList = sFieldList & ", "
        End If
        sFieldList = sFieldList & v
    Next
    sFieldList = sFieldList & ")"

' Armar el Query:

    sQuery = "Transform Sum(Valor) "
    
    Select Case inAgrupacion
    Case 0      ' Por trabajador
        
        sQuery = sQuery & "SELECT D.Trabajador as Codigo, D.Departamento, D.Cargo "
        sQuery = sQuery & "FROM nomDetallesProceso AS D "
        sQuery = sQuery & "WHERE D.FechaCierre BETWEEN " & FechaDB(idtDesde) & " AND " & FechaDB(idtHasta) & " "
        sQuery = sQuery & "GROUP BY D.Trabajador, D.Departamento, D.Cargo "
        Select Case inOrdenamiento
        Case 0
            sQuery = sQuery & "ORDER BY D.Trabajador "
        Case 1
            sQuery = sQuery & "ORDER BY D.Departamento, D.Trabajador "
        Case 2
            sQuery = sQuery & "ORDER BY D.Cargo, D.Trabajador "
        End Select
        sQuery = sQuery & "PIVOT " & istrCodigoCampo & " IN " & sFieldList
    
    Case 1, 2     ' Por Cargo o Departamento
        If inAgrupacion = 1 Then str = "Departamento" Else str = "Cargo"
        sQuery = sQuery & "SELECT " & str & " AS Codigo "
        sQuery = sQuery & "FROM nomDetallesProceso "
        sQuery = sQuery & "WHERE FechaCierre BETWEEN " & FechaDB(idtDesde) & " AND " & FechaDB(idtHasta) & " "
        sQuery = sQuery & "GROUP BY  " & str & " "
        sQuery = sQuery & "ORDER BY  " & str & " "
        sQuery = sQuery & "PIVOT " & istrCodigoCampo & " IN " & sFieldList
    
    Case 3  ' Por Departamento/Cargo
        sQuery = sQuery & "SELECT Departamento "
        sQuery = sQuery & "FROM nomDetallesProceso "
        sQuery = sQuery & "WHERE FechaCierre BETWEEN " & FechaDB(idtDesde) & " AND " & FechaDB(idtHasta) & " "
        sQuery = sQuery & "GROUP BY  Departamento, Cargo "
        sQuery = sQuery & "ORDER BY  Departamento, Cargo "
        sQuery = sQuery & "PIVOT " & istrCodigoCampo & " IN " & sFieldList
    
    End Select

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    
    If rs.EOF Then
        mAdvertencia "No hay datos para el reporte"
        Set rs = Nothing
        Screen.MousePointer = vbDefault
        Exit Sub
    End If
    
    Set fView = New lfQuickView

    AnchoReporte = IIf(inAgrupacion = 0, 20, 24) + (15 * pCategoriasSeleccionadas.Count)
    
    If fView.SetReportWidth(AnchoReporte) Then
        ReDim Totales(1 To pCategoriasSeleccionadas.Count)
        ReDim SubTotales(1 To pCategoriasSeleccionadas.Count)
    
        Encabezado inAgrupacion, rs   ' Se pasa el Recordset para que tome los ttulos de las columnas (Fields(n).Name)
                                      ' inAgrupacion es para que determine el ttulo y longitud del primer campo
        Do While Not rs.EOF
            PasarLineaDetalle rs, inOrdenamiento, inAgrupacion
            rs.MoveNext
        Loop
    
        Select Case inAgrupacion
        Case 0
            If inOrdenamiento = 1 Or inOrdenamiento = 2 Then
                Ruptura inOrdenamiento, inAgrupacion, ""
            End If
        Case 3
            Ruptura 3, inAgrupacion, ""
        End Select
    
        PasarLinea "TOTAL", inAgrupacion, Totales
    
        Screen.MousePointer = vbDefault
    
        ShowNonModal fView
    End If

    Set rs = Nothing
    Unload fView
    Set fView = Nothing

End Sub
