VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsInstanciadorEntidad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' EntidadPersonaComercial es una "Persona Natural o Jurdica" con la cual
' se mantiene cualquier tipo de relacin contable. As of 18-1-2000,
' se reduce a Clientes, Proveedores, Vendedores y Bancos, aunque
' podra ampliarse con Empleados y cualquier otro tipo de
' Deudor/Acreedor.
Function EntidadPersonaComercial(stTipo As String, stCodigo As String) As Object
Dim objResult As Object
    
#If IsNotMain = 0 Then
    
    Select Case stTipo
    Case "BCO"
        Set objResult = New clsBancos
    Case Else
        Set EntidadPersonaComercial = Nothing
        Exit Function       ' Codigo invlido
    End Select
    
    If objResult.TipoEntidad <> stTipo Then
        ReportarError False, 10001, "Discrepancia: stTipo=" & stTipo & "Entidad.Tipo=" & objResult.TipoEntidad, "clsEntidad.EntidadPNJ"
        Set EntidadPersonaComercial = Nothing
        Exit Function
    End If
        
    If Not objResult.Load(stCodigo) Then
        Set objResult = Nothing
    End If

#Else

    Set objResult = Nothing
    
#End If
    
    Set EntidadPersonaComercial = objResult

End Function

Function Entidad(stTipo As String, stCodigo As String) As Object
Dim objResult As Object

  Set objResult = EntidadPersonaComercial(stTipo, stCodigo)
  Set Entidad = objResult

End Function

Public Function CreateRef(stTipo As String) As Object
Dim objResult As Object

#If IsNotMain = 0 Then

    Select Case stTipo
    Case "BCO"
        Set objResult = New clsBancos
    Case Else
        Set CreateRef = Nothing
        Exit Function       ' Codigo invlido
    End Select
    
    If objResult.TipoEntidad <> stTipo Then
        ReportarError False, 10001, "Discrepancia: stTipo=" & stTipo & "Entidad.Tipo=" & objResult.TipoEntidad, "clsEntidad.CreateRef"
        Set CreateRef = Nothing
        Exit Function
    End If
        
#Else

    Set objResult = Nothing

#End If
    
    Set CreateRef = objResult

End Function

' EntidadDOCUMENTO es un documento de algn tipo.
Function EntidadDOCUMENTO(stTipo As String, lngNumero As Long) As Object
Dim objResult As Object
    
    Set EntidadDOCUMENTO = Nothing
    Exit Function

End Function

' EntidadDOCUMENTOByRef es un documento de algn tipo.
Function EntidadDOCUMENTOByRef(stTipo As String, stRef As String) As Object
    
    Set EntidadDOCUMENTOByRef = Nothing

End Function

Public Function ValidarTipoISDOC(sTipo As String) As Boolean

    ValidarTipoISDOC = False

End Function

Function NombreEntidadISPC(stTipo As String, bPlural As Boolean) As String
Dim stResult As String

    Select Case stTipo
    Case "BCO"
        stResult = "Banco"
        If bPlural Then stResult = stResult & "s"
    Case Else
        stResult = "Desconocido: " & stTipo
    End Select

    NombreEntidadISPC = stResult
End Function

Sub SetCodeBoxData(stTipo As String, pBox As ucCodeBox)
    Select Case stTipo
    Case "BCO"
        pBox.Titulo = "Bancos"
        pBox.NombreTabla = "Bancos"
        pBox.NombreCodigo = "Codigo"
        pBox.NombreDescriptor = "Nombre"
    Case Else
        pBox.Enabled = False
        pBox.Text = "" & stTipo & "??"
    End Select

End Sub

Public Sub FillComboTiposEntidad(cbxDest As ComboBox)
Dim orgTxt As String
    orgTxt = cbxDest.Text
    cbxDest.Clear
    cbxDest.AddItem "Banco (BCO)"
    cbxDest.Text = orgTxt
End Sub

Public Function VerificarTipoEntidad(stTest As String) As Boolean
    
    stTest = Trim(Format(stTest, ">"))
    If stTest = "BCO" Then
        VerificarTipoEntidad = True
    Else
        VerificarTipoEntidad = False
    End If

End Function
