VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsHistoriaTrabajador"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public CodigoTrabajador As String
Public Desde As Date
Public Departamento As String
Public Cargo As String
Public Sueldo As Currency
Public Base As Integer  ' 0: Eventual o a destajo, 1:Diario, 2:Semanal, 3:Quincenal, 4:Mensual

Private rsIterador As Recordset

Public Function Save() As Boolean
Dim sQuery As String, bRetVal As Boolean

Retry:
    On Error GoTo ErrHandler
    bRetVal = True
    sQuery = "INSERT INTO nomHistTrab (CodigoTrabajador, Desde, Departamento, Cargo, Sueldo, Base) SELECT "
    sQuery = sQuery & StringDB(Me.CodigoTrabajador) & ", "
    sQuery = sQuery & FechaDB(Me.Desde) & ", "
    sQuery = sQuery & StringDB(Me.Departamento) & ", "
    sQuery = sQuery & StringDB(Me.Cargo) & ", "
    sQuery = sQuery & NumeroDB(Me.Sueldo) & ", "
    sQuery = sQuery & NumeroDB(Me.Base)

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    Save = bRetVal
    Exit Function

ErrHandler:
    If Err.Number <> 3022 Then
        ReportarError False, Err.Number, Err.Description, "clsHistoriaTrabajador::Save"
        bRetVal = False
        Resume ResumePoint
    End If

    dbHandle.Execute "Delete * FROM nomHistTrab WHERE CodigoTrabajador = " & StringDB(Me.CodigoTrabajador) & " AND Desde = " & FechaDB(Me.Desde), dbFailOnError
    Resume Retry

End Function

Public Sub LoadInstance(rs As Recordset, Optional ipDest As clsHistoriaTrabajador = Nothing)
Dim pDest As clsHistoriaTrabajador

    If ipDest Is Nothing Then
        Set pDest = Me
    Else
        Set pDest = ipDest
    End If

    With pDest
    .CodigoTrabajador = GetStringFromVariant(rs.Fields("CodigoTrabajador"))
    .Desde = GetDateFromVariant(rs.Fields("Desde"))
    .Departamento = GetStringFromVariant(rs.Fields("Departamento"))
    .Cargo = GetStringFromVariant(rs.Fields("Cargo"))
    .Sueldo = GetNumeroFromVariant(rs.Fields("Sueldo"))
    .Base = GetNumeroFromVariant(rs.Fields("Base"))
    End With

End Sub

Public Function IniciarIterador(istrCodigoTrabajador As String) As Boolean

    If Not rsIterador Is Nothing Then
        mAdvertencia "clsHistoriaTrabajador: ya tiene un iterador activo"
        IniciarIterador = False
        Exit Function
    End If
    
    Set rsIterador = dbHandle.OpenRecordset("SELECT * FROM nomHistTrab WHERE CodigoTrabajador = " & StringDB(istrCodigoTrabajador) & " ORDER BY Desde", dbOpenForwardOnly)
    If rsIterador.EOF Then
        Set rsIterador = Nothing
        IniciarIterador = False
        Exit Function
    End If
    
    IniciarIterador = True

End Function

Public Function NextItemIterador() As clsHistoriaTrabajador
Dim pItem As clsHistoriaTrabajador

    On Error GoTo ErrHandler

    If rsIterador.EOF Then
        Set rsIterador = Nothing
        Set NextItemIterador = Nothing
        Exit Function
    End If

    Set pItem = New clsHistoriaTrabajador
    LoadInstance rsIterador, pItem
    
    rsIterador.MoveNext

ResumePoint:
    Set NextItemIterador = pItem
    Exit Function

ErrHandler:
    Set rsIterador = Nothing
    Set pItem = Nothing
    Resume ResumePoint

End Function

Public Sub ActualizarTrabajador(istrCodTrab As String)
Dim pTrabajador As clsTrabajador, rs As Recordset

    Set pTrabajador = New clsTrabajador
    If pTrabajador.Load(istrCodTrab) Then
        Set rs = dbHandle.OpenRecordset("SELECT TOP 1 * FROM nomHistTrab WHERE CodigoTrabajador = " & StringDB(istrCodTrab) & " ORDER BY Desde DESC", dbOpenForwardOnly)
        If Not rs.EOF Then
            LoadInstance rs
            pTrabajador.ActualizarPosicion Me.Departamento, Me.Cargo, Me.Sueldo, Me.Base, Me.Desde
        End If
        Set rs = Nothing
    End If
    Set pTrabajador = Nothing

End Sub

Public Function Eliminar() As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
        
    dbHandle.Execute "DELETE * FROM nomHistTrab WHERE CodigoTrabajador = " & StringDB(Me.CodigoTrabajador) & " AND Desde = " & FechaDB(Me.Desde), dbFailOnError
    If dbHandle.RecordsAffected < 1 Then bRetVal = False

ResumePoint:
    Eliminar = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsHistoriaTrabajador::Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function LoadPosicionTrabajador(istrCodigoTrabajador As String, idtFecha As Date) As Boolean
Dim rs As Recordset, sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler

    sQuery = "SELECT TOP 1 * FROM nomHistTrab WHERE CodigoTrabajador = " & StringDB(istrCodigoTrabajador) & " AND Desde <= " & FechaDB(idtFecha) & " ORDER BY Desde DESC"
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        LoadInstance rs
        bRetVal = True
    End If
    
ResumePoint:
    Set rs = Nothing
    LoadPosicionTrabajador = bRetVal
    Exit Function

ErrHandler:
    
    bRetVal = False
    Resume ResumePoint

End Function
