VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsHabilidadTrabajador"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public CodigoTrabajador As String
Public CodigoHabilidad As String
Public GradoHabilidad As Long
Public Notas As String

Private rsIterador As Recordset

Public Sub LoadInstance(rs As Recordset, Optional ipDest As clsHabilidadTrabajador = Nothing)
Dim pDest As clsHabilidadTrabajador

    If ipDest Is Nothing Then
        Set pDest = Me
    Else
        Set pDest = ipDest
    End If

    With pDest
    .CodigoTrabajador = GetStringFromVariant(rs.Fields("CodigoTrabajador"))
    .CodigoHabilidad = GetStringFromVariant(rs.Fields("CodigoHabilidad"))
    .GradoHabilidad = GetNumeroFromVariant(rs.Fields("Grado"))
    .Notas = Field2Function(GetStringFromVariant(rs.Fields("Notas")))
    End With

End Sub

Public Function Load(istrCodigoTrabajador As String, istrCodigoHabilidad As String) As Boolean
Dim rs As Recordset, bRetVal As Boolean

    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomHabilidadesTrabajador WHERE CodigoTrabajador = " & StringDB(istrCodigoTrabajador) & " AND CodigoHabilidad = " & StringDB(istrCodigoHabilidad), dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs
    End If
    Set rs = Nothing

    Load = bRetVal

End Function

Public Function Update(istrCodigoTrabajador As String, istrCodigoHabilidad As String, ByVal lngGradoHabilidad As Long, istrNotas As String) As Boolean
Dim bRetVal As Boolean, sQuery As String, sBuffNotas As String

    On Error GoTo ErrHandler
    bRetVal = True
    sBuffNotas = StringDB(Function2Field(istrNotas))

    sQuery = "UPDATE nomHabilidadesTrabajador SET "
    sQuery = sQuery & "Grado = " & NumeroDB(lngGradoHabilidad) & ", "
    sQuery = sQuery & "Notas = " & sBuffNotas & " "
    sQuery = sQuery & "WHERE CodigoTrabajador = " & StringDB(istrCodigoTrabajador) & " AND "
    sQuery = sQuery & "CodigoHabilidad = " & StringDB(istrCodigoHabilidad)
    
    dbHandle.Execute sQuery, dbFailOnError
    
    If dbHandle.RecordsAffected = 0 Then
        sQuery = "INSERT INTO nomHabilidadesTrabajador (CodigoTrabajador, CodigoHabilidad, Grado, Notas) SELECT "
        sQuery = sQuery & StringDB(istrCodigoTrabajador) & ", "
        sQuery = sQuery & StringDB(istrCodigoHabilidad) & ", "
        sQuery = sQuery & NumeroDB(lngGradoHabilidad) & ", "
        sQuery = sQuery & sBuffNotas
        
        dbHandle.Execute sQuery, dbFailOnError
    End If

ResumePoint:
    Update = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsHabilidadTrabajdor::Update"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function IniciarIteradorTrabajador(istrCodigoTrabajador As String) As Boolean
Dim sQuery As String

    sQuery = "SELECT * FROM nomHabilidadesTrabajador WHERE CodigoTrabajador = " & StringDB(istrCodigoTrabajador) & " ORDER BY CodigoHabilidad"
    Set rsIterador = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rsIterador.EOF Then
        Set rsIterador = Nothing
        IniciarIteradorTrabajador = False
        Exit Function
    End If
    
    IniciarIteradorTrabajador = True

End Function

Public Function NextHabilidadTrabajador() As clsHabilidadTrabajador
Dim pRetVal As clsHabilidadTrabajador

    If rsIterador.EOF Then
        rsIterador.Close
        Set rsIterador = Nothing
    End If

    If rsIterador Is Nothing Then
        Set NextHabilidadTrabajador = Nothing
        Exit Function
    End If

    Set pRetVal = New clsHabilidadTrabajador
    LoadInstance rsIterador, pRetVal
    rsIterador.MoveNext
    
    Set NextHabilidadTrabajador = pRetVal

End Function

Public Function Eliminar(istrCodigoTrabajador As String, istrCodigoHabilidad As String) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    dbHandle.Execute "DELETE * FROM nomHabilidadesTrabajador WHERE CodigoTrabajador = " & StringDB(istrCodigoTrabajador) & " AND CodigoHabilidad = " & StringDB(istrCodigoHabilidad), dbFailOnError
    If dbHandle.RecordsAffected < 1 Then bRetVal = False

ResumePoint:
    Eliminar = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsHabilidadTrabajdor::Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function
