VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsGeneradorFormatos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public CodigoScript As String
Public FechaCierre As Date

Private WithEvents pRecibo As clsRecibo
Attribute pRecibo.VB_VarHelpID = -1
Private pScript As clsScript, _
        WithEvents pTrabajador As clsTrabajador
Attribute pTrabajador.VB_VarHelpID = -1
Private pInterprete As Object
Private NumeroRecibo As Long


Private Function Setup() As Boolean
Dim bRetVal As Boolean
Dim pAsigDed As clsAsigDed

    On Error GoTo ErrHandler
    bRetVal = True

    Set pInterprete = CreateObject("ScriptControl")
    pInterprete.Language = "VBScript"

    Set pTrabajador = New clsTrabajador
    Set pRecibo = New clsRecibo
    
    ResetGlobalScript
    pGlobalScript.AddObject "Proceso", Me
    pGlobalScript.AddObject "Trabajador", pTrabajador
    pGlobalScript.AddObject "Recibo", pRecibo
    pGlobalScript.AddObject "Script", pScript

    pInterprete.AddObject "Proceso", Me
    pInterprete.AddObject "Trabajador", pTrabajador
    pInterprete.AddObject "Recibo", pRecibo
    pInterprete.AddObject "Script", pScript
    
    pInterprete.AddObject "GlobalScript", mMain.pGlobalScript
    pInterprete.AddObject "Factoria", mMain.pFactoria

    pInterprete.AddCode pScript.codeBaseScript ' Contiene todas las definiciones globales del script
    
    pInterprete.AddCode "Function TrabajadorElegible" & vbCrLf & _
                          pScript.codeTrabajadorElegible & _
                          "End Function"

    pInterprete.Modules.Add "AsigDed"  ' Para separar las asignaciones/deducciones del cdigo general.
    For Each pAsigDed In pScript.AsigDed
10      pInterprete.Modules("AsigDed").AddCode _
            "Function " & pAsigDed.Codigo & vbCrLf & _
            pAsigDed.Formula & vbCrLf & _
            "End Function" & vbCrLf
    Next

ResumePoint:
    Setup = bRetVal
    Exit Function

ErrHandler:
Dim strErrText As String

    If Erl = 10 Then
        strErrText = ":" & vbCrLf & "Error en evaluacin de AsigDed " & pAsigDed.Codigo
    ElseIf InStr(1, Err.Source, "VBScript") Then
        strErrText = ":" & vbCrLf & pInterprete.Error.Text
    Else
        strErrText = ""
    End If
    ReportarError False, Err.Number, Err.Description, Err.Source & " en clsProcesoNomina::Go" & strErrText
    bRetVal = False

    Resume ResumePoint

End Function

Public Sub Go()
Dim pAsigDed As clsAsigDed, lpTrabajador As clsTrabajador, vmMontoAsigDed As Currency
Dim totAsig As Currency, totDed As Currency
Dim pExcepcion As clsExcepcion, vExcepcion As Variant, vNombreRecibo As Variant
Dim pDatosRecibo As clsDatosRecibo
Dim CPrinter As CLinePrinter, sPrinterName As String

    On Error GoTo ErrHandler1

    NumeroRecibo = 1
    Set pScript = New clsScript
    If Not pScript.Load(CodigoScript) Then
        mAdvertencia "Cdigo de script invlido: " & CodigoScript
        Set pScript = Nothing
        Exit Sub
    End If

    If Not Setup Then
        Set pScript = Nothing
        Exit Sub
    End If

    Set pExcepcion = New clsExcepcion

    Screen.MousePointer = vbHourglass

    On Error GoTo ErrHandler2

    If pScript.StartIteradorTrabajadores Then

        Do
            Set lpTrabajador = pScript.NextTrabajador
            If Not lpTrabajador Is Nothing Then
                
                lpTrabajador.Clone pTrabajador  ' Copia el trabajador ledo al Script
                
                If pInterprete.Eval("TrabajadorElegible") Then
                    For Each pAsigDed In pScript.AsigDed
        
10                      vmMontoAsigDed = pInterprete.Modules("AsigDed").Eval(pAsigDed.Codigo)
                        If vmMontoAsigDed <> 0 Then
                            If pAsigDed.CodigoRecibo <> "" Then
                                pRecibo.Acumular pAsigDed.CodigoRecibo, vmMontoAsigDed, pAsigDed.Tipo
                            End If
                        End If
                    Next
                    
                    For Each pDatosRecibo In pScript.Recibos
                        sPrinterName = Printer.DeviceName
                        Set CPrinter = New CLinePrinter
                        CPrinter.SetPrinter pDatosRecibo.NombrePrinter
                        pRecibo.PrintRecibo CStr(pDatosRecibo.NombreArchivo), True
                        CPrinter.SetPrinter sPrinterName
                    Next
        
                        NumeroRecibo = NumeroRecibo + 1
                End If
                pRecibo.Reinit
            
            End If
        Loop While Not lpTrabajador Is Nothing


    End If
    
ResumePoint:

    Screen.MousePointer = vbDefault
    
    ResetGlobalScript
    Set pExcepcion = Nothing
    Set pRecibo = Nothing
    Set pTrabajador = Nothing
    Set pInterprete = Nothing
    Set pScript = Nothing
    
    Exit Sub

ErrHandler2:

ErrHandler1:
Dim strErrText As String

    If Erl = 10 Then
        strErrText = ":" & vbCrLf & "Error en evaluacin de AsigDed " & pAsigDed.Codigo
    ElseIf InStr(1, Err.Source, "VBScript") Then
        strErrText = ":" & vbCrLf & pInterprete.Error.Text
    Else
        strErrText = ""
    End If
    ReportarError False, Err.Number, Err.Description, Err.Source & " en clsProcesoNomina::Go" & strErrText
    Resume ResumePoint

End Sub

Private Sub pRecibo_RequestEvarVal(oResult As Boolean, istrVarID As String, ovRetBuff As Variant, ostrRetBuff As String)
Dim vRetVal As Variant
Dim sRetStr As String

    oResult = False
    Select Case UCase(istrVarID)
    Case "FECHACIERRE"
        oResult = True
        ovRetBuff = Me.FechaCierre
        ostrRetBuff = Format(Me.FechaCierre, "Short Date")
    Case "TIPOSCRIPT", "CODIGOPROCESO"
        oResult = True
        ovRetBuff = Me.CodigoScript
        ostrRetBuff = Me.CodigoScript
    Case "OPERADOR"
        oResult = True
        ovRetBuff = UsuarioActivo.Codigo
        ostrRetBuff = UsuarioActivo.Codigo
    End Select
    If oResult Then Exit Sub    ' Ya pas... Request para el proceso

    oResult = pTrabajador.EvalVar(CStr(istrVarID), ovRetBuff, sRetStr)
    If oResult Then
        ostrRetBuff = sRetStr
        Exit Sub
    End If                      ' Request para el Trabajador

    oResult = Empresa.EvalVar(CStr(istrVarID), ovRetBuff, sRetStr)
    If oResult Then
        ostrRetBuff = sRetStr
        Exit Sub
    End If                      ' Request para la Empresa

    oResult = True
    vRetVal = pInterprete.Eval(istrVarID)   ' Prueba para el componente VBS del Proceso
    ovRetBuff = vRetVal
    Select Case varType(vRetVal)
    Case vbBoolean
        ostrRetBuff = IIf(vRetVal, "VERDADERO", "FALSO")
    Case vbByte, vbInteger, vbLong
        ostrRetBuff = Format(vRetVal, "##,###,##0")
    Case vbCurrency, vbDecimal, vbDouble, vbSingle
        ostrRetBuff = Format(vRetVal, "###,###,##0.00")
    Case vbDate
        ostrRetBuff = Format(vRetVal, "Short Date")
    Case vbString, vbVariant
        ostrRetBuff = vRetVal
    Case Else
        oResult = False
    End Select
    If oResult Then Exit Sub    ' Procesado por componente VBS del Proceso

    oResult = True
    vRetVal = pGlobalScript.Eval(istrVarID)   ' Prueba para el componente VBS Global
    ovRetBuff = vRetVal
    Select Case varType(vRetVal)
    Case vbBoolean
        ostrRetBuff = IIf(vRetVal, "VERDADERO", "FALSO")
    Case vbByte, vbInteger, vbLong
        ostrRetBuff = Format(vRetVal, "##,###,##0")
    Case vbCurrency, vbDecimal, vbDouble, vbSingle
        ostrRetBuff = Format(vRetVal, "###,###,##0.00")
    Case vbDate
        ostrRetBuff = Format(vRetVal, "Short Date")
    Case vbString, vbVariant
        ostrRetBuff = vRetVal
    Case Else
        oResult = False
    End Select

End Sub

Private Sub pRecibo_RequestFormato(pDetalle As Variant, ostrDestBuffer As Variant)

    If scExisteIdentificador(pInterprete, "FormatearDetallesRecibo") Then
        pInterprete.Run "FormatearDetallesRecibo", pDetalle, ostrDestBuffer
        Exit Sub
    End If

    If scExisteIdentificador(pGlobalScript, "FormatearDetallesRecibo") Then
        pGlobalScript.Run "FormatearDetallesRecibo", pDetalle, ostrDestBuffer
        Exit Sub
    End If

End Sub
