VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsFiltro"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const TABLE_NAME = "nomFiltros"

Public Codigo As String
Public Atributo As String
Public Tipo As Boolean          ' False: FieldDef, True: AttributeValue
Public ValorDesde As String
Public ValorHasta As String

Private Sub LoadInstance(rs As Recordset, Optional pDest As clsFiltro = Nothing)
Dim lpDest As clsFiltro

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        Set lpDest = pDest
    End If

    With rs
    lpDest.Codigo = stGetStringFromVariant(.Fields("Codigo"))
    lpDest.Atributo = stGetStringFromVariant(.Fields("codigoAtributo"))
    lpDest.ValorDesde = stGetStringFromVariant(.Fields("valorDesde"))
    lpDest.ValorHasta = stGetStringFromVariant(.Fields("valorHasta"))
    End With

End Sub

Public Function Load(Codigo As String, Optional Destino As clsFiltro = Nothing) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset

    On Error GoTo ErrHandler

    sQuery = "SELECT * FROM nomFiltros WHERE Codigo = " & StringDB(Codigo)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs, Destino
    End If

ResumePoint:

    Set rs = Nothing
    Load = bRetVal
    Exit Function

ErrHandler:
    
    Err.Raise Err.Number, "clsFiltro::Load", Err.Description
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function SaveNew( _
    istrCodigo As String, _
    istrcodigoAtributo As String, _
    istrValorDesde As String, _
    istrValorHasta As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "INSERT INTO nomFiltros (Codigo, codigoAtributo, valorDesde, valorHasta) VALUES ("
    sQuery = sQuery & StringDB(istrCodigo)
    sQuery = sQuery & "," & StringDB(istrcodigoAtributo)
    sQuery = sQuery & "," & StringDB(istrValorDesde)
    sQuery = sQuery & "," & StringDB(istrValorHasta)
    sQuery = sQuery & ")"

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    SaveNew = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsFiltro::AddNew"
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos( _
    sCodigo As String, _
    istrcodigoAtributo As String, _
    istrValorDesde As String, _
    istrValorHasta As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "UPDATE nomFiltros SET "
    sQuery = sQuery & "codigoAtributo = " & StringDB(istrcodigoAtributo)
    sQuery = sQuery & ", valorDesde = " & StringDB(istrValorDesde)
    sQuery = sQuery & ", valorHasta = " & StringDB(istrValorHasta)
    
    sQuery = sQuery & " WHERE Codigo = " & StringDB(sCodigo)

    dbHandle.Execute sQuery, dbFailOnError
    
ResumePoint:
    ActualizarDescriptivos = bRetVal
    Exit Function

ErrHandler:
    Err.Raise Err.Number, "clsFiltro::ActualizarDescriptivos", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Eliminar() As Boolean
Dim sQuery As String, bRetVal As Boolean, rs As Recordset, n As Long

    sQuery = "SELECT COUNT(codigoFiltro) AS Q FROM nomFiltrosScript WHERE codigoFiltro = " & StringDB(Me.Codigo)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        n = 0
    Else
        n = GetNumeroFromVariant(rs.Fields("Q"))
    End If
    Set rs = Nothing

    If n > 0 Then
        mAdvertencia "El filtro es usado por scripts... no puede ser eliminado"
        Eliminar = False
        Exit Function
    End If

    sQuery = "DELETE * FROM nomFiltros WHERE Codigo = " & StringDB(Me.Codigo)
    bRetVal = True
    On Error GoTo ErrHandler

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    Eliminar = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsFiltro::Eliminar"
    Resume ResumePoint

End Function

Public Function FiltrosScript(istrCodigoScript As String) As Collection
Dim sQuery As String, pRetCol As Collection, pFiltro As clsFiltro, rs As Recordset

    On Error GoTo ErrHandler

    sQuery = "SELECT * FROM nomFiltros WHERE Codigo IN (Select codigoFiltro FROM nomFiltrosScript WHERE codigoScript = " & StringDB(istrCodigoScript) & ")"
    Set pRetCol = New Collection

    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    Do While Not rs.EOF
        Set pFiltro = New clsFiltro
        LoadInstance rs, pFiltro
        pRetCol.Add pFiltro
        rs.MoveNext
    Loop
    Set rs = Nothing

ResumePoint:
    Set FiltrosScript = pRetCol
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsFiltro::FiltrosScript"
    Set pRetCol = Nothing
    Resume ResumePoint

End Function

Public Sub FillCombo(pDestCombo As ComboBox)
Dim sOrgText As String, rs As Recordset

    sOrgText = pDestCombo.Text
    pDestCombo.Clear
    Set rs = dbHandle.OpenRecordset("SELECT Codigo FROM nomFiltros ORDER BY Codigo", dbOpenForwardOnly)
    Do While Not rs.EOF
        pDestCombo.AddItem GetStringFromVariant(rs.Fields("Codigo"))
        rs.MoveNext
    Loop
    Set rs = Nothing
    pDestCombo.Text = sOrgText
    
End Sub

Public Function Filtros() As Collection
Dim rs As Recordset, retCol As Collection, pFiltro As clsFiltro

    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomFiltros ORDER BY Codigo", dbOpenForwardOnly)
    Set retCol = New Collection
    
    Do While Not rs.EOF
        Set pFiltro = New clsFiltro
        LoadInstance rs, pFiltro
        retCol.Add pFiltro
        rs.MoveNext
    Loop
    
    Set rs = Nothing
    
    Set Filtros = retCol

End Function
