VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsExcepciones"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public AllowRefresh As Boolean
Private Contenido As Collection

' Agrega una entrada a la tabla, que pasa a la BD
Public Function Add( _
    Codigo As String, _
    Descripcion As String, _
    bVisible As Integer) As clsDescriptorExcepcion
Dim sqlQuery As String, objNewMember As clsDescriptorExcepcion, i As Integer
    
    On Error GoTo ErrHandler
    sqlQuery = "INSERT INTO nomTiposExcepcion (Codigo, Descripcion, Visible) VALUES (" & StringDB(Codigo) & ", " & StringDB(Descripcion) & ", " & NumeroDB(bVisible) & ")"
    dbHandle.Execute sqlQuery, dbFailOnError
    'create a new object
    Set objNewMember = New clsDescriptorExcepcion

    With objNewMember
        .Codigo = Codigo
        .Descripcion = Descripcion
        .Visible = bVisible
    End With

    'set the properties passed into the method
    
    i = 1
    Do While i <= Contenido.Count
        If Contenido.Item(i).Codigo < Codigo Then
            i = i + 1
        Else
            Exit Do
        End If
    Loop
    
    If i <= Contenido.Count Then
        Contenido.Add objNewMember, Codigo, i
    Else
        Contenido.Add objNewMember, Codigo
    End If
    'return the object created
ResumePoint:
    Set Add = objNewMember
    Set objNewMember = Nothing
    Exit Function
ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsExcepciones::Add"
    Set objNewMember = Nothing
    Err.Clear
    Resume ResumePoint
End Function

Public Property Get Item(vntIndexKey As Variant) As clsDescriptorExcepcion
    'used when referencing an element in the collection
    'vntIndexKey contains either the Index or Key to the collection,
    'this is why it is declared as a Variant
    'Syntax: Set foo = x.Item(xyz) or Set foo = x.Item(5)
Dim RetVal As clsDescriptorExcepcion
    On Error GoTo NoHay
    Set RetVal = Contenido.Item(vntIndexKey)
    Set Item = RetVal
    Exit Property
NoHay:
    Set RetVal = Nothing
    Resume Next
End Property

Public Property Get Count() As Long
    'used when retrieving the number of elements in the
    'collection. Syntax: Debug.Print x.Count
    Count = Contenido.Count
End Property

Public Function Remove(vntIndexKey As String) As Boolean
    'used when removing an element from the acollection
    'vntIndexKey contains either the Index or Key, which is why
    'it is declared as a Variant
    'Syntax: x.Remove(xyz)
Dim inst As clsDescriptorExcepcion, sqlQuery As String, isOk As Boolean
    
    Set inst = Item(vntIndexKey)
    If inst Is Nothing Then
        Remove = False
        Exit Function
    End If

    isOk = True
    On Error GoTo ErrorHandler
    sqlQuery = "DELETE * FROM nomTiposExcepcion WHERE Codigo = '" & vntIndexKey & "'"
    dbHandle.Execute sqlQuery, dbFailOnError

    Contenido.Remove vntIndexKey
ResumePoint:
    Remove = isOk
    Exit Function
ErrorHandler:
    ReportarError False, Err.Number, Err.Description, "TablasCodigo.Remove"
    isOk = False
    Resume ResumePoint
End Function

Public Sub Update(Codigo As String, _
    Descripcion As String, _
    ByVal bVisible As Integer)
Dim inst As clsDescriptorExcepcion, sqlQuery As String
    
    Set inst = Item(Codigo)
    If inst Is Nothing Then
        mAdvertencia "Error (consistencia) item " & Codigo & " no aparece en 'Almacenes.Update'"
    Else
        inst.Descripcion = Descripcion
    End If
    
    On Error GoTo ErrHandler
    sqlQuery = "UPDATE nomTiposExcepcion SET Descripcion = " & StringDB(Descripcion) & ", Visible = " & NumeroDB(bVisible) & " WHERE Codigo = " & StringDB(Codigo) & ";"
    dbHandle.Execute sqlQuery, dbFailOnError
    Exit Sub
ErrHandler:
    ReportarError False, Err.Number, Err.Description, "TablasCOdigo.Update"
    Resume Next
End Sub

Public Sub Refresh()
Dim rsHandle As Recordset, inst As clsDescriptorExcepcion
    
    If Not AllowRefresh Then Exit Sub

    On Error GoTo ErrHandler

    Set Contenido = New Collection
    Set rsHandle = dbHandle.OpenRecordset("SELECT * FROM nomTiposExcepcion ORDER BY Descripcion;", dbOpenDynaset)
    With rsHandle
    If Not .BOF Then
        .MoveFirst
        Do While Not .EOF
            Set inst = New clsDescriptorExcepcion
            inst.Codigo = .Fields("Codigo")
            inst.Descripcion = .Fields("Descripcion")
            inst.Visible = .Fields("Visible")
            Contenido.Add inst, inst.Codigo
            .MoveNext
        Loop
    End If
    .Close
    End With
    Exit Sub

ErrHandler:
    Err.Clear

End Sub

Private Sub Class_Initialize()
  AllowRefresh = True
  Refresh
End Sub

Private Sub Class_Terminate()
    Set Contenido = Nothing
End Sub

Public Sub FillCombo(cbx As ComboBox)
Dim inst As clsDescriptorExcepcion, orgText As String
    
    Refresh
    orgText = cbx.Text
    cbx.Clear
    cbx.Text = orgText
    cbx.SelStart = 0
    cbx.SelLength = Len(cbx.Text)

    For Each inst In Contenido
        cbx.AddItem inst.Descripcion & "(" & inst.Codigo & ")"
    Next
End Sub

Public Function Validar(stCodigo As String) As Boolean
Dim inst As clsDescriptorExcepcion, _
    f As frmDescriptorExcepcion

    stCodigo = sExtractRightCode(stCodigo)
    If stCodigo = "" Then
        Validar = True
        Exit Function
    End If

    Set inst = Item(stCodigo)
    If inst Is Nothing Then
      If Len(stCodigo) > 12 Then
        mAdvertencia "La longitud del cdigo no puede exceder los 12 caracteres"
        Validar = False
        Exit Function
      End If
      If Not Confirmar("Crear excepcin " & stCodigo) Then
        Validar = False
        Exit Function
      End If
      Set f = New frmDescriptorExcepcion
      f.SetParentForm Nothing
      f.SetVars stCodigo, "", True
      f.Caption = "Excepciones: Creacin"
      ShowNonModal f
      If f.Result Then
        Me.Add f.txCodigo.Text, f.txDescripcion.Text, CInt(f.chkVisible.Value = vbChecked)
        Validar = True
      Else
        Validar = False
      End If
      Unload f
    Else
        Validar = True
        Set inst = Nothing
    End If
End Function

' Accesores...
Public Function Nombre(stCodigo As String) As String
Dim inst As clsDescriptorExcepcion
  
  Set inst = Item(stCodigo)
  If inst Is Nothing Then
    Nombre = "INVALIDA"
  Else
    Nombre = inst.Descripcion
    Set inst = Nothing
  End If

End Function


