VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsExcepcion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public NumeroID As Long
Public CodTrabajador As String
Public CodExcepcion As String
Public Fecha As Date                ' Fecha de "ocurrencia" de la excepcion
Public Valor As Double              ' Valor de la excepcion
Public Notas As String
Public TipoRecurrencia As Integer   ' 0: Una Vez, 1: n-Veces, 2: Hasta Fecha, 3: Permanente
Public Recurrencia As Double        ' Si TipoRecurrencia = 1: Cantidad de Veces restantes; Si tipoRecurrencia = 2: Fecha hasta la cual se aplicar
Public Operador As String           ' Cdigo del ltimo operador que manipul esta excepcion

Private rsIteradorTrabajador As Recordset

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsExcepcion = Nothing)
Dim lpDest As clsExcepcion

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        lpDest = pDest
    End If
    
    With Me
    .NumeroID = GetNumeroFromVariant(rs!NumeroID)
    .CodExcepcion = GetStringFromVariant(rs!CodExcepcion)
    .CodTrabajador = GetStringFromVariant(rs!CodTrabajador)
    .Fecha = GetDateFromVariant(rs!Fecha)
    .Valor = GetNumeroFromVariant(rs!Valor)
    .Notas = Field2Function(GetStringFromVariant(rs!Notas))
    .TipoRecurrencia = GetNumeroFromVariant(rs!TipoRecurrencia)
    .Recurrencia = GetNumeroFromVariant(rs!Recurrencia)
    .Operador = GetStringFromVariant(rs!Operador)
    End With

End Sub

Public Function Load(ByVal lNumeroExcepcion As Long, Optional pDest As clsExcepcion = Nothing) As Boolean
Dim rs As Recordset, bRetVal As Boolean

    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomExcepciones WHERE NumeroID = " & NumeroDB(lNumeroExcepcion), dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs, pDest
    End If
    Set rs = Nothing

    Load = bRetVal

End Function

Public Function NumeroProximaExcepcion() As Long
Dim rs As Recordset, lRetVal As Long

    Set rs = dbHandle.OpenRecordset("SELECT Max(NumeroID) AS MaxVal FROM nomExcepciones", dbOpenForwardOnly)
    If rs.EOF Then
        lRetVal = 0
    Else
        lRetVal = GetNumeroFromVariant(rs.Fields("MaxVal"))
    End If
    Set rs = Nothing
    NumeroProximaExcepcion = lRetVal + 1

End Function

Public Function Remove() As Boolean
Dim bRetVal As Boolean, sQuery As String

    On Error GoTo ErrHandler
    bRetVal = True
    sQuery = "DELETE * FROM nomExcepciones WHERE NumeroID = " & Me.NumeroID
    dbHandle.Execute sQuery, dbFailOnError
    
    If dbHandle.RecordsAffected < 1 Then bRetVal = False

ResumePoint:
    Remove = bRetVal
    Exit Function

ErrHandler:
    Err.Clear
    bRetVal = False
    Resume ResumePoint

End Function

Public Function EliminarExcepciones(istrCodTrab As String, istrTipoEx As String) As Boolean
Dim sQuery As String, bRetVal

    On Error GoTo ErrHandler
    sQuery = "DELETE * FROM nomExcepciones WHERE CodTrabajador = " & StringDB(istrCodTrab) & " AND CodExcepcion = " & StringDB(istrTipoEx)
    dbHandle.Execute sQuery, dbFailOnError
    If dbHandle.RecordsAffected < 1 Then bRetVal = False

ResumePoint:
    EliminarExcepciones = bRetVal
    Exit Function

ErrHandler:
    Err.Clear
    bRetVal = False
    Resume ResumePoint
End Function

Public Function SaveNew(istrCodTrab As String, istrTipoEx As String, ByVal idtFechaEx As Date, ByVal idblValorExcepcion As Double, ByVal inTipoRecurrencia As Integer, ByVal ivRecurrencia As Double, istrComentarios As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    Me.NumeroID = NumeroProximaExcepcion
    sQuery = "INSERT INTO nomExcepciones (NumeroId, CodTrabajador, CodExcepcion, Fecha, Valor, Notas, TipoRecurrencia, Recurrencia, Operador, FechaRegistro) SELECT "
    sQuery = sQuery & NumeroDB(Me.NumeroID) & ", "
    sQuery = sQuery & StringDB(istrCodTrab) & ", "
    sQuery = sQuery & StringDB(istrTipoEx) & ", "
    sQuery = sQuery & FechaDB(idtFechaEx) & ", "
    sQuery = sQuery & NumeroDB(idblValorExcepcion) & ", "
    sQuery = sQuery & StringDB(Function2Field(istrComentarios)) & ", "
    sQuery = sQuery & NumeroDB(inTipoRecurrencia) & ", "
    sQuery = sQuery & NumeroDB(ivRecurrencia) & ", "
    sQuery = sQuery & StringDB(UsuarioActivo.Codigo) & ", "
    sQuery = sQuery & FechaDB(Date)

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:

    SaveNew = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsExcepcion::SaveNew"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Update(ByVal inNumEx As Long, ByVal idtFechaEx As Date, ByVal idblValorExcepcion As Double, ByVal inTipoRecurrencia As Integer, ByVal dblRecurrencia As Double, istrComentarios As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    sQuery = "UPDATE nomExcepciones SET "
    sQuery = sQuery & "Fecha = " & FechaDB(idtFechaEx) & ", "
    sQuery = sQuery & "Valor = " & NumeroDB(idblValorExcepcion) & ", "
    sQuery = sQuery & "Notas = " & StringDB(Function2Field(istrComentarios)) & " ,"
    sQuery = sQuery & "TipoRecurrencia = " & NumeroDB(inTipoRecurrencia) & ", "
    sQuery = sQuery & "Recurrencia = " & NumeroDB(dblRecurrencia) & ", "
    sQuery = sQuery & "Operador = " & StringDB(UsuarioActivo.Codigo) & ", "
    sQuery = sQuery & "FechaRegistro = " & FechaDB(Date) & " "
    sQuery = sQuery & "WHERE NumeroId = " & NumeroDB(inNumEx)

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:

    Update = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsExcepcion::Update"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function IniciarIteradorTrabajador(istCodTrab As String) As Boolean
Dim bRetVal As Boolean

    Set rsIteradorTrabajador = dbHandle.OpenRecordset("SELECT * FROM nomExcepciones WHERE CodTrabajador = " & StringDB(istCodTrab) & " ORDER BY Fecha, NumeroID", dbOpenForwardOnly)
    If rsIteradorTrabajador.EOF Then
        Set rsIteradorTrabajador = Nothing
        bRetVal = False
    Else
        bRetVal = True
    End If
    
    IniciarIteradorTrabajador = bRetVal

End Function

Public Function NextExcepcionTrabajador() As clsExcepcion
Dim pRetVal As clsExcepcion

    If rsIteradorTrabajador Is Nothing Then
        Set pRetVal = Nothing
    Else
        If rsIteradorTrabajador.EOF Then
            Set rsIteradorTrabajador = Nothing
            Set pRetVal = Nothing
        Else
            Set pRetVal = New clsExcepcion
            pRetVal.LoadInstance rsIteradorTrabajador
            rsIteradorTrabajador.MoveNext
        End If
    End If

    Set NextExcepcionTrabajador = pRetVal

End Function

Public Function ValorExcepcionesTrabajador(istrCodTrab As String, istrCodEx As String, inDate As Date) As Double
Dim rs As Recordset, dblRetVal As Double

    Set rs = dbHandle.OpenRecordset("SELECT SUM(Valor) AS Result FROM nomExcepciones WHERE CodTrabajador = " & StringDB(istrCodTrab) & " AND CodExcepcion = " & StringDB(istrCodEx) & " AND Fecha <= " & FechaDB(inDate), dbOpenForwardOnly)
    If rs Is Nothing Then
        dblRetVal = 0
    Else
        If rs.EOF Then
            dblRetVal = 0
        Else
            dblRetVal = GetNumeroFromVariant(rs.Fields("Result"))
        End If
        Set rs = Nothing
    End If
    
    ValorExcepcionesTrabajador = dblRetVal

End Function

Public Sub RegistrarUso(istrCodTrab As String, istrCodEx As String, dtFechaProceso As Date, pLista As clsPresentadorExcep)
Dim rs As Recordset, pExcepcion As clsExcepcion, dtFinExcepcion As Date

    Set pExcepcion = New clsExcepcion

    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomExcepciones WHERE CodTrabajador = " & StringDB(istrCodTrab) & " AND CodExcepcion = " & StringDB(istrCodEx) & " AND Fecha <= " & FechaDB(dtFechaProceso), dbOpenForwardOnly)
    Do While Not rs.EOF

        pExcepcion.LoadInstance rs
        pLista.AddExcepcion pExcepcion
        rs.MoveNext

        Select Case pExcepcion.TipoRecurrencia
        Case 0
            dbHandle.Execute "DELETE * FROM nomExcepciones WHERE NumeroId = " & NumeroDB(pExcepcion.NumeroID), dbFailOnError
        Case 1
            pExcepcion.Recurrencia = pExcepcion.Recurrencia - 1
            If pExcepcion.Recurrencia > 0 Then
                dbHandle.Execute "UPDATE nomExcepciones SET Recurrencia = Recurrencia - 1 WHERE NumeroId = " & NumeroDB(pExcepcion.NumeroID), dbFailOnError
            Else
                dbHandle.Execute "DELETE * FROM nomExcepciones WHERE NumeroId = " & NumeroDB(pExcepcion.NumeroID), dbFailOnError
            End If
        Case 2
            dtFinExcepcion = CDate(pExcepcion.Recurrencia)
            If (dtFinExcepcion <= dtFechaProceso) Then
                dbHandle.Execute "DELETE * FROM nomExcepciones WHERE NumeroId = " & NumeroDB(pExcepcion.NumeroID), dbFailOnError
            End If
        End Select

    Loop

    Set rs = Nothing
    Set pExcepcion = Nothing

End Sub

Public Function ImagenTipoRecurrencia() As String
Dim sRetVal As String

    Select Case Me.TipoRecurrencia
    Case 0
        sRetVal = "UNICA"
    Case 1
        sRetVal = "N-VECES"
    Case 2
        sRetVal = "HASTA FECHA"
    Case 3
        sRetVal = "INDEFINIDA"
    End Select

    ImagenTipoRecurrencia = sRetVal

End Function

Public Function ImagenValorRecurrencia() As String
Dim sRetVal As String

    Select Case Me.TipoRecurrencia
    Case 0, 3
        sRetVal = "N/A"
    Case 1
        sRetVal = Format(Recurrencia, "#,##0")
    Case 2
        sRetVal = Format(Recurrencia, "Short Date")
    End Select

    ImagenValorRecurrencia = sRetVal

End Function
