VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsDescriptorHabilidad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Codigo As String
Public Descripcion As String
Public MinRango As Integer
Public MaxRango As Integer

Public Sub FillComboEnumeraciones(cbxCombo As ComboBox)
Dim strOriginal As String, rs As Recordset

    strOriginal = cbxCombo.Text
    cbxCombo.Clear
    Set rs = dbHandle.OpenRecordset("SELECT DISTINCT Enumerador FROM nomEnumHabilidades ORDER BY Enumerador", dbOpenForwardOnly)
    Do While Not rs.EOF
        cbxCombo.AddItem GetStringFromVariant(rs.Fields("Enumerador"))
        rs.MoveNext
    Loop
    Set rs = Nothing
    cbxCombo.Text = strOriginal

End Sub

Public Sub FillComboGrados(cbxDest As ComboBox) ' Los combos de grado son de tipo DropDownList, y no permiten la manipulacin direecta de la propiedad Text
Dim rs As Recordset, n As Long

    cbxDest.Clear
    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomEnumHabilidades WHERE CodigoHabilidad = " & StringDB(Me.Codigo) & " ORDER BY Valor", dbOpenForwardOnly)
    If Not rs.EOF Then
        Do
            cbxDest.AddItem GetStringFromVariant(rs.Fields("Enumerador"))
            rs.MoveNext
        Loop While Not rs.EOF
    Else
        For n = Me.MinRango To Me.MaxRango
            cbxDest.AddItem Trim(CStr(n))
        Next
    End If
    Set rs = Nothing

End Sub

Public Function GradoFromCombo(cbxCombo As ComboBox) As Long ' Obtiene el Grado de Habilidad a partir del contenido del combo
Dim Ch As String, lngRetVal As Long

    Ch = Left(UCase(RemoveSpaces(cbxCombo.Text)), 1)
    If Ch >= "0" And Ch <= "9" Then
        lngRetVal = Val(cbxCombo.Text)
    Else
        lngRetVal = cbxCombo.ListIndex + 1
    End If
    GradoFromCombo = lngRetVal

End Function

Public Function ImagenGrado(inGrado As Long, Optional istrCodigoHabilidad As String = "") As String
Dim rs As Recordset, strRetVal As String, strTemp As String

    strTemp = istrCodigoHabilidad
    If strTemp = "" Then strTemp = Me.Codigo
    Set rs = dbHandle.OpenRecordset("SELECT Enumerador FROM nomEnumHabilidades WHERE CodigoHabilidad = " & StringDB(strTemp) & " AND Valor = " & NumeroDB(inGrado), dbOpenForwardOnly)
    If rs.EOF Then
        strRetVal = ""
    Else
        strRetVal = GetStringFromVariant(rs.Fields("Enumerador"))
    End If
    Set rs = Nothing
    
    If strRetVal = "" Then strRetVal = Trim(str(inGrado))

    ImagenGrado = strRetVal

End Function

Public Function Load(istrCodigo As String) As Boolean
Dim rs As Recordset, bRetVal As Boolean

    Set rs = dbHandle.OpenRecordset("SELECT * FROM nomDescHabilidad WHERE Codigo = " & StringDB(istrCodigo), dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        With Me
        .Codigo = GetStringFromVariant(rs.Fields("Codigo"))
        .Descripcion = GetStringFromVariant(rs.Fields("Descripcion"))
        .MinRango = GetNumeroFromVariant(rs.Fields("MinRango"))
        .MaxRango = GetNumeroFromVariant(rs.Fields("MaxRango"))
        End With
        bRetVal = True
    End If
    Set rs = Nothing

    Load = bRetVal

End Function

Public Sub Borrar()

    dbHandle.Execute "DELETE * FROM nomEnumHabilidades WHERE Codigoabilidad = " & StringDB(Me.Codigo), dbFailOnError
    dbHandle.Execute "DELETE * FROM nomHabilidades WHERE CodigoHabilidad = " & StringDB(Me.Codigo), dbFailOnError

End Sub

Public Sub AddEnumeracion(istrCodigoEnum As String, inValor As Integer)
Dim sQuery As String

    sQuery = "INSERT INTO nomEnumHabilidades (CodigoHabilidad, Enumerador, Valor) SELECT "
    sQuery = sQuery & StringDB(Me.Codigo) & ", "
    sQuery = sQuery & StringDB(istrCodigoEnum) & ", "
    sQuery = sQuery & NumeroDB(inValor)

    dbHandle.Execute sQuery, dbFailOnError

End Sub

Public Sub Eliminar()
Dim rs As Recordset, q As Long

    Set rs = dbHandle.OpenRecordset("SELECT Count(CodigoHabilidad) AS Q from nomHabilidadesTrabajador WHERE CodigoHabilidad = " & StringDB(Me.Codigo), dbOpenForwardOnly)
    If rs.EOF Then
        q = 0
    Else
        q = GetNumeroFromVariant(rs.Fields("Q"))
    End If
    Set rs = Nothing
    
    If q > 0 Then
        mAdvertencia "Imposible borrar habilidad: hay trabajadores que la tienen."
        Exit Sub
    End If
    
    Borrar

End Sub

Public Sub Save()
Dim sQuery As String

    sQuery = "INSERT INTO nomDescHabilidad (Codigo, Descripcion, MinRango, MaxRango) SELECT "
    sQuery = sQuery & StringDB(Me.Codigo) & ", "
    sQuery = sQuery & StringDB(Me.Descripcion) & ", "
    sQuery = sQuery & NumeroDB(Me.MinRango) & ", "
    sQuery = sQuery & NumeroDB(Me.MaxRango)

    dbHandle.Execute sQuery, dbFailOnError

End Sub
