VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsAsigDed"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Codigo As String
Public Descripcion As String
Public Tipo As Integer                  ' 0: Asignacin, 1: Deduccin, 2: Aporte patronal
Public ClaseLaboral As String           ' Opcional: Tipo de partida en la cual se acumula a efectos de procesos con valores acumulativos (liquidacion, etc). Puede dejarse en blanco
Public CodigoReporte As String          ' Cdigo de agrupacin para los reportes de nmina
Public codigoCuenta As String           ' Opcional (si se usa contab): codigo de la cuenta donde se acumulan las asigded por este concepto. Puede reemplazarse por algun tipo de macro (p.ej: Trabajador.Atributo o DefProceso.Atributo) que es interpretado en funcin del contexto
Public CodigoContrapartida As String    ' Si es un aporte patronal, cdigo de la cuenta a la cual se acreditar
Public Formula As String                ' Formula para el clculo
Public CodigoRecibo As String           ' Cdigo de agrupacin para el RECIBO de nomina.

Private Sub LoadInstance(rs As Recordset, Optional pDest As clsAsigDed = Nothing)
Dim pInstance As clsAsigDed

    On Error GoTo ErrHandler

    If pDest Is Nothing Then
        Set pInstance = Me
    Else
        Set pInstance = pDest
    End If

    With pInstance
    .Codigo = stGetStringFromVariant(rs!Codigo)
    .Descripcion = stGetStringFromVariant(rs!Descripcion)
    .Tipo = GetNumeroFromVariant(rs!Tipo)
    .ClaseLaboral = stGetStringFromVariant(rs!ClaseLaboral)
    .CodigoReporte = stGetStringFromVariant(rs!CodigoReporte)
    .codigoCuenta = stGetStringFromVariant(rs!codigoCuenta)
    .CodigoContrapartida = stGetStringFromVariant(rs!CodigoContrapartida)
    .Formula = Field2Function(stGetStringFromVariant(rs!Formula))
    .CodigoRecibo = stGetStringFromVariant(rs!CodigoRecibo)
    End With

    Exit Sub

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsAsigDed::LoadInstance"
    Err.Clear

End Sub

Public Function Load(Codigo As String, Optional destino As clsAsigDed = Nothing) As Boolean
Dim bRetVal As Boolean, sQuery As String, rs As Recordset

    On Error GoTo ErrHandler

    sQuery = "SELECT * FROM nomDefAsigDed WHERE Codigo = " & StringDB(Codigo)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs, destino
    End If

ResumePoint:

    Set rs = Nothing
    Load = bRetVal
    Exit Function

ErrHandler:
    
    Err.Raise Err.Number, "clsAsigDed::Load", Err.Description
    bRetVal = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function SaveNew( _
    Codigo As String, _
    istrDescripcion As String, _
    ByVal inTipo As Integer, _
    istrClaseLaboral As String, _
    istrCodigoReporte As String, _
    istrCodigoCuenta As String, _
    istrCodigoContrapartida As String, _
    istrFormula As String, _
    istrCodigoRecibo As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "INSERT INTO nomDefAsigDed (Codigo, Descripcion, Tipo, ClaseLaboral, CodigoReporte, CodigoCuenta, CodigoContrapartida, Formula, CodigoRecibo) VALUES ("
    sQuery = sQuery & StringDB(Codigo)
    sQuery = sQuery & "," & StringDB(istrDescripcion)
    sQuery = sQuery & "," & Trim(inTipo)
    sQuery = sQuery & "," & StringDB(istrClaseLaboral)
    sQuery = sQuery & "," & StringDB(istrCodigoReporte)
    sQuery = sQuery & "," & StringDB(istrCodigoCuenta)
    sQuery = sQuery & "," & StringDB(istrCodigoContrapartida)
    sQuery = sQuery & "," & StringDB(Function2Field(istrFormula))
    sQuery = sQuery & "," & StringDB(istrCodigoRecibo)
    sQuery = sQuery & ")"

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    SaveNew = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsAsigDed::AddNew"
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos(sCodigo As String, _
    istrDescripcion As String, _
    ByVal ilTipo As Long, _
    istrClaseLaboral As String, _
    istrCodigoReporte As String, _
    istrCodigoCuenta As String, _
    istrCodigoContrapartida As String, _
    istrFormula As String, _
    istrCodigoRecibo As String) As Boolean
Dim sQuery As String, bRetVal As Boolean

    bRetVal = True
    On Error GoTo ErrHandler

    sQuery = "UPDATE nomDefAsigDed SET "
    sQuery = sQuery & "Descripcion = " & StringDB(istrDescripcion) & ", "
    sQuery = sQuery & "Tipo = " & NumeroDB(ilTipo)
    sQuery = sQuery & ", ClaseLaboral = " & StringDB(istrClaseLaboral)
    sQuery = sQuery & ", CodigoReporte = " & StringDB(istrCodigoReporte)
    sQuery = sQuery & ", CodigoCuenta = " & StringDB(istrCodigoCuenta)
    sQuery = sQuery & ", CodigoContrapartida = " & StringDB(istrCodigoContrapartida)
    sQuery = sQuery & ", Formula = " & StringDB(Function2Field(istrFormula))
    sQuery = sQuery & ", CodigoRecibo = " & StringDB(istrCodigoRecibo)
    sQuery = sQuery & " WHERE Codigo = " & StringDB(sCodigo)

    dbHandle.Execute sQuery, dbFailOnError
    
ResumePoint:
    ActualizarDescriptivos = bRetVal
    Exit Function

ErrHandler:
    Err.Raise Err.Number, "clsAsigDed::ActualizarDescriptivos", Err.Description
    bRetVal = False
    Resume ResumePoint

End Function

Public Function Eliminar() As Boolean
Dim sQuery As String, bRetVal As Boolean

    sQuery = "DELETE * FROM nomDefAsigDed WHERE Codigo = " & StringDB(Me.Codigo)
    bRetVal = True
    On Error GoTo ErrHandler

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    Eliminar = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsAsigDed::Eliminar"
    Resume ResumePoint

End Function

Public Function Validar(istrCodigo As String) As Boolean
Dim pAuxiliar As clsAsigDed, isOk As Boolean
Dim frmCreate As frmAsigDed, strCh As String, i As Integer

    istrCodigo = Trim(UCase(istrCodigo))
    istrCodigo = RemoveSpaces(istrCodigo)
    strCh = Left(istrCodigo, 1)
    If (strCh < "A" Or strCh > "Z") Then
        mAdvertencia "Los cdigos de Asig/Ded deben comenzar por una letra"
        Validar = False
        Exit Function
    End If

    For i = 2 To Len(istrCodigo)
        strCh = Mid(istrCodigo, 1)
        If strCh < "A" Or strCh > "Z" Then
            If strCh < "0" Or strCh > "9" Then
                If strCh <> "_" Then
                    mAdvertencia "Los identificadores de Asig/ded solo pueden contener letras, dgitos o el caracter '_'"
                    Validar = False
                    Exit Function
                End If
            End If
        End If
    Next

    Set pAuxiliar = New clsAsigDed
    isOk = pAuxiliar.Load(istrCodigo)
    If Not isOk Then
        isOk = Confirmar("Desea crear asig/ded con cdigo " & istrCodigo)
        If isOk Then
            Set frmCreate = New frmAsigDed
            frmCreate.SetCodigo istrCodigo
            frmCreate.SetContexto 3
            While frmCreate.Visible: DoEvents: Wend
            Unload frmCreate
            Set frmCreate = Nothing
            
            isOk = pAuxiliar.Load(istrCodigo)
        End If
    End If
    Set pAuxiliar = Nothing

    Validar = isOk

End Function

Public Function AsigDedScript(istrCodigoScript As String) As Collection
Dim sQuery As String, pRetCol As Collection, pAsigDed As clsAsigDed, rs As Recordset

    On Error GoTo ErrHandler

    sQuery = "SELECT nomDefAsigded.*, s.Orden FROM nomDefAsigDed, nomAsigDedScript AS s WHERE s.CodigoScript = " & StringDB(istrCodigoScript) & " AND s.codigoAsigDed = nomDefAsigDed.Codigo ORDER BY Orden"
    Set pRetCol = New Collection

    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    Do While Not rs.EOF
        Set pAsigDed = New clsAsigDed
        LoadInstance rs, pAsigDed
        pRetCol.Add pAsigDed
        rs.MoveNext
    Loop
    Set rs = Nothing

ResumePoint:
    Set AsigDedScript = pRetCol
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsAsigDed::AsigDedScript"
    Set pRetCol = Nothing
    Resume ResumePoint

End Function

