VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsAlmacenSaldos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Intefaz entre clsSaldoCuentaPeriodo y a BD"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' En principio, solamente la clase "cls<NombreEntidad>" debe tener
' conocimiento de la clase "clsAlmacen<NombreEntidad>". De momento
' me parece un poco artificial, rebuscado; pero la implementacion
' de los mtodos de almacenamiento debe estar tan alejada de la
' aplicacin como sea posible.

Option Explicit

Private cSCP As clsSaldoCuentaPeriodo

Public Function LoadSaldoCuenta(ByVal Cuenta As String, ByVal periodo As Long) As clsSaldoCuentaPeriodo
Dim scpRetVal As clsSaldoCuentaPeriodo, sQuery As String, rs As Recordset

    sQuery = "SELECT TOP 1 * FROM SaldosPeriodo WHERE CodigoCuenta = " & StringDB(Cuenta) & " AND "
    sQuery = sQuery & "NumeroPeriodo <= " & NumeroDB(periodo) & " ORDER BY NumeroPeriodo DESC"
    
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    
    If rs.EOF Then
        scpRetVal.codigoCuenta = Cuenta
        scpRetVal.SaldoInicial = 0
        scpRetVal.NumeroPeriodo = periodo
        scpRetVal.Debitos = 0#
        scpRetVal.Creditos = 0#
    Else
        Set scpRetVal = New clsSaldoCuentaPeriodo
        With scpRetVal
        .codigoCuenta = rs.Fields("CodigoCuenta")
        .Creditos = rs.Fields("Creditos")
        .Debitos = rs.Fields("Debitos")
        .NumeroPeriodo = rs.Fields("NumeroPeriodo")
        .SaldoInicial = rs.Fields("SaldoInicial")
        If .NumeroPeriodo < periodo Then
            .SaldoInicial = scpRetVal.SaldoInicial + scpRetVal.Debitos - scpRetVal.Creditos
            .NumeroPeriodo = periodo
            .Debitos = 0#
            .Creditos = 0#
        End If                          ' Se cre un control, cuyo saldo inicial es igual al "saldo final" del anterior, con DB y CR = 0
    End If
    
    Set LoadSaldoCuenta = scpRetVal
End Function

' clsAlmacenSaldos.RegistrarVariacion es llamada desde clsCuenta.RegistrarVariacion
' Si Reverse, en vez de sumar el valor al lado correspondiente, lo resta del lado contrario.
' -------------------------------------------------
' Si Cierre, no se registra EL MOVIMIENTO (i.e. no se alteran los DB y CR del perodo), y
' se permite el asiento a un perodo POSTERIOR al activo en la empresa seleccionada (dado
' que el cierre se ejecuta CONTRA un perodo posterior (generalmente el siguiente) al actual.
Public Sub RegistrarVariacion(Cuenta As String, periodo As Long, ByVal Variacion As Double, Reverse As Boolean, Cierre As Boolean)
Attribute RegistrarVariacion.VB_Description = "Actualiza los debitos o creditos de una cuenta para el periodo en que se produjo el movimiento, y todos los saldo iniciales desde all en adelante"
Dim PeriodoActual As Long, _
    ProximoPeriodo As Long
Dim bSeekRes As Boolean
Dim SaldoInicial As Double
Dim lPeriodo As Long, isResultado As Boolean
Dim instCuenta As clsCuenta, instSaldo As clsSaldoCuentaPeriodo
Dim rs As Recordset, sQuery As String

    PeriodoActual = Empresa.refPeriodoActual
    
    If Not Cierre And (periodo > PeriodoActual) Then   ' esto nunca debe pasar, pero...
        mAdvertencia "ERROR: Intento de registrar VarSaldo" & Chr(13) & "para un perodo no abierto:" & str(periodo)
        Exit Sub
    End If

    Set instCuenta = New clsCuenta
    instCuenta.Load Cuenta
    isResultado = (instCuenta.Funcion = 4) Or (instCuenta.Funcion = 5)
    ' Proceso del primer registro:
    sQuery = "SELECT TOP 1 * FROM SaldosPeriodo WHERE CodigoCuenta = " & StringDB(Cuenta) & " AND "
    sQuery = sQuery & "NumeroPeriodo <= " & NumeroDB(periodo) & " "
    sQuery = sQuery & "ORDER BY NumeroPeriodo DESC"
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then                ' No hay un control para el periodo. (ni para ninguno anterior)
        sQuery = "INSERT INTO SaldosPeriodo (CodigoCuenta, NumeroPeriodo, SaldoInicial, Debitos, Creditos) SELECT "
        sQuery = sQuery & StringDB(Cuenta) & ", "
        sQuery = sQuery & NumeroDB(periodo) & ", 0, "
        sQuery = sQuery & NumeroDB(IIf(Variacion > 0), Variacion, 0) & ", "
        sQuery = sQuery & NumeroDB(IIf(Variacion < 0), 0, -Variacion)
    Else                ' Hay un control para el perodo, o para uno anterior.
        If GetNumeroFromVariant(rs.Fields("NumeroPeriodo")) = periodo Then  ' si es el de ste perodo
            sQuery = "UPDATE SaldosPeriodo SET "   ' se actualiza el registro
            If Reverse Then
                If Variacion > 0 Then
                    sQuery = sQuery & "Creditos = Creditos - " & NumeroDB(Variacion) & " "
                Else
                    sQuery = sQuery & "Debitos = Debitos - " & NumeroDB(Abs(Variacion)) & " "
                End If
            Else
                If Variacion > 0 Then
                    sQuery = sQuery & "Debitos = Debitos + " & NumeroDB(Variacion) & " "
                Else
                    sQuery = sQuery & "Creditos = Creditos - " & NumeroDB(Abs(Variacion)) & " "
                End If
            End If
            sQuery = sQuery & "WHERE CodigoCuenta = " & StringDB(Cuenta) & " AND NumeroPeriodo = " & NumeroDB(periodo)
        Else    ' Pertenece a un periodo anterior: se inserta el nuevo registro
            sQuery = "INSERT INTO SaldosPeriodo (CodigoCuenta, NumeroPeriodo, SaldoInicial, Debitos, Creditos) SELECT "
            sQuery = sQuery & StringDB(Cuenta) & ", "
            sQuery = sQuery & NumeroDB(periodo) & ", "
            SaldoInicial = GetNumeroFromVariant(rs.Fields("SaldoInicial")) + GetNumeroFromVariant(rs.Fields("Debitos")) - GetNumeroFromVariant(rs.Fields("Creditos"))
            sQuery = sQuery & NumeroDB(SaldoInicial) & ", "
            sQuery = sQuery & NumeroDB(IIf(Variacion > 0), Variacion, 0) & ", "
            sQuery = sQuery & NumeroDB(IIf(Variacion < 0), 0, -Variacion)
        End If
    End If
    rs.Close
    Set rs = Nothing
    dbHandle.Execute sQuery, dbFailOnError  ' Se ejecuta incondicionalmente

    If Not Cierre Then  ' No registrar EL MOVIMIENTO (variacion en el periodo) si se trata de un cierre
        .Edit
        If Variacion < 0 Then
            If Not Reverse Then
                .Fields("Creditos") = .Fields("Creditos") - Variacion
            Else
                .Fields("Debitos") = .Fields("Debitos") + Variacion
            End If
        Else
            If Not Reverse Then
                .Fields("Debitos") = .Fields("Debitos") + Variacion
            Else
                .Fields("Creditos") = .Fields("Creditos") - Variacion
            End If
        End If
        .Update
    Else
        .Edit
        .Fields("SaldoInicial") = .Fields("SaldoInicial") + Variacion
        .Update
    End If
    
    
    
    
    ProximoPeriodo = mPeriodos.nextPeriodo(periodo)
    Do While ProximoPeriodo <= PeriodoActual    ' Ciclo para actualizar todos los perodos posteriores
        If (PeriodoPeriodo(ProximoPeriodo) = 1 And isResultado) Then
        ' Si se est pasando una "frontera de ejercicio"
            .Seek "=", instCuenta.Codigo, ProximoPeriodo
            If .NoMatch Then CrearRegistro instCuenta.Codigo, ProximoPeriodo, 0#
            If (instCuenta.Status = 2) Then
                Cuenta = Empresa.CuentaGanPer
                instCuenta.Load Cuenta
                instCuenta.RegistrarVariacion Variacion, ProximoPeriodo, Reverse, True
            End If
            Set instCuenta = Nothing
            Cerrar
            Exit Sub
        End If
        .Seek "=", Cuenta, ProximoPeriodo
        If Not .NoMatch Then
            .Edit
            .Fields("SaldoInicial") = .Fields("SaldoInicial") + Variacion
            .Update
        End If
        ProximoPeriodo = mPeriodos.nextPeriodo(ProximoPeriodo)
    Loop
    
    Set instCuenta = Nothing
    End With
    Cerrar
End Sub

Public Function CrearRegistro(stCodigo As String, lPeriodo As Long, lfSaldoInicial As Double) As Boolean
' Crea un registro "en blanco", para el primer periodo de una cuenta de resultados...
' Es usado exclusivamente por clsEmpresa, durant eel proceso de cierre.
    Abrir
    With rsHandle
    Do While stCodigo <> ""
        .Seek "=", stCodigo, lPeriodo
        If .NoMatch Then
            .AddNew
            .Fields("CodigoCuenta") = stCodigo
            .Fields("NumeroPeriodo") = lPeriodo
            .Fields("Debitos") = 0#
            .Fields("Creditos") = 0#
            .Fields("SaldoInicial") = lfSaldoInicial
            .Update
        End If
        stCodigo = mCodigos.CodigoSubordinante(stCodigo)
    Loop
    End With
    Cerrar
    CrearRegistro = True
End Function

Public Sub LlenarSaldosCuenta(stCuenta As String, ByVal PeriodoInicial As Long, ByVal PeriodoFinal As Long, colDestino As Collection)
Dim nextPeriodo As Long, instSaldo As clsSaldoCuentaPeriodo
    
    nextPeriodo = PeriodoInicial - 1
    Abrir
    With rsHandle
    Do
        .Seek ">", stCuenta, nextPeriodo
        If .NoMatch Then
            nextPeriodo = 0
            Exit Do
        End If
        If .Fields("CodigoCuenta") <> stCuenta Or .Fields("NumeroPeriodo") > PeriodoFinal Then
            nextPeriodo = 0
            Exit Do
        End If
        Set instSaldo = New clsSaldoCuentaPeriodo
        instSaldo.codigoCuenta = .Fields("CodigoCuenta")
        instSaldo.NumeroPeriodo = .Fields("NumeroPeriodo")
        instSaldo.Creditos = .Fields("Creditos")
        instSaldo.Debitos = .Fields("Debitos")
        instSaldo.SaldoInicial = .Fields("SaldoInicial")
        nextPeriodo = instSaldo.NumeroPeriodo
        colDestino.Add instSaldo
    Loop While nextPeriodo <> 0
    End With
    Cerrar
End Sub

Public Function BalanceCuentaIntervalo(codigoCuenta As String, RefInicio As Long, RefFinal As Long) As Double
Dim rsHandle As Recordset, sqlQuery As String, Total As Double

    sqlQuery = "SELECT (Sum(Debitos) - Sum(Creditos)) AS Resultado "
    sqlQuery = sqlQuery & "From " & "SaldosPeriodo" & " "
    sqlQuery = sqlQuery & "WHERE CodigoCuenta =  '" & codigoCuenta
    sqlQuery = sqlQuery & "' and NumeroPeriodo >=" & str(RefInicio) & " and NumeroPeriodo <=" & str(RefFinal) & ";"
    Set rsHandle = dbHandle.OpenRecordset(sqlQuery, dbOpenDynaset)
    With rsHandle
    If .BOF Then
        Total = 0
    Else
        .MoveFirst
        Total = Val(stGetStringFromVariant(.Fields("Resultado")))
    End If
    .Close
    End With
    Set rsHandle = Nothing
    BalanceCuentaIntervalo = Total
End Function

Private Sub Class_Initialize()
    Set cSCP = New clsSaldoCuentaPeriodo    ' Crea la instancia de trabajo
End Sub

Private Sub Class_Terminate()
    Set cSCP = Nothing                      ' Destruye la instancia de trabajo
    If Not rsHandle Is Nothing Then
        qAperturas = 0
        rsHandle.Close
        Set rsHandle = Nothing
    End If
End Sub
