VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsAlmacenPrefijos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Almacen para los prefijos en memoria"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Collection" ,"clsPrefijo"
Attribute VB_Ext_KEY = "Member0" ,"clsPrefijo"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
'local variable to hold collection
Private mCol As Collection

Private Sub PutInTable(Codigo As String, Funcion As Byte)
    
    dbHandle.Execute "INSERT INTO Prefijos (Prefijo, Uso) SELECT " & StringDB(Codigo) & ", " & NumeroDB(Funcion), dbOpenForwardOnly

End Sub

Public Function Add(Codigo As String, Funcion As Byte) As clsPrefijo
    'create a new object
    Dim objNewMember As clsPrefijo
    Set objNewMember = New clsPrefijo

    'set the properties passed into the method
    objNewMember.Codigo = Codigo
    objNewMember.Funcion = Funcion

    PutInTable Codigo, Funcion
    mCol.Add objNewMember, Codigo
    
    'return the object created
    Set Add = objNewMember
    Set objNewMember = Nothing
End Function

Public Property Get Item(stClavePrefijo As String) As clsPrefijo
Attribute Item.VB_UserMemId = 0
Dim f As FDefinirPrefijos, iRetVal As clsPrefijo
    'used when referencing an element in the collection
    'vntIndexKey contains either the Index or Key to the collection,
    'this is why it is declared as a Variant
    'Syntax: Set foo = x.Item(xyz) or Set foo = x.Item(5)
  
  On Error GoTo ErrH
  Set Item = mCol.Item(stClavePrefijo)
  If Item Is Nothing Then
    Set f = New FDefinirPrefijos
    f.SetPrefijo stClavePrefijo
    f.Show 0
    While f.Visible: DoEvents: Wend
    If f.ok Then Me.Add stClavePrefijo, f.Funcion
    Unload f
    Set f = Nothing
    Set Item = mCol.Item(stClavePrefijo)
  End If
  Exit Property
ErrH:
    If Err.Number = 5 Then
        Set Item = Nothing
        Resume Next
    Else
        On Error GoTo 0
        Resume
    End If
End Property

Public Sub FillCollectionByFuncion(destColl As Collection)
Dim rs As Recordset, Item As clsPrefijo, sqlQuery As String
    
    sqlQuery = "SELECT * FROM Prefijos ORDER BY Uso, Prefijo"
    Set rs = dbHandle.OpenRecordset(sqlQuery, dbOpenDynaset)
    If Not rs.BOF Then
        rs.MoveFirst
        Do
            Set Item = New clsPrefijo
            Item.Codigo = rs.Fields("Prefijo")
            Item.Funcion = rs.Fields("Uso")
            destColl.Add Item
            rs.MoveNext
        Loop While Not rs.EOF
    End If
    rs.Close
    Set rs = Nothing
End Sub

Public Property Get Count() As Long
    'used when retrieving the number of elements in the
    'collection. Syntax: Debug.Print x.Count
    Count = mCol.Count
End Property

Public Property Get NewEnum() As IUnknown
Attribute NewEnum.VB_UserMemId = -4
Attribute NewEnum.VB_MemberFlags = "40"
    'this property allows you to enumerate
    'this collection with the For...Each syntax
    Set NewEnum = mCol.[_NewEnum]
End Property

Private Sub Class_Initialize()
Dim rs As Recordset, Item As clsPrefijo
    'creates the collection when this class is created
    Set mCol = New Collection
    Set rs = dbHandle.OpenRecordset("SELECT * FROM Prefijos ORDER BY Prefijo", dbOpenForwardOnly)
    Do While Not rs.EOF
        Set Item = New clsPrefijo
        Item.Codigo = rs.Fields("Prefijo")
        Item.Funcion = rs.Fields("Uso")
        mCol.Add Item, Item.Codigo
        rs.MoveNext
    Loop
    rs.Close
    Set rs = Nothing
End Sub

Private Sub Class_Terminate()
    'destroys collection when this class is terminated
    Set mCol = Nothing
End Sub

