VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsAlmacenDetalles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private rsHandle As Recordset
Private qAperturas As Integer

Public Sub Abrir()
    If qAperturas = 0 Then
        Set rsHandle = dbHandle.OpenRecordset("Detalles", dbOpenTable)
    End If
    rsHandle.Index = "PrimaryKey"
    qAperturas = qAperturas + 1
End Sub

Public Sub Cerrar()
    If qAperturas = 0 Then Exit Sub
    qAperturas = qAperturas - 1
    If qAperturas = 0 Then
        rsHandle.Close
        Set rsHandle = Nothing
    End If
End Sub

Private Sub Load(detalle As clsDetalles)
    With rsHandle
    detalle.NumeroComprobante = .Fields("NumeroComprobante")
    detalle.NumeroLinea = .Fields("NumeroLinea")
    detalle.Cuenta = .Fields("Cuenta")
    detalle.Debe = .Fields("Debe")
    detalle.Descripcion = .Fields("Descripcion")
    detalle.Haber = .Fields("Haber")
    detalle.RefDetalle = .Fields("RefDetalle")
    detalle.refPeriodo = .Fields("RefPeriodo")
    End With
End Sub

Public Function GrabarNuevoDetalle(detalle As clsDetalles) As Boolean
Dim isOk As Boolean, lCuenta As clsCuenta
    Set lCuenta = New clsCuenta
    isOk = lCuenta.Load(detalle.Cuenta)
    If (isOk) Then
        If (lCuenta.Status = 1) Then ' Si se trata de una cuenta de control...
            isOk = False
            Report "Cuenta " & detalle.Cuenta & " no localizada: AlmacenDetalles.GrabarNuevoDetalle"
        End If
        If lCuenta.Status = 0 Then  ' Si no tiene un status asignado
            lCuenta.SetStatus 2     ' forzar nuevos status = Detalle
        End If
    End If
    
    If isOk Then
        Abrir
        With rsHandle
        .AddNew
        .Fields("NumeroComprobante") = detalle.NumeroComprobante
        .Fields("NumeroLinea") = detalle.NumeroLinea
        .Fields("RefPeriodo") = detalle.refPeriodo
        .Fields("Cuenta") = detalle.Cuenta
        .Fields("RefDetalle") = detalle.RefDetalle
        .Fields("Descripcion") = detalle.Descripcion
        .Fields("Debe") = detalle.Debe
        .Fields("Haber") = detalle.Haber
        .Update
        End With
        lCuenta.RegistrarVariacion detalle.Debe - detalle.Haber, detalle.refPeriodo, False, False
    End If
    Set lCuenta = Nothing
    Cerrar
    GrabarNuevoDetalle = isOk
End Function

Public Function IteradorCuentaPeriodo(codigoCuenta As String, _
                                      RefPeriodoI As Long, RefPeriodoF As Long, _
                                      Procesador As clsProcesadorDetalles) As Integer
Dim lCodigoCuenta As String, _
    lrefPeriodo As Long, _
    lNumComprobante As Long, _
    lNumeroLinea As Integer, _
    instDetalle As clsDetalles, _
    RetVal As Integer
    
    Abrir
    Set instDetalle = New clsDetalles
    lCodigoCuenta = codigoCuenta: lrefPeriodo = RefPeriodoI
    lNumComprobante = 0: lNumeroLinea = 0: RetVal = 0
    With rsHandle
    .Index = "IndicePorCuenta"
    Do
        DoEvents
        .Seek ">", lCodigoCuenta, lrefPeriodo, lNumComprobante, lNumeroLinea
        If .NoMatch Then
            RetVal = 26     ' myEOF
        Else
            Load instDetalle
            lNumComprobante = instDetalle.NumeroComprobante
            lNumeroLinea = instDetalle.NumeroLinea
            lrefPeriodo = instDetalle.refPeriodo
            If instDetalle.Cuenta <> codigoCuenta Or lrefPeriodo > RefPeriodoF Then
                RetVal = 26
            Else
                RetVal = Procesador.Accion(instDetalle)
            End If
        End If
    Loop While RetVal = 0
    Set instDetalle = Nothing
    End With
    Cerrar
End Function

Public Function IteradorMovimientosCuenta(stCuentaInicio As String, _
                                          stCuentaFin As String, _
                                          lRefPeriodoI As Long, _
                                          lRefPeriodoF As Long, _
                                          Procesador As clsProcesadorDetalles) As Integer
Dim sqlQuery As String, _
    instDetalle As clsDetalles, _
    rsHandle As Recordset, _
    RetVal As Integer

    Set instDetalle = New clsDetalles
    sqlQuery = "SELECT * FROM " & "Detalles" & " "
    sqlQuery = sqlQuery & "WHERE Cuenta >='" & stCuentaInicio & " ' AND "
    sqlQuery = sqlQuery & "Cuenta <= '" & stCuentaFin & "ZZZZZZZZ' AND "
    sqlQuery = sqlQuery & "RefPeriodo >=" & Str(lRefPeriodoI) & " AND RefPeriodo <=" & Str(lRefPeriodoF) & " "
    sqlQuery = sqlQuery & "ORDER BY Cuenta, RefPeriodo, NumeroComprobante, NumeroLinea"
    
    RetVal = 0
    Set rsHandle = dbHandle.OpenRecordset(sqlQuery, dbOpenDynaset)
    With rsHandle
    If Not .BOF Then
        .MoveFirst
        Do While RetVal = 0 And Not .EOF
            instDetalle.NumeroComprobante = .Fields("NumeroComprobante")
            instDetalle.NumeroLinea = .Fields("NumeroLinea")
            instDetalle.Cuenta = .Fields("Cuenta")
            instDetalle.Debe = .Fields("Debe")
            instDetalle.Descripcion = .Fields("Descripcion")
            instDetalle.Haber = .Fields("Haber")
            instDetalle.RefDetalle = .Fields("RefDetalle")
            instDetalle.refPeriodo = .Fields("RefPeriodo")
            RetVal = Procesador.Accion(instDetalle)
            If RetVal = 0 Then .MoveNext
        Loop
    End If
    .Close
    End With
    Set rsHandle = Nothing
    Set instDetalle = Nothing
    IteradorMovimientosCuenta = RetVal
End Function

Public Function FillDetallesComprobante(NumeroComprobante As Long, DestCol As Collection) As Boolean
Dim numeroC As Long, numeroL As Integer
Dim instDetalle As clsDetalles
    Abrir
    With rsHandle
    numeroL = 0
    Do
        .Seek ">", NumeroComprobante, numeroL
        If Not .NoMatch Then
            numeroC = .Fields("NumeroComprobante")
            numeroL = .Fields("NumeroLinea")
            If numeroC = NumeroComprobante Then
                Set instDetalle = New clsDetalles
                instDetalle.NumeroComprobante = numeroC
                instDetalle.NumeroLinea = numeroL
                instDetalle.refPeriodo = .Fields("RefPeriodo")
                instDetalle.Cuenta = .Fields("Cuenta")
                instDetalle.RefDetalle = .Fields("RefDetalle")
                instDetalle.Descripcion = .Fields("Descripcion")
                instDetalle.Debe = .Fields("Debe")
                instDetalle.Haber = .Fields("Haber")
                DestCol.Add instDetalle
            End If
        End If
    Loop While Not .NoMatch And numeroC = NumeroComprobante
    End With
    Cerrar
    FillDetallesComprobante = True
End Function

Public Function EliminarDetallesComprobante(NumeroComprobante As Long)
Dim numeroC As Long, numeroL As Integer
Dim instDetalle As clsDetalles
    Abrir
    With rsHandle
    numeroL = 0
    Do
        .Seek ">", NumeroComprobante, numeroL
        If Not .NoMatch Then
            numeroC = .Fields("NumeroComprobante")
            numeroL = .Fields("NumeroLinea")
            If numeroC = NumeroComprobante Then
                .Delete
            End If
        End If
    Loop While Not .NoMatch And numeroC = NumeroComprobante
    End With
    Cerrar
    EliminarDetallesComprobante = True
End Function

Public Function TieneDetalles(inst As clsCuenta) As Boolean
Dim RetVal As Boolean
    
    Abrir
    With rsHandle
    .Index = "IndicePorCuenta"
    .Seek ">", inst.Codigo, 0, 0, 0
    If .NoMatch Then
        RetVal = False
    Else
        RetVal = (.Fields("Cuenta") = inst.Codigo)
    End If
    .Index = "PrimaryKey"
    End With
    Cerrar
    TieneDetalles = RetVal
End Function

Private Sub Class_Terminate()
    If qAperturas Then
        rsHandle.Close
        mAdvertencia "Error interno: Open/Close mismatch en Detalles"
    End If
    Set rsHandle = Nothing
End Sub
