VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsAlmacenCuentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Implementa los mecanismos de acceso a disco y validacin de cuentas"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' En teora, debe existir slo una instancia de esta clase en
' cada aplicacin. Es una implementacin en forma de clase de
' un mdulo de acceso a datos para una entidad (Cuentas).

Option Explicit

Private Type tagCuenta
    Codigo As String
    Titulo As String
    lado As Byte
    Status As Byte
    Saldo As Double
End Type

Private rsHandle As Recordset
Private qAperturas As Integer
Private cCuenta As tagCuenta

Private Sub LoadCCuenta(rsHandle As Recordset, pDest As clsCuenta)
    
    With pDest
    .Codigo = rsHandle.Fields("Codigo")
    .Titulo = rsHandle.Fields("Titulo")
    .Status = rsHandle.Fields("Status")
    .lado = rsHandle.Fields("Lado")
    .Saldo = rsHandle.Fields("Saldo")
    End With
End Sub

Public Function LoadCuenta(Codigo As String, destino As clsCuenta) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.OpenRecordset("SELECT * FROM Cuentas WHERE Codigo = " & StringDB(Codigo), dbOpenForwardOnly)
    If Not rs.EOF Then
        bRetVal = True
        LoadCCuenta rs, destino
    Else
        bRetVal = False
    End If
    Set rs = Nothing
    LoadCuenta = bRetVal

End Function

Public Function LoadSiguiente(destino As clsCuenta) As Boolean
Dim bResult As Boolean, rs As Recordset

    Set rs = dbHandle.OpenRecordset("SELECT * FROM Cuentas WHERE Codigo IN (Select MIN(Codigo) FROM Cuentas WHERE Codigo > " & StringDB(destino.Codigo) & ")", dbOpenForwardOnly)
    If rs.EOF Then
        bResult = False
    Else
        bResult = True
        destino.Codigo = rs.Fields("Codigo")
        destino.Titulo = rs.Fields("Titulo")
        destino.Status = rs.Fields("Status")
        destino.lado = rs.Fields("Lado")
        destino.Saldo = rs.Fields("Saldo")
    End If
    Set rs = Nothing
    LoadSiguiente = bResult

End Function

Public Function LoadAnterior(destino As clsCuenta) As Boolean
Dim bResult As Boolean, rs As Recordset

    Set rs = dbHandle.OpenRecordset("SELECT * FROM Cuentas WHERE Codigo IN (Select MAX(Codigo) FROM Cuentas WHERE Codigo < " & StringDB(destino.Codigo) & ")", dbOpenForwardOnly)
    If rs.EOF Then
        bResult = False
    Else
        bResult = True
        destino.Codigo = rs.Fields("Codigo")
        destino.Titulo = rs.Fields("Titulo")
        destino.Status = rs.Fields("Status")
        destino.lado = rs.Fields("Lado")
        destino.Saldo = rs.Fields("Saldo")
    End If
    Set rs = Nothing
    LoadAnterior = bResult

End Function

Public Function ExisteCodigo(arg As String) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.OpenRecordset("Select COdigo from Cuentas WHERE Codigo = " & StringDB(arg), dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
    End If
    Set rs = Nothing
    ExisteCodigo = bRetVal

End Function

Public Function CrearCuenta(Clave As String) As Boolean
Dim stSubordinante As String, isCreated As Boolean

    If Not ValidarEstructuraCodigo(Clave, Empresa.FormatoCodigos) Then
        mAdvertencia "Error: Formato invalido" & Chr(13) & "Formato: " & Empresa.FormatoCodigos
        CrearCuenta = False
        Exit Function
    End If
    
    If Not Confirmar("Crear cuenta " & Clave) Then
        CrearCuenta = False
        Exit Function
    End If

    stSubordinante = mCodigos.CodigoSubordinante(Clave)
    If (stSubordinante <> "") Then
        If Not Me.ValidarCuenta(stSubordinante) Then
            CrearCuenta = False
            Exit Function
        End If
    End If

    OpenFIECuentas Clave
    isCreated = ExisteCodigo(Clave)
    
    CrearCuenta = isCreated

End Function

Public Function Add(iCuenta As clsCuenta) As Boolean
Dim bRetVal As Boolean, sQuery As String

    On Error GoTo ErrHandler

    sQuery = "INSERT INTO Cuentas (Codigo, Titulo, Status, Lado, Saldo) SELECT "
    sQuery = sQuery & StringDB(iCuenta.Codigo) & ", "
    sQuery = sQuery & StringDB(iCuenta.Titulo) & ", "
    sQuery = sQuery & NumeroDB(iCuenta.Status) & ", "
    sQuery = sQuery & NumeroDB(iCuenta.lado) & ", "
    sQuery = sQuery & NumeroDB(iCuenta.Saldo)

    bRetVal = True
    dbHandle.Execute sQuery, dbFailOnError
    
ResumePoint:
    Add = bRetVal
    Exit Function

ErrHandler:
    bRetVal = False
    Resume ResumePoint

End Function

Public Function ValidarCuenta(Codigo As String) As Boolean
Dim bRetVal As Boolean, stTemp As String
    
    stTemp = Trim(Format(Codigo, ">"))
    stTemp = mCodigos.MergeCodigoFormato(stTemp, Empresa.FormatoCodigos)
    If stTemp <> Codigo Then Codigo = stTemp
    If stTemp = "" Then
        mAdvertencia "Debe llenar el cdigo de la cuenta"
        bRetVal = False
    Else
        If Len(stTemp) > 20 Then
            mAdvertencia "La maxima longitud del cdigo son 20 caracteres"
            bRetVal = False
        Else
            If ExisteCodigo(stTemp) Then
                bRetVal = True
            Else
                If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_CUENTAS) Then
                    bRetVal = False
                Else
                    bRetVal = CrearCuenta(stTemp)
                End If
            End If
        End If
    End If
    ValidarCuenta = bRetVal
End Function

' Aqu no hace falta el parametro Reverse, pues slo afecta el saldo de la cuenta
Public Function RegistrarVariacion(instCuenta As clsCuenta, Monto As Double) As Boolean
Dim bRetVal As Boolean, rs As Recordset, sQuery As String

    On Error GoTo ErrHandler

    sQuery = "UPDATE Cuentas SET Saldo = Saldo + " & NumeroDB(Monto) & " "
    sQuery = sQuery & "WHERE Codigo = " & StringDB(instCuenta.Codigo)
    dbHandle.Execute sQuery, dbFailOnError

    bRetVal = LoadCuenta(instCuenta.Codigo, instCuenta)
    
ResumePoint:
    RegistrarVariacion = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenCuentas::RegistrarVariacion"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function CambiarTitulo(instCuenta As clsCuenta, istTitulo As String)
Dim bRetVal As Boolean
    
    On Error GoTo ErrHandler
    dbHandle.Execute "UPDATE Cuentas SET Titulo = " & StringDB(istTitulo) & " WHERE Codigo = " & StringDB(instCuenta.Codigo), dbFailOnError
    instCuenta.Titulo = istTitulo
    bRetVal = True

ResumePoint:
    CambiarTitulo = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenCuentas::CambiarTitulo"
    bRetVal = False
    Resume ResumePoint

End Function

Public Function SetStatus(instCuenta As clsCuenta, inStatus As Integer)
Dim bRetVal As Boolean
    
    On Error GoTo ErrHandler
    dbHandle.Execute "UPDATE Cuentas SET Status = " & NumeroDB(inStatus) & " WHERE Codigo = " & StringDB(instCuenta.Codigo), dbFailOnError
    instCuenta.Status = inStatus
    bRetVal = True

ResumePoint:
    SetStatus = bRetVal
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "AlmacenCuentas::SetStatus"
    bRetVal = False
    Resume ResumePoint

End Function

Public Sub LlenarColeccionCuentas(DestCol As Collection)
Dim rs As Recordset, instCuenta As clsCuenta

    Set rs = dbHandle.OpenRecordset("SELECT * FROM Cuentas ORDER BY Codigo", dbOpenForwardOnly)
    Do While Not rs.EOF
    
        Set instCuenta = New clsCuenta
        LoadCCuenta rs, instCuenta
        DestCol.Add instCuenta, instCuenta.Codigo
        rs.MoveNext
    
    Loop
    Set rs = Nothing

End Sub

Public Sub LlenarColeccionCuentasPrefijo(stPrefijo As String, DestCol As Collection)
Dim rs As Recordset, instCuenta As clsCuenta

    Set rs = dbHandle.OpenRecordset("SELECT * FROM Cuentas WHERE Codigo LIKE '" & stPrefijo & "*' ORDER BY Codigo", dbOpenForwardOnly)
    Do While Not rs.EOF
        Set instCuenta = New clsCuenta
        LoadCCuenta rs, instCuenta
        DestCol.Add instCuenta, instCuenta.Codigo
        rs.MoveNext
    Loop
    Set rs = Nothing
End Sub

Public Function TieneSubordinadas(arg As clsCuenta) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.OpenRecordset("SELECT Codigo FROM Cuentas WHERE Codigo > " & StringDB(arg.Codigo) & " AND Codigo LIKE '" & arg.Codigo & "*'", dbOpenForwardOnly)
    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
    End If
    Set rs = Nothing
    TieneSubordinadas = bRetVal

End Function

Public Function Eliminar(arg As clsCuenta) As Boolean
Dim bRetVal As Boolean

    On Error GoTo ErrHandler
    bRetVal = True
    
    dbHandle.Execute "DELETE * FROM Cuentas WHERE Codigo = " & StringDB(arg.Codigo), dbFailOnError
    
ResumePoint:
    
    Eliminar = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "AlmacenCuentas:Eliminar"
    bRetVal = False
    Resume ResumePoint

End Function
