VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CPrintPreview"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Dim fPreview As frmPreview

Public Property Set SourceDoc(pDoc As CFormatoDocumento)
    
    Set fPreview.SourceProc = pDoc
    
End Property

Private Sub Class_Initialize()

    Set fPreview = New frmPreview
    Load fPreview
'   fPreview.Show 0

End Sub

Public Sub EndDoc()

    fPreview.SSTab1.Tab = 0
    fPreview.Show
    While fPreview.Visible: DoEvents: Wend
    Unload fPreview
    Set fPreview = Nothing

End Sub

Public Sub NewPage()

    On Error GoTo ErrHandler
    fPreview.NewPage
    Exit Sub

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "CPrintPreview::NewPage"
    Resume Next

End Sub

Public Property Get TextHeight(s As String) As Long

    On Error GoTo ErrHandler

    TextHeight = fPreview.picPagina(fPreview.cPage).TextHeight(s) / fPreview.Factor + 1
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.TextHeight"
    Err.Clear

End Property

Public Property Get TextWidth(s As String) As Long

    On Error GoTo ErrHandler

    TextWidth = fPreview.picPagina(fPreview.cPage).TextWidth(s) / fPreview.Factor + 1
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.TextWidth"
    Err.Clear
    
End Property

Public Property Let FontName(sNewFont As String)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).FontName = sNewFont
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let FontName"
    Err.Clear

End Property

Public Property Get FontName() As String

    On Error GoTo ErrHandler
    
    FontName = fPreview.picPagina(fPreview.cPage).FontName
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get FontName"
    Err.Clear

End Property

Public Property Let FontSize(dNewSize As Double)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).FontSize = dNewSize * fPreview.Factor
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let FontSize"
    Err.Clear

End Property

Public Property Get FontSize() As Double

    On Error GoTo ErrHandler
    
    FontSize = fPreview.picPagina(fPreview.cPage).FontSize / fPreview.Factor
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get FontSize"
    Err.Clear

End Property

Public Property Let FontBold(bNewStat As Boolean)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).FontBold = bNewStat
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let FontBold"
    Err.Clear

End Property

Public Property Get FontBold() As Boolean

    On Error GoTo ErrHandler
    
    FontBold = fPreview.picPagina(fPreview.cPage).FontBold
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get FontBold"
    Err.Clear

End Property

Public Property Let FontItalic(bNewStat As Boolean)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).FontItalic = bNewStat
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.LetFontItalic"
    Err.Clear

End Property

Public Property Get FontItalic() As Boolean

    On Error GoTo ErrHandler
    
    FontBold = fPreview.picPagina(fPreview.cPage).FontItalic
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.GetFontItalic"
    Err.Clear

End Property

Public Property Let FontUnderline(bNewStat As Boolean)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).FontUnderline = bNewStat
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let FontUnderline"
    Err.Clear

End Property

Public Property Get FontUnderline() As Boolean

    On Error GoTo ErrHandler
    
    FontUnderline = fPreview.picPagina(fPreview.cPage).FontUnderline
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get FontUnderline"
    Err.Clear

End Property

Public Property Let DrawStyle(nNewStyle As Integer)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).DrawStyle = nNewStyle
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let DrawStyle"
    Err.Clear

End Property

Public Property Get DrawStyle() As Integer

    On Error GoTo ErrHandler
    
    DrawStyle = fPreview.picPagina(fPreview.cPage).DrawStyle
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get DrawStyle"
    Err.Clear

End Property

Public Property Let DrawWidth(ByVal nNewWidth As Integer)
Dim nTemp As Integer

    On Error GoTo ErrHandler
    
    nTemp = nNewWidth * fPreview.Factor + 0.5
    If nTemp < 1 Then nTemp = 1
    fPreview.picPagina(fPreview.cPage).DrawWidth = nTemp
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let DrawWidth"
    Err.Clear
    
End Property

Public Property Get DrawWidth() As Integer

    On Error GoTo ErrHandler
    
    DrawWidth = fPreview.picPagina(fPreview.cPage).DrawWidth
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get DrawWidth"
    Err.Clear

End Property

Public Property Get ForeColor() As Long

    On Error GoTo ErrHandler
    
    ForeColor = fPreview.picPagina(fPreview.cPage).ForeColor
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get ForeColor"
    Err.Clear

End Property

Public Property Let ForeColor(lNewColor As Long)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).ForeColor = lNewColor
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let ForeColor"
    Err.Clear

End Property

Public Property Let CurrentX(ByVal nNewX As Long)
Dim nTemp As Double

    On Error GoTo ErrHandler
    
    nTemp = nNewX * fPreview.Factor
    fPreview.picPagina(fPreview.cPage).CurrentX = nTemp
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let CurrentX"
    Err.Clear
    
End Property

Public Property Get CurrentX() As Long

    On Error GoTo ErrHandler
    
    CurrentX = fPreview.picPagina(fPreview.cPage).CurrentX / fPreview.Factor
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get CurrentX"
    Err.Clear

End Property

Public Property Let CurrentY(ByVal nNewY As Long)
Dim nTemp As Double

    On Error GoTo ErrHandler
    
    nTemp = nNewY * fPreview.Factor
    fPreview.picPagina(fPreview.cPage).CurrentY = nTemp
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Let CurrentY"
    Err.Clear

End Property

Public Property Get CurrentY() As Long

    On Error GoTo ErrHandler
    
    CurrentY = fPreview.picPagina(fPreview.cPage).CurrentY / fPreview.Factor
    Exit Property

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Get CurrentY"
    Err.Clear

End Property

Public Sub DoPrint(sText As String)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).Print sText;
    Exit Sub

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.DoPrint"
    Err.Clear

End Sub

Public Sub Cuadro(ByVal x1 As Long, ByVal y1 As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal nColor As Long)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).Line (x1 * fPreview.Factor, y1 * fPreview.Factor)-(x2 * fPreview.Factor, y2 * fPreview.Factor), nColor, B
    Exit Sub

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Cuadro"
    Err.Clear

End Sub

Public Sub Linea(ByVal x1 As Long, ByVal y1 As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal nColor As Long)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).Line (x1 * fPreview.Factor, y1 * fPreview.Factor)-(x2 * fPreview.Factor, y2 * fPreview.Factor), nColor
    Exit Sub

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.Linea"
    Err.Clear

End Sub

Public Sub PaintPicture(pImage As IPictureDisp, x As Long, y As Long, Width As Long, Height As Long)

    On Error GoTo ErrHandler
    
    fPreview.picPagina(fPreview.cPage).PaintPicture pImage, x * fPreview.Factor, y * fPreview.Factor, Width * fPreview.Factor, Height * fPreview.Factor
    Exit Sub

ErrHandler:
    MsgBox "ERROR " & Err.Number & " (" & Err.Description & ")" & Chr(13) & "CPrintPreview.PaintPicture"
    Err.Clear

End Sub
