VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CFormatoDocumento"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public PrinterName As String
Public PaperWidth As String
Public PaperHeight As String
Public PaperSize As Integer
Public qCopias As Integer
Public FontName As String       ' MS Sans Serif
Public FontSize As Integer
Public FontBold As Boolean
Public FontUnderline As Boolean
Public FontItalic As Boolean
Public Orientacion As Integer
Public AltoDetalle As Long
Public YComienzoDetalle As Long
Public DetallesPagina As Long

Private PageSection As CSeccionFormato
Private Heading1 As CSeccionFormato
Private HeadingN As CSeccionFormato
Private FooterN As CSeccionFormato
Private FooterZ As CSeccionFormato
Private Detalles As CSeccionFormato

Public pDocumento As Object
Private sNombreArchivo As String, nLineNumber As Long

Private Sub ReportarError(sErrMsg As String)

    MsgBox sErrMsg & Chr(13) & "Archivo:" & sNombreArchivo & ", Linea:" & str(nLineNumber) & Chr(13) & Err.Description
    Err.Clear

End Sub

Private Sub Class_Initialize()

    On Error GoTo ErrHandler

'1.- Crea las areas de seccion de formato
    Set PageSection = New CSeccionFormato
    Set Heading1 = New CSeccionFormato
    Set HeadingN = New CSeccionFormato
    Set FooterN = New CSeccionFormato
    Set FooterZ = New CSeccionFormato
    Set Detalles = New CSeccionFormato

    On Error Resume Next
'2.- Inicia los valores de configuracion del printer con el estado actual
    With Printer
    PrinterName = .DeviceName
    PaperSize = .PaperSize
    PaperHeight = .Height
    PaperWidth = .Width
    qCopias = .Copies
    FontName = .FontName
    FontSize = .FontSize
    FontBold = .FontBold
    FontUnderline = .FontUnderline
    FontItalic = .FontItalic
    Orientacion = .Orientation
    End With

    Exit Sub

ErrHandler:
    ReportarError "Error en inicializacion de CFormatoDocumento."
    Err.Clear

End Sub

' PDoc debe cumplir con ISDOC
Public Function SetDocumento(pDoc As Object, doPreview As Boolean) As Boolean
Dim nFile As Integer, sLine As String
Dim pSeccion As CSeccionFormato, nModo As Integer
Dim nLineType As CONSTRUCCION
Dim isError As Boolean
Dim sVarID As String, sVarVal As String
Dim pPrinterStatus As CPrinterStatus

1    On Error GoTo ErrHandler

2    Set pDocumento = pDoc
3    sNombreArchivo = pDoc.NombreArchivoFormato

4    nFile = FreeFile
5    Open sNombreArchivo For Input As #nFile
6    nLineNumber = 0
7    nModo = -1

8    Do While Not EOF(nFile)
9        Line Input #1, sLine
        
10       nLineNumber = nLineNumber + 1
11       nLineType = mParser.LineType(sLine)
        
12       Select Case nLineType
         Case DECLARACION
14           sLine = Format(Trim(sLine), ">")
15            Select Case sLine
              Case "ENTORNO"
17               nModo = 0
18            Case "PAGINA"
19                Set pSeccion = PageSection
20                nModo = 1
21            Case "ENCABEZADO1"
22                Set pSeccion = Heading1
23                nModo = 1
24            Case "ENCABEZADON"
25                Set pSeccion = HeadingN
26                nModo = 1
27            Case "CIERREN"
28                Set pSeccion = FooterN
29                nModo = 1
30            Case "CIERREZ"
31                Set pSeccion = FooterZ
32                nModo = 1
33            Case "DETALLES"
34                Set pSeccion = Detalles
35                nModo = 1
36            Case Else
37                isError = True
38                ReportarError "Codigo de seccion invlido: " & sLine
39                Exit Do
40            End Select
41        Case ASIGNACION
42            If nModo <> 0 Then
43                ReportarError "Las asignaciones solo se permiten en la seccin de entorno"
44                isError = True
45                Exit Do
46            Else
47                sLine = Trim(sLine)
48                If Not ParseAsignacion(sLine, sVarID, sVarVal) Then
49                    ReportarError "Asignacion invalida: " & sLine
50                    isError = True
51                    Exit Do
52                Else
53                    sVarID = Format(sVarID, ">")
54                    Select Case sVarID
                      Case "ANCHO", "WIDTH"
56                        If Not NumeroValido(sVarVal) Then
57                            ReportarError "Argumento invalido"
58                            isError = True
59                            Exit Do
60                        End If
61                        PaperWidth = Val(sVarVal)
62                    Case "ALTO", "HEIGHT"
63                        If Not NumeroValido(sVarVal) Then
64                            ReportarError "Argumento invalido"
65                            isError = True
66                            Exit Do
67                        End If
68                        PaperHeight = Val(sVarVal)
69                    Case "PAPERTYPE", "PAPEL"
70                        If Not NumeroValido(sVarVal) Then
71                            ReportarError "Argumento invalido"
72                            isError = True
73                            Exit Do
74                        End If
75                        PaperSize = Val(sVarVal)
76                    Case "COPIAS", "COPIES"
77                        If Not NumeroValido(sVarVal) Then
78                            ReportarError "Argumento invalido"
79                            isError = True
80                            Exit Do
81                        End If
82                        qCopias = Val(sVarVal)
83                    Case "ALTODETALLE", "DETAILHEIGHT"
84                        If Not NumeroValido(sVarVal) Then
85                            ReportarError "Argumento invalido"
86                            isError = True
87                            Exit Do
88                        End If
89                        AltoDetalle = Val(sVarVal)
90                    Case "YCOMIENZODETALLE", "YDETAILSTART"
91                        If Not NumeroValido(sVarVal) Then
92                            ReportarError "Argumento invalido"
93                            isError = True
94                            Exit Do
95                        End If
96                        YComienzoDetalle = Val(sVarVal)
97                    Case "DETALLESPAGINA", "DETAILSPAGE"
98                        If Not NumeroValido(sVarVal) Then
99                            ReportarError "Argumento invalido"
100                           isError = True
101                           Exit Do
102                       End If
103                       DetallesPagina = Val(sVarVal)
104                   Case "ORIENTACION", "ORIENTATION"
105                       If Not NumeroValido(sVarVal) Then
106                           ReportarError "Argumento invalido"
107                           isError = True
108                           Exit Do
109                       End If
110                       Orientacion = Val(sVarVal)
111                   Case Else
112                       ReportarError "Identificador desconocido"
113                       isError = True
114                       Exit Do
115                   End Select
116               End If

117           End If
        
118       Case pObject
            
119           If nModo <> 1 Then
120               ReportarError "Los objetos de impresin solo se permiten en las secciones de documento"
121               isError = True
122               Exit Do
123           Else
124               Dim pContainer As New CPOContainer
125               If pContainer.CreatePrintableObject(sLine) Then
126                   pSeccion.Add pContainer
127               Else
128                   ReportarError pContainer.ErrorString
129               End If
130               Set pContainer = Nothing
131           End If
        
132       End Select
        
133   Loop

134   Close

135   If isError Then
136       SetDocumento = False
137       Exit Function
138   End If
    
' Inicializacion de la impresora

139   Set pPrinterStatus = New CPrinterStatus ' Se salv toda la informacin actual del printer...
140   pPrinterStatus.SavePrinter

141   ConfigurarImpresora
    
    Pagina = 1
    On Error Resume Next
    qPaginas = 1
    qPaginas = 1 + Int(pDocumento.Detalles.Count / DetallesPagina)
    
    On Error GoTo 0
    If doPreview Then
        isError = PreviewDocumento(pDoc)
    Else
        isError = PrintDocumento(pDoc)
    End If

' Restablecer impresora
    pPrinterStatus.RestorePrinter

    SetDocumento = Not isError
    
    Exit Function

ErrHandler:

    Close
    ReportarError "Error en proceso de formato: Class Initialize. Erl=" & str(Erl)
    Err.Clear
    SetDocumento = False
    Exit Function

End Function

Public Function PreviewDocumento(pDoc As Object) As Boolean
Dim ColDetalles As Collection, pDetalle As Object, nDetalle As Integer, i As Integer
Dim PrintObject As CPrintPreview

1   On Error GoTo ErrHandler

2   Set PrintObject = New CPrintPreview
3   Set ColDetalles = pDoc.Detalles

4   Set PrintObject.SourceDoc = Me

5   PageSection.Display PrintObject, pDoc, Nothing, 0
6   Heading1.Display PrintObject, pDoc, Nothing, 0
    
7   nDetalle = 0
8   For Each pDetalle In ColDetalles
9       If nDetalle = Me.DetallesPagina Then
10          FooterN.Display PrintObject, pDoc, pDetalle, 0
11          PrintObject.NewPage: Pagina = Pagina + 1
12          PageSection.Display PrintObject, pDoc, Nothing, 0
13          HeadingN.Display PrintObject, pDoc, pDetalle, 0
14          nDetalle = 0
15      End If
16      Detalles.Display PrintObject, pDetalle, pDoc, YComienzoDetalle + (nDetalle * AltoDetalle)
17      nDetalle = nDetalle + 1
18  Next
19  FooterZ.Display PrintObject, pDoc, Nothing, 0
    
20  PrintObject.EndDoc

21  Set ColDetalles = Nothing
22  Set PrintObject = Nothing
    Exit Function

ErrHandler:

    ReportarError "Error en PreviewDocumento " & Erl
    Err.Clear
    PreviewDocumento = False

End Function

Public Function PrintDocumento(pDoc As Object) As Boolean
Dim ColDetalles As Collection, pDetalle As Object, nDetalle As Integer, i As Integer

1    On Error GoTo ErrHandler

2    Set ColDetalles = pDoc.Detalles
     Printer.Print " "
3    PageSection.Display Printer, pDoc, Nothing, 0
4    Heading1.Display Printer, pDoc, Nothing, 0
    
5    nDetalle = 0
6    For Each pDetalle In ColDetalles
7        If nDetalle = Me.DetallesPagina Then
8            FooterN.Display Printer, pDoc, pDetalle, 0
9            Printer.NewPage: Pagina = Pagina + 1
10           PageSection.Display Printer, pDoc, Nothing, 0
11           HeadingN.Display Printer, pDoc, pDetalle, 0
12           nDetalle = 0
13      End If
14      Detalles.Display Printer, pDetalle, pDoc, YComienzoDetalle + (nDetalle * AltoDetalle)
15      nDetalle = nDetalle + 1
16  Next
17  FooterZ.Display Printer, pDoc, Nothing, 0
    
18  Printer.EndDoc

19  Exit Function

ErrHandler:

    ReportarError "Error en PrintDocumento " & Erl
    Err.Clear
    PrintDocumento = False

End Function

Private Sub ConfigurarImpresora()
Dim i As Integer

    On Error Resume Next

    If PrinterName <> Printer.DeviceName Then
        For i = 0 To Printers.Count - 1
            If Not StrComp(Printers(i).DeviceName, PrinterName, vbTextCompare) Then
                Set Printer = Printers(i)
                Exit For
            End If
        Next
    End If

    If FontName <> Printer.FontName Then
        For i = 0 To Printer.FontCount - 1
            If Not StrComp(FontName, Printer.Fonts(i), vbTextCompare) Then
                Printer.FontName = Printer.Fonts(i)
                Exit For
            End If
        Next
    End If
    
    Printer.FontBold = FontBold
    Printer.FontItalic = FontItalic
    Printer.FontUnderline = FontUnderline
    Printer.Copies = qCopias

    If FontSize > 0 Then Printer.FontSize = FontSize

    If Orientacion Then
        Printer.Orientation = Orientacion
    End If

    Printer.PaperSize = PaperSize
    If Printer.PaperSize = vbPRPSUser Then
        Printer.Height = PaperHeight
        Printer.Width = PaperWidth
    End If

End Sub
