VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Begin VB.UserControl ucParametrosCompra 
   ClientHeight    =   1995
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   5865
   ScaleHeight     =   1995
   ScaleWidth      =   5865
   Begin VB.Frame Frame 
      Height          =   2085
      Left            =   0
      TabIndex        =   0
      Top             =   -90
      Width           =   5865
      Begin ucNumero.ucNumBox numMontoRetencionCE 
         Height          =   315
         Left            =   4200
         TabIndex        =   19
         Top             =   1620
         Width           =   1575
         _ExtentX        =   2778
         _ExtentY        =   556
         Enabled         =   0   'False
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin VB.TextBox txNumDoc 
         Enabled         =   0   'False
         Height          =   315
         Left            =   1050
         MaxLength       =   20
         TabIndex        =   2
         Top             =   180
         Width           =   1785
      End
      Begin VB.TextBox txNumeroControl 
         Alignment       =   1  'Right Justify
         Enabled         =   0   'False
         Height          =   315
         Left            =   4530
         TabIndex        =   4
         Top             =   180
         Width           =   1155
      End
      Begin VB.CheckBox chkAplicarRetencion 
         Caption         =   "Aplicar retencin (slo Cont.Esp.)"
         Height          =   285
         Left            =   3090
         TabIndex        =   7
         Top             =   540
         Width           =   2655
      End
      Begin ucNumero.ucNumBox numCreditoFiscal 
         Height          =   315
         Left            =   1050
         TabIndex        =   17
         Top             =   1620
         Width           =   1785
         _ExtentX        =   3149
         _ExtentY        =   556
         Enabled         =   0   'False
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox numPorcentaje1 
         Height          =   315
         Left            =   3780
         TabIndex        =   11
         Top             =   900
         Width           =   675
         _ExtentX        =   1191
         _ExtentY        =   556
         Enabled         =   0   'False
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox numGravable1 
         Height          =   315
         Left            =   1050
         TabIndex        =   9
         Top             =   900
         Width           =   1785
         _ExtentX        =   3149
         _ExtentY        =   556
         Enabled         =   0   'False
         ShowCalc        =   -1  'True
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox numExento 
         Height          =   315
         Left            =   1050
         TabIndex        =   6
         Top             =   540
         Width           =   1785
         _ExtentX        =   3149
         _ExtentY        =   556
         Enabled         =   0   'False
         ShowCalc        =   -1  'True
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox numPorcentaje2 
         Height          =   315
         Left            =   3780
         TabIndex        =   15
         Top             =   1260
         Width           =   675
         _ExtentX        =   1191
         _ExtentY        =   556
         Enabled         =   0   'False
         ShowCalc        =   0   'False
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin ucNumero.ucNumBox numGravable2 
         Height          =   315
         Left            =   1050
         TabIndex        =   13
         Top             =   1260
         Width           =   1785
         _ExtentX        =   3149
         _ExtentY        =   556
         Enabled         =   0   'False
         ShowCalc        =   -1  'True
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "IVA Retenido:"
         Height          =   195
         Left            =   3090
         TabIndex        =   18
         Top             =   1680
         Width           =   990
      End
      Begin VB.Label Label10 
         AutoSize        =   -1  'True
         Caption         =   "Cr. F&iscal:"
         Height          =   195
         Left            =   240
         TabIndex        =   16
         Top             =   1680
         Width           =   690
      End
      Begin VB.Label Label9 
         AutoSize        =   -1  'True
         Caption         =   "% Ret &1:"
         Height          =   195
         Left            =   3105
         TabIndex        =   10
         Top             =   960
         Width           =   600
      End
      Begin VB.Label Label8 
         AutoSize        =   -1  'True
         Caption         =   "Gravable &1:"
         Height          =   195
         Left            =   105
         TabIndex        =   8
         Top             =   930
         Width           =   825
      End
      Begin VB.Label Label7 
         AutoSize        =   -1  'True
         Caption         =   "E&xento:"
         Height          =   195
         Left            =   390
         TabIndex        =   5
         Top             =   570
         Width           =   540
      End
      Begin VB.Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "&Factura:"
         Height          =   195
         Left            =   345
         TabIndex        =   1
         Top             =   210
         Width           =   585
      End
      Begin VB.Label Label13 
         AutoSize        =   -1  'True
         Caption         =   "Numero de Control:"
         Height          =   195
         Left            =   3090
         TabIndex        =   3
         Top             =   210
         Width           =   1365
      End
      Begin VB.Label Label12 
         AutoSize        =   -1  'True
         Caption         =   "Gravable &2:"
         Height          =   195
         Left            =   105
         TabIndex        =   12
         Top             =   1290
         Width           =   825
      End
      Begin VB.Label Label14 
         AutoSize        =   -1  'True
         Caption         =   "% Ret &2:"
         Height          =   195
         Left            =   3105
         TabIndex        =   14
         Top             =   1320
         Width           =   600
      End
   End
End
Attribute VB_Name = "ucParametrosCompra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_Enabled As Boolean
Public MontoTotal As Currency, CreditoFiscal As Currency, MontoRetenido As Currency

Public Event Change()
Public Event StatusInfo(s As String)
Public Event CheckForRIF(ByRef isOk As Boolean)

Public Property Get Factura() As String
  Factura = txNumDoc.Text
End Property

Public Property Get ValorExento() As Currency
  ValorExento = numExento.Value
End Property

Public Property Get Gravable1() As Currency
  Gravable1 = numGravable1.Value
End Property

Public Property Get Gravable2() As Currency
  Gravable2 = numGravable2.Value
End Property

Public Property Get Porcentaje1() As Double
  Porcentaje1 = numPorcentaje1.Value
End Property

Public Property Get Porcentaje2() As Double
  Porcentaje2 = numPorcentaje2.Value
End Property

Public Property Get MontoIVA1()
  MontoIVA1 = numGravable1.Value / 100 * numPorcentaje1.Value
End Property

Public Property Get MontoIVA2()
  MontoIVA2 = numGravable2.Value / 100 * numPorcentaje2.Value
End Property

Public Property Get NumeroControl() As Long
  NumeroControl = ValOf(txNumeroControl.Text)
End Property

Public Property Get IvaRetenido() As Currency
  IvaRetenido = numMontoRetencionCE.Value
End Property

Public Property Get MontoNeto() As Currency
  MontoNeto = MontoTotal - numMontoRetencionCE.Value
End Property

Public Sub Update()
Dim mTotal As Currency, mCredito As Currency, pRet As Double
  mCredito = numGravable1.Value / 100 * numPorcentaje1.Value
  mCredito = mCredito + numGravable2.Value / 100 * numPorcentaje2.Value
  mTotal = numExento.Value + numGravable1.Value + numGravable2.Value + mCredito
  MontoTotal = mTotal
  CreditoFiscal = mCredito
  numCreditoFiscal.Value = mCredito
  Dim isAllFine As Boolean
  isAllFine = True
  RaiseEvent CheckForRIF(isAllFine)
  If txNumeroControl.Text <> "" And isAllFine Then
    pRet = Empresa.PorcentajeRetencionIVACE / 100
  Else
    pRet = 1
  End If
  If UserControl.chkAplicarRetencion.Value = vbUnchecked Then pRet = 0
  MontoRetenido = mCredito * pRet
  numMontoRetencionCE = MontoRetenido
  RaiseEvent Change
End Sub

Public Property Get Enabled() As Boolean
  Enabled = m_Enabled
End Property

Public Property Let Enabled(Value As Boolean)
Dim s As Control
  For Each s In UserControl.Controls
    On Error Resume Next
    With s
    .Enabled = Value
    .TabStop = Value
    End With
    If Err.Number Then Err.Clear
  Next
  numCreditoFiscal.Enabled = False
  m_Enabled = Value
  If m_Enabled Then
    Update
    RaiseEvent Change
  End If
End Property

Private Sub chkAplicarRetencion_Click()
  Update
End Sub

Private Sub numExento_GotFocus()
  RaiseEvent StatusInfo("Monto de bienes o servicios exentos en la factura")
End Sub

Private Sub numExento_Validate(Cancel As Boolean)
  If numExento < 0 Then
    mAdvertencia "Por favor, use solo numero no negativos"
    Cancel = True
    Exit Sub
  End If
  Update
End Sub

Private Sub numGravable1_GotFocus()
  RaiseEvent StatusInfo("Monto de bienes o servicios gravables a valor general (IV1)")
End Sub

Private Sub numGravable1_Validate(Cancel As Boolean)
  If numGravable1.Value < 0 Then
    mAdvertencia "El monto debe ser mayor o igual que cero"
    Cancel = True
    Exit Sub
  End If
  Update
End Sub

Private Sub numGravable2_GotFocus()
  RaiseEvent StatusInfo("Monto sujeto a IVA preferencial (IV2)")
End Sub

Private Sub numPorcentaje1_GotFocus()
  RaiseEvent StatusInfo("Porcentaje de reencion para valor general (IV1)")
End Sub

Private Sub numPorcentaje1_Validate(Cancel As Boolean)
  If numPorcentaje1.Value < 0 Or numPorcentaje1.Value > 100 Then
    mAdvertencia "El porcentaje debe estar entre CERO y CIEN"
    Cancel = True
    Exit Sub
  End If
  If numPorcentaje1.Value <> TiposImpuesto.ValorActualImpuesto("IV1") Then
    If Not Confirmar("El valor actual de IV1 es de " & Format(TiposImpuesto.ValorActualImpuesto("IV1"), "0.00\%") & vbCrLf & "Est seguro de que este valor es correcto") Then
      Cancel = True
      Exit Sub
    End If
  End If
  Update
End Sub

Private Sub numGravable2_Validate(Cancel As Boolean)
  If numGravable2.Value < 0 Then
    mAdvertencia "El monto debe ser mayor o igual que cero"
    Cancel = True
    Exit Sub
  End If
  Update
End Sub

Private Sub numPorcentaje2_GotFocus()
  RaiseEvent StatusInfo("Porcentaje correspondiente al IVA preferencial (IV2)")
End Sub

Private Sub numPorcentaje2_Validate(Cancel As Boolean)
  If numPorcentaje2.Value < 0 Or numPorcentaje2.Value > 100 Then
    mAdvertencia "El porcentaje debe estar entre CERO y CIEN"
    Cancel = True
    Exit Sub
  End If
  If numPorcentaje2.Value <> TiposImpuesto.ValorActualImpuesto("IV2") Then
    If Not Confirmar("El valor actual de IV2 es de " & Format(TiposImpuesto.ValorActualImpuesto("IV2"), "0.00\%") & vbCrLf & "Est seguro de que este valor es correcto") Then
      Cancel = True
      Exit Sub
    End If
  End If
  Update
End Sub

Private Sub txNumeroControl_GotFocus()
  RaiseEvent StatusInfo("Numero de control -si no se incluye, se aplicar una retencion del 100% del IVA")
End Sub

Private Sub txNumeroControl_Validate(Cancel As Boolean)
  If Not NumeroValido(txNumeroControl.Text) Then
    mAdvertencia "Numero invalido"
    Cancel = True
    Exit Sub
  End If
  Update
End Sub

Private Sub UserControl_Initialize()
  On Error GoTo ErrHandler
  UserControl.numPorcentaje1.Value = TiposImpuesto.ValorActualImpuesto("IV1")
  UserControl.numPorcentaje2.Value = TiposImpuesto.ValorActualImpuesto("IV2")
  Exit Sub
ErrHandler:
  Err.Clear
End Sub

Public Sub ClearEdit()
  With UserControl
  .txNumDoc.Text = ""
  .txNumeroControl.Text = ""
  .numExento.Value = 0
  .chkAplicarRetencion.Value = vbUnchecked
  .numGravable1.Value = 0
  .numPorcentaje1.Value = TiposImpuesto.ValorActualImpuesto("IV1")
  .numPorcentaje2.Value = TiposImpuesto.ValorActualImpuesto("IV2")
  .numGravable2.Value = 0
  .numCreditoFiscal.Value = 0
  End With
End Sub
