VERSION 5.00
Begin VB.UserControl ucNumeroFactura 
   ClientHeight    =   315
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   1620
   ScaleHeight     =   315
   ScaleWidth      =   1620
   Begin VB.TextBox txCorrelativo 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   720
      TabIndex        =   1
      Text            =   "0000000"
      Top             =   0
      Width           =   885
   End
   Begin VB.ComboBox cbxSerie 
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   765
   End
End
Attribute VB_Name = "ucNumeroFactura"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public ParentForm As Form
Private localInstance As clsFacturas, orgNumero As Long, orgSerie As String
Private m_Visible As Boolean, m_Enabled As Boolean
Private m_Overriden As Boolean  ' El usuario ESPECIFICO un nmero de factura...
Private m_AcceptBlank As Boolean
Private Const DESIGN_WIDTH = 1620
Private Const DESIGN_HEIGHT = 315

Public Property Get AcceptBlank() As Boolean
    AcceptBlank = m_AcceptBlank
End Property

Public Property Let AcceptBlank(bNewVal As Boolean)
    m_AcceptBlank = bNewVal
    PropertyChanged "AcceptBlank"
End Property

Public Sub SetNumeroFactura(dest As clsFacturas)
' Determina el nmero definitivo de la factura
    
    If dest.Numero Then Exit Sub
    
    If Not m_Overriden Then
        dest.Correlativo = 0
    Else
        dest.Correlativo = Correlativo
    End If
    
    dest.Serie = Serie

End Sub

Public Property Get Overriden() As Boolean
    Overriden = m_Overriden
End Property

Public Property Get Enabled() As Boolean
    Enabled = cbxSerie.Enabled
End Property

Public Property Let Enabled(bVal As Boolean)
    cbxSerie.Enabled = bVal
    txCorrelativo.Enabled = bVal
    m_Enabled = bVal
End Property

Public Property Get Visible() As Boolean
    Visible = cbxSerie.Visible
End Property

Public Property Let Visible(bVal As Boolean)
    cbxSerie.Visible = bVal
    txCorrelativo.Visible = bVal
    m_Visible = bVal
End Property

Public Property Get Serie() As String
    Serie = cbxSerie.Text
End Property

Public Property Let Serie(st As String)
    cbxSerie.Text = st
End Property

Public Property Get Correlativo() As Long
    Correlativo = ValOf(txCorrelativo.Text)
End Property

Public Property Let Correlativo(vArg As Long)
    txCorrelativo.Text = Format(vArg, "000000")
End Property

Public Function instance() As clsFacturas
    If localInstance.Serie <> Me.Serie Or localInstance.Correlativo <> Me.Correlativo Then
        If Not localInstance.LoadBySerie(Serie, Correlativo) Then
            localInstance.Blank Date
            localInstance.Serie = Serie
            localInstance.Correlativo = Correlativo
            localInstance.FechaTransaccion = Date
        End If
    End If
    Set instance = localInstance
End Function

Public Function Referencia() As String
Dim f As New clsFacturas
  f.Serie = cbxSerie.Text
  On Error Resume Next
  f.Correlativo = ValOf(txCorrelativo.Text)
  If Err.Number Then Err.Clear: f.Correlativo = 0
  Referencia = f.Referencia
End Function

Public Function isNew() As Boolean
    isNew = Not localInstance.LoadBySerie(Serie, Correlativo)
End Function

Private Function CheckRef() As Boolean
    If Correlativo = 0 Then
        Correlativo = Series.ProximaFacturaSerie(cbxSerie.Text)
        m_Overriden = False
    Else
        If Not localInstance.LoadBySerie(Serie, Correlativo) Then
            localInstance.Blank ParentForm.txFechaFactura.Fecha
            localInstance.Serie = Serie
            localInstance.Correlativo = Correlativo
        End If
    End If
    
    CheckRef = True
End Function

Private Sub cbxSerie_GotFocus()
    HighLight cbxSerie
    On Error Resume Next
    ParentForm.lblStatus.Caption = "Seleccione la serie de facturas deseada"
    orgSerie = cbxSerie.Text
End Sub

Private Sub cbxSerie_LostFocus()
Dim lNuevo As Long
    If Not ParentForm.Enabled Then Exit Sub
    If Not ParentForm.Visible Then Exit Sub
    If Not Me.Enabled Then Exit Sub
    If ParentForm.ActiveControl Is Me Then Exit Sub
    If ParentForm.ActiveControl.Name = "cbCancelar" Then Exit Sub

    cbxSerie.Text = Trim(Format(cbxSerie.Text, ">"))
    cbxSerie.SelLength = 0
    
    If cbxSerie.Text = "" Then
        If Not AcceptBlank Then
            mAdvertencia "No puede dejar la serie en blanco"
            cbxSerie.SetFocus
            Exit Sub
        End If
    End If

    If Trim(cbxSerie.Text) = "" Then
        Exit Sub
    End If

    If cbxSerie.Text <> orgSerie Then
        txCorrelativo.Text = "000000"
        m_Overriden = False
    End If
    
    If Not Series.Validar(cbxSerie.Text) Then
        mAdvertencia "Serie invlida"
        cbxSerie.SetFocus
        Exit Sub
    End If

    CheckRef

End Sub

Private Sub txCorrelativo_LostFocus()
Dim l As Long
    
    If Trim(cbxSerie.Text = "") Then
        txCorrelativo.Text = ""
        Exit Sub
    End If

    l = ValOf(txCorrelativo.Text)
    If l = 0 Then
        m_Overriden = False
    Else
        If l <> orgNumero Then
            m_Overriden = True
        End If
    End If

    If Not ParentForm.Enabled Then Exit Sub
    If Not ParentForm.Visible Then Exit Sub
    If Not Me.Enabled Then Exit Sub
    If ParentForm.ActiveControl Is Me Then Exit Sub
    If ParentForm.ActiveControl.Name = "cbCancelar" Then Exit Sub
    If Not NumeroValido(txCorrelativo.Text) Then
        mAdvertencia "Numero invalido"
        txCorrelativo.SetFocus
        Exit Sub
    End If
    txCorrelativo.SelLength = 0
    CheckRef
End Sub

Private Sub txCorrelativo_GotFocus()
    HighLight txCorrelativo
    On Error Resume Next
    orgNumero = ValOf(txCorrelativo.Text)
    ParentForm.lblStatus.Caption = "Introduzca el numero de la factura deseada"
End Sub

Private Sub UserControl_Initialize()
Dim instSerie As clsSerie, orgSerie As String
    
    Visible = True
    Enabled = True
    m_Overriden = False
    txCorrelativo.ZOrder 0: cbxSerie.ZOrder 0
    Set localInstance = New clsFacturas
    txCorrelativo.Text = "0000000"
    On Error GoTo SkipLoad
    orgSerie = cbxSerie.Text
    cbxSerie.Text = "???"
    Series.FillCombo cbxSerie
    Set instSerie = Series.Item(orgSerie)
    If instSerie Is Nothing Then
        cbxSerie.Text = Series.Item(1).Codigo
    Else
        Set instSerie = Nothing
        cbxSerie.Text = orgSerie
    End If

ReturnPoint:
    Exit Sub

SkipLoad:
    Resume ReturnPoint

End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    Me.Serie = PropBag.ReadProperty("Serie", "")
    Me.Correlativo = PropBag.ReadProperty("Correlativo", 0)
    Me.AcceptBlank = PropBag.ReadProperty("AcceptBlank", False)
    cbxSerie.Enabled = m_Enabled
    txCorrelativo.Enabled = m_Enabled
    cbxSerie.Visible = m_Visible
    txCorrelativo.Visible = m_Visible
End Sub

Private Sub UserControl_Resize()
  If UserControl.Width < DESIGN_WIDTH Then
    txCorrelativo.Font.Bold = False
    txCorrelativo.Font.Name = "Arial"
    cbxSerie.Font.Name = "Arial"
  End If
  cbxSerie.Width = 765 * UserControl.Width / DESIGN_WIDTH
  cbxSerie.Font.Size = 8 * UserControl.Width / DESIGN_WIDTH
  txCorrelativo.Width = 885 * UserControl.Width / DESIGN_WIDTH
  txCorrelativo.Font.Size = 8 * UserControl.Width / DESIGN_WIDTH
  txCorrelativo.left = cbxSerie.Width + 15
  txCorrelativo.Height = cbxSerie.Height
End Sub

Private Sub UserControl_Terminate()
    Set localInstance = Nothing
    Set ParentForm = Nothing
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    PropBag.WriteProperty "Serie", Serie
    PropBag.WriteProperty "Correlativo", Correlativo
    PropBag.WriteProperty "AcceptBlank", m_AcceptBlank
End Sub

Public Function IsEmpty() As Boolean
Dim bRetVal As Boolean
    If cbxSerie.Text <> "" Then
        bRetVal = False
    ElseIf ValOf(txCorrelativo.Text) <> 0 Then
        bRetVal = False
    Else
        bRetVal = True
    End If
    IsEmpty = bRetVal
End Function
