VERSION 5.00
Begin VB.UserControl ucMenu 
   Appearance      =   0  'Flat
   BackColor       =   &H80000005&
   BackStyle       =   0  'Transparent
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   2175
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4680
   KeyPreview      =   -1  'True
   ScaleHeight     =   2175
   ScaleWidth      =   4680
   Begin VB.VScrollBar VScroll1 
      Height          =   2175
      Left            =   4350
      TabIndex        =   2
      Top             =   0
      Visible         =   0   'False
      Width           =   345
   End
   Begin VB.PictureBox Picture1 
      BorderStyle     =   0  'None
      Height          =   975
      Left            =   0
      ScaleHeight     =   975
      ScaleWidth      =   2145
      TabIndex        =   0
      Top             =   0
      Width           =   2145
      Begin SimplexW.ucItemMenu item 
         Height          =   720
         Index           =   0
         Left            =   0
         TabIndex        =   1
         TabStop         =   0   'False
         Top             =   0
         Visible         =   0   'False
         Width           =   2115
         _ExtentX        =   3731
         _ExtentY        =   1270
         Caption         =   "Item 0"
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BackColor       =   -2147483643
         ForeColor       =   -2147483630
      End
   End
End
Attribute VB_Name = "ucMenu"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Event ItemSelected(pRenglon As clsRenglonConsumo)
Public Event MenuSelected(sCodigo As String, ByRef bProcessed As Boolean)

Private nCols As Long, nRows As Long
Private nControls As Integer
Private nActiveControl As Integer
Private nVisibleItems As Integer
Private sMenuID As String
Private bModo As Boolean      ' False: Modo de Seleccin, True: Modo de Edicion
Private WithEvents pRenglon As clsRenglonConsumo
Attribute pRenglon.VB_VarHelpID = -1
Private nIndex As Integer
Private sCurMenu As String

Public Property Get ScrollBar() As VScrollBar
  Set ScrollBar = VScroll1
End Property

Public Property Get ItemIndex() As Integer
  ItemIndex = nIndex
End Property

Public Property Get nItems() As Integer
  nItems = nControls
End Property

Public Property Let Modo(binMode As Boolean)
Dim i As Integer
  bModo = binMode
  For i = 1 To nControls
    item(i).Modo = binMode
  Next
End Property

Public Property Get Modo() As Boolean
  Modo = bModo
End Property

Private Sub AjustarBarraScroll()
  Picture1.top = 0
  VScroll1.Value = 0
  nCols = UserControl.Width \ item(0).Width
  nRows = nControls \ nCols + IIf(nControls Mod nCols <> 0, 1, 0)
  Dim nVisibleRows As Integer
  nVisibleRows = UserControl.Height \ item(0).Height
  If nVisibleRows < nRows Then
'    VScroll1.Visible = True
    nCols = (UserControl.Width - VScroll1.Width) \ item(0).Width
    nRows = nControls \ nCols + IIf(nControls Mod nCols <> 0, 1, 0)
    nVisibleRows = UserControl.Height \ item(0).Height
    VScroll1.Min = 0
    VScroll1.Max = (nRows - nVisibleRows) * item(0).Height
    VScroll1.SmallChange = item(0).Height
    VScroll1.LargeChange = item(0).Height
    VScroll1.left = Picture1.Width - VScroll1.Width
    VScroll1.Height = UserControl.Height
  Else
    VScroll1.Visible = False
  End If
  Picture1.Height = nRows * item(0).Height
  If Picture1.Height < UserControl.Height Then Picture1.Height = UserControl.Height
End Sub

Public Function SetMenu(Optional istrMenuID As String = "\") As Boolean
Dim pItemMenu As clsItemMenu, pSecItem As clsItemMenu, i As Integer, pPicture As StdPicture

  If sCurMenu = istrMenuID Then
    SetMenu = True
    Exit Function
  End If

  sCurMenu = istrMenuID
  For i = nControls To 1 Step -1
    item(i).Visible = False
    Unload item(i)
  Next

  nControls = 0
  Set pItemMenu = New clsItemMenu
  If pItemMenu.IniciarIteradorMenu(istrMenuID) Then
  Do
    Set pSecItem = pItemMenu.NextItem
    If Not pSecItem Is Nothing Then
      AddItem pSecItem
    End If
  Loop While Not pSecItem Is Nothing
  End If
  Set pItemMenu = Nothing

  AjustarBarraScroll
  
  If nControls > 0 Then
    On Error Resume Next
    item(1).SetFocus
    sMenuID = istrMenuID
  End If
  
  nActiveControl = 0
  SetMenu = (nControls > 0)

End Function

Private Sub item_GotFocus(Index As Integer)
Dim iTopControl As Integer, iBottomControl As Integer
    
    On Error Resume Next
    item(nActiveControl).DeSelect
    On Error GoTo 0
    nActiveControl = Index
    item(nActiveControl).SetSelect

End Sub

Private Sub item_ItemSelected(Index As Integer, pItem As clsItemMenu)
Dim bProcessed As Boolean

  nIndex = Index

  If bModo Then
    RaiseEvent ItemSelected(Nothing)
    Exit Sub
  End If
  
  If pItem.isTerminal Then
      On Error Resume Next
      pRenglon.SetModoDefinicion pItem.CodigoItem
      If Err.Number <> 0 Then
        MsgBox "ERROR: " & Err.Description
        Err.Clear
        Exit Sub
      End If
'       MsgBox pItem.CodigoItem & ": " & pItem.Descripcion
'      SetMenu "\"
  Else
    bProcessed = False
    RaiseEvent MenuSelected(pItem.CodigoItem, bProcessed)
    ' Si es utilizado dentro de un "ctlMenuSet", la respuesta debe ser bien rpida...
    If Not bProcessed Then
      Me.SetMenu pItem.CodigoItem
    End If
  End If
End Sub

Private Sub pRenglon_ItemDefined()
    RaiseEvent ItemSelected(pRenglon)
End Sub

Private Sub item_KeyDown(Index As Integer, KeyCode As Integer, Shift As Integer)
    UserControl_KeyDown KeyCode, Shift
End Sub

Private Sub UserControl_GotFocus()
    If nActiveControl > 0 Then
      If nActiveControl >= nControls Then
        nActiveControl = 0
      End If
    End If
    On Error Resume Next
    item(nActiveControl).SetFocus
    If Err.Number Then Err.Clear
End Sub

Private Sub UserControl_Initialize()
    Set pRenglon = New clsRenglonConsumo
End Sub

Private Sub UserControl_KeyDown(KeyCode As Integer, Shift As Integer)

    Select Case KeyCode
    Case vbKeyDown
        If nActiveControl + 1 <= nControls Then
            item(nActiveControl + 1).SetFocus
        End If
    Case vbKeyUp
        If nActiveControl > 1 Then
            item(nActiveControl - 1).SetFocus
        End If
    Case vbKeyPageUp
        If nActiveControl - nVisibleItems > 0 Then
            nActiveControl = nActiveControl - nVisibleItems
        Else
            nActiveControl = 1
        End If
        item(nActiveControl).SetFocus
    Case vbKeyPageDown
        If nActiveControl + nVisibleItems < nControls Then
            nActiveControl = nActiveControl + nVisibleItems
        Else
            nActiveControl = nControls
        End If
        item(nActiveControl).SetFocus
    Case vbKeyHome
'        item(1).SetFocus
    Case vbKeyEnd
        item(nControls).SetFocus
    Case vbKeyReturn
        item_ItemSelected nActiveControl, item(nActiveControl).item
    End Select

End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    Set item(0).Font = PropBag.ReadProperty("Font", item(0).Font)
'    item(0).BackColor = PropBag.ReadProperty("BackColor", item(0).BackColor)
'    item(0).ForeColor = PropBag.ReadProperty("ForeColor", item(0).ForeColor)
End Sub

Private Sub UserControl_Resize()
Dim i As Integer

'  Frame1.Width = UserControl.Width
'  Frame1.Height = UserControl.Height

  nCols = UserControl.Width \ item(0).Width
  nRows = UserControl.Height \ item(0).Height
  
  For i = 1 To nControls
'    item(i).Width = UserControl.Width - VScroll1.Width
    item(i).top = ((i - 1) \ nCols) * item(i).Height
    item(i).left = ((i - 1) Mod nCols) * item(i).Width
  Next
  
  Picture1.Width = UserControl.Width
  AjustarBarraScroll

'    VScroll1.Left = item(0).Width + 15
'    VScroll1.Height = UserControl.Height
'  nVisibleItems = UserControl.Height \ item(0).Height
'  VScroll1.LargeChange = nVisibleItems

End Sub

Public Property Get Font() As IFontDisp
Dim i As Integer
    Set Font = item(0).Font
End Property

Public Property Set Font(pFont As IFontDisp)
Dim i As Integer
    For i = 0 To nControls
        Set item(i).Font = pFont
    Next
End Property

Public Function AddItem(ipItem As clsItemMenu)

    nControls = nControls + 1
    Load item(nControls)
    item(nControls).Caption = ipItem.Descripcion
    Set item(nControls).Font = item(0).Font
    item(nControls).top = ((nControls - 1) \ nCols) * item(nControls).Height
    item(nControls).left = ((nControls - 1) Mod nCols) * item(nControls).Width
    item(nControls).Visible = True
    item(nControls).ZOrder
    item(nControls).TabStop = True
    item(nControls).BackColor = ipItem.nColor
    item(nControls).FramedLabel.ToolTipText = ipItem.ToolTipText
    Set item(nControls).item = ipItem

End Function

Private Sub UserControl_Terminate()
    Set pRenglon = Nothing
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    PropBag.WriteProperty "Font", item(0).Font
End Sub

Private Sub VScroll1_Change()
  Picture1.top = -VScroll1.Value
End Sub
