VERSION 5.00
Object = "{F93FDE78-A4B4-11D7-9BCE-00C026A196EC}#1.1#0"; "ADObox.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Begin VB.UserControl ucLineaPOS 
   ClientHeight    =   1110
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   8805
   LockControls    =   -1  'True
   ScaleHeight     =   1110
   ScaleWidth      =   8805
   Begin ucNumero.ucNumBox numCantidad 
      Height          =   315
      Left            =   4260
      TabIndex        =   3
      Top             =   0
      Width           =   1575
      _ExtentX        =   2778
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin codeBoxA.ucCodeBox ucItemVentaBox 
      Height          =   315
      Left            =   7620
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   810
      Visible         =   0   'False
      Width           =   1065
      _ExtentX        =   1879
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "itemsVenta"
      NombreDescripcion=   "Descripcion"
      Titulo          =   "Productos"
   End
   Begin ucNumero.ucNumBox numDescuento 
      Height          =   315
      Left            =   4260
      TabIndex        =   7
      Top             =   390
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox numPrecio 
      Height          =   315
      Left            =   750
      TabIndex        =   5
      Top             =   360
      Width           =   2025
      _ExtentX        =   3572
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.TextBox txCodigo 
      Height          =   315
      Left            =   750
      TabIndex        =   1
      Top             =   0
      Width           =   2055
   End
   Begin prjUcFramedLabel.ucFramedLabel lblDescripcion 
      Height          =   285
      Left            =   1020
      Top             =   750
      Width           =   7665
      _ExtentX        =   13520
      _ExtentY        =   503
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   "PRUEBA"
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   12
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Descuento:"
      Height          =   195
      Left            =   3150
      TabIndex        =   6
      Top             =   420
      Width           =   825
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "C&antidad:"
      Height          =   195
      Left            =   3150
      TabIndex        =   2
      Top             =   30
      Width           =   675
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo:"
      Height          =   195
      Left            =   60
      TabIndex        =   0
      Top             =   30
      Width           =   540
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Precio:"
      Height          =   195
      Left            =   60
      TabIndex        =   4
      Top             =   420
      Width           =   495
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Descripcin:"
      Height          =   195
      Left            =   60
      TabIndex        =   8
      Top             =   780
      Width           =   885
   End
End
Attribute VB_Name = "ucLineaPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : ucLineaPOS
' DateTime  : 23/04/2004 13:46
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------

Option Explicit

Private item As clsItemVenta
Private UltimoPrecio As Currency
Private CargarIVAGenericos As Boolean
Private PrecioReferencia As Currency
Private doShowPrecioNeto As Boolean

Public Event AgregarLinea(Codigo As String, Cantidad As Double, Precio As Currency, item As clsItemVenta)
Public Event RequestCierre()
Public Event CargarCuenta(ByVal refCuenta As String)
Public Event RequestDelete()
Public Event RequestPrecio(ByRef n As Integer)
Public Event RequestShowPrecioNeto(ByRef b As Boolean)

Public Tipo As Boolean

'---------------------------------------------------------------------------------------
' Procedure : ResetControl
' DateTime  : 23/04/2004 16:31
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Sub ResetControl()
  With UserControl
  .txCodigo.Text = ""
  .numCantidad.Value = 0
  .numDescuento.Value = 0
  .numPrecio.Value = 0
  End With
  
  On Error Resume Next
  txCodigo.SetFocus
  If Err.Number Then Err.Clear

End Sub

Private Sub numPrecio_Validate(Cancel As Boolean)
  Dim PrecioNeto As Currency
  RaiseEvent RequestShowPrecioNeto(doShowPrecioNeto)
  If doShowPrecioNeto Then
    PrecioNeto = numPrecio.Value
  Else
    PrecioNeto = numPrecio.Value / (1# + item.PorcentajeImpuesto(1) / 100)
  End If
  If PrecioNeto < item.PrecioMinimo Then
    If VerificarUsuario("PVP inferior al minimo") < 5 Then
      Cancel = True
      Exit Sub
    End If
  End If
  UltimoPrecio = PrecioNeto
  PrecioNeto = (PrecioReferencia - UltimoPrecio) * 100 / PrecioReferencia
  numDescuento.Value = PrecioNeto
End Sub

Private Sub numPrecio_KeyDown(KeyCode As Integer, Shift As Integer)
  If KeyCode = vbKeyEnd Or KeyCode = vbKeyReturn Then
    Dim isCancel As Boolean
    isCancel = False
    numPrecio_Validate isCancel
    If isCancel Then Exit Sub
    If KeyCode = vbKeyEnd Then
      RaiseEvent AgregarLinea(txCodigo.Text, numCantidad.Value, UltimoPrecio, item)
      ResetControl
      Exit Sub
    End If
    numDescuento.SetFocus
  End If
End Sub

Private Sub numDescuento_Validate(Cancel As Boolean)
  Dim PrecioNeto As Currency
  Dim factor As Double
  
  RaiseEvent RequestShowPrecioNeto(doShowPrecioNeto)
  If doShowPrecioNeto Then
    factor = 1
  Else
    factor = 1 + item.PorcentajeImpuesto(1) / 100
  End If

  PrecioNeto = PrecioReferencia * (1# - numDescuento.Value / 100)
  If Abs(PrecioNeto - numPrecio) < 1 Then Exit Sub
  If PrecioNeto < item.PrecioMinimo Then
    If VerificarUsuario("PVP inferior al minimo") < 5 Then
      Cancel = True
      Exit Sub
    End If
  End If
  UltimoPrecio = PrecioNeto
  If doShowPrecioNeto Then
    numPrecio.Value = PrecioNeto
  Else
    numPrecio.Value = PrecioNeto * (1# + item.PorcentajeImpuesto(1) / 100)
  End If
End Sub

Private Sub numDescuento_KeyDown(KeyCode As Integer, Shift As Integer)
  If KeyCode = vbKeyEnd Or KeyCode = vbKeyReturn Then
  Dim isCancel As Boolean
    numDescuento_Validate isCancel
    If isCancel Then Exit Sub
    RaiseEvent AgregarLinea(txCodigo.Text, numCantidad.Value, UltimoPrecio, item)
    ResetControl
  End If
End Sub

'---------------------------------------------------------------------------------------
' Procedure : ucItemVentaBox_GetQuery
' DateTime  : 23/04/2004 13:34
' Author    : Leonardo Azpurua
' Purpose   : Eventos de solicitud de formato del control de busqueda
'---------------------------------------------------------------------------------------
'
Private Sub ucItemVentaBox_GetQuery(sPreffix As String, sRetVal As String)
Dim stQuery As String, sAux As String

    stQuery = "SELECT I.Codigo, I.Descripcion, Precio" & Trim(Str(nPrecioStandard)) & " * (1 + (T.Porcentaje / 100)) as Precio FROM itemsVenta I, TiposImpuesto T "
    If left(sPreffix, 1) = "." Then
        sAux = right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE I.Descripcion LIKE '%" & sAux & "%'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
    ElseIf left(sPreffix, 1) = "!" Then
      If Mid(sPreffix, 2, 1) = "." Then
        sAux = right(sPreffix, Len(sPreffix) - 2)
        stQuery = stQuery & " WHERE I.Codigo LIKE '%" & sAux & "%'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
      Else
        sAux = right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE I.Codigo LIKE '" & sAux & "%'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
      End If
    Else
        stQuery = stQuery & " WHERE I.Descripcion LIKE '" & sPreffix & "%'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Descripcion"
    End If

    sRetVal = stQuery

End Sub

Private Sub ucItemVentaBox_RequestFormat(rs As Recordset, sRetVal As String)
Dim s As String, pItem As clsItemVenta, dExistencia As Double

    On Error GoTo ErrHandler

    Set pItem = AlmacenItemsVenta.ItemVenta(GetStringFromVariant(rs!Codigo))
    dExistencia = pItem.ExistenciaGeneral
    If dExistencia < 0 Or dExistencia = HIGH_VALUE Then
        dExistencia = 0
    End If
    Set pItem = Nothing

    s = stFullLength(GetStringFromVariant(rs!Descripcion), 40)
    s = s & FormatNumero(GetNumeroFromVariant(rs!Precio), Empresa.MascaraPrecios, 12) & " "
    s = s & FormatNumero(dExistencia, Empresa.MascaraCantidades, 10)
    s = s & " (" & GetStringFromVariant(rs!Codigo) & ")"

    sRetVal = s
    Exit Sub

ErrHandler:
    Err.Clear

End Sub

'---------------------------------------------------------------------------------------
' Property Enabled
' DateTime  : 23/04/2004 13:31
' Author    : Leonardo Azpurua
' Purpose   : Activa/Desactiva los controles internos del UC
'---------------------------------------------------------------------------------------
'
Public Property Get Enabled() As Boolean
  Enabled = txCodigo.Enabled
End Property

Public Property Let Enabled(newEnabled As Boolean)
Dim pControl As Control
  For Each pControl In UserControl.Controls
    On Error Resume Next
    pControl.Enabled = newEnabled
    If Err.Number Then Err.Clear
  Next
End Property

'---------------------------------------------------------------------------------------
' Procedure : GetPeso
' DateTime  : 23/04/2004 12:54
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function GetPeso(psCodigoItem As String)
Dim pBalanza As Object, Peso As Double, pFactoria As CFactoria

  On Error GoTo ErrHandler

  Set pBalanza = CreateObject("IBalanza.CBalanza")
  Set pFactoria = New CFactoria
  Set pBalanza.Factoria = pFactoria
  Peso = pBalanza.GetPeso
  psCodigoItem = pBalanza.CodigoProducto
  Set pBalanza = Nothing
  
  GetPeso = Peso
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "frmPOS::GetPeso"
  Err.Clear
  GetPeso = 0

End Function

'---------------------------------------------------------------------------------------
' Procedure : SelectItemVarios
' DateTime  : 23/04/2004 12:49
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function SelectItemVarios() As clsItemVenta
Dim rs As Recordset, frmMenu As lfPopupMenu
Dim Codigos() As String
Dim stCodigoProducto As String

  Set rs = dbHandle.Execute("SELECT Codigo, Descripcion FROM ItemsVenta WHERE Codigo LIKE '0__'")
  If Not rs.EOF Then
    ReDim Codigos(0)
    Set frmMenu = New lfPopupMenu
    Do While Not rs.EOF
      frmMenu.AddOption GetStringFromVariant(rs.Fields("Descripcion")), True
      ReDim Preserve Codigos(UBound(Codigos) + 1)
      Codigos(UBound(Codigos)) = GetStringFromVariant(rs.Fields("Codigo"))
      rs.MoveNext
    Loop
    rs.Close
    Centrar frmMenu
    frmMenu.Show vbModal
    If frmMenu.mnuResult Then
      stCodigoProducto = Codigos(frmMenu.mnuResult)
      If Not item.Load(stCodigoProducto) Then
        item.Codigo = ""
      End If
    Else
      item.Codigo = ""
    End If
    Unload frmMenu
    Set frmMenu = Nothing
  End If
  Set rs = Nothing
  
  Set SelectItemVarios = IIf(item.Codigo <> "", item, Nothing)

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdReadCuenta
' DateTime  : 23/04/2004 12:52
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdReadCuenta() As Boolean
Dim stc2 As String, retVal As Boolean, stInput As String

  retVal = False
  stInput = Trim(txCodigo.Text)
  If left(stInput, 1) = "/" Or left(stInput, 1) = "-" Then
    stc2 = right(stInput, Len(stInput) - 1)
    RaiseEvent CargarCuenta(stc2)
    retVal = True
    ResetControl
  End If
  isCmdReadCuenta = retVal
End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdDelete
' DateTime  : 23/04/2004 13:25
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdDelete() As Boolean
Dim iRetVal As Integer

  If txCodigo.Text <> "-" Then
    isCmdDelete = 0
    Exit Function
  End If

  RaiseEvent RequestDelete
  ResetControl
  isCmdDelete = True

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdReadScale
' DateTime  : 23/04/2004 13:36
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdReadScale() As Boolean
Dim dblPeso As Double, pItemVenta As clsItemVenta
Dim sCodigo As String, retVal As Boolean

  If txCodigo.Text <> "." Then
    isCmdReadScale = False
    Exit Function
  End If

  dblPeso = GetPeso(sCodigo)
  If dblPeso > 0 Then
    If sCodigo <> "" Then
      Set pItemVenta = AlmacenItemsVenta.ItemVenta(sCodigo)
    Else
      Set pItemVenta = SelectItemVarios
    End If

    If pItemVenta Is Nothing Then
      mAdvertencia "Producto invlido"
      retVal = False
    Else
      item.Load pItemVenta.Codigo
      txCodigo.Text = item.Codigo
      numCantidad.Value = dblPeso
      numPrecio.Value = IIf(doShowPrecioNeto, item.PrecioNeto(nPrecioStandard), item.PrecioConIVA(nPrecioStandard))
      retVal = True
    End If
  Else
    retVal = False
  End If

  RaiseEvent AgregarLinea(pItemVenta.Codigo, numCantidad.Value, item.Precio(nPrecioStandard), pItemVenta)
  UltimoPrecio = item.PrecioNeto(1)
  ResetControl

  isCmdReadScale = retVal

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdAddLast
' DateTime  : 23/04/2004 13:43
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdAddLast() As Boolean

  If txCodigo.Text <> "+" Then
    isCmdAddLast = False
    Exit Function
  End If
  
  If item.Codigo = "" Then
    isCmdAddLast = False
    Exit Function
  End If

  If Not item.Refresh Then
    mAdvertencia "Acaba de desaparecer el producto"
    isCmdAddLast = False
  End If
  
  RaiseEvent AgregarLinea(item.Codigo, 1, UltimoPrecio, item)
  ResetControl
  
  isCmdAddLast = True

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdAddGenericos
' DateTime  : 23/04/2004 13:46
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdAddGenericos() As Boolean
Dim stc2 As String, pItemVenta As clsItemVenta
Dim stInput As String, vmPrecio As Currency

  stInput = UCase(Trim(txCodigo.Text))

  If left(stInput, 1) <> "+" Then
    isCmdAddGenericos = False
    Exit Function
  End If
  
  stc2 = right(stInput, Len(stInput) - 1)
  If Not NumeroValido(stc2) Then
    isCmdAddGenericos = False
    Exit Function
  End If

  vmPrecio = Val(stc2)

  If vmPrecio > 500000 Then
    If Not Confirmar("Es correcto el precio", True) Then
      isCmdAddGenericos = False
      Exit Function
    End If
  End If

  Set pItemVenta = SelectItemVarios
  If Not pItemVenta Is Nothing Then   ' Determinar cantidad a partir de precio...
                                      ' Se supone que el monto indicado incluye el IVA
    If Not CargarIVAGenericos Then
      vmPrecio = vmPrecio / (1# + pItemVenta.PorcentajeImpuesto(1) / 100)
    End If
    RaiseEvent AgregarLinea(pItemVenta.Codigo, 1, vmPrecio, pItemVenta)
    UltimoPrecio = vmPrecio
    ResetControl
    isCmdAddGenericos = True
    Exit Function
  Else
    mAdvertencia "Debe definir los cdigos de los productos genricos"
  End If

  isCmdAddGenericos = False

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdMultiply
' DateTime  : 23/04/2004 15:27
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdMultiply() As Integer
Dim stc2 As String, stInput As String

  stInput = txCodigo.Text
  
  If left(stInput, 1) <> "*" Then
    isCmdMultiply = False
    Exit Function
  End If
  
  If item.Codigo = "" Then
    isCmdMultiply = False
    Exit Function
  End If

  stc2 = right(stInput, Len(stInput) - 1)
  If stc2 = "" Then
    isCmdMultiply = False
    Exit Function
  End If

  If Not NumeroValido(stc2) Then
    isCmdMultiply = False
    Exit Function
  End If
    
  numCantidad.Value = Val(stc2) - 1
  If numCantidad.Value = 0 Or numCantidad.Value = -1 Then
    isCmdMultiply = False
    Exit Function
  End If

  If numCantidad.Value > 24 Then
    If Not Confirmar("Seguro que son tantos", True) Then
      isCmdMultiply = False
      Exit Function
    End If
  End If
    
  RaiseEvent AgregarLinea(item.Codigo, numCantidad.Value, UltimoPrecio, item)
  
  ResetControl
  
  isCmdMultiply = True

End Function

'---------------------------------------------------------------------------------------
' Procedure : ParseInput
' DateTime  : 23/04/2004 15:44
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function ParseInput() As Boolean
Dim stTranslate As String, stc2 As String
Dim nSelGenerico As Integer, i As Integer
Dim stInput As String, stCodigoProducto As String
Dim dblCantidad As Double
Dim n As Integer

  stInput = UCase(Trim(txCodigo.Text))
  txCodigo.Text = stInput

  If isCmdDelete() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdReadScale() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdReadCuenta() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdAddLast() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdAddGenericos() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdMultiply() Then
    ParseInput = False
    Exit Function
  End If

  If Not mParseInput.ParseInput(stInput, stCodigoProducto, dblCantidad) Then
    mAdvertencia "ARTICULO " & stCodigoProducto & " NO LOCALIZADO..."
    Exit Function
  End If
  
  If Not item.Load(stCodigoProducto) Then
    mAdvertencia "Producto no localizado"
    ParseInput = False
    Exit Function
  End If

  RaiseEvent RequestPrecio(n)
  RaiseEvent RequestShowPrecioNeto(doShowPrecioNeto)
  txCodigo.Text = stCodigoProducto
  numPrecio.Value = IIf(doShowPrecioNeto, item.PrecioNeto(n), item.PrecioConIVA(n))
  UltimoPrecio = item.PrecioNeto(n)
  PrecioReferencia = UltimoPrecio
  numCantidad.Value = dblCantidad
'  numPrecio.Value = numPrecio.Value * dblCantidad
  lblDescripcion.Caption = item.Descripcion
  ParseInput = True

End Function

Private Sub UserControl_EnterFocus()
  numCantidad.Formato = Empresa.MascaraCantidades
End Sub

'---------------------------------------------------------------------------------------
' Eventos de construccion / destruccion del control
' DateTime  : 23/04/2004 17:01
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Sub UserControl_Initialize()
  Set item = New clsItemVenta
  With ucItemVentaBox
    Set .dbHandle = dbHandle
    .Titulo = "Productos"
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Descripcion"
    .NombreTabla = "itemsVenta"
  End With
  doShowPrecioNeto = CBool(Val(GetSetting("ClearLight", "General", "MostrarPrecioSinIVA", "0")))
  CargarIVAGenericos = CBool(Val(GetSetting("ClearLight", "General", "CargarIVAGenericos", "0")))
End Sub

Private Sub UserControl_Terminate()
  Set item = Nothing
End Sub

'---------------------------------------------------------------------------------------
' Codigo para los eventos de los controles
' DateTime  : 23/04/2004 16:58
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------

Private Sub txCodigo_KeyDown(KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case vbKeyF2
      txCodigo.Text = ucItemVentaBox.Buscar
    Case vbKeyEnd
      If txCodigo.Text = "" Then
        If Shift = 0 Then Tipo = True Else Tipo = False
        RaiseEvent RequestCierre
        Exit Sub
      End If
      If ParseInput Then
        RaiseEvent AgregarLinea(txCodigo.Text, numCantidad.Value, UltimoPrecio, item)
        ResetControl
      End If
    Case vbKeyReturn
      If txCodigo.Text = "" Then Exit Sub
      If ParseInput Then
        UserControl.numCantidad.SetFocus
        Exit Sub
      End If
  End Select
End Sub

Private Sub txCodigo_KeyPress(KeyAscii As Integer)
  Dim sCodigo As String
  
  If txCodigo.Text = "" Then
    If UCase(Chr(KeyAscii)) >= "A" And UCase(Chr(KeyAscii)) <= "Z" Then
      sCodigo = mHotKey.ParseHotKey(UCase(Chr(KeyAscii)))
      If sCodigo <> "" Then
        txCodigo.Text = sCodigo
        KeyAscii = 0
      End If
    End If
'    If KeyAscii = 13 Then
'      KeyAscii = 0
'      RaiseEvent RequestCierre
'    End If
  End If

  If KeyAscii = 13 Then KeyAscii = 0

End Sub

Private Sub numCantidad_Validate(Cancel As Boolean)
Static maxCantidad As Double
  If txCodigo.Text = "" Then Exit Sub
  If Abs(numCantidad.Value) < 0.01 Then
    mAdvertencia "Debe especificar una cantidad"
    Cancel = True
    Exit Sub
  End If
  
  If maxCantidad = 0 Then
    maxCantidad = Val(GetSetting("ClearLight", "General", "MaxCantidadPOS", "60"))
  End If
  
  If Abs(numCantidad.Value) > maxCantidad Then
    If Not Confirmar("La cantidad est por encima del margen normal" & vbCrLf & "Es correcta") Then
      Cancel = True
      Exit Sub
    End If
  End If

End Sub

Private Sub numCantidad_KeyDown(KeyCode As Integer, Shift As Integer)
Dim isCancel As Boolean
  If KeyCode = vbKeyEnd Then
    numCantidad_Validate isCancel
    If isCancel Then Exit Sub
    RaiseEvent AgregarLinea(txCodigo.Text, numCantidad.Value, UltimoPrecio, item)
    ResetControl
  End If
  If KeyCode = vbKeyReturn Then
    numCantidad_Validate isCancel
    If isCancel Then Exit Sub
    numPrecio.SetFocus
  End If
End Sub

