VERSION 5.00
Object = "{F93FDE78-A4B4-11D7-9BCE-00C026A196EC}#1.1#0"; "ADObox.ocx"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Begin VB.UserControl ucLineaPOS 
   ClientHeight    =   1170
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   8160
   LockControls    =   -1  'True
   ScaleHeight     =   1170
   ScaleWidth      =   8160
   Begin ucNumero.ucNumBox numCantidad 
      Height          =   315
      Left            =   6540
      TabIndex        =   4
      Top             =   0
      Width           =   1575
      _ExtentX        =   2778
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin codeBoxA.ucCodeBox ucItemVentaBox 
      Height          =   315
      Left            =   6840
      TabIndex        =   5
      Top             =   450
      Visible         =   0   'False
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "itemsVenta"
      NombreDescripcion=   "Descripcion"
      Titulo          =   "Productos"
   End
   Begin prjUcFramedLabel.ucFramedLabel lblDescripcion 
      Height          =   435
      Left            =   1230
      Top             =   360
      Width           =   6885
      _ExtentX        =   12144
      _ExtentY        =   767
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   1
      Caption         =   ""
      FontBold        =   -1  'True
      FontName        =   "MS Sans Serif"
      FontSize        =   12
   End
   Begin ucNumero.ucNumBox numDescuento 
      Height          =   315
      Left            =   6660
      TabIndex        =   10
      Top             =   840
      Visible         =   0   'False
      Width           =   1455
      _ExtentX        =   2566
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox numPrecio 
      Height          =   315
      Left            =   780
      TabIndex        =   9
      Top             =   840
      Width           =   2025
      _ExtentX        =   3572
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.CheckBox chkMayor 
      Caption         =   "Caja"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   3180
      TabIndex        =   2
      Top             =   0
      Width           =   1995
   End
   Begin VB.TextBox txCodigo 
      Height          =   315
      Left            =   750
      TabIndex        =   1
      Top             =   0
      Width           =   2055
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Descripcin:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   60
      TabIndex        =   6
      Top             =   480
      Width           =   1065
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Descuento:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   5370
      TabIndex        =   7
      Top             =   870
      Visible         =   0   'False
      Width           =   990
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Precio:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   60
      TabIndex        =   8
      Top             =   900
      Width           =   615
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "C&antidad:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   5580
      TabIndex        =   3
      Top             =   30
      Width           =   825
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Cdigo:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   60
      TabIndex        =   0
      Top             =   30
      Width           =   645
   End
End
Attribute VB_Name = "ucLineaPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : ucLineaPOS
' DateTime  : 23/04/2004 13:46
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------

Option Explicit

Private Item As clsItemVenta
Private UltimoPrecio As Currency
Private FactorCantidad As Double
Private CargarIVAGenericos As Boolean

Public Event AgregarLinea(Codigo As String, Cantidad As Double, Precio As Currency, Item As clsItemVenta)
Public Event RequestCierre()
Public Event CargarCuenta(ByVal refCuenta As String)
Public Event RequestDelete()

'---------------------------------------------------------------------------------------
' Procedure : ResetControl
' DateTime  : 23/04/2004 16:31
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Sub ResetControl()
  With UserControl
  .txCodigo.Text = ""
  .numCantidad.Value = 0
'  .chkMayor.Value = vbUnchecked
  .numDescuento.Value = 0
  .numPrecio.Value = 0
  End With
  
  On Error Resume Next
  txCodigo.SetFocus
  If Err.Number Then Err.Clear

End Sub

'---------------------------------------------------------------------------------------
' Procedure : ucItemVentaBox_GetQuery
' DateTime  : 23/04/2004 13:34
' Author    : Leonardo Azpurua
' Purpose   : Eventos de solicitud de formato del control de busqueda
'---------------------------------------------------------------------------------------
'
Private Sub ucItemVentaBox_GetQuery(sPreffix As String, sRetVal As String)
Dim stQuery As String, sAux As String

    stQuery = "SELECT I.Codigo, I.Descripcion, Precio" & Trim(Str(nPrecioStandard)) & " * (1 + (T.Porcentaje / 100)) as Precio FROM itemsVenta I, TiposImpuesto T "
    If left(sPreffix, 1) = "." Then
        sAux = right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE I.Descripcion LIKE '%" & sAux & "%'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
    ElseIf left(sPreffix, 1) = "!" Then
      If Mid(sPreffix, 2, 1) = "." Then
        sAux = right(sPreffix, Len(sPreffix) - 2)
        stQuery = stQuery & " WHERE I.Codigo LIKE '%" & sAux & "%'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
      Else
        sAux = right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE I.Codigo LIKE '" & sAux & "%'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Codigo"
      End If
    Else
        stQuery = stQuery & " WHERE I.Descripcion LIKE '" & sPreffix & "%'"
        stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
        stQuery = stQuery & " ORDER BY I.Descripcion"
    End If

    sRetVal = stQuery

End Sub

Private Sub ucItemVentaBox_RequestFormat(rs As Recordset, sRetVal As String)
Dim s As String, pItem As clsItemVenta, dExistencia As Double

    On Error GoTo ErrHandler

    Set pItem = AlmacenItemsVenta.ItemVenta(GetStringFromVariant(rs!Codigo))
    dExistencia = pItem.ExistenciaGeneral
    If dExistencia < 0 Or dExistencia = HIGH_VALUE Then
        dExistencia = 0
    End If
    Set pItem = Nothing

    s = stFullLength(GetStringFromVariant(rs!Descripcion), 40)
    s = s & FormatNumero(GetNumeroFromVariant(rs!Precio), Empresa.MascaraPrecios, 12) & " "
    s = s & FormatNumero(dExistencia, Empresa.MascaraCantidades, 10)
    s = s & " (" & GetStringFromVariant(rs!Codigo) & ")"

    sRetVal = s
    Exit Sub

ErrHandler:
    Err.Clear

End Sub

'---------------------------------------------------------------------------------------
' Property Enabled
' DateTime  : 23/04/2004 13:31
' Author    : Leonardo Azpurua
' Purpose   : Activa/Desactiva los controles internos del UC
'---------------------------------------------------------------------------------------
'
Public Property Get Enabled() As Boolean
  Enabled = txCodigo.Enabled
End Property

Public Property Let Enabled(newEnabled As Boolean)
Dim pControl As Control
  For Each pControl In UserControl.Controls
    On Error Resume Next
    pControl.Enabled = newEnabled
    If Err.Number Then Err.Clear
  Next
End Property

'---------------------------------------------------------------------------------------
' Procedure : GetPeso
' DateTime  : 23/04/2004 12:54
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function GetPeso(psCodigoItem As String)
Dim pBalanza As Object, Peso As Double, pFactoria As CFactoria

  On Error GoTo ErrHandler

  Set pBalanza = CreateObject("IBalanza.CBalanza")
  Set pFactoria = New CFactoria
  Set pBalanza.Factoria = pFactoria
  Peso = pBalanza.GetPeso
  psCodigoItem = pBalanza.CodigoProducto
  Set pBalanza = Nothing
  
  GetPeso = Peso
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "frmPOS::GetPeso"
  Err.Clear
  GetPeso = 0

End Function

'---------------------------------------------------------------------------------------
' Procedure : SelectItemVarios
' DateTime  : 23/04/2004 12:49
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function SelectItemVarios() As clsItemVenta
Dim rs As Recordset, frmMenu As lfPopupMenu
Dim Codigos() As String
Dim stCodigoProducto As String

  Set rs = dbHandle.Execute("SELECT Codigo, Descripcion FROM ItemsVenta WHERE Codigo LIKE '0__'")
  If Not rs.EOF Then
    ReDim Codigos(0)
    Set frmMenu = New lfPopupMenu
    Do While Not rs.EOF
      frmMenu.AddOption GetStringFromVariant(rs.Fields("Descripcion")), True
      ReDim Preserve Codigos(UBound(Codigos) + 1)
      Codigos(UBound(Codigos)) = GetStringFromVariant(rs.Fields("Codigo"))
      rs.MoveNext
    Loop
    rs.Close
    Centrar frmMenu
    frmMenu.Show vbModal
    If frmMenu.mnuResult Then
      stCodigoProducto = Codigos(frmMenu.mnuResult)
      If Not Item.Load(stCodigoProducto) Then
        Item.Codigo = ""
      End If
    Else
      Item.Codigo = ""
    End If
    Unload frmMenu
    Set frmMenu = Nothing
  End If
  Set rs = Nothing
  
  Set SelectItemVarios = IIf(Item.Codigo <> "", Item, Nothing)

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdReadCuenta
' DateTime  : 23/04/2004 12:52
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdReadCuenta() As Boolean
Dim stc2 As String, retVal As Boolean, stInput As String

  retVal = False
  stInput = Trim(txCodigo.Text)
  If left(stInput, 1) = "/" Or left(stInput, 1) = "-" Then
    stc2 = right(stInput, Len(stInput) - 1)
    RaiseEvent CargarCuenta(stc2)
    retVal = True
    ResetControl
  End If
  isCmdReadCuenta = retVal
End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdDelete
' DateTime  : 23/04/2004 13:25
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdDelete() As Boolean
Dim iRetVal As Integer

  If txCodigo.Text <> "-" Then
    isCmdDelete = 0
    Exit Function
  End If

  RaiseEvent RequestDelete
  ResetControl
  isCmdDelete = True

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdReadScale
' DateTime  : 23/04/2004 13:36
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdReadScale() As Boolean
Dim dblPeso As Double, pItemVenta As clsItemVenta
Dim sCodigo As String, retVal As Boolean

  If txCodigo.Text <> "." Then
    isCmdReadScale = False
    Exit Function
  End If

  dblPeso = GetPeso(sCodigo)
  If dblPeso > 0 Then
    If sCodigo <> "" Then
      Set pItemVenta = AlmacenItemsVenta.ItemVenta(sCodigo)
    Else
      Set pItemVenta = SelectItemVarios
    End If

    If pItemVenta Is Nothing Then
      mAdvertencia "Producto invlido"
      retVal = False
    Else
      Item.Load pItemVenta.Codigo
      txCodigo.Text = Item.Codigo
      chkMayor.Value = vbUnchecked
      numCantidad.Value = dblPeso
      numPrecio.Value = Item.PrecioConIVA(1)
      FactorCantidad = 1
      retVal = True
    End If
  Else
    retVal = False
  End If

  RaiseEvent AgregarLinea(pItemVenta.Codigo, numCantidad.Value, Item.Precio(1), pItemVenta)
  UltimoPrecio = Item.PrecioNeto(1)
  ResetControl

  isCmdReadScale = retVal

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdAddLast
' DateTime  : 23/04/2004 13:43
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdAddLast() As Boolean

  If txCodigo.Text <> "+" Then
    isCmdAddLast = False
    Exit Function
  End If
  
  If Item.Codigo = "" Then
    isCmdAddLast = False
    Exit Function
  End If

  If Not Item.Refresh Then
    mAdvertencia "Acaba de desaparecer el producto"
    isCmdAddLast = False
  End If
  
  If FactorCantidad > 1 Then
    UltimoPrecio = Item.PrecioNeto(2)
    numPrecio.Value = Item.PrecioConIVA(2)
  Else
    UltimoPrecio = Item.PrecioNeto(1)
    numPrecio.Value = Item.PrecioConIVA(1)
  End If
  
  RaiseEvent AgregarLinea(Item.Codigo, FactorCantidad, UltimoPrecio, Item)
  ResetControl
  
  isCmdAddLast = True

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdAddGenericos
' DateTime  : 23/04/2004 13:46
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdAddGenericos() As Boolean
Dim stc2 As String, pItemVenta As clsItemVenta
Dim stInput As String, vmPrecio As Currency

  stInput = UCase(Trim(txCodigo.Text))

  If left(stInput, 1) <> "+" Then
    isCmdAddGenericos = False
    Exit Function
  End If
  
  stc2 = right(stInput, Len(stInput) - 1)
  If Not NumeroValido(stc2) Then
    isCmdAddGenericos = False
    Exit Function
  End If

  vmPrecio = Val(stc2)

  If vmPrecio > 500000 Then
    If Not Confirmar("Es correcto el precio", True) Then
      isCmdAddGenericos = False
      Exit Function
    End If
  End If

  Set pItemVenta = SelectItemVarios
  If Not pItemVenta Is Nothing Then   ' Determinar cantidad a partir de precio...
                                      ' Se supone que el monto indicado incluye el IVA
    If Not CargarIVAGenericos Then
      vmPrecio = vmPrecio / (1# + pItemVenta.PorcentajeImpuesto(1) / 100)
    End If
    RaiseEvent AgregarLinea(pItemVenta.Codigo, 1, vmPrecio, pItemVenta)
    UltimoPrecio = vmPrecio
    FactorCantidad = 1
    ResetControl
    isCmdAddGenericos = True
    Exit Function
  Else
    mAdvertencia "Debe definir los cdigos de los productos genricos"
  End If

  isCmdAddGenericos = False

End Function

'---------------------------------------------------------------------------------------
' Procedure : isCmdMultiply
' DateTime  : 23/04/2004 15:27
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function isCmdMultiply() As Integer
Dim stc2 As String, stInput As String

  stInput = txCodigo.Text
  
  If left(stInput, 1) <> "*" Then
    isCmdMultiply = False
    Exit Function
  End If
  
  If Item.Codigo = "" Then
    isCmdMultiply = False
    Exit Function
  End If

  stc2 = right(stInput, Len(stInput) - 1)
  If stc2 = "" Then
    isCmdMultiply = False
    Exit Function
  End If

  If Not NumeroValido(stc2) Then
    isCmdMultiply = False
    Exit Function
  End If
    
  numCantidad.Value = Val(stc2) - 1
  If numCantidad.Value = 0 Or numCantidad.Value = -1 Then
    isCmdMultiply = False
    Exit Function
  End If

  If numCantidad.Value > 24 Then
    If Not Confirmar("Seguro que son tantos", True) Then
      isCmdMultiply = False
      Exit Function
    End If
  End If
    
  RaiseEvent AgregarLinea(Item.Codigo, numCantidad.Value * FactorCantidad, UltimoPrecio, Item)
  
  ResetControl
  
  isCmdMultiply = True

End Function

'---------------------------------------------------------------------------------------
' Procedure : ParseInput
' DateTime  : 23/04/2004 15:44
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Function ParseInput() As Boolean
Dim stTranslate As String, stc2 As String
Dim nSelGenerico As Integer, i As Integer
Dim stInput As String, stCodigoProducto As String
Dim dblCantidad As Double

  stInput = UCase(Trim(txCodigo.Text))
  txCodigo.Text = stInput

  If isCmdDelete() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdReadScale() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdReadCuenta() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdAddLast() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdAddGenericos() Then
    ParseInput = False
    Exit Function
  End If
  
  If isCmdMultiply() Then
    ParseInput = False
    Exit Function
  End If

  If Not mParseInput.ParseInput(stInput, stCodigoProducto, dblCantidad) Then
    mAdvertencia "ARTICULO " & stCodigoProducto & " NO LOCALIZADO..."
    Exit Function
  End If
  
  If Not Item.Load(stCodigoProducto) Then
    ParseInput = False
    Exit Function
  End If

  txCodigo.Text = stCodigoProducto
  numPrecio.Value = Item.PrecioConIVA(1)
  UltimoPrecio = Item.PrecioNeto(1)
  numCantidad.Value = dblCantidad
'  numPrecio.Value = numPrecio.Value * dblCantidad
  lblDescripcion.Caption = Item.Descripcion
  FactorCantidad = 1
  chkMayor.Value = vbUnchecked
  chkMayor.Caption = Item.Presentacion
  ParseInput = True

End Function

'---------------------------------------------------------------------------------------
' Eventos de construccion / destruccion del control
' DateTime  : 23/04/2004 17:01
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Sub UserControl_Initialize()
  Set Item = New clsItemVenta
  Set ucItemVentaBox.dbHandle = dbHandle
  If Not Empresa Is Nothing Then numDescuento.Formato = Empresa.MascaraCantidades
  CargarIVAGenericos = CBool(Val(GetSetting("ClearLight", "General", "CargarIVAGenericos", "0")))
End Sub

Private Sub UserControl_Show()
  If Not Empresa Is Nothing Then numCantidad.Formato = Empresa.MascaraCantidades
End Sub

Private Sub UserControl_Terminate()
  Set Item = Nothing
End Sub

'---------------------------------------------------------------------------------------
' Codigo para los eventos de los controles
' DateTime  : 23/04/2004 16:58
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Private Sub txCodigo_KeyDown(KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case vbKeyF2
      txCodigo.Text = ucItemVentaBox.Buscar
    Case vbKeyEnd
      If txCodigo.Text = "" Then
        RaiseEvent RequestCierre
        Exit Sub
      End If
      If ParseInput Then
        RaiseEvent AgregarLinea(txCodigo.Text, numCantidad.Value * FactorCantidad, UltimoPrecio, Item)
        ResetControl
      End If
    Case vbKeyReturn
      If txCodigo.Text = "" Then
        DoEvents
        RaiseEvent RequestCierre
        Exit Sub
      End If
      If ParseInput Then
'        RaiseEvent AgregarLinea(txCodigo.Text, numCantidad.Value * FactorCantidad, UltimoPrecio, item)
        UserControl.chkMayor.SetFocus
        Exit Sub
      End If
  End Select
End Sub

Private Sub txCodigo_KeyPress(KeyAscii As Integer)
  Dim sCodigo As String
  
  If KeyAscii = 13 Then KeyAscii = 0
  If txCodigo.Text = "" Then
    If UCase(Chr(KeyAscii)) >= "A" And UCase(Chr(KeyAscii)) <= "Z" Then
      sCodigo = mHotKey.ParseHotKey(UCase(Chr(KeyAscii)))
      If sCodigo <> "" Then
        txCodigo.Text = sCodigo
        KeyAscii = 0
      End If
    End If
  End If

End Sub

Private Sub chkMayor_Click()
  If chkMayor.Value = vbChecked Then
    FactorCantidad = Item.CantidadPresentacion
    UltimoPrecio = Item.PrecioNeto(2)
    numPrecio.Value = Item.PrecioConIVA(2) * FactorCantidad
  Else
    FactorCantidad = 1
    UltimoPrecio = Item.PrecioNeto(1)
    numPrecio.Value = Item.PrecioConIVA(1) * FactorCantidad
  End If
End Sub

Private Sub chkMayor_KeyDown(KeyCode As Integer, Shift As Integer)
  If KeyCode = vbKeyEnd Then
    RaiseEvent AgregarLinea(txCodigo.Text, numCantidad.Value * FactorCantidad, UltimoPrecio, Item)
    ResetControl
  End If

  If KeyCode = vbKeyReturn Then
    numCantidad.SetFocus
  End If
End Sub

Private Sub numCantidad_KeyDown(KeyCode As Integer, Shift As Integer)
  If KeyCode = vbKeyEnd Or KeyCode = vbKeyReturn Then
    RaiseEvent AgregarLinea(txCodigo.Text, numCantidad.Value * FactorCantidad, UltimoPrecio, Item)
    ResetControl
  End If
End Sub


