VERSION 5.00
Object = "{F93FDE78-A4B4-11D7-9BCE-00C026A196EC}#1.1#0"; "ADObox.ocx"
Begin VB.UserControl ucItemVentaBox 
   ClientHeight    =   315
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2355
   ScaleHeight     =   315
   ScaleWidth      =   2355
   Begin codeBoxA.ucCodeBox ucCodeBox1 
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   2355
      _ExtentX        =   4154
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "ItemsVenta"
      NombreDescripcion=   "Descripcion"
      Titulo          =   "Productos y Servicios"
   End
End
Attribute VB_Name = "ucItemVentaBox"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'Eventos
Event KeyDown(KeyCode As Integer, Shift As Integer)
Event Change() 'MappingInfo=ucCodeBox1,ucCodeBox1,-1,Change
'Property Variables:
Dim m_ParentForm As Form ' , m_Cantidad As Double, m_Precio As Double
Dim dblQty As Double

Public Validando As Boolean

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=ucCodeBox1,ucCodeBox1,-1,Font
Public Property Get Font() As Font
  Set Font = ucCodeBox1.Font
End Property

Public Property Set Font(ByVal New_Font As Font)
  Set ucCodeBox1.Font = New_Font
  PropertyChanged "Font"
End Property

Public Property Get CodeBox() As ucCodeBox
  Set CodeBox = UserControl.ucCodeBox1
End Property

Public Function Cantidad() As Double
    Cantidad = dblQty
End Function

Private Function ParseInput(istrInput As String, ostrCodigoProducto As String, odblCantidad As Double) As Boolean
    ParseInput = mParseInput.ParseInput(istrInput, ostrCodigoProducto, odblCantidad)
End Function

Public Function Validar() As Boolean
Dim cInstance As clsItemVenta, retVal As Boolean
Dim stCodigo As String
    
    If Text = "" Then
        Validar = True
        Exit Function
    End If
    
    Validando = True
    stCodigo = CheckForWildcards(ucCodeBox1.Text, ucCodeBox1.NombreTabla, ucCodeBox1.NombreCodigo)
    ucCodeBox1.Text = stCodigo
    
    ParseInput Text, stCodigo, dblQty
    
    Set cInstance = New clsItemVenta
    retVal = cInstance.ValidarCodigo(stCodigo)
    Set cInstance = Nothing
    Validando = False
    Validar = retVal
End Function

Public Function instance() As clsItemVenta
Dim cInstance As clsItemVenta, Result As Boolean
Dim stCodigo As String
    ParseInput Text, stCodigo, dblQty
    Set cInstance = New clsItemVenta
    Result = cInstance.Load(stCodigo)
    If Not Result Then Set cInstance = Nothing
    Set instance = cInstance
End Function

Private Sub ucCodeBox1_GetQuery(sPreffix As String, sRetVal As String)
Dim stQuery As String, sAux As String

  If nPrecioStandard = 0 Then
    mParseInput.LoadPrecioStandard
  End If

  sAux = sPreffix
  stQuery = "SELECT I.Codigo, I.Descripcion, Precio" & Trim(Str(nPrecioStandard)) & " * (1 + (T.Porcentaje / 100)) as Precio FROM itemsVenta I, TiposImpuesto T "
  If left(sAux, 1) = "." Then
    sAux = right(sAux, Len(sAux) - 1)
    stQuery = stQuery & " WHERE I.Descripcion LIKE '%" & sAux & "%'"
    stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
    stQuery = stQuery & " ORDER BY I.Codigo"
  ElseIf left(sAux, 1) = "!" Then
    If Mid(sAux, 2, 1) = "." Then
      sAux = right(sAux, Len(sAux) - 2)
      stQuery = stQuery & " WHERE I.Codigo LIKE '%" & sAux & "%'"
      stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
      stQuery = stQuery & " ORDER BY I.Codigo"
    Else
      sAux = right(sAux, Len(sAux) - 1)
      stQuery = stQuery & " WHERE I.Codigo LIKE '" & sAux & "%'"
      stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
      stQuery = stQuery & " ORDER BY I.Codigo"
    End If
  Else
    stQuery = stQuery & " WHERE I.Descripcion LIKE '" & sAux & "%'"
    stQuery = stQuery & " AND T.Codigo = I.TipoImpuesto1 "
    stQuery = stQuery & " ORDER BY I.Descripcion"
  End If

  sRetVal = stQuery

End Sub

Private Sub ucCodeBox1_KeyPress(KeyAscii As Integer)
Dim sTranslate As String

  If ucCodeBox1.Text = "" Then
    sTranslate = UCase(Chr(KeyAscii))
    If sTranslate >= "A" And sTranslate <= "Z" Then
      sTranslate = ParseHotKey(sTranslate)
      If sTranslate <> "" Then
        ucCodeBox1.Text = sTranslate
        ucCodeBox1.SelStart = Len(ucCodeBox1.Text)
        KeyAscii = 0
        Exit Sub
      End If
    End If
  End If

End Sub

Private Sub ucCodeBox1_RequestFormat(rs As ADODB.Recordset, sRetVal As String)
Dim s As String, pItem As clsItemVenta, dExistencia As Double

  On Error GoTo ErrHandler

  Set pItem = AlmacenItemsVenta.ItemVenta(GetStringFromVariant(rs!Codigo))
  dExistencia = pItem.ExistenciaGeneral
  If dExistencia < 0 Or dExistencia = HIGH_VALUE Then
    dExistencia = 0
  End If
  Set pItem = Nothing
  
  s = stFullLength(GetStringFromVariant(rs!Descripcion), 40)
  s = s & FormatNumero(GetNumeroFromVariant(rs!Precio), Empresa.MascaraPrecios, 12) & " "
  s = s & FormatNumero(dExistencia, Empresa.MascaraCantidades, 10)
  s = s & " (" & GetStringFromVariant(rs!Codigo) & ")"

  sRetVal = s
  Exit Sub

ErrHandler:
  sRetVal = ""
  Err.Clear

End Sub

Private Sub ucCodeBox1_GotFocus()
'    If Not AlmacenItemsVenta Is Nothing Then
'        AlmacenItemsVenta.Abrir
'    End If
End Sub

Private Sub ucCodeBox1_KeyDown(KeyCode As Integer, Shift As Integer)
  If KeyCode = vbKeyF3 And Shift = 4 Then
    Dim s As String, buscador As New clsBuscaProducto
    s = buscador.BuscarAtributo(New clsItemVenta, dbHandle)
    If s <> "" Then
      ucCodeBox1.Text = s
    End If
    Exit Sub
  End If
  RaiseEvent KeyDown(KeyCode, Shift)
End Sub

Public Function CodigoProducto() As String
Dim sCodigo As String, dblCantidad As Double
    If ParseInput(Text, sCodigo, dblCantidad) Then
        CodigoProducto = sCodigo
    Else
        CodigoProducto = Text
    End If
End Function

Public Function GetCantidad() As Double
Dim sCodigo As String, dblCantidad As Double

    If ParseInput(Text, sCodigo, dblCantidad) Then
        GetCantidad = dblCantidad
    Else
        GetCantidad = 1
    End If

End Function


Private Sub ucCodeBox1_LostFocus()
Dim instance As clsItemVenta, stCopia As String, stTranslate As String

    If Validando Then Exit Sub
    On Error GoTo 0
    If Ambient.DisplayName = ParentForm.ActiveControl.Name Then Exit Sub
    If Not ParentForm.Enabled Then Exit Sub
    If Not ParentForm.Visible Then Exit Sub
    If Not Me.Enabled Then Exit Sub
    If ParentForm.ActiveControl.Name = "cbCancelar" Then Exit Sub
    stCopia = Trim(Format(ucCodeBox1.Text, ">"))
    ucCodeBox1.Text = stCopia
    If ucCodeBox1.Text = "" Then Exit Sub
    
    Validando = True
    stCopia = CheckForWildcards(stCopia, ucCodeBox1.NombreTabla, ucCodeBox1.NombreCodigo)
    ucCodeBox1.Text = stCopia

    ParseInput stCopia, stTranslate, dblQty
    
    Set instance = New clsItemVenta
    If instance.Load(stTranslate) Then
        Validando = False
        Exit Sub
    End If

    instance.ValidarCodigo stTranslate
    If ucCodeBox1.Visible And ucCodeBox1.Enabled Then ucCodeBox1.SetFocus
    Set instance = Nothing
    Validando = False
End Sub

Public Property Let Text(s As String)
    ucCodeBox1.Text = s
End Property

Public Property Get Text() As String
    On Error GoTo ErrHandler
    Text = AlmacenAlternos.Translate(ucCodeBox1.Text)
    Exit Property
ErrHandler:
    Text = ucCodeBox1.Text
    Resume Next
End Property

Public Property Get Enabled() As Boolean
    Enabled = ucCodeBox1.Enabled
End Property

Public Property Let Enabled(v As Boolean)
    ucCodeBox1.Enabled = v
End Property

Public Property Get SelStart() As Integer
    SelStart = ucCodeBox1.SelStart
End Property

Public Property Let SelStart(arg As Integer)
    ucCodeBox1.SelStart = arg
End Property

Public Property Get SelLength() As Integer
    SelLength = ucCodeBox1.SelLength
End Property

Public Property Let SelLength(arg As Integer)
    ucCodeBox1.SelLength = arg
End Property

Public Property Get ParentForm() As Form
    Set ParentForm = m_ParentForm
End Property

Public Property Set ParentForm(ByVal fParentForm As Form)
    Set m_ParentForm = fParentForm
End Property

Private Sub UserControl_Initialize()
    If Not dbHandle Is Nothing Then Set ucCodeBox1.dbHandle = dbHandle
End Sub

Public Function Linea() As String
Dim cInstance As clsItemVenta
    Set cInstance = instance
    Linea = cInstance.Linea
    Set cInstance = Nothing
End Function

Public Function Descripcion() As String
Dim cInstance As clsItemVenta
    Set cInstance = instance
    If cInstance Is Nothing Then
        Descripcion = ""
    Else
        Descripcion = cInstance.Descripcion
        Set cInstance = Nothing
    End If
End Function
        
Public Function Precio(index As Integer) As Currency
Dim cInstance As clsItemVenta, retVal As Currency
    Set cInstance = instance
    If cInstance Is Nothing Then
        retVal = 0@
    Else
        retVal = cInstance.PrecioNeto(index)
        Set cInstance = Nothing
    End If
    Precio = retVal
End Function

Public Function TipoImpuesto(index As Integer) As String
Dim cInstance As clsItemVenta, retVal As String
    Set cInstance = instance
    If cInstance Is Nothing Then
        retVal = ""
    Else
        retVal = cInstance.TipoImpuesto(index)
        Set cInstance = Nothing
    End If
    TipoImpuesto = retVal
End Function

Public Function Presentacion() As String
Dim cInstance As clsItemVenta
    Set cInstance = instance
    If cInstance Is Nothing Then
        Presentacion = ""
    Else
        Presentacion = cInstance.Presentacion
        Set cInstance = Nothing
    End If
End Function

Public Function CantidadPresentacion() As Double
Dim cInstance As clsItemVenta
    
    Set cInstance = instance
    If cInstance Is Nothing Then
        CantidadPresentacion = 0#
    Else
        CantidadPresentacion = cInstance.CantidadPresentacion
        Set cInstance = Nothing
    End If

End Function

Private Sub ucCodeBox1_Change()
  RaiseEvent Change
End Sub

Private Sub ucCodeBox1_DblClick()
Dim pInstance As clsItemVenta
    Set pInstance = Me.instance
    If Not pInstance Is Nothing Then pInstance.Show
    Set pInstance = Nothing
End Sub

Public Function Buscar() As String
    Buscar = ucCodeBox1.Buscar
End Function

Public Function PrecioPresentacion(index As Integer, iPresentacion As String) As Currency
Dim cInstance As clsItemVenta
    Set cInstance = instance
    If cInstance Is Nothing Then
        PrecioPresentacion = 0#
    Else
        PrecioPresentacion = cInstance.PrecioPresentacion(index, iPresentacion)
        Set cInstance = Nothing
    End If
End Function

Public Sub FillComboPresentacion(cbx As ComboBox)
Dim cInstance As clsItemVenta
    Set cInstance = instance
    If cInstance Is Nothing Then
        cbx.Clear
    Else
        cInstance.FillComboPresentacion cbx
        Set cInstance = Nothing
    End If
End Sub

Public Function ValidarPresentacion(starg As String) As Boolean
Dim cInstance As clsItemVenta
    Set cInstance = instance
    If cInstance Is Nothing Then
        ValidarPresentacion = True
    Else
        ValidarPresentacion = cInstance.ValidarPresentacion(starg)
        Set cInstance = Nothing
    End If
End Function

Public Function CheckDisponibilidad(ByVal Cantidad As Double, Almacen As String, interactivo As Boolean) As Boolean
Dim cInstance As clsItemVenta
    Set cInstance = instance
    If cInstance Is Nothing Then
        CheckDisponibilidad = True
    Else
        CheckDisponibilidad = cInstance.CheckDisponibilidad(Cantidad, Almacen, interactivo)
        Set cInstance = Nothing
    End If
End Function

Public Function FactorPresentacion(stUnidad As String) As Double
Dim cInstance As clsItemVenta
    Set cInstance = instance
    If cInstance Is Nothing Then
        FactorPresentacion = 1#
    Else
        FactorPresentacion = cInstance.FactorPresentacion(stUnidad)
        Set cInstance = Nothing
    End If
End Function

Private Sub UserControl_Resize()
'    If UserControl.Height <> 315 Then
'        UserControl.Height = 315
'    End If
    ucCodeBox1.Width = UserControl.Width
    ucCodeBox1.Height = UserControl.Height
End Sub
