VERSION 5.00
Object = "{F93FDE78-A4B4-11D7-9BCE-00C026A196EC}#1.1#0"; "ADObox.ocx"
Begin VB.UserControl ucItemInventarioBox 
   ClientHeight    =   315
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2355
   ScaleHeight     =   315
   ScaleWidth      =   2355
   Begin codeBoxA.ucCodeBox ucCodeBox1 
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   2355
      _ExtentX        =   4154
      _ExtentY        =   556
      NombreCodigo    =   "Codigo"
      NombreTabla     =   "ItemsVenta"
      NombreDescripcion=   "Descripcion"
      Titulo          =   "Productos y Servicios"
   End
End
Attribute VB_Name = "ucItemInventarioBox"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Event KeyDown(KeyCode As Integer, Shift As Integer)
'Property Variables:
Dim m_ParentForm As Form
Public Validando As Boolean
Private sProveedor As String

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=ucCodeBox1,ucCodeBox1,-1,Font
Public Property Get Font() As Font
  Set Font = ucCodeBox1.Font
End Property

Public Property Set Font(ByVal New_Font As Font)
  Set ucCodeBox1.Font = New_Font
  PropertyChanged "Font"
End Property

Public Property Get CodeBox() As ucCodeBox
  Set CodeBox = UserControl.ucCodeBox1
End Property

Public Sub SetProveedor(sCodProv As String)
  sProveedor = sCodProv
End Sub

Public Function RefProveedor() As String
Dim pAlmacenCotsPP As clsAlmacenCotsPP
Dim sRetVal As String

    If sProveedor = "" Then
        RefProveedor = ""
        Exit Function
    End If
    
    Set pAlmacenCotsPP = New clsAlmacenCotsPP
    sRetVal = pAlmacenCotsPP.Codigo2RefProv(sProveedor, UCase(Trim(ucCodeBox1.Text)))
    Set pAlmacenCotsPP = Nothing
    
    RefProveedor = sRetVal
End Function

Public Function Validar() As Boolean
Dim cInstance As clsItemInventario, RetVal As Boolean
Dim stCopia As String, stTranslate As String


    If Text = "" Then
        Validar = True
        Exit Function
    End If
    
    Validando = True
    stCopia = Trim(Format(ucCodeBox1.Text, ">"))
    ucCodeBox1.Text = stCopia
    stCopia = CheckForWildcards(stCopia, ucCodeBox1.NombreTabla, ucCodeBox1.NombreCodigo)
    
    stTranslate = AlmacenAlternos.Translate(stCopia)
    ucCodeBox1.Text = stTranslate
    
    Set cInstance = New clsItemInventario
    RetVal = cInstance.ValidarCodigo(Me.Text)
    Set cInstance = Nothing
    Validar = RetVal
    Validando = False

End Function

Public Function instance() As clsItemInventario
Dim cInstance As clsItemInventario, Result As Boolean
    Set cInstance = New clsItemInventario
    Result = cInstance.Load(AlmacenAlternos.Translate(ucCodeBox1.Text))
    If Not Result Then Set cInstance = Nothing
    Set instance = cInstance
End Function

Private Sub ucCodeBox1_DblClick()
Dim pInstance As clsItemInventario

    Set pInstance = Me.instance
    If Not pInstance Is Nothing Then pInstance.Show
    Set pInstance = Nothing

End Sub

Private Sub ucCodeBox1_RequestFormat(rs As ADODB.Recordset, sRetVal As String)
Dim lsRetVal As String

    lsRetVal = stFullLength(GetStringFromVariant(rs!Descripcion), 40) & " " & FormatNumero(GetNumeroFromVariant(rs!Existencia), Empresa.MascaraCantidades, 12) & " (" & GetStringFromVariant(rs!Codigo) & ")"
    sRetVal = lsRetVal

End Sub

Private Sub ucCodeBox1_GetQuery(sPreffix As String, sRetVal As String)
Dim stQuery As String, sAux As String

    stQuery = "SELECT Codigo, Descripcion, Existencia FROM itemsInventario "
    If left(sPreffix, 1) = "." Then
        sAux = right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE Descripcion LIKE '" & "%" & sAux & "%'"
        stQuery = stQuery & " ORDER BY Codigo"
    ElseIf left(sPreffix, 1) = "!" Then
      If Mid(sAux, 2, 1) = "." Then
        sAux = right(sPreffix, Len(sPreffix) - 2)
        stQuery = stQuery & " WHERE Codigo LIKE '%" & sAux & "%'"
        stQuery = stQuery & " ORDER BY Codigo"
      Else
        sAux = right(sPreffix, Len(sPreffix) - 1)
        stQuery = stQuery & " WHERE Codigo LIKE '" & sAux & "%'"
        stQuery = stQuery & " ORDER BY Codigo"
      End If
    Else
        stQuery = stQuery & " WHERE Descripcion LIKE '" & sPreffix & "%'"
        stQuery = stQuery & " ORDER BY Descripcion"
    End If

    sRetVal = stQuery

End Sub

Public Function Buscar() As String

    Buscar = ucCodeBox1.Buscar

End Function

Private Sub ucCodeBox1_KeyDown(KeyCode As Integer, Shift As Integer)
    
    RaiseEvent KeyDown(KeyCode, Shift)

End Sub

Private Sub ucCodeBox1_LostFocus()
Dim instance As clsItemInventario, stCopia As String
Dim stTranslate As String, nActiveWindow As Long

    If Validando Then Exit Sub
    On Error GoTo 0
    stCopia = Trim(Format(ucCodeBox1.Text, ">"))
    ucCodeBox1.Text = stCopia
    If Ambient.DisplayName = ParentForm.ActiveControl.Name Then Exit Sub
    If Not ParentForm.Enabled Then Exit Sub
    If Not ParentForm.Visible Then Exit Sub
    If Not Me.Enabled Then Exit Sub
    If ParentForm.ActiveControl.Name = "cbCancelar" Then Exit Sub
    If ucCodeBox1.Text = "" Then Exit Sub
  
    Validando = True
    
    stCopia = CheckForWildcards(stCopia, ucCodeBox1.NombreTabla, ucCodeBox1.NombreCodigo)
    ucCodeBox1.Text = stCopia
    stTranslate = AlmacenAlternos.Translate(stCopia)
    If stTranslate <> "" Then
        stCopia = stTranslate
        ucCodeBox1.Text = stTranslate
    End If
    
    If sProveedor <> "" Then
    Dim pAlmCots As clsAlmacenCotsPP
        Set pAlmCots = New clsAlmacenCotsPP
        stCopia = pAlmCots.RefProv2Codigo(sProveedor, stCopia)
        Set pAlmCots = Nothing
    End If
    
    ucCodeBox1.Text = stCopia
    
    Set instance = New clsItemInventario
    If instance.Load(stCopia) Then
        Validando = False
        Exit Sub
    End If

    instance.ValidarCodigo stCopia
    If ucCodeBox1.Visible And ucCodeBox1.Enabled Then ucCodeBox1.SetFocus
    Set instance = Nothing
    Validando = False

End Sub

Public Property Let Text(s As String)
    ucCodeBox1.Text = s
End Property

Public Property Get Text() As String
    On Error GoTo ErrHandler
    
    Text = AlmacenAlternos.Translate(ucCodeBox1.Text)

    Exit Property

ErrHandler:

    Text = ucCodeBox1.Text
    Resume Next
End Property

Public Property Get Enabled() As Boolean
    Enabled = ucCodeBox1.Enabled
End Property

Public Property Let Enabled(v As Boolean)
    ucCodeBox1.Enabled = v
End Property

Public Property Get SelStart() As Integer
    SelStart = ucCodeBox1.SelStart
End Property

Public Property Let SelStart(arg As Integer)
    ucCodeBox1.SelStart = arg
End Property

Public Property Get SelLength() As Integer
    SelLength = ucCodeBox1.SelLength
End Property

Public Property Let SelLength(arg As Integer)
    ucCodeBox1.SelLength = arg
End Property

Public Property Get ParentForm() As Form
    Set ParentForm = m_ParentForm
End Property

Public Property Set ParentForm(ByVal fParentForm As Form)
    Set m_ParentForm = fParentForm
End Property

Private Sub UserControl_Initialize()
    If Not dbHandle Is Nothing Then Set ucCodeBox1.dbHandle = dbHandle
    ucCodeBox1.NombreTabla = "itemsInventario"
    ucCodeBox1.NombreCodigo = "Codigo"
    ucCodeBox1.NombreDescriptor = "Descripcion"
    ucCodeBox1.Titulo = "Items de Inventario"
    sProveedor = ""
End Sub

' Accesores...
Public Function Linea() As String
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        Linea = cInstance.Linea
    Else
        Linea = ""
    End If
    Set cInstance = Nothing
End Function

Public Function Descripcion() As String
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        Descripcion = ""
    Else
        Descripcion = cInstance.Descripcion
    End If
    Set cInstance = Nothing
End Function
        
Public Function CostoPromedio() As Double
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        CostoPromedio = 0#
    Else
        CostoPromedio = cInstance.CostoPromedio
    End If
    Set cInstance = Nothing
End Function

Public Function UltimoCosto() As Double
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        UltimoCosto = 0#
    Else
        UltimoCosto = cInstance.UltimoCosto
    End If
    Set cInstance = Nothing
End Function

Public Function TipoImpuesto(Index As Integer) As String
Dim cInstance As clsItemInventario, RetVal As String
    Set cInstance = instance
    If cInstance Is Nothing Then
        RetVal = ""
    Else
        RetVal = cInstance.TipoImpuesto(Index)
    End If
    Set cInstance = Nothing
    TipoImpuesto = RetVal
End Function

Public Function Existencia() As Double
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        Existencia = 0
    Else
        Existencia = cInstance.Existencia
    End If
    Set cInstance = Nothing
End Function

Public Function ExistenciaFisica() As Double
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        ExistenciaFisica = 0
    Else
        ExistenciaFisica = cInstance.ExistenciaFisica
    End If
    Set cInstance = Nothing
End Function

Public Function Disponibilidad() As Double
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        Disponibilidad = 0
    Else
        Disponibilidad = cInstance.Disponibilidad
    End If
    Set cInstance = Nothing
End Function

Public Function FechaUltimaCompra() As Date
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        FechaUltimaCompra = DateSerial(1980, 1, 1)
    Else
        FechaUltimaCompra = cInstance.FechaUltimaCompra
        Set cInstance = Nothing
    End If
End Function

Public Function UltimoProveedor() As String
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        UltimoProveedor = ""
    Else
        UltimoProveedor = cInstance.UltimoProveedor
        Set cInstance = Nothing
    End If
End Function

Public Function PrecioUltimaCompra() As Double
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        PrecioUltimaCompra = 0
    Else
        PrecioUltimaCompra = cInstance.PrecioUltimaCompra
        Set cInstance = Nothing
    End If
End Function

Public Function NombreEmpaque() As String
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        NombreEmpaque = ""
    Else
        NombreEmpaque = cInstance.NombreEmpaque
        Set cInstance = Nothing
    End If
End Function

Public Function CantidadEmpaque() As Double
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        CantidadEmpaque = 0
    Else
        CantidadEmpaque = cInstance.CantidadEmpaque
        Set cInstance = Nothing
    End If
End Function

Public Function ValidarPresentacion(stPresentacion As String) As Boolean
Dim cInstance As clsItemInventario
    Set cInstance = Me.instance
    If cInstance Is Nothing Then
        ValidarPresentacion = True
    Else
        ValidarPresentacion = cInstance.ValidarPresentacion(stPresentacion)
        Set cInstance = Nothing
    End If
End Function

Public Function CantidadPresentacion() As Double
Dim cInstance As clsItemInventario
    Set cInstance = Me.instance
    If cInstance Is Nothing Then
        CantidadPresentacion = 0
    Else
        CantidadPresentacion = cInstance.CantidadEmpaque
        Set cInstance = Nothing
    End If
End Function

Public Sub FillComboPresentacion(cbx As ComboBox)
Dim cInstance As clsItemInventario
    Set cInstance = instance
    If cInstance Is Nothing Then
        cbx.Clear
        cbx.Text = ""
        cbx.AddItem "<INVALIDO>"
    Else
        cInstance.FillCombo cbx
        Set cInstance = Nothing
    End If
End Sub

Private Sub UserControl_Resize()

'    If UserControl.Height <> 315 Then
'        UserControl.Height = 315
'    End If
    ucCodeBox1.Width = UserControl.Width
    ucCodeBox1.Height = UserControl.Height

End Sub


