VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Begin VB.UserControl ucEditorDocumentosFiscales 
   ClientHeight    =   2640
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   8445
   ScaleHeight     =   2640
   ScaleWidth      =   8445
   Begin VB.CheckBox chkRegistrarDocumento 
      Caption         =   "Registrar Documento Fiscal"
      Height          =   255
      Left            =   0
      TabIndex        =   0
      Top             =   60
      Width           =   2415
   End
   Begin VB.TextBox txReferencia 
      Height          =   315
      Left            =   1890
      TabIndex        =   5
      Top             =   540
      Width           =   1785
   End
   Begin VB.TextBox txFacturaRelacionada 
      Height          =   315
      Left            =   1890
      TabIndex        =   8
      Top             =   870
      Width           =   1785
   End
   Begin ucNumero.ucNumBox txControlFinal 
      Height          =   315
      Left            =   7200
      TabIndex        =   3
      Top             =   30
      Width           =   1185
      _ExtentX        =   2090
      _ExtentY        =   556
      Formato         =   "00000000"
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox txControlInicial 
      Height          =   315
      Left            =   6000
      TabIndex        =   2
      Top             =   30
      Width           =   1185
      _ExtentX        =   2090
      _ExtentY        =   556
      Formato         =   "00000000"
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox porcentajeIV1 
      Height          =   315
      Left            =   3690
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   1230
      Width           =   555
      _ExtentX        =   979
      _ExtentY        =   556
      Enabled         =   0   'False
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox montoGravable1 
      Height          =   315
      Left            =   1890
      TabIndex        =   11
      Top             =   1200
      Width           =   1785
      _ExtentX        =   3149
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox montoGravable2 
      Height          =   315
      Left            =   1890
      TabIndex        =   14
      Top             =   1530
      Width           =   1785
      _ExtentX        =   3149
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox porcentajeIV2 
      Height          =   315
      Left            =   3690
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   1560
      Width           =   555
      _ExtentX        =   979
      _ExtentY        =   556
      Enabled         =   0   'False
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin prjUcFramedLabel.ucFramedLabel lblVentasNetas 
      Height          =   315
      Left            =   1890
      Top             =   2250
      Width           =   1785
      _ExtentX        =   3149
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin ucNumero.ucNumBox montoExento 
      Height          =   315
      Left            =   1890
      TabIndex        =   18
      Top             =   1860
      Width           =   1785
      _ExtentX        =   3149
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox montoRetenido 
      Height          =   315
      Left            =   6630
      TabIndex        =   22
      Top             =   2250
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin prjUcFramedLabel.ucFramedLabel montoIVA1 
      Height          =   315
      Left            =   6630
      Top             =   660
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin prjUcFramedLabel.ucFramedLabel montoIVA2 
      Height          =   315
      Left            =   6630
      Top             =   1050
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin prjUcFramedLabel.ucFramedLabel totalIVA 
      Height          =   315
      Left            =   6630
      Top             =   1440
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin prjUcFramedLabel.ucFramedLabel totalBruto 
      Height          =   315
      Left            =   6630
      Top             =   1830
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
   End
   Begin VB.Label Label18 
      AutoSize        =   -1  'True
      Caption         =   "Monto del IVA a VG:"
      Height          =   195
      Left            =   4980
      TabIndex        =   6
      Top             =   750
      Width           =   1455
   End
   Begin VB.Label Label17 
      AutoSize        =   -1  'True
      Caption         =   "Monto del IVA a TP:"
      Height          =   195
      Left            =   4980
      TabIndex        =   9
      Top             =   1140
      Width           =   1440
   End
   Begin VB.Label Label16 
      AutoSize        =   -1  'True
      Caption         =   "Total IVA:"
      Height          =   195
      Left            =   4980
      TabIndex        =   15
      Top             =   1530
      Width           =   705
   End
   Begin VB.Label Label12 
      AutoSize        =   -1  'True
      Caption         =   "Total Bruto:"
      Height          =   195
      Left            =   4980
      TabIndex        =   19
      Top             =   1890
      Width           =   825
   End
   Begin VB.Label Label10 
      AutoSize        =   -1  'True
      Caption         =   "IVA Retenido:"
      Height          =   195
      Left            =   5010
      TabIndex        =   20
      Top             =   2280
      Width           =   990
   End
   Begin VB.Label Label15 
      AutoSize        =   -1  'True
      Caption         =   "Monto Exento:"
      Height          =   195
      Left            =   0
      TabIndex        =   17
      Top             =   1890
      Width           =   1035
   End
   Begin VB.Label Label14 
      AutoSize        =   -1  'True
      Caption         =   "Monto Gravable a VG:"
      Height          =   195
      Left            =   0
      TabIndex        =   10
      Top             =   1230
      Width           =   1590
   End
   Begin VB.Label Label9 
      AutoSize        =   -1  'True
      Caption         =   "Monto Gravable a TP:"
      Height          =   195
      Left            =   0
      TabIndex        =   13
      Top             =   1560
      Width           =   1575
   End
   Begin VB.Label Label13 
      AutoSize        =   -1  'True
      Caption         =   "Total Ventas Netas:"
      Height          =   195
      Left            =   0
      TabIndex        =   21
      Top             =   2310
      Width           =   1410
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Referencia:"
      Height          =   195
      Left            =   0
      TabIndex        =   4
      Top             =   570
      Width           =   825
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Numeros de control de/a:"
      Height          =   195
      Left            =   4110
      TabIndex        =   1
      Top             =   60
      Width           =   1815
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Factura Relacionada:"
      Height          =   195
      Left            =   0
      TabIndex        =   7
      Top             =   900
      Width           =   1530
   End
End
Attribute VB_Name = "ucEditorDocumentosFiscales"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Event UpdateStatusText(s As String)
Public Event PermitirInhibicionDocumento(ByRef isOk As Boolean)
Public Event Change(sourceControl As String)

Public pDocumentoFiscal As New CDocumentoFiscal

Private m_Requerido As Boolean
Private m_TipoDF As String, m_TipoEntidad As String, m_TipoDoc As String, m_CodigoEntidad As String
Private m_RifEntidad As String, m_NombreEntidad As String
Private ProximoNC As Long

Public Sub Reset()
  If ProximoNC > 0 Then
    ProximoNC = txControlFinal.value + 1
    SaveSetting "ClearLight", "General", "ProximoNC", Trim(Str(ProximoNC))
  End If
  If Not m_Requerido Then chkRegistrarDocumento.value = vbUnchecked: chkRegistrarDocumento.Enabled = True
  txControlInicial.Text = "": txControlFinal.Text = ""
  txReferencia.Text = ""
  txFacturaRelacionada.Text = ""
  montoGravable1.value = 0
  montoGravable2.value = 0
  montoExento.value = 0
  montoRetenido.value = 0
  txControlInicial.value = ProximoNC
  txControlFinal.value = ProximoNC
End Sub

' --------------------------------------------------------------------------------------
' Accesores:
' Gravable1, Gravable2, Exento, Retencion, IVA1, IVA2, TotalGeneral
' RIF, NombreEntidad
' --------------------------------------------------------------------------------------
Public Property Get Gravable1() As Currency
  Gravable1 = montoGravable1.value
End Property

Public Property Get Gravable2() As Currency
  Gravable2 = montoGravable2.value
End Property

Public Property Get Exento() As Currency
  Exento = montoExento.value
End Property

Public Property Get Retencion() As Currency
  Retencion = montoRetenido.value
End Property

Public Property Get IVA1()
  IVA1 = montoGravable1 * porcentajeIV1 / 100
End Property

Public Property Get IVA2()
  IVA2 = montoGravable2 * porcentajeIV2 / 100
End Property

Public Property Get TotalGeneral()
  TotalGeneral = Gravable1 + Gravable2 + Exento + IVA1 + IVA2
End Property

Public Property Let RIF(value As String)
  m_RifEntidad = value
End Property

Public Property Let Nombre(value As String)
  m_NombreEntidad = value
End Property

'---------------------------------------------------------------------------------------
' Procedure : IsDefined
' DateTime  : 15/09/2005 10:46
' Author    : Leonardo Azpurua
' Purpose   : Indica si "debe haber" un documento fiscal definido. Es decir, si el
'             control chkRegistrarDocumento esta tildado
'---------------------------------------------------------------------------------------
'
Public Property Get isDefined() As Boolean
  isDefined = (chkRegistrarDocumento.value = vbChecked)
End Property

Public Property Let isDefined(value As Boolean)
  chkRegistrarDocumento.value = IIf(value, vbChecked, vbUnchecked)
End Property

'---------------------------------------------------------------------------------------
' Procedure : SetData
' DateTime  : 11/09/2005 01:33
' Author    : Leonardo Azpurua
' Purpose   : Recibe del cliente los datos relativos al documento
'             TipoDF: Tipo de Documento Fiscal
'             TipoEntidad: Tipo de Entidad Relacionada
'             TipoDoc: Tipo de documento (ISDOC)
'             CodigoEntidad: Codigo de la entidad relacionada
'---------------------------------------------------------------------------------------
'
Public Sub SetData(TipoDF As String, TipoEntidad As String, TipoDoc As String, CodigoEntidad As String)
  m_TipoDF = TipoDF
  m_TipoEntidad = TipoEntidad
  m_TipoDoc = TipoDoc
  m_CodigoEntidad = CodigoEntidad
End Sub

' --------------------------------------------
' Version "minima" de la anterior. El Tipo de
' documento fiscal debe estar definido.
' --------------------------------------------
Public Sub SetTipoDF(TipoDF As String)
  m_TipoDF = TipoDF
End Sub

'---------------------------------------------------------------------------------------
' Procedure : Requerido
' DateTime  : 11/09/2005 01:14
' Author    : Leonardo Azpurua
' Purpose   : Indica si es obligatorio que el usuario suministre los datos del documento
'             fiscal.
'---------------------------------------------------------------------------------------
'
Public Property Let Requerido(value As Boolean)
  m_Requerido = value
  If value Then
    UserControl.chkRegistrarDocumento.value = vbChecked
    Disable chkRegistrarDocumento
  Else
    Enable chkRegistrarDocumento
  End If
End Property

Public Property Get Requerido() As Boolean
  Requerido = m_Requerido
End Property

'---------------------------------------------------------------------------------------
' Procedure : AllowEditValues (Property)
' DateTime  : 10/09/2005 21:45
' Author    : Leonardo Azpurua
' Purpose   : Determina si se permitir la edicin de los valores.
'---------------------------------------------------------------------------------------
'
Public Property Let AllowEditValues(bAllow As Boolean)
  With UserControl
  .montoExento.Enabled = bAllow: .montoExento.TabStop = bAllow
  .montoGravable1.Enabled = bAllow: .montoExento.TabStop = bAllow
  .montoGravable2.Enabled = bAllow: .montoGravable2.TabStop = bAllow
  End With
End Property

Public Property Get AllowEditValues() As Boolean
  AllowEditValues = montoExento.Enabled
End Property

'---------------------------------------------------------------------------------------
' Procedure : SetValores
' DateTime  : 10/09/2005 22:16
' Author    : Leonardo Azpurua
' Purpose   : Recibe los valores actuales del documento asociado
'---------------------------------------------------------------------------------------
'
Public Sub SetValores(Exento As Currency, Gravable1 As Currency, Gravable2 As Currency)
  montoExento.value = Exento
  montoGravable1.value = Gravable1
  montoGravable2.value = Gravable2
  ActualizarDisplay
End Sub

Public Sub SetPorcentajesImpuesto(IV1 As Double, IV2 As Double)
  porcentajeIV1.value = IV1
  porcentajeIV2.value = IV2
End Sub

'---------------------------------------------------------------------------------------
' Procedure : SetControlText
' DateTime  : 10/09/2005 23:52
' Author    : Leonardo Azpurua
' Purpose   : Establece el valor de un control de texto (desde afuera).
'             Los controles donde s <> "" son bloqueados
'---------------------------------------------------------------------------------------
'
Private Sub SetControlText(X As TextBox, s As String)
  X.Text = s
  If s <> "" Then
    Disable X
  Else
    Enable X
  End If
End Sub

'---------------------------------------------------------------------------------------
' Procedure : Referencia
' DateTime  : 10/09/2005 23:48
' Author    : Leonardo Azpurua
' Purpose   : Establece la referencia para el documento fiscal.
'             Si es diferente de "" no puede modificarse
'---------------------------------------------------------------------------------------
'
Public Property Let Referencia(sValue As String)
  SetControlText txReferencia, sValue
End Property

'---------------------------------------------------------------------------------------
' Procedure : FacturaRelacionada
' DateTime  : 10/09/2005 23:49
' Author    : Leonardo Azpurua
' Purpose   : Establece la factura relacionada. sValue <> "" -> Control.Locked
'---------------------------------------------------------------------------------------
'
Public Property Let FacturaRelacionada(sValue As String)
  SetControlText txFacturaRelacionada, sValue
End Property


'---------------------------------------------------------------------------------------
' Procedure : ValidarForma
' DateTime  : 10/09/2005 23:53
' Author    : Leonardo Azpurua
' Purpose   : Determina la validez de los argumentos.
'---------------------------------------------------------------------------------------
'
Public Function ValidarForma(Optional Warn As Boolean = True) As Boolean
  If UserControl.chkRegistrarDocumento.value = vbUnchecked Then
    ValidarForma = True
    Exit Function
  End If

  If txReferencia.Text = "" Then
    If Warn Then
      mAdvertencia "Debe suministrar una referencia"
      On Error Resume Next
      txReferencia.SetFocus
      If Err.Number Then Err.Clear
    End If
    ValidarForma = False
    Exit Function
  End If
  
  If txControlInicial.value = 0 Then
    If Warn Then
      mAdvertencia "Si no indica el numero de control, el documento no tiene valor fiscal"
      If Not Confirmar("Desea registrar el documento, a pesar de ello") Then
        On Error Resume Next
        txControlInicial.SetFocus
        If Err.Number Then Err.Clear
        ValidarForma = False
        Exit Function
      End If
    End If
  End If
  
  If txControlInicial.value > txControlFinal.value Then
    If Warn Then
      mAdvertencia "El numero de control inicial debe ser menor que el final"
      ValidarForma = False
      Exit Function
    End If
  End If

  ValidarForma = True
End Function

'---------------------------------------------------------------------------------------
' Procedure : DocumentoFiscal
' DateTime  : 11/09/2005 01:28
' Author    : Leonardo Azpurua
' Purpose   : Devuelve el documento fiscal, si fue definido, y si es valido.
'---------------------------------------------------------------------------------------
'
Public Function DocumentoFiscal(Optional Warn As Boolean = True) As CDocumentoFiscal
  If UserControl.chkRegistrarDocumento.value = vbUnchecked Then
    Set DocumentoFiscal = Nothing
  ElseIf Not ValidarForma(Warn) Then
    Set DocumentoFiscal = Nothing
  Else
    Set DocumentoFiscal = GetDocumentoFiscal
  End If
End Function

Private Sub SetHelpText(s As String)
  RaiseEvent UpdateStatusText(s)
End Sub

Public Sub ActualizarDisplay()
Attribute ActualizarDisplay.VB_Description = "Determina si el control acepta como valido un Documento Indefinido"
Dim Impuesto As Double
  
  Impuesto = montoGravable1.value * porcentajeIV1.value / 100
  montoIVA1.Caption = Format(Impuesto, Empresa.MascaraMonetarios)
  
  Impuesto = montoGravable2.value * porcentajeIV2.value / 100
  montoIVA2.Caption = Format(Impuesto, Empresa.MascaraMonetarios)
  
  Impuesto = montoGravable1.value + montoGravable2.value + montoExento.value
  lblVentasNetas.Caption = Format(Impuesto, Empresa.MascaraMonetarios)
  
  Impuesto = ValOf(montoIVA1.Caption) + ValOf(montoIVA2.Caption)
  totalIVA.Caption = Format(Impuesto, Empresa.MascaraMonetarios)
  
  Impuesto = ValOf(lblVentasNetas.Caption) + ValOf(totalIVA.Caption)
  totalBruto.Caption = Format(Impuesto, Empresa.MascaraMonetarios)
  
'  If Empresa.ContribuyenteEspecial And PorcentajeRetencionCE > 0 And montoGravable1 + montoGravable2 > Empresa.ValorActualUT * 20 Then
'    If montoRetenido.Enabled Then
'      montoRetenido.value = ValOf(totalIVA.Caption) / 100 * PorcentajeRetencionIVACE
'    End If
'  End If

End Sub

'---------------------------------------------------------------------------------------
' Procedure : GetDocumentoFiscal
' DateTime  : 10/09/2005 22:31
' Author    : Leonardo Azpurua
' Purpose   : Llena el documento fiscal con los datos del control
'---------------------------------------------------------------------------------------
'
Public Function GetDocumentoFiscal() As CDocumentoFiscal
Dim retVal As CDocumentoFiscal
Dim factor As Double

  If UserControl.chkRegistrarDocumento.value = vbUnchecked Then
    Set GetDocumentoFiscal = Nothing
    Exit Function
  End If

  If m_TipoEntidad = "" Then
    Err.Raise 10001 + vbObjectError, "EditorDocumentosFiscales", "Informacion de entidad no suministrada"
  End If
  
  Select Case m_TipoDF
  Case "FCT"
    factor = 1
  Case "NDB"
    factor = 1
  Case "NCR"
    factor = -1
  End Select

  Set retVal = New CDocumentoFiscal
  With retVal
    .Fecha = Date
    .TipoDoc = m_TipoDoc
    .NumeroDoc = 0
    .TipoDocFiscal = m_TipoDF
    .TipoEntidad = m_TipoEntidad
    .CodigoEntidad = m_CodigoEntidad
    .RifEntidad = m_RifEntidad
    .NombreEntidad = m_NombreEntidad
    .Referencia = txReferencia.Text
    .NumeroControlInicial = txControlInicial.value
    .NumeroControlFinal = txControlFinal.value
    .FacturaRelacionada = txFacturaRelacionada.Text
    .Exento = montoExento.value * factor
    .Gravable1 = montoGravable1.value * factor
    .Gravable2 = montoGravable2.value * factor
    .Tasa1 = porcentajeIV1.value
    .Tasa2 = porcentajeIV2.value
    If montoIVA1.Caption = "" Then montoIVA1.Caption = "0"
    If montoIVA2.Caption = "" Then montoIVA2.Caption = "0"
    
    .Impuesto1 = CCur(montoIVA1.Caption) * factor
    .Impuesto2 = CCur(montoIVA2.Caption) * factor
    .Retencion = UserControl.montoRetenido.value * (-factor)
  End With
  Set GetDocumentoFiscal = retVal
End Function

'---------------------------------------------------------------------------------------
' Procedure : chkRegistrarDocumento_Click
' DateTime  : 11/09/2005 01:26
' Author    : Leonardo Azpurua
' Purpose   : Solicita del anfitrion permiso para inhibir la generacion del documento.
'---------------------------------------------------------------------------------------
'
Private Sub chkRegistrarDocumento_Click()
  If chkRegistrarDocumento.value = vbUnchecked Then
    Dim ok As Boolean
    ok = True
    RaiseEvent PermitirInhibicionDocumento(ok)
    If Not ok Then
      chkRegistrarDocumento.value = vbChecked
    End If
  End If
  RaiseEvent Change("chkRegistrarDocumento")
End Sub

Private Sub montoExento_GotFocus()
  SetHelpText "Monto exento de impuesto"
End Sub

Private Sub montoExento_Validate(Cancel As Boolean)
  ActualizarDisplay
  RaiseEvent Change("montoExento")
End Sub

Private Sub montoGravable1_GotFocus()
  SetHelpText "Monto gravable a Valor General"
End Sub

Private Sub montoGravable1_Validate(Cancel As Boolean)
  ActualizarDisplay
  RaiseEvent Change("montoGravable1")
End Sub

Private Sub montoGravable2_GotFocus()
  SetHelpText "Monto gravable a tasa preferencial"
End Sub

Private Sub montoGravable2_Validate(Cancel As Boolean)
  ActualizarDisplay
  RaiseEvent Change("montoGravable2")
End Sub

Private Sub montoRetenido_GotFocus()
  SetHelpText "Monto del IVA retenido"
End Sub

Private Sub montoRetenido_Validate(Cancel As Boolean)
  ActualizarDisplay
  RaiseEvent Change("montoRetenido")
End Sub

Private Sub porcentajeIV1_GotFocus()
  SetHelpText "Porcentaje vigente para la tasa general"
End Sub

Private Sub porcentajeIV1_Validate(Cancel As Boolean)
  ActualizarDisplay
End Sub

Private Sub porcentajeIV2_GotFocus()
  SetHelpText "Porcentaje de impuesto para la tasa preferencial"
End Sub

Private Sub porcentajeIV2_Validate(Cancel As Boolean)
  ActualizarDisplay
End Sub

Private Sub txControlFinal_GotFocus()
  SetHelpText "Ultimo numero de control utilizado en el documento"
End Sub

Private Sub txControlFinal_Validate(Cancel As Boolean)
  If txControlFinal.value = 0 Then
    If Not Confirmar("Dejar el numero de control en blanco (el documento no es valido)") Then
      Cancel = False
      Exit Sub
    End If
  End If
  If txControlInicial.value = 0 Then
    txControlInicial.value = txControlFinal.value
  End If
End Sub

Private Sub txControlInicial_GotFocus()
  SetHelpText "Primer numero de control utilizado en el documento"
End Sub

Private Sub txControlInicial_Validate(Cancel As Boolean)
  If txControlInicial.value = 0 Then
    If Not Confirmar("Dejar el numero de control en blanco (el documento no es valido)") Then
      Cancel = False
      Exit Sub
    End If
  End If
  If txControlFinal.value = 0 Then
    txControlFinal.value = txControlInicial.value
  End If
End Sub

Private Sub txFacturaRelacionada_GotFocus()
  SetHelpText "Referencia de la factura relacionada"
End Sub

Private Sub txReferencia_GotFocus()
  SetHelpText "Referencia del documento tal como aparecer en el libro"
End Sub

Private Sub txReferencia_Validate(Cancel As Boolean)
  If txReferencia.Text = "" Then
    If Not Confirmar("Esta seguro de que quiere dejar la referencia en blanco", True) Then
      Cancel = True
      Exit Sub
    End If
  End If
End Sub

Private Sub UserControl_Initialize()
  ProximoNC = Val(GetSetting("ClearLight", "General", "ProximoNC", "0"))
  txControlInicial.value = ProximoNC
  txControlFinal.value = ProximoNC
End Sub

'---------------------------------------------------------------------------------------
' Procedure : UserControl_ReadProperties/WriteProperties
' DateTime  : 11/09/2005 01:45
' Author    : Leonardo Azpurua
' Purpose   : Persistencia de valores definidos en tiempo de diseo.
'---------------------------------------------------------------------------------------
'
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
  AllowEditValues = PropBag.ReadProperty("AllowEditValues", True)
  Requerido = PropBag.ReadProperty("Requerido", False)
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
  PropBag.WriteProperty "AllowEditValues", AllowEditValues
  PropBag.WriteProperty "Requerido", Requerido
End Sub
