VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Begin VB.UserControl ucECC 
   BackStyle       =   0  'Transparent
   ClientHeight    =   2775
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   9705
   ScaleHeight     =   2775
   ScaleWidth      =   9705
   Begin VB.TextBox txConcepto 
      Height          =   315
      Left            =   3690
      MaxLength       =   50
      TabIndex        =   2
      Tag             =   "GED_Concepto"
      Top             =   1290
      Visible         =   0   'False
      Width           =   3990
   End
   Begin SimplexW.acCodeBox txCodigo 
      Height          =   315
      Left            =   60
      TabIndex        =   1
      Tag             =   "GED_Cuenta"
      Top             =   1260
      Visible         =   0   'False
      Width           =   2655
      _ExtentX        =   4683
      _ExtentY        =   556
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox ucNumBox1 
      Height          =   315
      Left            =   7680
      TabIndex        =   3
      Tag             =   "GED_Cantidad"
      Top             =   1290
      Visible         =   0   'False
      Width           =   1905
      _ExtentX        =   3360
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSFlexGridLib.MSFlexGrid flxDetalles 
      Height          =   2775
      Left            =   -30
      TabIndex        =   0
      Top             =   0
      Width           =   9705
      _ExtentX        =   17119
      _ExtentY        =   4895
      _Version        =   393216
      Cols            =   4
      FixedCols       =   0
      RowHeightMin    =   315
      AllowBigSelection=   0   'False
   End
End
Attribute VB_Name = "ucECC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Const _
    ColCodigo = 0, _
    ColDescripcion = 1, _
    ColDebe = 2, _
    ColHaber = 3

Event SetMessage(stMessage As String)
Event AccountSelected(stCodigo As String)
Event DataChanged()

Private ParentForm As Form
Private GEDitor As GEDObject

Public Property Get Editor() As GEDObject
  Set Editor = GEDitor
End Property

Public Sub SetParentForm(p As Form)
    Set GEDitor = New GEDObject
    GEDitor.init Me, flxDetalles
    
    Set ParentForm = p
    Set txCodigo.ParentForm = p
    GEDitor.SetParentForm p
    
    With flxDetalles
        txCodigo.Text = ""
        GEDitor.AddControl ColCodigo, txCodigo
        
        txConcepto.Text = ""
        GEDitor.AddControl ColDescripcion, txConcepto

        GEDitor.AddControl ColDebe, ucNumBox1

        ucNumBox1.Text = ""
        GEDitor.AddControl ColHaber, ucNumBox1
    End With
    
    Reinit2
End Sub

Public Function isData() As Boolean
Dim bResult As Boolean
    isData = flxDetalles.TextMatrix(1, 0) <> ""
End Function

Public Property Get FixedRows() As Long
    FixedRows = flxDetalles.FixedRows
End Property

Public Property Let FixedRows(ByRef n As Long)
    If flxDetalles.Rows = n Then
      flxDetalles.Rows = n + 1
    End If
    flxDetalles.FixedRows = n
    GEDitor.SetGridColors
End Property

Public Property Get Rows() As Long
    Rows = flxDetalles.Rows
End Property

Public Sub InsertRow(RowPos As Long)
    flxDetalles.AddItem "", RowPos
End Sub

Public Sub FixUpTo(Row As Long)
    If Row > flxDetalles.Rows Then Exit Sub
    flxDetalles.FixedRows = Row
End Sub

Public Property Get Grid() As MSFlexGrid
    Set Grid = flxDetalles
End Property

Public Sub AddDetalle(Cuenta As String, Descripcion As String, Debe As Currency, Haber As Currency)
Dim i As Integer
    i = 1
    Do While flxDetalles.TextMatrix(i, 0) <> ""
        i = i + 1
        If i = flxDetalles.Rows Then flxDetalles.Rows = flxDetalles.Rows + 1
    Loop

    flxDetalles.TextMatrix(i, 0) = Cuenta
    flxDetalles.TextMatrix(i, 1) = Descripcion
    flxDetalles.TextMatrix(i, 2) = FormatNumero(Debe, "###,###,###,##0.00", 18)
    flxDetalles.TextMatrix(i, 3) = FormatNumero(Haber, "###,###,###,##0.00", 18)
    
    GEDitor.SetGridColors
End Sub

Public Property Get Debitos() As Currency
    Debitos = GEDitor.SumaColumna(2)
End Property

Public Property Get Creditos() As Currency
    Creditos = GEDitor.SumaColumna(3)
End Property

Public Property Get Balance() As Currency
    Balance = GEDitor.SumaColumna(2) - GEDitor.SumaColumna(3)
End Property

Public Function Detalles() As Collection
Dim retCol As Collection, itemCol As clsDetalles, i As Integer
    Set retCol = New Collection
    With flxDetalles
    For i = 1 To .Rows - 1
        Set itemCol = New clsDetalles
        itemCol.Cuenta = .TextMatrix(i, 0)
        itemCol.Debe = ValOf(.TextMatrix(i, 2))
        itemCol.Haber = ValOf(.TextMatrix(i, 3))
        itemCol.Descripcion = .TextMatrix(i, 1)
        retCol.Add itemCol
        Set itemCol = Nothing
    Next
    End With
    Set Detalles = retCol
End Function

Public Sub SetBufferComprobante(inst As clsBufferComprobante)
Dim col As Collection, instDetalle As clsDetalles
  Set col = inst.Detalles
  With flxDetalles
    .Rows = 2
    .FixedRows = 1
    For Each instDetalle In col
      .TextMatrix(.Rows - 1, ColCodigo) = instDetalle.Cuenta
      .TextMatrix(.Rows - 1, ColDescripcion) = instDetalle.Descripcion
      If (instDetalle.Debe > 0.001) Then
        .TextMatrix(.Rows - 1, ColDebe) = Format(instDetalle.Debe, Empresa.FormatoSaldos)
      Else
        .TextMatrix(.Rows - 1, ColHaber) = Format(instDetalle.Haber, Empresa.FormatoSaldos)
      End If
      .Rows = .Rows + 1
    Next
    If (.Rows > 2) Then .Rows = .Rows - 1
  End With
End Sub

Sub SetComprobante(orgInst As clsComprobante)
Dim col As Collection, instDetalle As clsDetalles
    Set col = New Collection
    AlmacenDetalles.FillDetallesComprobante orgInst.NumeroComprobante, col
    With flxDetalles
    .Rows = 2
    For Each instDetalle In col
        .TextMatrix(.Rows - 1, ColCodigo) = instDetalle.Cuenta
        .TextMatrix(.Rows - 1, ColDescripcion) = instDetalle.Descripcion
        If (instDetalle.Debe > 0.001) Then
            .TextMatrix(.Rows - 1, ColDebe) = Format(instDetalle.Debe, Empresa.FormatoSaldos)
        Else
            .TextMatrix(.Rows - 1, ColHaber) = Format(instDetalle.Haber, Empresa.FormatoSaldos)
        End If
        .Rows = .Rows + 1
    Next
    If (.Rows > 2) Then .Rows = .Rows - 1
    End With
End Sub

Public Sub FillNewRow(Row As Long)
Dim DB As Double, cr As Double
    If Row = 1 Then Exit Sub
    
    flxDetalles.TextMatrix(Row, ColDescripcion) = flxDetalles.TextMatrix(Row - 1, 1)
    DB = GEDitor.SumaColumna(2): cr = GEDitor.SumaColumna(3)
    DB = DB - cr
    If (DB < 0) Then
        DB = -DB
        flxDetalles.TextMatrix(Row, ColDebe) = Format(DB, Empresa.FormatoSaldos)
    Else
        flxDetalles.TextMatrix(Row, ColHaber) = Format(DB, Empresa.FormatoSaldos)
    End If
End Sub

Public Function IsRowValid(Row As Long)
Dim pCuenta As clsCuenta

    On Error Resume Next
    Dim ctl As Control
    Set ctl = ParentForm.ActiveControl
    If Err.Number <> 0 Then Set ctl = Nothing
    On Error GoTo 0
    If Not ctl Is Nothing Then
      If ctl.Name = "cbCancelar" Or ctl.Name = "cbCerrar" Then
        IsRowValid = True
        Exit Function
      End If
    End If
    
    With flxDetalles
    If .TextMatrix(Row, ColCodigo) = "" Then
        mAdvertencia "Debe introducir un cdigo de cuenta"
        IsRowValid = False
        Exit Function
    End If
    
    Set pCuenta = New clsCuenta
    If Not pCuenta.Load(.TextMatrix(Row, ColCodigo)) Then
      mAdvertencia "Cuenta invlida"
      IsRowValid = False
      Exit Function
    End If
    
    If pCuenta.Status = 1 Then
      mAdvertencia "La cuenta " & .TextMatrix(Row, ColCodigo) & " es de control."
      IsRowValid = False
      Exit Function
    End If
    Set pCuenta = Nothing

    If .TextMatrix(Row, ColDescripcion) = "" Then
        mAdvertencia "Debe especificar un concepto o descripcion del movimiento"
        IsRowValid = False
        Exit Function
    End If
    If .TextMatrix(Row, ColDebe) = "" And .TextMatrix(Row, ColHaber) = "" Then
        mAdvertencia "Debe indicar un monto en alguna de las columnas DB o CR"
        IsRowValid = False
        Exit Function
    End If
    End With
    IsRowValid = True
    RaiseEvent DataChanged
End Function

Public Function MayAddRow(cRow As Long) As Boolean
    RaiseEvent DataChanged
    MayAddRow = True
End Function

Public Function MayDeleteRow(cRow As Long) As Boolean
    MayDeleteRow = True
End Function

Public Function ValidateCell(Row As Long, col As Long) As Boolean
Dim dMonto As Double, lCuenta As clsCuenta, isOk As Boolean
Static lValid As Single

    If ParentForm.ActiveControl.Name = "cbCancelar" Or ParentForm.ActiveControl.Name = "cbCerrar" Then
        ValidateCell = True
        Exit Function
    End If
    
    With flxDetalles
    Select Case col
        Case ColCodigo: ' Codigo
            If txCodigo.Text = "" Then
              If Row = .Rows - 1 Then
                ValidateCell = True
                Exit Function
              End If
              mAdvertencia "ERROR: No puede dejar el cdigo de cuenta en blanco"
              ValidateCell = False
              Exit Function
            End If
            
'            While txCodigo.Validando: Wend
            Set lCuenta = New clsCuenta
            isOk = lCuenta.Load(MergeCodigoFormato(txCodigo.Text, Empresa.FormatoCodigos))
            If isOk Then
              If lCuenta.Status = 1 Then
                If Timer - lValid > 0.5 Then
                  mAdvertencia "Cuenta de Control"
                End If
                isOk = False
                lValid = Timer
              End If
            End If
            Set lCuenta = Nothing
            If Not isOk Then
                ValidateCell = False
                Exit Function
            End If
            .TextMatrix(Row, col) = MergeCodigoFormato(txCodigo.Text, Empresa.FormatoCodigos)
            txCodigo.Text = .TextMatrix(Row, col)
            RaiseEvent AccountSelected(txCodigo.Text)
        
        Case ColDescripcion: ' Descripcion
            If .TextMatrix(Row, col) = "" Then
                .TextMatrix(Row, col) = "INVALIDO!"
            End If
        Case ColDebe: ' Debe
            If Not NumeroValido(.TextMatrix(Row, col)) Then
                ValidateCell = False
                Exit Function
            End If
            dMonto = ValOf(.TextMatrix(Row, col))
            If (dMonto > 0.001) Then
                .TextMatrix(Row, col) = Format(dMonto, Empresa.FormatoSaldos)
                .TextMatrix(Row, col + 1) = ""
            Else
                .TextMatrix(Row, col) = ""
            End If
        Case ColHaber: ' Haber
            If Not NumeroValido(.TextMatrix(Row, col)) Then
                ValidateCell = False
                Exit Function
            End If
            dMonto = ValOf(.TextMatrix(Row, col))
            If (dMonto > 0.001) Then
                .TextMatrix(Row, col) = Format(dMonto, Empresa.FormatoSaldos)
                .TextMatrix(Row, col - 1) = ""
            Else
                .TextMatrix(Row, col) = ""
            End If
    End Select
    End With
    ValidateCell = True
End Function

Private Sub Reinit2()
Dim i As Integer
  GEDitor.GED_Clear
  lmGridUtils.ClearGrid flxDetalles
End Sub

Public Sub Reinit()
    Reinit2
End Sub

Private Sub txRefDetalle_KeyPress(KeyAscii As Integer)
    If KeyAscii = vbKeyReturn Then KeyAscii = 0
End Sub

Private Sub flxDetalles_EnterCell()
    GEDitor.EnterCell
End Sub

Private Sub flxDetalles_GotFocus()
    GEDitor.EnterCell
End Sub

Private Sub flxDetalles_Scroll()
    GEDitor.Scroll
End Sub

Private Sub txCodigo_GotFocus()
    RaiseEvent SetMessage("Cdigo de la cuenta deseada.")
    HighLight txCodigo
End Sub

Private Sub txCodigo_KeyDown(KeyCode As Integer, Shift As Integer)
    GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txCodigo_LostFocus()
    GEDitor.ControlLost
End Sub

Private Sub txConcepto_GotFocus()
    RaiseEvent SetMessage("Introduzca la descripcin o concepto del movimiento")
    HighLight txConcepto
End Sub

Private Sub txConcepto_KeyDown(KeyCode As Integer, Shift As Integer)
    GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub txConcepto_LostFocus()
    GEDitor.ControlLost
End Sub

Private Sub ucNumBox1_GotFocus()
    If flxDetalles.col = 2 Then
        RaiseEvent SetMessage("Monto a cargar a la cuenta seleccionada")
    Else
        RaiseEvent SetMessage("Monto a acreditar a la cuenta seleccionada")
    End If
    HighLight ucNumBox1
End Sub

Private Sub ucNumBox1_KeyDown(KeyCode As Integer, Shift As Integer)
    GEDitor.KeyDown KeyCode, Shift
End Sub

Private Sub ucNumBox1_KeyPress(KeyAscii As Integer)
    txRefDetalle_KeyPress KeyAscii
End Sub

Private Sub ucNumBox1_LostFocus()
    GEDitor.ControlLost
End Sub

Private Sub UserControl_Initialize()
    
    With flxDetalles
        
        .ColAlignment(ColCodigo) = flexAlignLeftTop
        .ColWidth(ColCodigo) = txCodigo.Width
        .TextMatrix(0, ColCodigo) = "Cuenta"
        
        .ColAlignment(ColDescripcion) = flexAlignLeftTop
        .ColWidth(ColDescripcion) = txConcepto.Width
        txConcepto.Text = ""
        .TextMatrix(0, ColDescripcion) = "Concepto"

        .ColAlignment(ColDebe) = flexAlignRightTop
        .ColWidth(ColDebe) = ucNumBox1.Width
        .TextMatrix(0, ColDebe) = "DEBE"

        .ColAlignment(ColHaber) = flexAlignRightTop
        .ColWidth(ColHaber) = ucNumBox1.Width
        .TextMatrix(0, ColHaber) = "HABER"
    
    End With

End Sub

Private Sub UserControl_Resize()
    flxDetalles.Height = UserControl.Height
    flxDetalles.Width = UserControl.Width
End Sub

Public Function Validar() As Boolean ' Funcin para validar antes del proceso
Dim i As Long, pCuenta As clsCuenta
Dim sDebitos As Currency, sCreditos As Currency
Dim bError As Boolean

    bError = False
    Set pCuenta = New clsCuenta
    For i = 1 To flxDetalles.Rows - 1
        
      If i = flxDetalles.Rows - 1 And flxDetalles.TextMatrix(i, 0) = "" Then
        Exit For
      End If
      
      If Not pCuenta.Load(flxDetalles.TextMatrix(i, 0)) Then
          mAdvertencia "Linea" & Str(i) & ": cuenta """ & flxDetalles.TextMatrix(i, 0) & """ no registrada."
          bError = True
          Exit For
      End If
      
      If pCuenta.Status = 1 Then
          mAdvertencia "Error: la cuenta " & pCuenta.Codigo & " es de control"
          bError = True
          Exit For
      End If
      
      sDebitos = sDebitos + ValOf(flxDetalles.TextMatrix(i, 2))
      sCreditos = sCreditos + ValOf(flxDetalles.TextMatrix(i, 3))

    Next

    Set pCuenta = Nothing
        
    If bError Then
        
        Validar = False
        Exit Function
    
    End If
    
    If Abs(sDebitos - sCreditos) > 0.01 Then
        
        If Not Confirmar("Aceptar el asiento desbalanceado") Then
            
            Validar = False
            Exit Function
        
        End If
    
    End If
    
    Validar = True

End Function


'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=flxDetalles,flxDetalles,-1,Font
Public Property Get Font() As Font
Attribute Font.VB_Description = "Returns/sets the default font or the font for individual cells."
Attribute Font.VB_UserMemId = -512
  Set Font = flxDetalles.Font
End Property

Public Property Set Font(ByVal New_Font As Font)
  Set flxDetalles.Font = New_Font
  PropertyChanged "Font"
End Property

'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)

  Set Font = PropBag.ReadProperty("Font", Ambient.Font)
End Sub

'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

  Call PropBag.WriteProperty("Font", Font, Ambient.Font)
End Sub

