Attribute VB_Name = "mMain"
Option Explicit

Enum TipoProceso
    TP_NO_PROCESAR = 0
    TP_ENTREGA_INMEDIATA = 1
    TP_ORDEN_DESPACHO = 2
    TP_ORDEN_TRANSPORTE = 3
End Enum

Public Const TMB_CHEQUE = 0
Public Const TMB_DEPOSITO = 1
Public Const TMB_NCR = 2
Public Const TMB_NDB = 3

Public AlmacenItemsVenta As clsAlmacenItemsVenta, _
        AlmacenAlternos As clsAlmacenAlternosItemVenta, _
        AlmacenComposiciones As clsAlmacenCompItemsVnt, _
        AlmacenItemsInventario As clsAlmacenItemsInventario, _
        AlmacenCuentas As clsAlmacenCuentas, _
        AlmacenPrefijos As clsAlmacenPrefijos, _
        AlmacenClientes As clsAlmacenClientes, _
        AlmacenProveedores As clsAlmacenProveedores, _
        AlmacenSaldosEntidad As clsAlmacenSaldosEntidad, _
        AlmacenContactos As clsAlmacenContactos, _
        AlmacenExUbic As clsAlmacenExUbic, _
        AlmacenDocumentosISPC As clsAlmacenDocumentosISPC, _
        AlmacenVendedores As clsAlmacenVendedores, _
        Almacenes As clsAlmacenes, _
        Empresa As clsParametrosEmpresa, _
        Series As clsSeries, _
        AlmacenFacturas As clsAlmacenFacturas, _
        AlmacenDetallesFactura As clsAlmacenDetallesFactura, _
        AlmacenDetallesEntidad As clsAlmacenDetallesEntidad, _
        AlmacenDetallesItemVenta As clsAlmacenDetallesItemVenta

Public AlmacenDetallesItemInv As clsAlmacenDetallesItemInv, _
        AlmacenCompAlmacen As clsAlmacenCompAlmacen, _
        AlmacenMINVS As clsAlmacenDetallesItemInv, _
        AlmacenVencimientosISPC As clsAlmacenVencISPC

Public LineasInventario As clsTablasCodigo
Public LineasVenta As clsTablasCodigo
Public Zonas As clsTablasCodigo

Public AlmacenCompras As clsAlmacenCompras
Public AlmacenDetallesCompra As clsAlmacenDetallesCompra

Public Condiciones As clsCondiciones
Public TiposImpuesto As clsTiposImpuesto

Public AlmacenSaldos As clsAlmacenSaldos
Public AlmacenComprobantes As clsAlmacenComprobantes
Public AlmacenDetalles As clsAlmacenDetalles

Public Sesiones As clsSesionesPOS
Public CuentasPOS As clsCuentasPOS


Public poleEnabled As Boolean


Public Const FormatoPrecios = "###,###,##0.00"
Public Const FormatoExistencia = "##,###,##0"

Private Sub InstanciarAlmacenes()
    Set AlmacenItemsVenta = New clsAlmacenItemsVenta
    Set AlmacenAlternos = New clsAlmacenAlternosItemVenta
    Set AlmacenComposiciones = New clsAlmacenCompItemsVnt
    Set AlmacenItemsInventario = New clsAlmacenItemsInventario
    Set AlmacenCuentas = New clsAlmacenCuentas
    Set AlmacenPrefijos = New clsAlmacenPrefijos
    Set AlmacenClientes = New clsAlmacenClientes
    Set AlmacenSaldos = New clsAlmacenSaldos
    Set AlmacenComprobantes = New clsAlmacenComprobantes
    Set AlmacenDetalles = New clsAlmacenDetalles
    Set AlmacenProveedores = New clsAlmacenProveedores
    Set Empresa = New clsParametrosEmpresa
    Set AlmacenContactos = New clsAlmacenContactos
    Set AlmacenVendedores = New clsAlmacenVendedores
    Set Almacenes = New clsAlmacenes
    Set AlmacenExUbic = New clsAlmacenExUbic
    Set Series = New clsSeries
    Set AlmacenFacturas = New clsAlmacenFacturas
    Set AlmacenDetallesFactura = New clsAlmacenDetallesFactura
    Set TiposImpuesto = New clsTiposImpuesto
    Set Condiciones = New clsCondiciones
    Set AlmacenDetallesItemVenta = New clsAlmacenDetallesItemVenta
    Set AlmacenCompAlmacen = New clsAlmacenCompAlmacen
    Set AlmacenMINVS = New clsAlmacenDetallesItemInv
    Set AlmacenSaldosEntidad = New clsAlmacenSaldosEntidad
    Set AlmacenDocumentosISPC = New clsAlmacenDocumentosISPC
    Set AlmacenDetallesEntidad = New clsAlmacenDetallesEntidad
    Set AlmacenVencimientosISPC = New clsAlmacenVencISPC
    Set AlmacenCompras = New clsAlmacenCompras
    Set AlmacenDetallesCompra = New clsAlmacenDetallesCompra
    Set LineasInventario = New clsTablasCodigo: LineasInventario.SetTableName "LineasInventario", "Lineas de Inventario", "Linea de Inventario"
    Set LineasVenta = New clsTablasCodigo: LineasVenta.SetTableName "LineasVenta", "Lineas de Productos", "Linea de Productos"
    Set Zonas = New clsTablasCodigo: Zonas.SetTableName "Zonas", "Zonas", "Zona"
    Set Sesiones = New clsSesionesPOS
End Sub

Private Sub DestruirAlmacenes()
    Set Sesiones = Nothing
    Set Zonas = Nothing
    Set LineasVenta = Nothing
    Set LineasInventario = Nothing
    Set AlmacenDetallesCompra = Nothing
    Set AlmacenCompras = Nothing
    Set AlmacenVencimientosISPC = Nothing
    Set AlmacenDetallesEntidad = Nothing
    Set AlmacenDocumentosISPC = Nothing
    Set AlmacenSaldosEntidad = Nothing
    Set AlmacenMINVS = Nothing
    Set AlmacenCompAlmacen = Nothing
    Set AlmacenDetallesItemVenta = Nothing
    Set Condiciones = Nothing
    Set TiposImpuesto = Nothing
    Set AlmacenDetallesFactura = Nothing
    Set AlmacenFacturas = Nothing
    Set Series = Nothing
    Set AlmacenExUbic = Nothing
    Set Almacenes = Nothing
    Set AlmacenVendedores = Nothing
    Set AlmacenContactos = Nothing
    Set Empresa = Nothing
    Set AlmacenProveedores = Nothing
    Set AlmacenClientes = Nothing
    Set AlmacenPrefijos = Nothing
    Set AlmacenCuentas = Nothing
    Set AlmacenItemsInventario = Nothing
    Set AlmacenComposiciones = Nothing
    Set AlmacenAlternos = Nothing
    Set AlmacenItemsVenta = Nothing
    Set AlmacenDetalles = Nothing
    Set AlmacenComprobantes = Nothing
    Set AlmacenSaldos = Nothing
End Sub

Private Function VerificarDirectorioDatos() As Boolean
Dim stTemp As String
Dim f As fselDataPath
    stTemp = GetSetting(AppName:=AppName, Section:="General", Key:="DataDir", Default:="UNDEF")
    If stTemp = "UNDEF" Then
        Set f = New fselDataPath
        f.SetAppName AppName
        f.SetFileName "bo01.mdb"
        f.chkAllowNotData.Value = vbUnchecked
        f.chkAllowNotData.Enabled = False
        f.Show 1
        Unload f
        Set f = Nothing
        stTemp = GetSetting(AppName:=AppName, Section:="General", Key:="DataDir", Default:="UNDEF")
    End If
    VerificarDirectorioDatos = (stTemp <> "UNDEF")
End Function

Private Sub PrepararEntorno()
Dim fLogin As LFGetUser, lrefPeriodo As Long

    DestruirAlmacenes
CheckDataDir:
    If Not VerificarDirectorioDatos Then
        If mainForm.Visible Then mainForm.Hide
        End
    End If

    On Error GoTo ErrHandler
    Set dbHandle = Workspaces(0).OpenDatabase(BuildDataPath("bo01.mdb", AppName))

#If False Then
    Set fLogin = New LFGetUser
    fLogin.Show 1
    UsuarioActivo.Codigo = fLogin.txCodigo.Text
    If UsuarioActivo.Codigo = "" Then
        dbHandle.Close
        End
    End If
    Unload fLogin
    Set fLogin = Nothing
#Else
    UsuarioActivo.Codigo = "ADMIN"
#End If
    lmUsuarios.LeerUsuario UsuarioActivo.Codigo
    UsuarioActivo = lmUsuarios.cUsuario

    InstanciarAlmacenes

    lrefPeriodo = Empresa.AnhoMes2Periodo(Year(Date), Month(Date))
    If (Empresa.PeriodoCurso < lrefPeriodo) Then
        If VerificarUsuario("Abrir nuevo periodo contable") < 5 Then
            End
        End If
        Empresa.ActualizarUltimoPeriodo lrefPeriodo
    End If

     Printer.Font.Name = "Courier New"
    
    Exit Sub
ErrHandler:
    If Err.Number = 3024 Then
        mAdvertencia "ERROR: No puedo localizar la Base de Datos" & Chr(13) & _
                     "en la ubicacin especificada... Por favor, intentelo de nuevo" & Chr(13) & _
                     "(" & BuildDataPath("bo01.mdb", AppName) & ")"
        SaveSetting AppName, "General", "DataDir", "UNDEF"
        Resume CheckDataDir
    Else
        On Error GoTo 0
        Resume
    End If
End Sub

Sub Main()
    VSLIB.AppName = "SimplexW"
    PrepararEntorno
    mainForm.Show 0
    While mainForm.Visible: DoEvents: Wend
    Unload mainForm
    Set mainForm = Nothing
    DestruirAlmacenes
End Sub
