Attribute VB_Name = "lmUsuarios"
Type Usuario
    Codigo  As String
    Clave   As Long
    Nivel   As Byte
    Nombre  As String
    Perfil As String
End Type

Private qAperturas As Integer
Public cUsuario As Usuario, UsuarioActivo As Usuario

Sub AbrirUsuarios()
End Sub

Sub CerrarUsuarios()
End Sub

Public Function RegistrarUsuario(ByVal Codigo As String, ByVal Clave As String, ByVal Nivel As Byte, ByVal Nombre As String, ByVal Perfil As String) As Boolean
    Dim s As String

    If Len(Codigo) < 4 Or Len(Clave) < 4 Then
        mAdvertencia "Los codigos y claves de usuario deben tener al menos cuatro caracteres"
        RegistrarUsuario = False
        Exit Function
    End If

    s = "INSERT INTO Usuarios (Codigo, Clave, Nivel, Nombre, Perfil) SELECT "
    s = s & StringDB(Codigo) & ", "
    s = s & NumeroDB(CalcActKey(Clave)) & ", "
    s = s & NumeroDB(Nivel) & ", "
    s = s & StringDB(Nombre) & ", "
    s = s & StringDB(Perfil)
    
    dbHandle.Execute s
    
    RegistrarUsuario = True
End Function

Public Function ActualizarDescriptivosUsuario(ByVal Codigo As String, ByVal Nombre As String, ByVal Nivel As Byte, Perfil As String) As Boolean
Dim bRetVal As Boolean, s As String, pRecs As Long

    s = "UPDATE Usuarios SET Nombre = " & StringDB(Nombre) & ", "
    s = s & "Nivel = " & NumeroDB(Nivel) & ", "
    s = s & "Perfil = " & StringDB(Perfil) & " "
    s = s & "WHERE Codigo = " & StringDB(Codigo)
    dbHandle.Execute s, pRecs
    bRetVal = (pRecs = 1)
    ActualizarDescriptivosUsuario = bRetVal
End Function

Public Function LeerUsuario(Codigo As String) As Boolean
Dim Found As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM usuarios WHERE Codigo = " & StringDB(Codigo))
    With rs
    If .EOF Then
        Found = False
    Else
        cUsuario.Codigo = GetStringFromVariant(.Fields("Codigo"))
        cUsuario.Clave = GetNumeroFromVariant(.Fields("Clave"))
        cUsuario.Nivel = GetNumeroFromVariant(.Fields("Nivel"))
        cUsuario.Nombre = GetStringFromVariant(.Fields("Nombre"))
        On Error Resume Next
        cUsuario.Perfil = GetStringFromVariant(.Fields("Perfil"))
        If Err.Number Then
          Err.Clear
          cUsuario.Perfil = ""
        End If
        If cUsuario.Perfil = "" Then
            cUsuario.Perfil = "SUPER"
        End If
        Found = True
    End If
    End With
    LeerUsuario = Found

End Function

Public Function LeerUsuarioPorClave(lngClave As Long) As Boolean
Dim Found As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM Usuarios WHERE Clave = " & NumeroDB(lngClave))
    With rs
    If .EOF Then
        Found = False
    Else
        cUsuario.Codigo = GetStringFromVariant(.Fields("Codigo"))
        cUsuario.Clave = GetNumeroFromVariant(.Fields("Clave"))
        cUsuario.Nivel = GetNumeroFromVariant(.Fields("Nivel"))
        cUsuario.Nombre = GetStringFromVariant(.Fields("Nombre"))
        On Error Resume Next
        cUsuario.Perfil = GetStringFromVariant(.Fields("Perfil"))
        If Err.Number Then
          Err.Clear
          cUsuario.Perfil = ""
        End If
        If Perfil = "" Then
            cUsuario.Perfil = "SUPER"
        End If
        Found = True
    End If
    End With
    LeerUsuarioPorClave = Found

End Function

Public Function ActualizarClaveUsuario(ByVal Codigo As String, ByVal Clave As String) As Boolean
Dim bRetVal As Boolean, qRecs As Long
    
    dbHandle.Execute "UPDATE Usuarios SET Clave = " & NumeroDB(CalcActKey(Clave)) & " WHERE Codigo = " & StringDB(Codigo)
    bRetVal = True
    ActualizarClaveUsuario = bRetVal

End Function

Public Function ExisteUsuario(Codigo As String) As Boolean
Dim Found As Boolean, rs As Recordset
    
    Set rs = dbHandle.Execute("SELECT Codigo FROM Usuarios WHERE Codigo = " & StringDB(Codigo))
    If rs.EOF Then
        Found = False
    Else
        Found = True
    End If
    Set rs = Nothing
    ExisteUsuario = Found

End Function

Public Function VerificarUsuario(stArgCaption As String) As Integer
Dim bResult As Boolean
Dim f As New LFGetUser, retVal As Integer
Dim tmpUsuario As Usuario

  If CBool(GetSetting("ClearLight", "General", "GetPass", "0")) Then
    Set f1 = New frmGetPass
    f1.Caption = stArgCaption
    f1.Show vbModal
    bResult = f1.bResult
    Unload f1
    Set f1 = Nothing
    tmpUsuario = cUsuario
    If Not bResult Then
        retVal = 0
    Else
        retVal = cUsuario.Nivel
    End If
    cUsuario = tmpUsuario
  Else
    Set f = New LFGetUser
    f.Caption = stArgCaption
    f.Show 1
    If f.txCodigo = "" Then
      retVal = 0
    Else
      tmpUsuario = cUsuario
      If Not LeerUsuario(f.txCodigo.Text) Then
        retVal = 0
      Else
        retVal = cUsuario.Nivel
      End If
      cUsuario = tmpUsuario
    End If
    Unload f
    Set f = Nothing
  End If
  VerificarUsuario = retVal
End Function


Public Function ClaveEspecial() As Long

    ClaveEspecial = 110954

End Function

Public Function ValidarClaveUsuario(Codigo As String, Clave As String) As Boolean
    
    Codigo = Format(Codigo, ">")
    Clave = Format(Clave, ">")
    If Not LeerUsuario(Codigo) Then
        ValidarClaveUsuario = False
        Exit Function
    End If

    If Val(Clave) = ClaveEspecial Then
        ValidarClaveUsuario = True
        Exit Function
    End If

    If CalcActKey(Clave) <> cUsuario.Clave Then
        ValidarClaveUsuario = False
    Else
        ValidarClaveUsuario = True
    End If

End Function

Public Sub EliminarUsuario(Codigo As String)

    dbHandle.Execute "DELETE FROM Usuarios WHERE Codigo = " & StringDB(Codigo)

End Sub

Public Function EstaAutorizado(sCodigo As String, pOperacion As PermisosUsuario) As Boolean
Dim rs As Recordset, sPerfil As String, nPermiso As Integer

    On Error Resume Next
    Set rs = dbHandle.Execute("SELECT Perfil FROM Usuarios WHERE Codigo = " & StringDB(sCodigo))
    If Err.Number <> 0 Then
        Err.Clear
        EstaAutorizado = True
        Exit Function
    End If
    
    On Error GoTo 0

    sPerfil = GetStringFromVariant(rs.Fields("Perfil"))
    If sPerfil = "" Then
        sPerfil = "SUPER"
    End If

    Set rs = Nothing
    
    If sPerfil = "SUPER" Then
        EstaAutorizado = True
        Exit Function
    End If

    Set rs = dbHandle.Execute("SELECT COUNT(Permiso) AS TienePermiso FROM perfilesPermisos WHERE CodigoPerfil = " & StringDB(sPerfil) & " AND Permiso = " & NumeroDB(pOperacion))
    nPermiso = rs.Fields("TienePermiso")
    Set rs = Nothing
    
    If nPermiso = 0 Then
        mAdvertencia "Acceso no autorizado... Lo siento"
    End If

    EstaAutorizado = (nPermiso <> 0)

End Function

