Attribute VB_Name = "mUpgrade232"
Option Explicit

Private Function ProximoNumero(istrTableName As String) As Long
Dim lngNumero As Long, tDef As TableDef, fld As Field
Dim rs As Recordset

  Set rs = dbHandle.OpenRecordset("SELECT Max(Numero) As Ultimo FROM " & istrTableName, dbOpenForwardOnly)
  If rs.EOF Then
    lngNumero = 0
  Else
    If IsNull(rs.Fields("Ultimo").Value) Then
      lngNumero = 0
    Else
      lngNumero = rs.Fields("Ultimo").Value
    End If
  End If

  lngNumero = lngNumero + 1
  rs.Close
  Set rs = Nothing

  On Error GoTo NoSuchField

  Set tDef = dbHandle.TableDefs(istrTableName)
  Set fld = tDef.Fields("FechaRegistro")
  fld.DefaultValue = "Now()"

RetVal:
  ProximoNumero = lngNumero
  Exit Function

NoSuchField:
  Resume RetVal

End Function

Sub Main()
Dim tDef As TableDef, fldDef As Field, rs As Recordset
Dim dtAhora As Date, pContadores As CContadores

  If Now() > CDate("2002-08-24") Then
    MsgBox "Operacion no autorizada"
    End
  End If

  On Error GoTo NoSuchDB
  Set dbHandle = Workspaces(0).OpenDatabase(Command)
  
  On Error GoTo Siguela
  Set tDef = dbHandle.TableDefs("Contadores")
    MsgBox "Ya existe la tabla de contadores"
    Set dbHandle = Nothing
    End

Siguela:
  Set tDef = New TableDef
  tDef.Name = "Contadores"

  Set fldDef = New Field
  With fldDef
  .Name = "Factura"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With

  Set fldDef = New Field
  With fldDef
  .Name = "NotaEntrega"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With
  
  Set fldDef = New Field
  With fldDef
  .Name = "Cotizacion"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With
  
  Set fldDef = New Field
  With fldDef
  .Name = "DevolucionVenta"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With
  
  Set fldDef = New Field
  With fldDef
  .Name = "Compra"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With
  
  Set fldDef = New Field
  With fldDef
  .Name = "OrdenCompra"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With
  
  Set fldDef = New Field
  With fldDef
  .Name = "DevolucionCompra"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With

  Set fldDef = New Field
  With fldDef
  .Name = "Ajuste"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With

  Set fldDef = New Field
  With fldDef
  .Name = "Transferencia"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With

  Set fldDef = New Field
  With fldDef
  .Name = "NotaDBCR"
  .Type = dbLong
  .DefaultValue = 1
  tDef.Fields.Append fldDef
  End With

  Set fldDef = New Field
  With fldDef
  .Name = "Apertura"
  .Type = dbDate
  .DefaultValue = "Now()"
  tDef.Fields.Append fldDef
  End With

  Set fldDef = New Field
  With fldDef
  .Name = "Clave"
  .Type = dbLong
  tDef.Fields.Append fldDef
  End With
  
  Set fldDef = New Field
  With fldDef
  .Name = "Status"
  .Type = dbCurrency
  tDef.Fields.Append fldDef
  End With

  dbHandle.TableDefs.Append tDef

  Set rs = dbHandle.OpenRecordset("Contadores", dbOpenTable)
  With rs
  .AddNew
  .Fields("Factura").Value = ProximoNumero("Facturas")
  .Fields("NotaEntrega").Value = ProximoNumero("NNEE")
  .Fields("Cotizacion").Value = ProximoNumero("Cotizaciones")
  .Fields("DevolucionVenta").Value = ProximoNumero("DevolucionesVenta")
  .Fields("Compra").Value = ProximoNumero("Compras")
  .Fields("OrdenCompra").Value = ProximoNumero("ocOrdenes")
  .Fields("DevolucionCompra").Value = ProximoNumero("DevolucionesCompra")
  .Fields("Ajuste").Value = ProximoNumero("Ajustes")
  .Fields("Transferencia").Value = ProximoNumero("Transferencias")
  .Fields("NotaDBCR").Value = ProximoNumero("NotasDCCP")
  dtAhora = Now
  .Fields("Apertura").Value = dtAhora
  .Update
  End With
  Set rs = Nothing

  Set pContadores = New CContadores
  pContadores.SetValid
  Set pContadores = Nothing

  Set tDef = dbHandle.TableDefs("Series")
  Set fldDef = New Field
  With fldDef
  .Name = "ProximaFactura"
  .Type = dbLong
  tDef.Fields.Append fldDef
  End With

  dbHandle.Execute "UPDATE Series, Facturas SET Series.ProximaFactura = Facturas.Correlativo + 1 WHERE Facturas.Serie = Series.CodigoSerie", dbFailOnError
  dbHandle.Execute "UPDATE Series SET ProximaFactura = 1 WHERE ProximaFactura IS NULL", dbFailOnError
  
  dbHandle.Close
  Set dbHandle = Nothing

  Exit Sub

NoSuchDB:
  MsgBox "Argumento invlido", vbOKOnly, "ERROR"
  End

End Sub
