Attribute VB_Name = "mUnidades"
Option Explicit

Public Sub InicializarUnidades()
Dim rs As Recordset

  Set Unidades = New CUnits
  Set rs = dbHandle.OpenRecordset("SELECT * FROM Unidades", dbOpenForwardOnly)
  Do While Not rs.EOF
    Unidades.AddEquivalencia rs.Fields("Unidad"), GetStringFromVariant(rs.Fields("Equivalencia")), GetNumeroFromVariant(rs.Fields("Factor"))
    rs.MoveNext
  Loop
  Set rs = Nothing

End Sub

Public Sub FillComboUnidades(cbxCombo As ComboBox)
Dim stOrg As String, rs As Recordset

  stOrg = cbxCombo.Text
  cbxCombo.Clear
  Set rs = dbHandle.OpenRecordset("SELECT DISTINCT Unidad FROM Unidades UNION SELECT Equivalencia FROM Unidades ORDER BY Unidad", dbOpenForwardOnly)
  Do While Not rs.EOF
    cbxCombo.AddItem GetStringFromVariant(rs.Fields("Unidad"))
    rs.MoveNext
  Loop
  cbxCombo.Text = stOrg

End Sub

Public Function AgregarUnidad(stUnidad As String) As Boolean
Dim frmEdit As frmDefinirUnidad, bResult As Boolean

  Set frmEdit = New frmDefinirUnidad
  frmEdit.SetUnidad stUnidad
  frmEdit.Show vbModal
  bResult = frmEdit.bResult
  Unload frmEdit
  Set frmEdit = Nothing
  
  AgregarUnidad = bResult

End Function

Public Function ValidarUnidad(stUnidad As String) As Boolean
Dim bResult As Boolean

  bResult = Unidades.IsValid(stUnidad)
  If Not bResult Then
    bResult = AgregarUnidad(stUnidad)
  End If
  If Not bResult Then mAdvertencia "Unidad no registrada"
  ValidarUnidad = bResult

End Function
