Attribute VB_Name = "mTipoUtilidad"
Option Explicit

Private bTipoUtilidad As Boolean
Private bIsInit As Boolean

Private Sub init()
  If Not bIsInit Then
    bIsInit = True
    bTipoUtilidad = CBool(GetSetting(AppName, "General", "TipoUtilidad", "0"))
  End If
End Sub

Public Function TipoUtilidad() As Boolean
  init
  TipoUtilidad = bTipoUtilidad
End Function

Public Function CalcularUtilidad(Precio As Currency, Costo As Currency) As Currency
  If TipoUtilidad Then
    If Costo < 0.01 Then
      CalcularUtilidad = 0
    Else
      CalcularUtilidad = Precio / Costo * 100 - 100
    End If
  Else
    CalcularUtilidad = lmProporciones.CalcPDescuento(Precio, Costo)
  End If
End Function

Public Function CalcularPrecio(Costo As Currency, Utilidad As Currency) As Currency
  If TipoUtilidad Then
    CalcularPrecio = Costo * (1# + Utilidad / 100)
  Else
    If Utilidad = 100 Then
      CalcularPrecio = 0
    Else
      CalcularPrecio = Costo / (1# - (Utilidad / 100))
    End If
  End If
End Function

Public Function ValidarMargen(vMargen As Double) As Boolean
  If Not TipoUtilidad Then
    If vMargen > 100 Then
      ValidarMargen = False
    Else
      ValidarMargen = True
    End If
  Else
    ValidarMargen = True
  End If
End Function
