Attribute VB_Name = "mScriptsEntidad"
Option Explicit

'---------------------------------------------------------------------------------------
' Procedure : ScriptsEntidad
' DateTime  : 17/02/2005 21:15
' Author    : Leonardo Azpurua
' Purpose   : Ejecuta  un script desde la forma de interfaz de entidad
' ADVERTENCIA!
'   La forma, pasada en el segundo argumento (f), es pasada al script como "Forma"
'   DEBE CONTENER UN CommonDialog llamado CommonDialog1
'---------------------------------------------------------------------------------------
'
Public Sub ScriptsEntidad(ownerObject As Object, f As Form)
Dim fMenu As lfPopupMenu
Dim h As New CHistoriaScripts
Dim v As Variant

  Set fMenu = New lfPopupMenu
  v = h.MRUList("Scripts" & ownerObject.TipoEntidad)
  Dim i As Integer
  For i = 1 To UBound(v)
    fMenu.AddOption CStr(v(i)), True
  Next
  If UBound(v) > 0 Then fMenu.AddOption ""
  fMenu.AddOption "<Seleccionar>", True
  fMenu.Show vbModal
  i = fMenu.mnuResult
  If i = 0 Then Exit Sub
  Dim s As String
  s = fMenu.mnuOption(i)
  Unload fMenu
  If s = "<Seleccionar>" Then
    With f.CommonDialog1
    .InitDir = BuildDataPath("", AppName)
    .DialogTitle = "Seleccione el Script Deseado"
    .flags = cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist Or cdlOFNNoChangeDir
    .Filter = "VB Scripts|*.vbs"
    .FileName = BuildDataPath("*.vbs", AppName)
    .CancelError = True
    On Error Resume Next
    .ShowOpen
    If Err.Number Then
      Err.Clear
      Exit Sub
    End If
    
    s = .FileName
    End With
    If s = "" Then Exit Sub
    h.Add s, "Scripts" & ownerObject.TipoEntidad
  End If
  
  If mScriptExecute.LoadScriptFile(s, , False) Then
    pScript.AddObject "OwnerObject", ownerObject
    pScript.AddObject "Forma", f
    On Error GoTo ErrHandler
    pScript.Run "Main"
    If Err.Number Then Err.Clear
    pScript.Reset
  End If

ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, lErrN As Long
  sErrD = Err.Description: lErrN = Err.Number
  If pScript.Error.Number <> 0 Then
    MsgBox "ERROR EN ARCHIVO DE SCRIPT:" & vbCrLf & _
           "Numero: " & pScript.Error.Number & vbCrLf & _
           "Descripcion: " & pScript.Error.Description & vbCrLf & _
           "Linea: " & pScript.Error.Line & vbCrLf & _
           "Texto: " & pScript.Error.Text, vbCritical, s & ": ERROR EN SCRIPT"
  Else
    ReportarError False, lErrN, sErrD, "mScriptsEntidad:ScriptsEntidad::VB exec Error"
  End If
  pScript.Reset
  Resume ResumePoint
End Sub
