Attribute VB_Name = "mScriptForms"
Option Explicit

Public pScriptForms As ScriptControl

Public Sub LoadScript(pForm As Object)
Dim s As String, sFileName As String

  On Error GoTo ErrHandler

  If pScriptForms Is Nothing Then
    Set pScriptForms = CreateObject("ScriptControl")
    pScriptForms.AddObject "Factoria", New CFactoria
  End If

  pScriptForms.Modules.Add pForm.Name & pForm.hWnd
  sFileName = pForm.Name & ".vbs"
  s = sFileName
  If Dir(Trim(s)) = "" Then s = BuildDataPath(sFileName, AppName)
  If Dir(Trim(s)) = "" Then s = App.Path & "\" & sFileName
  If Dir(Trim(s)) = "" Then s = GetSetting(AppName, "General", "UbicacionScripts", "") & "\" & s
  If Dir(Trim(s)) Then
    Exit Sub
  End If
  
  s = File2String(s)
  If s <> "" Then
    pScriptForms.Modules(pForm.Name & pForm.hWnd).AddCode s
  End If

ResumePoint:
  Exit Sub

ErrHandler:
  Set pScriptForms = Nothing
  Resume ResumePoint
End Sub

Public Function ProcesarEvento(pForm As Form, sEvento As String, pControl As Control) As Boolean
Dim p As Object, isOk As Boolean

  If pScriptForms Is Nothing Then
    ProcesarEvento = True
    Exit Function
  End If

  On Error GoTo ErrHandler
  pScriptForms.Modules(pForm.Name & pForm.hWnd).Run "SetControl", pForm, pControl
  isOk = pForm.pScriptForms.Modules(pForm.Name & pForm.hWnd).Eval(sEvento)

ResumePoint:
  ProcesarEvento = isOk
  Exit Function

ErrHandler:
  isOk = True
  Resume ResumePoint

End Function
