Attribute VB_Name = "mParseInput"
Option Explicit

Private ParametrosInicializados As Boolean
Private bLabelHasWeight As Boolean
Private PrefixByWeight As String
Private PriceOffset As Integer      ' Posicin inicial del precio en la etiqueta
Private PriceLength As Integer      ' Longitud del campo precio
Private PriceScale As Integer       ' Posicin del punto decimal (desde la derecha)

Private qtyOffset As Integer        ' Posicion de las cantidades (si DatoBalanza = PESO)
Private qtyLength As Integer        ' Longitud del campo
Private qtyScale As Integer         ' Posicin del punto decimal (desde la derecha)
Private codeOffset As Integer
Private codeLength As Integer
Private lblPreffix As String

Private nRedondeoCantidad As Integer

Public nPrecioStandard As Integer

Public Sub LoadPrecioStandard()
  nPrecioStandard = Val(GetSetting("ClearLight", "General", "PrecioStandard", "1"))
  If nPrecioStandard < 1 Or nPrecioStandard > 4 Then nPrecioStandard = 1
End Sub

Public Function IndicePrecioStandard() As Integer
  IndicePrecioStandard = Val(GetSetting("ClearLight", "General", "PrecioStandard", "1"))
End Function

Private Sub ReadConfig()

  If ParametrosInicializados Then Exit Sub
  PrefixByWeight = GetSetting("ClearLight", "General", "PreffixWeight", "0123456789")
  qtyOffset = Val(GetSetting("ClearLight", "General", "QtyOffset", "7"))
  qtyLength = Val(GetSetting("ClearLight", "General", "QtyLength", "5"))
  qtyScale = Val(GetSetting("ClearLight", "General", "QtyScale", "3"))
  
  PriceOffset = Val(GetSetting("ClearLight", "General", "PriceOffset", "7"))
  PriceLength = Val(GetSetting("ClearLight", "General", "PriceLength", "5"))
  PriceScale = Val(GetSetting("ClearLight", "General", "PriceScale", "0"))
  
  codeOffset = Val(GetSetting("ClearLight", "General", "CodeOffset", "1"))
  codeLength = Val(GetSetting("ClearLight", "General", "CodeLength", "6"))

  If UCase(GetSetting(AppName, "General", "DatoBalanza", "PESO")) <> "PESO" Then
    bLabelHasWeight = False
  Else
    bLabelHasWeight = True
  End If
  
  nRedondeoCantidad = InStr(1, Empresa.MascaraCantidades, ".")
  If (nRedondeoCantidad > 0) Then
    nRedondeoCantidad = Len(Empresa.MascaraCantidades) - nRedondeoCantidad
  Else
    nRedondeoCantidad = 0
  End If
  LoadPrecioStandard
  lblPreffix = GetSetting("ClearLight", "General", "PrefijoBalanza", "")

  ParametrosInicializados = True

End Sub

' La suposicion de que 2{n}*M {M > 12} slo es vlida para cdigos UPC o EAN.
' detecta la presencia de caracteres no vlidos en UPC o EAN para descartar
        Private Function SoloNumeros(s As String) As Boolean
        Dim i As Integer, l As Integer
          l = Len(s)
          For i = 1 To l
            If Mid(s, i, 1) < "0" Or Mid(s, i, 1) > "9" Then
              SoloNumeros = False
              Exit Function
            End If
          Next
          SoloNumeros = True
        End Function

Public Function ParseInput(istrInput As String, ostrCodigoProducto As String, odblCantidad As Double) As Boolean
Dim stCodigoProducto As String, dblCantidad As Double
Dim stc2 As String, pItemVenta As New clsItemVenta, isOk As Boolean

  ' Configuracin de parmetros de la balanza
  If Not ParametrosInicializados Then
    ReadConfig
  End If
  
  stCodigoProducto = AlmacenAlternos.Translate(istrInput)
  ostrCodigoProducto = stCodigoProducto
  If pItemVenta.Load(stCodigoProducto) Then
    ostrCodigoProducto = stCodigoProducto
    odblCantidad = 1
    ParseInput = True
    Exit Function
  End If

  If lblPreffix <> "" Then
    If lblPreffix <> left(istrInput, Len(lblPreffix)) Then
      ParseInput = False
      Exit Function
    End If
  End If

  If Len(istrInput) >= 12 And SoloNumeros(istrInput) Then
    stCodigoProducto = Mid(istrInput, codeOffset, codeLength)
    stCodigoProducto = AlmacenAlternos.Translate(stCodigoProducto)
    If pItemVenta.Load(stCodigoProducto) Then
      If bLabelHasWeight Then
        stc2 = Mid(stCodigoProducto, 2, 1)
        If InStr(1, PrefixByWeight, stc2, vbTextCompare) <> 0 Then
          dblCantidad = Val(Mid(istrInput, qtyOffset, qtyLength)) / (10 ^ qtyScale)
        Else
          dblCantidad = Val(Mid(istrInput, qtyOffset, qtyLength)) ' 230001 00375 9; 230001 00003 1
          If dblCantidad = 0 Then dblCantidad = 1
          If dblCantidad > 36 Then
              mAdvertencia "Etiqueta invlida"
              ParseInput = False
              Exit Function
          End If
        End If
      Else
        dblCantidad = Val(Mid(istrInput, PriceOffset, PriceLength)) / (10 ^ PriceScale)
        dblCantidad = dblCantidad / (pItemVenta.PrecioNeto(nPrecioStandard) * (1# + pItemVenta.PorcentajeImpuesto(1) / 100))
      End If
      ostrCodigoProducto = stCodigoProducto
      odblCantidad = dblCantidad
      ParseInput = True
      Exit Function
    End If
  End If
  
  stCodigoProducto = istrInput
  dblCantidad = 1

  stCodigoProducto = AlmacenAlternos.Translate(stCodigoProducto)
  ostrCodigoProducto = stCodigoProducto

  isOk = pItemVenta.Load(stCodigoProducto)
  If isOk Then
    dblCantidad = Int(dblCantidad * (10 ^ nRedondeoCantidad) + 0.5) / (10 ^ nRedondeoCantidad)
    ostrCodigoProducto = stCodigoProducto
    odblCantidad = dblCantidad
  End If

  ParseInput = isOk

End Function
