Attribute VB_Name = "mMain"
Option Explicit

Public Const HIGH_VALUE = 999999999999#

Public Const TMB_CHEQUE = 0
Public Const TMB_DEPOSITO = 1
Public Const TMB_NCR = 2
Public Const TMB_NDB = 3

Public Const CONTEXTO_FACTURA = 1
Public Const CONTEXTO_COTIZACION = 2
Public Const CONTEXTO_ORDEN = 2
Public Const CONTEXTO_NNEE = 3
Public Const CONTEXTO_OPSNE = 4
Public Const CONTEXTO_FACTNE = 5
Public Const CONTEXTO_DEVNE = 6

Enum enmEstadosEquipo
    NUEVO = 0
    Recibido = 1
    ASIGNADO = 2
    REPARADO = 3
    ENTREGADO = 4
End Enum

Enum TipoProceso
    TP_NO_PROCESAR = 0
    TP_ENTREGA_INMEDIATA = 1
    TP_ORDEN_DESPACHO = 2
    TP_ORDEN_TRANSPORTE = 3
End Enum

Enum EstadosTrabajo
    LIBRE = 0
    ABIERTA = 1
    Cerrada = 2
End Enum

Public Serial As Long

Public AlmacenItemsVenta As clsAlmacenItemsVenta, _
        AlmacenAlternos As clsAlmacenAlternosItemVenta, _
        AlmacenComposiciones As clsAlmacenCompItemsVnt, _
        AlmacenItemsInventario As clsAlmacenItemsInventario, _
        AlmacenBancos As clsAlmacenBancos, _
        AlmacenCuentas As clsAlmacenCuentas, _
        AlmacenPrefijos As clsAlmacenPrefijos, _
        AlmacenClientes As clsAlmacenClientes, _
        AlmacenProveedores As clsAlmacenProveedores, _
        AlmacenContactos As clsAlmacenContactos, _
        AlmacenVendedores As clsAlmacenVendedores, _
        AlmacenExUbic As clsAlmacenExUbic, _
        Almacenes As clsAlmacenes, _
        Empresa As clsParametrosEmpresa, _
        Series As clsSeries, _
        AlmacenFacturas As clsAlmacenFacturas, _
        AlmacenDetallesFactura As clsAlmacenDetallesFactura, _
        AlmacenDetallesItemVenta As clsAlmacenDetallesItemVenta, _
        AlmacenIndicadores As clsAlmacenIndicadores

Public AlmacenDetallesItemInv As clsAlmacenDetallesItemInv, _
        AlmacenCompAlmacen As clsAlmacenCompAlmacen, _
        AlmacenMINVS As clsAlmacenDetallesItemInv

Public AlmacenSaldosEntidad As clsAlmacenSaldosEntidad, _
        AlmacenDocumentosISPC As clsAlmacenDocumentosISPC, _
        AlmacenDetallesEntidad As clsAlmacenDetallesEntidad, _
        AlmacenVencimientosISPC As clsAlmacenVencISPC

Public Lineas As clsTablasCodigo

Public Zonas As clsTablasCodigo
Public TiposCliente As clsTablasCodigo

Public AlmacenCompras As clsAlmacenCompras
Public AlmacenDetallesCompra As clsAlmacenDetallesCompra

Public Condiciones As clsCondiciones
Public TiposImpuesto As clsTiposImpuesto

Public AlmacenSaldos As clsAlmacenSaldos
Public AlmacenComprobantes As clsAlmacenComprobantes
Public AlmacenDetalles As clsAlmacenDetalles

Public Sesiones As clsSesionesPOS
Public CuentasPOS As clsCuentasPOS

Public pfNav As Object

Public Tarjetas As clsTarjetas

Public poleEnabled As Boolean

Public MontoRecibido As Double, Vuelto As Double    ' Para POS
Public SesionActiva As clsSesionPOS
Public pDisplay As CDisplay

Public MontoServicioDelivery As Currency
Public Contadores As CContadores
Public UsarVINVS As Boolean
Public pScriptPOS As Object

Public Function FormatoPrecios() As String
    
    FormatoPrecios = Empresa.MascaraPrecios

End Function

Public Function FormatoExistencia() As String
    
    FormatoExistencia = Empresa.MascaraCantidades

End Function

Private Sub InstanciarAlmacenes()
    Set AlmacenItemsVenta = New clsAlmacenItemsVenta
    Set AlmacenAlternos = New clsAlmacenAlternosItemVenta
    Set AlmacenComposiciones = New clsAlmacenCompItemsVnt
    Set AlmacenItemsInventario = New clsAlmacenItemsInventario
    Set AlmacenBancos = New clsAlmacenBancos
    Set AlmacenCuentas = New clsAlmacenCuentas
    Set AlmacenPrefijos = New clsAlmacenPrefijos
    Set AlmacenClientes = New clsAlmacenClientes
    Set AlmacenSaldos = New clsAlmacenSaldos
    Set AlmacenComprobantes = New clsAlmacenComprobantes
    Set AlmacenDetalles = New clsAlmacenDetalles
    Set AlmacenProveedores = New clsAlmacenProveedores
    Set Empresa = New clsParametrosEmpresa
    Set AlmacenContactos = New clsAlmacenContactos
    Set AlmacenVendedores = New clsAlmacenVendedores
    Set Almacenes = New clsAlmacenes
    Set AlmacenExUbic = New clsAlmacenExUbic
    Set Series = New clsSeries
    Set AlmacenFacturas = New clsAlmacenFacturas
    Set AlmacenDetallesFactura = New clsAlmacenDetallesFactura
    Set TiposImpuesto = New clsTiposImpuesto
    Set Condiciones = New clsCondiciones
    Set AlmacenDetallesItemVenta = New clsAlmacenDetallesItemVenta
    Set AlmacenCompAlmacen = New clsAlmacenCompAlmacen
    Set AlmacenMINVS = New clsAlmacenDetallesItemInv
    Set AlmacenSaldosEntidad = New clsAlmacenSaldosEntidad
    Set AlmacenDocumentosISPC = New clsAlmacenDocumentosISPC
    Set AlmacenDetallesEntidad = New clsAlmacenDetallesEntidad
    Set AlmacenVencimientosISPC = New clsAlmacenVencISPC
    Set AlmacenCompras = New clsAlmacenCompras
    Set AlmacenDetallesCompra = New clsAlmacenDetallesCompra
    Set Lineas = New clsTablasCodigo: Lineas.SetTableName "Lineas", "Lineas de Productos", "Linea de Productos"
    Set Zonas = New clsTablasCodigo: Zonas.SetTableName "Zonas", "Zonas", "Zona"
    Set TiposCliente = New clsTablasCodigo: TiposCliente.SetTableName "TiposCliente", "Tipos de cliente", "Tipo de cliente"
    Set Sesiones = New clsSesionesPOS
    Set Tarjetas = New clsTarjetas

End Sub

Private Sub DestruirAlmacenes()
    Set Tarjetas = Nothing
    Set Sesiones = Nothing
    Set TiposCliente = Nothing
    Set Zonas = Nothing
    Set Lineas = Nothing
    Set AlmacenDetallesCompra = Nothing
    Set AlmacenCompras = Nothing
    Set AlmacenVencimientosISPC = Nothing
    Set AlmacenDetallesEntidad = Nothing
    Set AlmacenDocumentosISPC = Nothing
    Set AlmacenSaldosEntidad = Nothing
    Set AlmacenMINVS = Nothing
    Set AlmacenCompAlmacen = Nothing
    Set AlmacenDetallesItemVenta = Nothing
    Set Condiciones = Nothing
    Set TiposImpuesto = Nothing
    Set AlmacenDetallesFactura = Nothing
    Set AlmacenFacturas = Nothing
    Set Series = Nothing
    Set AlmacenExUbic = Nothing
    Set Almacenes = Nothing
    Set AlmacenVendedores = Nothing
    Set AlmacenContactos = Nothing
    Set Empresa = Nothing
    Set AlmacenProveedores = Nothing
    Set AlmacenClientes = Nothing
    Set AlmacenPrefijos = Nothing
    Set AlmacenCuentas = Nothing
    Set AlmacenBancos = Nothing
    Set AlmacenItemsInventario = Nothing
    Set AlmacenComposiciones = Nothing
    Set AlmacenAlternos = Nothing
    Set AlmacenItemsVenta = Nothing
    Set AlmacenDetalles = Nothing
    Set AlmacenComprobantes = Nothing
    Set AlmacenSaldos = Nothing
    Set SesionActiva = Nothing

End Sub


Public Sub PrepararEntorno()
Dim fLogin As LFGetUser, lrefPeriodo As Long
Dim isSuper As Boolean

    Set dbHandle = OpenDatabase(BuildDataPath("bo01.mdb", AppName))

    Set fLogin = New LFGetUser
    
    fLogin.Show 1
    UsuarioActivo.Codigo = fLogin.txCodigo.Text
    
    If Val(fLogin.txClave.Text) = ClaveEspecial Then
        isSuper = True
    Else
        isSuper = False
    End If
    
    If UsuarioActivo.Codigo = "" Then
        dbHandle.Close
        End
    End If
    Unload fLogin
    Set fLogin = Nothing
    lmUsuarios.LeerUsuario UsuarioActivo.Codigo
    UsuarioActivo = lmUsuarios.cUsuario
    
    If isSuper Then UsuarioActivo.Nivel = 99

    If Not EstaAutorizado(UsuarioActivo.Codigo, CERRAR_SESION) Then
        mAdvertencia "Acceso denegado"
        End
    End If

    Set Contadores = New CContadores
    InstanciarAlmacenes

'     mainForm.Caption = "CLEAR, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
'     Printer.Font.Name = "Courier New"

End Sub

Private Sub PerformCierresX()
Dim rs As Recordset

    mAdvertencia "ADVERTENCIA!" & vbCrLf & "El siguiente proceso cierra todas las sesiones abiertas en este terminal"
    If Not Confirmar("Desea continuar", True) Then
        End
    End If

    Set rs = dbHandle.OpenRecordset("SELECT SessionID FROM SesionesPOS WHERE FacturasRealizadas > 0 AND Cerrada = 0 AND MachineID = " & NumeroDB(MachineID), dbOpenForwardOnly)

    If rs.EOF Then
        mAdvertencia "No hay sesiones abiertas"
    Else

        StartTransaction
        dbHandle.Execute "UPDATE SesionesPOS SET Cerrada = 1 WHERE  FacturasRealizadas > 0 AND MachineID = " & NumeroDB(mMachineID.MachineID), dbFailOnError
        If Confirmar("Desea registrar los cambios") Then
            CommitTransaction
        Else
            AbortTransaction
        End If
    
    End If
    Set rs = Nothing

End Sub

Sub Main()
Dim frmCierre As frmCierresZ

    vslib.AppName = "ClearLight"
    Splash.Show 1
    Unload Splash

    CheckKey AppName
    
    Serial = mKeyGenerator.Serial(GetSetting(AppName, "General", "Serial", "INVALIDA"))
    UsarVINVS = Val(GetSetting("ClearLight", "General", "UsarVINV", "0"))
    
    Set pDisplay = New CDisplay

    PrepararEntorno
    
    Set pScript = CreateObject("ScriptControl")
    pScript.Language = "VBScript"
    pScript.Reset
    Set pScriptPOS = CreateObject("ScriptControl")
    pScriptPOS.Language = "VBScript"
    pScriptPOS.Reset
    
    PerformCierresX
    Set frmCierre = New frmCierresZ
    frmCierre.RestrictTerminal
    ShowNonModal frmCierre
    Unload frmCierre
    Set frmCierre = Nothing
    DestruirAlmacenes

End Sub
