Attribute VB_Name = "mMain"
Option Explicit

Enum EstadosTrabajo
    LIBRE = 0
    ABIERTA = 1
    Cerrada = 2
End Enum

Enum TipoProceso
    TP_NO_PROCESAR = 0
    TP_ENTREGA_INMEDIATA = 1
    TP_ORDEN_DESPACHO = 2
    TP_ORDEN_TRANSPORTE = 3
End Enum

Public Const HIGH_VALUE = 999999999999#
Public Const TMB_CHEQUE = 0
Public Const TMB_DEPOSITO = 1
Public Const TMB_NCR = 2
Public Const TMB_NDB = 3

Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Public ServiciosCaja As New CServiciosCaja
Public MontoServicioDelivery As Currency
Public MaximoDescuento As Double
Public Contadores As CContadores
Public formaWSM As frmMonitorCajas

Public Serial As Long

Public AlmacenAmbientes As clsAlmacenAmbientes

Public AlmacenItemsVenta As clsAlmacenItemsVenta, _
        AlmacenAlternos As clsAlmacenAlternosItemVenta, _
        AlmacenComposiciones As clsAlmacenCompItemsVnt, _
        AlmacenItemsInventario As clsAlmacenItemsInventario, _
        AlmacenPrefijos As clsAlmacenPrefijos, _
        AlmacenClientes As clsAlmacenClientes, _
        AlmacenContactos As clsAlmacenContactos, _
        AlmacenVendedores As clsAlmacenVendedores, _
        AlmacenExUbic As clsAlmacenExUbic, _
        Almacenes As clsAlmacenes, _
        Empresa As clsParametrosEmpresa, _
        AlmacenProveedores As clsAlmacenProveedores

Public AlmacenCuentas As clsAlmacenCuentas
Public AlmacenComprobantes As clsAlmacenComprobantes

Public AlmacenDetallesItemInv As clsAlmacenDetallesItemInv, _
        AlmacenCompAlmacen As clsAlmacenCompAlmacen, _
        AlmacenMINVS As clsAlmacenDetallesItemInv, _
        AlmacenDetallesItemVenta As clsAlmacenDetallesItemVenta

Public AlmacenSaldosEntidad As clsAlmacenSaldosEntidad, _
        AlmacenDocumentosISPC As clsAlmacenDocumentosISPC, _
        AlmacenDetallesEntidad As clsAlmacenDetallesEntidad, _
        AlmacenVencimientosISPC As clsAlmacenVencISPC

Public Lineas As clsTablasCodigo

Public Zonas As clsTablasCodigo
Public TiposCliente As clsTablasCodigo

Public Condiciones As clsCondiciones
Public TiposImpuesto As clsTiposImpuesto

Public AlmacenSaldos As clsAlmacenSaldos
Public AlmacenDetalles As clsAlmacenDetalles

Public Sesiones As clsSesionesPOS
Public CuentasPOS As clsCuentasPOS

Public pfNav As Object

Public pDisplay As CDisplay

Public MontoRecibido As Currency, Vuelto As Currency    ' Para POS
Public SesionActiva As clsSesionPOS
Public pScriptPOS As Object

Public Function FormatoPrecios() As String
    FormatoPrecios = Empresa.MascaraPrecios
End Function

Public Function FormatoExistencia() As String
    FormatoExistencia = Empresa.MascaraCantidades
End Function

Private Sub InstanciarAlmacenes()
  Set Contadores = New CContadores
  Set AlmacenAmbientes = New clsAlmacenAmbientes
  Set AlmacenItemsVenta = New clsAlmacenItemsVenta
  Set AlmacenAlternos = New clsAlmacenAlternosItemVenta
  Set AlmacenComposiciones = New clsAlmacenCompItemsVnt
  Set AlmacenItemsInventario = New clsAlmacenItemsInventario
  Set AlmacenPrefijos = New clsAlmacenPrefijos
  Set AlmacenClientes = New clsAlmacenClientes
  Set AlmacenSaldos = New clsAlmacenSaldos
  Set AlmacenDetalles = New clsAlmacenDetalles
  Set Empresa = New clsParametrosEmpresa
  Set AlmacenContactos = New clsAlmacenContactos
  Set AlmacenVendedores = New clsAlmacenVendedores
  Set Almacenes = New clsAlmacenes
  Set AlmacenExUbic = New clsAlmacenExUbic
  Set TiposImpuesto = New clsTiposImpuesto
  Set Condiciones = New clsCondiciones
  Set AlmacenCompAlmacen = New clsAlmacenCompAlmacen
  Set AlmacenMINVS = New clsAlmacenDetallesItemInv
  Set AlmacenDetallesItemVenta = New clsAlmacenDetallesItemVenta
  Set AlmacenSaldosEntidad = New clsAlmacenSaldosEntidad
  Set AlmacenDocumentosISPC = New clsAlmacenDocumentosISPC
  Set AlmacenDetallesEntidad = New clsAlmacenDetallesEntidad
  Set AlmacenVencimientosISPC = New clsAlmacenVencISPC
  Set Lineas = New clsTablasCodigo: Lineas.SetTableName "Lineas", "Lineas de Inventario", "Linea de Inventario"
  Set Zonas = New clsTablasCodigo: Zonas.SetTableName "Zonas", "Zonas", "Zona"
  Set TiposCliente = New clsTablasCodigo: TiposCliente.SetTableName "TiposCliente", "Tipos de cliente", "Tipo de cliente"
  Set AlmacenCuentas = New clsAlmacenCuentas
  Set AlmacenComprobantes = New clsAlmacenComprobantes
  Set AlmacenProveedores = New clsAlmacenProveedores
End Sub

Private Sub DestruirAlmacenes()
  Set AlmacenProveedores = Nothing
  Set AlmacenCuentas = Nothing
  Set AlmacenComprobantes = Nothing
  Set Sesiones = Nothing
  Set TiposCliente = Nothing
  Set Zonas = Nothing
  Set Lineas = Nothing
  Set AlmacenVencimientosISPC = Nothing
  Set AlmacenDetallesEntidad = Nothing
  Set AlmacenDocumentosISPC = Nothing
  Set AlmacenSaldosEntidad = Nothing
  Set AlmacenMINVS = Nothing
  Set AlmacenCompAlmacen = Nothing
  Set Condiciones = Nothing
  Set TiposImpuesto = Nothing
  Set AlmacenExUbic = Nothing
  Set Almacenes = Nothing
  Set AlmacenVendedores = Nothing
  Set AlmacenContactos = Nothing
  Set Empresa = Nothing
  Set AlmacenClientes = Nothing
  Set AlmacenPrefijos = Nothing
  Set AlmacenItemsInventario = Nothing
  Set AlmacenDetallesItemVenta = Nothing
  Set AlmacenComposiciones = Nothing
  Set AlmacenAlternos = Nothing
  Set AlmacenItemsVenta = Nothing
  Set AlmacenDetalles = Nothing
  Set AlmacenSaldos = Nothing
  Set SesionActiva = Nothing
  Set AlmacenAmbientes = Nothing
  Set Contadores = Nothing
End Sub

Private Function VerificarDirectorioDatos() As Boolean
Dim stTemp As String, orgCancelError As Boolean
    
    stTemp = GetSetting(AppName:=AppName, Section:="General", Key:="DataDir", Default:="UNDEF")
    VerificarDirectorioDatos = True
    
    Exit Function

End Function

Public Sub PrepararEntorno()
Dim lrefPeriodo As Long, sAlmacen As String
Dim pDataSet As CDataSet
Dim fLogin As LFGetUser

  On Error GoTo ErrHandler
  Set pDataSet = New CDataSet
  Set pDataSet = pDataSet.item(Val(GetSetting(AppName, "General", "UltimoDataSet", "-1")))
  If pDataSet Is Nothing Then
    mAdvertencia "Conjunto de datos no definido"
    End
  End If
  
  Set dbHandle = New ADODB.Connection
  With dbHandle
  .Open pDataSet.sConnect
  .CursorLocation = adUseClient
'  DataDir = pDataSet.sDataDir
  End With

  Set fLogin = New LFGetUser
  
  fLogin.Show 1
  UsuarioActivo.Codigo = fLogin.txCodigo.Text
  If UsuarioActivo.Codigo = "" Then
    dbHandle.Close
    End
  End If
  Unload fLogin
  Set fLogin = Nothing
  lmUsuarios.LeerUsuario UsuarioActivo.Codigo
  UsuarioActivo = lmUsuarios.cUsuario
  If Not EstaAutorizado(UsuarioActivo.Codigo, CERRAR_SESION) Then
    If UsuarioActivo.Nivel < 5 Then
      mAdvertencia "Acceso no autorizado: lo siento"
      dbHandle.Close
      End
    End If
  End If
        
  InstanciarAlmacenes
    
  Set SesionActiva = New clsSesionPOS
  Set Sesiones = New clsSesionesPOS

  If Not SesionActiva.IniciarSesion(UsuarioActivo.Codigo) Then
    dbHandle.Close
    End
  End If

'  mainForm.Caption = "CLEAR, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
'     Printer.Font.Name = "Courier New"

  Exit Sub
ErrHandler:
  If Err.Number = 3024 Then
    mAdvertencia "ERROR: No puedo localizar la Base de Datos" & Chr(13) & _
                 "en la ubicacin especificada... Por favor, intentelo de nuevo" & Chr(13) & _
                 "(" & BuildDataPath("bo01.mdb", AppName) & ")"
    End
  Else
    On Error GoTo 0
    Resume
  End If
End Sub

Sub Main()

  If App.PrevInstance Then
    MsgBox "Ya tiene una copia del programa en ejecucin"
    End
  End If

  VSLIB.AppName = "ClearLight"
  Splash.Show 1
  Unload Splash

  MontoServicioDelivery = Val(GetSetting("ClearLight", "General", "ValorDelivery", "0"))
  MaximoDescuento = Val(GetSetting("ClearLight", "General", "MaximoDescuento", "0"))
  nPrecioStandard = Val(GetSetting("ClearLight", "General", "PrecioStandard", "1"))
  
  If Not isKeyValid(GetSetting(AppName, "General", "Serial", "INVALIDA")) Then
    mAdvertencia "Clave de activacin invlida"
    End
  End If
  Serial = VSLIB.Serial(GetSetting(AppName, "General", "Serial", "INVALIDA"))

  PrepararEntorno
  Set formaWSM = New frmMonitorCajas
  ShowNonModal formaWSM
  Unload formaWSM
  Set formaWSM = Nothing
  DestruirAlmacenes
  dbHandle.Close
  Set dbHandle = Nothing
End Sub

