Attribute VB_Name = "mMain"
Option Explicit

Public Declare Sub Sleep Lib "Kernel32" (ByVal dwMilliseconds As Long)
Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public Const HIGH_VALUE = 999999999999#

Public Const TMB_CHEQUE = 0
Public Const TMB_DEPOSITO = 1
Public Const TMB_NCR = 2
Public Const TMB_NDB = 3

Public Const CONTEXTO_FACTURA = 1
Public Const CONTEXTO_COTIZACION = 2
Public Const CONTEXTO_ORDEN = 2
Public Const CONTEXTO_NNEE = 3
Public Const CONTEXTO_OPSNE = 4
Public Const CONTEXTO_FACTNE = 5
Public Const CONTEXTO_DEVNE = 6

Enum enmEstadosEquipo
    NUEVO = 0
    Recibido = 1
    ASIGNADO = 2
    REPARADO = 3
    ENTREGADO = 4
End Enum

Enum TipoProceso
    TP_NO_PROCESAR = 0
    TP_ENTREGA_INMEDIATA = 1
    TP_ORDEN_DESPACHO = 2
    TP_ORDEN_TRANSPORTE = 3
End Enum

Enum EstadosTrabajo
    LIBRE = 0
    ABIERTA = 1
    Cerrada = 2
End Enum

Public Contadores As CContadores
Public Serial As Long
Public UsarVINVS As Boolean
Public pDisplay As CDisplay
Public MontoServicioDelivery As Currency

Public AlmacenItemsVenta As clsAlmacenItemsVenta, _
        AlmacenAlternos As clsAlmacenAlternosItemVenta, _
        AlmacenComposiciones As clsAlmacenCompItemsVnt, _
        AlmacenItemsInventario As clsAlmacenItemsInventario, _
        AlmacenBancos As clsAlmacenBancos, _
        AlmacenCuentas As clsAlmacenCuentas, _
        AlmacenPrefijos As clsAlmacenPrefijos, _
        AlmacenClientes As clsAlmacenClientes, _
        AlmacenProveedores As clsAlmacenProveedores, _
        AlmacenContactos As clsAlmacenContactos, _
        AlmacenVendedores As clsAlmacenVendedores, _
        AlmacenExUbic As clsAlmacenExUbic, _
        Almacenes As clsAlmacenes, _
        Empresa As clsParametrosEmpresa, _
        Series As clsSeries, _
        AlmacenFacturas As clsAlmacenFacturas, _
        AlmacenDetallesFactura As clsAlmacenDetallesFactura, _
        AlmacenDetallesItemVenta As clsAlmacenDetallesItemVenta, _
        AlmacenIndicadores As clsAlmacenIndicadores

Public AlmacenDetallesItemInv As clsAlmacenDetallesItemInv, _
        AlmacenCompAlmacen As clsAlmacenCompAlmacen, _
        AlmacenMINVS As clsAlmacenDetallesItemInv

Public AlmacenSaldosEntidad As clsAlmacenSaldosEntidad, _
        AlmacenDocumentosISPC As clsAlmacenDocumentosISPC, _
        AlmacenDetallesEntidad As clsAlmacenDetallesEntidad, _
        AlmacenVencimientosISPC As clsAlmacenVencISPC

Public AlmacenAmbientes As clsAlmacenAmbientes
Public Lineas As clsTablasCodigo

Public Zonas As clsTablasCodigo
Public TiposCliente As clsTablasCodigo
Public TiposEquipo As clsTablasCodigo

Public AlmacenCompras As clsAlmacenCompras
Public AlmacenDetallesCompra As clsAlmacenDetallesCompra

Public Condiciones As clsCondiciones
Public TiposImpuesto As clsTiposImpuesto

Public AlmacenSaldos As clsAlmacenSaldos
Public AlmacenComprobantes As clsAlmacenComprobantes
Public AlmacenDetalles As clsAlmacenDetalles

Public Sesiones As clsSesionesPOS
Public CuentasPOS As clsCuentasPOS

Public pfNav As Object

Public Tarjetas As clsTarjetas
Public pScriptPOS As Object

Public poleEnabled As Boolean

Public MontoRecibido As Double, Vuelto As Double    ' Para POS
Public SesionActiva As clsSesionPOS

Public Function FormatoPrecios() As String
    
    FormatoPrecios = Empresa.MascaraPrecios

End Function

Public Function FormatoExistencia() As String
    
    FormatoExistencia = Empresa.MascaraCantidades

End Function

Private Sub InstanciarAlmacenes()
  Set Contadores = New CContadores
  Set AlmacenItemsVenta = New clsAlmacenItemsVenta
  Set AlmacenAlternos = New clsAlmacenAlternosItemVenta
  Set AlmacenComposiciones = New clsAlmacenCompItemsVnt
  Set AlmacenItemsInventario = New clsAlmacenItemsInventario
  Set AlmacenBancos = New clsAlmacenBancos
  Set AlmacenCuentas = New clsAlmacenCuentas
  Set AlmacenPrefijos = New clsAlmacenPrefijos
  Set AlmacenClientes = New clsAlmacenClientes
  Set AlmacenSaldos = New clsAlmacenSaldos
  Set AlmacenComprobantes = New clsAlmacenComprobantes
  Set AlmacenDetalles = New clsAlmacenDetalles
  Set AlmacenProveedores = New clsAlmacenProveedores
  Set Empresa = New clsParametrosEmpresa
  Set AlmacenContactos = New clsAlmacenContactos
  Set AlmacenVendedores = New clsAlmacenVendedores
  Set Almacenes = New clsAlmacenes
  Set AlmacenExUbic = New clsAlmacenExUbic
  Set Series = New clsSeries
  Set AlmacenFacturas = New clsAlmacenFacturas
  Set AlmacenDetallesFactura = New clsAlmacenDetallesFactura
  Set TiposImpuesto = New clsTiposImpuesto
  Set Condiciones = New clsCondiciones
  Set AlmacenDetallesItemVenta = New clsAlmacenDetallesItemVenta
  Set AlmacenCompAlmacen = New clsAlmacenCompAlmacen
  Set AlmacenMINVS = New clsAlmacenDetallesItemInv
  Set AlmacenSaldosEntidad = New clsAlmacenSaldosEntidad
  Set AlmacenDocumentosISPC = New clsAlmacenDocumentosISPC
  Set AlmacenDetallesEntidad = New clsAlmacenDetallesEntidad
  Set AlmacenVencimientosISPC = New clsAlmacenVencISPC
  Set AlmacenCompras = New clsAlmacenCompras
  Set AlmacenDetallesCompra = New clsAlmacenDetallesCompra
  Set Lineas = New clsTablasCodigo: Lineas.SetTableName "Lineas", "Lineas de Productos", "Linea de Productos"
  Set Zonas = New clsTablasCodigo: Zonas.SetTableName "Zonas", "Zonas", "Zona"
  Set TiposCliente = New clsTablasCodigo: TiposCliente.SetTableName "TiposCliente", "Tipos de cliente", "Tipo de cliente"
  Set Tarjetas = New clsTarjetas
  Set TiposEquipo = New clsTablasCodigo: TiposEquipo.SetTableName "rwsTiposEquipo", "Tipos de equipo", "Tipo de equipo"
  Set AlmacenAmbientes = New clsAlmacenAmbientes
  
  mainForm.MC_CONTAB.Enabled = Empresa.UsaContabilidad
  mainForm.MC_REPCONT.Enabled = Empresa.UsaContabilidad

End Sub

Private Sub DestruirAlmacenes()

  Set AlmacenAmbientes = Nothing
  Set TiposEquipo = Nothing
  Set Tarjetas = Nothing
  Set Sesiones = Nothing
  Set TiposCliente = Nothing
  Set Zonas = Nothing
  Set Lineas = Nothing
  Set AlmacenDetallesCompra = Nothing
  Set AlmacenCompras = Nothing
  Set AlmacenVencimientosISPC = Nothing
  Set AlmacenDetallesEntidad = Nothing
  Set AlmacenDocumentosISPC = Nothing
  Set AlmacenSaldosEntidad = Nothing
  Set AlmacenMINVS = Nothing
  Set AlmacenCompAlmacen = Nothing
  Set AlmacenDetallesItemVenta = Nothing
  Set Condiciones = Nothing
  Set TiposImpuesto = Nothing
  Set AlmacenDetallesFactura = Nothing
  Set AlmacenFacturas = Nothing
  Set Series = Nothing
  Set AlmacenExUbic = Nothing
  Set Almacenes = Nothing
  Set AlmacenVendedores = Nothing
  Set AlmacenContactos = Nothing
  Set Empresa = Nothing
  Set AlmacenProveedores = Nothing
  Set AlmacenClientes = Nothing
  Set AlmacenPrefijos = Nothing
  Set AlmacenCuentas = Nothing
  Set AlmacenBancos = Nothing
  Set AlmacenItemsInventario = Nothing
  Set AlmacenComposiciones = Nothing
  Set AlmacenAlternos = Nothing
  Set AlmacenItemsVenta = Nothing
  Set AlmacenDetalles = Nothing
  Set AlmacenComprobantes = Nothing
  Set AlmacenSaldos = Nothing
  Set SesionActiva = Nothing
  Set Contadores = Nothing
End Sub

Private Function VerificarDirectorioDatos() As Boolean
Dim stTemp As String, orgCancelError As Boolean
    
    stTemp = GetSetting(AppName:=AppName, Section:="General", Key:="DataDir", Default:="UNDEF")
    If stTemp = "UNDEF" Then
        mainForm.CommonDialog1.InitDir = "\"
    Else
        mainForm.CommonDialog1.InitDir = stTemp
    End If

    mainForm.CommonDialog1.DialogTitle = "ClearLight: Seleccione el archivo deseado"
    mainForm.CommonDialog1.FileName = "bo01.mdb"
    mainForm.CommonDialog1.flags = cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist ' Or cdlOFNExplorer
    mainForm.CommonDialog1.Filter = "Bases de Datos de Clear Light|bo01.mdb"
    orgCancelError = mainForm.CommonDialog1.CancelError
    mainForm.CommonDialog1.CancelError = True
    
    On Error GoTo ErrHandler
    mainForm.CommonDialog1.ShowOpen
    
    mainForm.CommonDialog1.CancelError = orgCancelError
    stTemp = left(mainForm.CommonDialog1.FileName, Len(mainForm.CommonDialog1.FileName) - Len(mainForm.CommonDialog1.FileTitle))
    
    SaveSetting AppName:=AppName, Section:="General", Key:="DataDir", Setting:=stTemp

    VerificarDirectorioDatos = True
    
    Exit Function

ErrHandler:
    If Err.Number = cdlCancel Then
        Err.Clear
        VerificarDirectorioDatos = False
        mainForm.CommonDialog1.CancelError = False
        Exit Function
    End If

    ReportarError True, Err.Number, Err.Description, "mMain::VerificarDirectorioDatos"
    End

End Function

Public Sub PrepararEntorno(Optional sCommand As String = "")
Dim fLogin As LFGetUser, lrefPeriodo As Long, sFileName As String

    DestruirAlmacenes
    
CheckDataDir:
    If sCommand <> "" Then
'      MsgBox sCommand
      sFileName = sCommand
      If left(sFileName, 1) = """" Then sFileName = right(sFileName, Len(sFileName) - 1)
      If right(sFileName, 1) = """" Then sFileName = left(sFileName, Len(sFileName) - 1)
      If Dir(sFileName) <> "" Then
        For lrefPeriodo = Len(sFileName) - 1 To 1 Step -1
          If Mid(sFileName, lrefPeriodo, 1) = "\" Then
            SaveSetting AppName, "General", "DataDir", left(sFileName, lrefPeriodo - 1)
            Exit For
          End If
        Next
      End If
    Else
      If Not VerificarDirectorioDatos Then
        If mainForm.Visible Then mainForm.Hide
        End
      End If
      sFileName = BuildDataPath("bo01.mdb", AppName)
    End If

    On Error GoTo ErrHandler
    Set dbHandle = OpenDatabase(sFileName)

    Set fLogin = New LFGetUser
    
    fLogin.Show 1
    UsuarioActivo.Codigo = fLogin.txCodigo.Text
    If UsuarioActivo.Codigo = "" Then
        dbHandle.Close
        End
    End If
    Unload fLogin
    Set fLogin = Nothing
    lmUsuarios.LeerUsuario UsuarioActivo.Codigo
    UsuarioActivo = lmUsuarios.cUsuario

    InstanciarAlmacenes

    Set SesionActiva = New clsSesionPOS
    Set Sesiones = New clsSesionesPOS

    If Not SesionActiva.IniciarSesion(UsuarioActivo.Codigo) Then
        dbHandle.Close
        End
    End If

    lrefPeriodo = Empresa.AnhoMes2Periodo(Year(Date), Month(Date))
    If (Empresa.PeriodoCurso < lrefPeriodo) Then
        If VerificarUsuario("Abrir nuevo periodo contable") < 5 Then
            End
        End If
        Empresa.ActualizarUltimoPeriodo lrefPeriodo
    End If

     mainForm.Caption = "CLEAR, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
'     Printer.Font.Name = "Courier New"
    
    Exit Sub
ErrHandler:
    If Err.Number = 3024 Then
        mAdvertencia "ERROR: No puedo localizar la Base de Datos" & Chr(13) & _
                     "en la ubicacin especificada... Por favor, intentelo de nuevo" & Chr(13) & _
                     "(" & BuildDataPath("bo01.mdb", AppName) & ")"
        SaveSetting AppName, "General", "DataDir", "UNDEF"
        sCommand = ""
        Resume CheckDataDir
    Else
        On Error GoTo 0
        Resume
    End If
End Sub


Sub Main()

    vslib.AppName = "ClearLight"
    Splash.Show 1
'    Load Splash
    Unload Splash
    
    CheckKey AppName
    Serial = vslib.Serial(GetSetting(AppName, "General", "Serial", "INVALIDA"))

    UsarVINVS = Val(GetSetting("ClearLight", "General", "UsarVINV", "0"))
    MontoServicioDelivery = Val(GetSetting("ClearLight", "General", "ValorDelivery", "0"))

    PrepararEntorno Command
    
    On Error Resume Next
    Set pScript = CreateObject("ScriptControl")
    If Err.Number <> 0 Then
      If Err.Number = 429 Then
        If MsgBox("Debe instalar el control de Scripts de Microsoft" & vbCrLf & _
                  "Si tiene el CD de instalacin, ejecute el programa sct10en.exe" & vbCrLf & _
                  "que encontrar en la carpeta \ServicePacks. De lo contrario," & vbCrLf & _
                  "deber descargarlo del sitio Web de Microsoft." & vbCrLf & _
                  "Pulse 'Aceptar' si quiere descargarlo ahora.", vbOKCancel + vbCritical, "ERROR: Componente no instalado") = vbYes Then
          ShellExecute mainForm.hwnd, vbNullString, "http://www.msdn.microsoft.com/downloads/sample.asp?url=/msdn-files/027/001/732/msdncompositedoc.xml", vbNullString, CurDir, 1
        End If
      Else
        MsgBox "Por favor reporte este error:" & vbCrLf & _
               "Numero: " & Err.Number & vbCrLf & _
               "Descripcion: " & Err.Description & vbCrLf & _
               "Ubicacion: mMain::CreateObject(ScriptControl)", vbCritical
      End If
      mAdvertencia "No fue posible iniciar el control de Scripts." & vbCrLf & "El soporte para esta caracterstica ser deshabilitado"
      Err.Clear
    Else
      pScript.Language = "VBScript"
      pScript.Reset
      Set pScriptPOS = CreateObject("ScriptControl")
      pScriptPOS.AddObject "Factoria", New CFactoria
      If mScriptExecute.LoadScriptFile("posExt.VBS", pScriptPOS) Then
        pScriptPOS.Run "Initialize"
      End If
    End If
    
    Set pDisplay = New CDisplay
    mainForm.Caption = "CLEAR, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
    mainForm.Show 0
    While mainForm.Visible: DoEvents: Wend
    Unload mainForm
    Set mainForm = Nothing
    DestruirAlmacenes

End Sub
