Attribute VB_Name = "mMain"
Option Explicit

Enum EstadosTrabajo
    LIBRE = 0
    ABIERTA = 1
    Cerrada = 2
End Enum

Enum TipoProceso
    TP_NO_PROCESAR = 0
    TP_ENTREGA_INMEDIATA = 1
    TP_ORDEN_DESPACHO = 2
    TP_ORDEN_TRANSPORTE = 3
End Enum

Public Const HIGH_VALUE = 999999999999#
Public Const TMB_CHEQUE = 0
Public Const TMB_DEPOSITO = 1
Public Const TMB_NCR = 2
Public Const TMB_NDB = 3

Public Declare Sub Sleep Lib "Kernel32" (ByVal dwMilliseconds As Long)
Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public MontoServicioDelivery As Currency
Public MaximoDescuento As Double
Public Contadores As CContadores

Public Serial As Long

Public AlmacenAmbientes As clsAlmacenAmbientes

Public AlmacenItemsVenta As clsAlmacenItemsVenta, _
        AlmacenAlternos As clsAlmacenAlternosItemVenta, _
        AlmacenComposiciones As clsAlmacenCompItemsVnt, _
        AlmacenItemsInventario As clsAlmacenItemsInventario, _
        AlmacenPrefijos As clsAlmacenPrefijos, _
        AlmacenClientes As clsAlmacenClientes, _
        AlmacenContactos As clsAlmacenContactos, _
        AlmacenVendedores As clsAlmacenVendedores, _
        AlmacenExUbic As clsAlmacenExUbic, _
        Almacenes As clsAlmacenes, _
        Empresa As clsParametrosEmpresa, _
        AlmacenProveedores As clsAlmacenProveedores

Public AlmacenCuentas As clsAlmacenCuentas
Public AlmacenComprobantes As clsAlmacenComprobantes

Public AlmacenDetallesItemInv As clsAlmacenDetallesItemInv, _
        AlmacenCompAlmacen As clsAlmacenCompAlmacen, _
        AlmacenMINVS As clsAlmacenDetallesItemInv, _
        AlmacenDetallesItemVenta As clsAlmacenDetallesItemVenta

Public AlmacenSaldosEntidad As clsAlmacenSaldosEntidad, _
        AlmacenDocumentosISPC As clsAlmacenDocumentosISPC, _
        AlmacenDetallesEntidad As clsAlmacenDetallesEntidad, _
        AlmacenVencimientosISPC As clsAlmacenVencISPC

Public Lineas As clsTablasCodigo

Public Zonas As clsTablasCodigo
Public TiposCliente As clsTablasCodigo

Public Condiciones As clsCondiciones
Public TiposImpuesto As clsTiposImpuesto

Public AlmacenSaldos As clsAlmacenSaldos
Public AlmacenDetalles As clsAlmacenDetalles

Public Sesiones As clsSesionesPOS
Public CuentasPOS As clsCuentasPOS

Public pfNav As Object

Public pDisplay As CDisplay

Public MontoRecibido As Currency, Vuelto As Currency    ' Para POS
Public SesionActiva As clsSesionPOS
Public pScriptPOS As Object

Public Function FormatoPrecios() As String
    FormatoPrecios = Empresa.MascaraPrecios
End Function

Public Function FormatoExistencia() As String
    FormatoExistencia = Empresa.MascaraCantidades
End Function

Private Sub InstanciarAlmacenes()
  Set AlmacenProveedores = New clsAlmacenProveedores
  Set Contadores = New CContadores
  Set AlmacenAmbientes = New clsAlmacenAmbientes
  Set AlmacenItemsVenta = New clsAlmacenItemsVenta
  Set AlmacenAlternos = New clsAlmacenAlternosItemVenta
  Set AlmacenComposiciones = New clsAlmacenCompItemsVnt
  Set AlmacenItemsInventario = New clsAlmacenItemsInventario
  Set AlmacenPrefijos = New clsAlmacenPrefijos
  Set AlmacenClientes = New clsAlmacenClientes
  Set AlmacenSaldos = New clsAlmacenSaldos
  Set AlmacenDetalles = New clsAlmacenDetalles
  Set Empresa = New clsParametrosEmpresa
  Set AlmacenContactos = New clsAlmacenContactos
  Set AlmacenVendedores = New clsAlmacenVendedores
  Set Almacenes = New clsAlmacenes
  Set AlmacenExUbic = New clsAlmacenExUbic
  Set TiposImpuesto = New clsTiposImpuesto
  Set Condiciones = New clsCondiciones
  Set AlmacenCompAlmacen = New clsAlmacenCompAlmacen
  Set AlmacenMINVS = New clsAlmacenDetallesItemInv
  Set AlmacenDetallesItemVenta = New clsAlmacenDetallesItemVenta
  Set AlmacenSaldosEntidad = New clsAlmacenSaldosEntidad
  Set AlmacenDocumentosISPC = New clsAlmacenDocumentosISPC
  Set AlmacenDetallesEntidad = New clsAlmacenDetallesEntidad
  Set AlmacenVencimientosISPC = New clsAlmacenVencISPC
  Set Lineas = New clsTablasCodigo: Lineas.SetTableName "Lineas", "Lineas de Inventario", "Linea de Inventario"
  Set Zonas = New clsTablasCodigo: Zonas.SetTableName "Zonas", "Zonas", "Zona"
  Set TiposCliente = New clsTablasCodigo: TiposCliente.SetTableName "TiposCliente", "Tipos de cliente", "Tipo de cliente"
  Set AlmacenCuentas = New clsAlmacenCuentas
  Set AlmacenComprobantes = New clsAlmacenComprobantes

End Sub

Private Sub DestruirAlmacenes()
  Set AlmacenCuentas = Nothing
  Set AlmacenComprobantes = Nothing
  Set Sesiones = Nothing
  Set TiposCliente = Nothing
  Set Zonas = Nothing
  Set Lineas = Nothing
  Set AlmacenVencimientosISPC = Nothing
  Set AlmacenDetallesEntidad = Nothing
  Set AlmacenDocumentosISPC = Nothing
  Set AlmacenSaldosEntidad = Nothing
  Set AlmacenMINVS = Nothing
  Set AlmacenCompAlmacen = Nothing
  Set Condiciones = Nothing
  Set TiposImpuesto = Nothing
  Set AlmacenExUbic = Nothing
  Set Almacenes = Nothing
  Set AlmacenVendedores = Nothing
  Set AlmacenContactos = Nothing
  Set Empresa = Nothing
  Set AlmacenClientes = Nothing
  Set AlmacenPrefijos = Nothing
  Set AlmacenItemsInventario = Nothing
  Set AlmacenDetallesItemVenta = Nothing
  Set AlmacenComposiciones = Nothing
  Set AlmacenAlternos = Nothing
  Set AlmacenItemsVenta = Nothing
  Set AlmacenDetalles = Nothing
  Set AlmacenSaldos = Nothing
  Set SesionActiva = Nothing
  Set AlmacenAmbientes = Nothing
  Set Contadores = Nothing
  Set AlmacenProveedores = Nothing
End Sub

Private Function VerificarDirectorioDatos() As Boolean
Dim stTemp As String, orgCancelError As Boolean
    
    stTemp = GetSetting(AppName:=AppName, Section:="General", Key:="DataDir", Default:="UNDEF")
    VerificarDirectorioDatos = True
    
    Exit Function

ErrHandler:
    If Err.Number = cdlCancel Then
        Err.Clear
        VerificarDirectorioDatos = False
        mainForm.CommonDialog1.CancelError = False
        Exit Function
    End If

    ReportarError True, Err.Number, Err.Description, "mMain::VerificarDirectorioDatos"
    End

End Function

Public Sub PrepararEntorno()
Dim fLogin As LFGetUser, lrefPeriodo As Long, sAlmacen As String

  DestruirAlmacenes
CheckDataDir:
  If Not VerificarDirectorioDatos Then
    If mainForm.Visible Then mainForm.Hide
    End
  End If

  On Error GoTo ErrHandler
  Set dbHandle = Workspaces(0).OpenDatabase(BuildDataPath("bo01.mdb", AppName))

  UsuarioActivo.Codigo = GetSetting("ClearLight", "General", "UserName", "")
  If UsuarioActivo.Codigo = "" Then
    mAdvertencia _
      "Debe utilizar el programa de configuracin del registro" & vbCrLf & _
      "para asignar un cdigo de usuario vlido a la variable ""UserName""" & vbCrLf & _
      "para poder usar este programa."
    End
  End If

  If Not lmUsuarios.LeerUsuario(UsuarioActivo.Codigo) Then
    mAdvertencia _
      "El Usuario " & UsuarioActivo.Codigo & " no est registrado." & vbCrLf & _
      "Por favor, cree su ficha desde ClearLight, o utilice el programa" & vbCrLf & _
      "de configuracin del registro para asignar un usuario existente."
    End
  End If
  UsuarioActivo = lmUsuarios.cUsuario

  InstanciarAlmacenes
    
  sAlmacen = GetSetting("ClearLight", "General", "AlmacenPOS", "")
  If Not Almacenes.ValidarAlmacen(sAlmacen) Then
  Dim fAlmacen As frmSelectAlmacen
    If sAlmacen = "" Then
      mAdvertencia "Debe definir el almacn de donde se descargarn las ventas de este equipo"
    Else
      mAdvertencia "El almacn " & sAlmacen & " es invlido. Debe definir uno nuevo."
    End If
    
    Set fAlmacen = New frmSelectAlmacen
    fAlmacen.Show vbModal
    If fAlmacen.bResult Then
      SaveSetting "ClearLight", "General", "AlmacenPOS", fAlmacen.Almacen
    Else
      dbHandle.Close
      End
    End If
    Unload fAlmacen
    Set fAlmacen = Nothing
  End If

  Set SesionActiva = New clsSesionPOS
  Set Sesiones = New clsSesionesPOS

  If Not SesionActiva.IniciarSesion(UsuarioActivo.Codigo) Then
    dbHandle.Close
    End
  End If

  lrefPeriodo = Empresa.AnhoMes2Periodo(Year(Date), Month(Date))
  If Empresa.UsaContabilidad Then
    If (Empresa.PeriodoCurso < lrefPeriodo) Then
      If VerificarUsuario("Abrir nuevo periodo contable") < 5 Then
        End
      End If
      Empresa.ActualizarUltimoPeriodo lrefPeriodo
    End If
  End If
  
  mainForm.Caption = "CLEAR, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
'     Printer.Font.Name = "Courier New"

  Exit Sub
ErrHandler:
  If Err.Number = 3024 Then
    mAdvertencia "ERROR: No puedo localizar la Base de Datos" & Chr(13) & _
                 "en la ubicacin especificada... Por favor, intentelo de nuevo" & Chr(13) & _
                 "(" & BuildDataPath("bo01.mdb", AppName) & ")"
    SaveSetting AppName, "General", "DataDir", "UNDEF"
    Resume CheckDataDir
  Else
    On Error GoTo 0
    Resume
  End If
End Sub

Sub Main()
Dim f As frmCasetaSalida
  
  vslib.AppName = "ClearLight"
  Splash.Show 1
  Unload Splash

  MontoServicioDelivery = Val(GetSetting("ClearLight", "General", "ValorDelivery", "0"))
  MaximoDescuento = Val(GetSetting("ClearLight", "General", "MaximoDescuento", "0"))

  If Not isKeyValid(GetSetting(AppName, "General", "Serial", "INVALIDA")) Then
      mAdvertencia "Clave de activacin invlida"
      End
  End If
  Serial = vslib.Serial(GetSetting(AppName, "General", "Serial", "INVALIDA"))
  
  PrepararEntorno
  
  mainForm.Caption = "CLEAR, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
  mainForm.Show 0

  On Error Resume Next
  Set pScript = CreateObject("ScriptControl")
  If Err.Number <> 0 Then
    If Err.Number = 429 Then
      If MsgBox("Debe instalar el control de Scripts de Microsoft" & vbCrLf & _
                "Si tiene el CD de instalacin, ejecute el programa sct10en.exe" & vbCrLf & _
                "que encontrar en la carpeta \ServicePacks. De lo contrario," & vbCrLf & _
                "deber descargarlo del sitio Web de Microsoft." & vbCrLf & _
                "Pulse 'Aceptar' si quiere descargarlo ahora.", vbOKCancel + vbCritical, "ERROR: Componente no instalado") = vbYes Then
        ShellExecute mainForm.hwnd, vbNullString, "http://www.msdn.microsoft.com/downloads/sample.asp?url=/msdn-files/027/001/732/msdncompositedoc.xml", vbNullString, CurDir, 1
      End If
    Else
      MsgBox "Por favor reporte este error:" & vbCrLf & _
             "Numero: " & Err.Number & vbCrLf & _
             "Descripcion: " & Err.Description & vbCrLf & _
             "Ubicacion: mMain::CreateObject(ScriptControl)", vbCritical
    End If
    mAdvertencia "No fue posible iniciar el control de Scripts." & vbCrLf & "El soporte para esta caracterstica ser deshabilitado" & vbCrLf & "Incluyendo la impresin de tickets de venta"
  Else
    pScript.Language = "VBScript"
    pScript.Reset
    Set pScriptPOS = CreateObject("ScriptControl")
    pScriptPOS.AddObject "Factoria", New CFactoria
    If mScriptExecute.LoadScriptFile("posExt.VBS", pScriptPOS) Then
      pScriptPOS.Run "Initialize"
    End If
  End If
  Set pDisplay = New CDisplay

  Set CuentasPOS = New clsCuentasPOS
  Set f = New frmCasetaSalida
  Load f

  If f.bIsOk Then ShowNonModal f
  
  Unload f
  Set f = Nothing
  Set CuentasPOS = Nothing

  Unload mainForm
  Set mainForm = Nothing
  
  If Not pScript Is Nothing Then
    pScript.Reset
    Set pScript = Nothing
  End If
  
  Set pDisplay = Nothing

  DestruirAlmacenes

End Sub

