Attribute VB_Name = "mMain"
Option Explicit

Enum EstadosTrabajo
    LIBRE = 0
    ABIERTA = 1
    Cerrada = 2
End Enum

Enum TipoProceso
    TP_NO_PROCESAR = 0
    TP_ENTREGA_INMEDIATA = 1
    TP_ORDEN_DESPACHO = 2
    TP_ORDEN_TRANSPORTE = 3
End Enum

Public Const HIGH_VALUE = 999999999999#
Public Const TMB_CHEQUE = 0
Public Const TMB_DEPOSITO = 1
Public Const TMB_NCR = 2
Public Const TMB_NDB = 3

Public Declare Sub Sleep Lib "Kernel32" (ByVal dwMilliseconds As Long)
Public MontoServicioDelivery As Currency

Public Serial As Long

Public AlmacenItemsVenta As clsAlmacenItemsVenta, _
        AlmacenAlternos As clsAlmacenAlternosItemVenta, _
        AlmacenComposiciones As clsAlmacenCompItemsVnt, _
        AlmacenItemsInventario As clsAlmacenItemsInventario, _
        AlmacenPrefijos As clsAlmacenPrefijos, _
        AlmacenClientes As clsAlmacenClientes, _
        AlmacenContactos As clsAlmacenContactos, _
        AlmacenVendedores As clsAlmacenVendedores, _
        AlmacenExUbic As clsAlmacenExUbic, _
        Almacenes As clsAlmacenes, _
        Empresa As clsParametrosEmpresa, _
        AlmacenAmbientes As clsAlmacenAmbientes

Public AlmacenCuentas As clsAlmacenCuentas
Public AlmacenComprobantes As clsAlmacenComprobantes

Public AlmacenDetallesItemInv As clsAlmacenDetallesItemInv, _
        AlmacenCompAlmacen As clsAlmacenCompAlmacen, _
        AlmacenMINVS As clsAlmacenDetallesItemInv, _
        AlmacenDetallesItemVenta As clsAlmacenDetallesItemVenta

Public AlmacenSaldosEntidad As clsAlmacenSaldosEntidad, _
        AlmacenDocumentosISPC As clsAlmacenDocumentosISPC, _
        AlmacenDetallesEntidad As clsAlmacenDetallesEntidad, _
        AlmacenVencimientosISPC As clsAlmacenVencISPC

Public Lineas As clsTablasCodigo

Public Zonas As clsTablasCodigo
Public TiposCliente As clsTablasCodigo

Public Condiciones As clsCondiciones
Public TiposImpuesto As clsTiposImpuesto

Public AlmacenSaldos As clsAlmacenSaldos
Public AlmacenDetalles As clsAlmacenDetalles

Public Sesiones As clsSesionesPOS
Public CuentasPOS As clsCuentasPOS

Public pfNav As Object

Public Tarjetas As clsTarjetas

Public poleEnabled As Boolean

Public MontoRecibido As Double, Vuelto As Double    ' Para POS
Public SesionActiva As clsSesionPOS

Public Function FormatoPrecios() As String
    
    FormatoPrecios = Empresa.MascaraPrecios

End Function

Public Function FormatoExistencia() As String
    
    FormatoExistencia = Empresa.MascaraCantidades

End Function

Private Sub InstanciarAlmacenes()
    Set AlmacenAmbientes = New clsAlmacenAmbientes
    Set AlmacenItemsVenta = New clsAlmacenItemsVenta
    Set AlmacenAlternos = New clsAlmacenAlternosItemVenta
    Set AlmacenComposiciones = New clsAlmacenCompItemsVnt
    Set AlmacenItemsInventario = New clsAlmacenItemsInventario
    Set AlmacenPrefijos = New clsAlmacenPrefijos
    Set AlmacenClientes = New clsAlmacenClientes
    Set AlmacenSaldos = New clsAlmacenSaldos
    Set AlmacenDetalles = New clsAlmacenDetalles
    Set Empresa = New clsParametrosEmpresa
    Set AlmacenContactos = New clsAlmacenContactos
    Set AlmacenVendedores = New clsAlmacenVendedores
    Set Almacenes = New clsAlmacenes
    Set AlmacenExUbic = New clsAlmacenExUbic
    Set TiposImpuesto = New clsTiposImpuesto
    Set Condiciones = New clsCondiciones
    Set AlmacenCompAlmacen = New clsAlmacenCompAlmacen
    Set AlmacenMINVS = New clsAlmacenDetallesItemInv
    Set AlmacenDetallesItemVenta = New clsAlmacenDetallesItemVenta
    Set AlmacenSaldosEntidad = New clsAlmacenSaldosEntidad
    Set AlmacenDocumentosISPC = New clsAlmacenDocumentosISPC
    Set AlmacenDetallesEntidad = New clsAlmacenDetallesEntidad
    Set AlmacenVencimientosISPC = New clsAlmacenVencISPC
    Set Lineas = New clsTablasCodigo: Lineas.SetTableName "Lineas", "Lineas de Inventario", "Linea de Inventario"
    Set Zonas = New clsTablasCodigo: Zonas.SetTableName "Zonas", "Zonas", "Zona"
    Set TiposCliente = New clsTablasCodigo: TiposCliente.SetTableName "TiposCliente", "Tipos de cliente", "Tipo de cliente"
    Set Tarjetas = New clsTarjetas
    Set AlmacenCuentas = New clsAlmacenCuentas
    Set AlmacenComprobantes = New clsAlmacenComprobantes

End Sub

Private Sub DestruirAlmacenes()
    Set AlmacenCuentas = Nothing
    Set AlmacenComprobantes = Nothing
    Set Tarjetas = Nothing
    Set Sesiones = Nothing
    Set TiposCliente = Nothing
    Set Zonas = Nothing
    Set Lineas = Nothing
    Set AlmacenVencimientosISPC = Nothing
    Set AlmacenDetallesEntidad = Nothing
    Set AlmacenDocumentosISPC = Nothing
    Set AlmacenSaldosEntidad = Nothing
    Set AlmacenMINVS = Nothing
    Set AlmacenCompAlmacen = Nothing
    Set Condiciones = Nothing
    Set TiposImpuesto = Nothing
    Set AlmacenExUbic = Nothing
    Set Almacenes = Nothing
    Set AlmacenVendedores = Nothing
    Set AlmacenContactos = Nothing
    Set Empresa = Nothing
    Set AlmacenClientes = Nothing
    Set AlmacenPrefijos = Nothing
    Set AlmacenItemsInventario = Nothing
    Set AlmacenDetallesItemVenta = Nothing
    Set AlmacenComposiciones = Nothing
    Set AlmacenAlternos = Nothing
    Set AlmacenItemsVenta = Nothing
    Set AlmacenDetalles = Nothing
    Set AlmacenSaldos = Nothing
    Set SesionActiva = Nothing
    Set AlmacenAmbientes = Nothing
End Sub

Private Function VerificarDirectorioDatos() As Boolean
Dim stTemp As String, orgCancelError As Boolean
    
    stTemp = GetSetting(AppName:=AppName, Section:="General", Key:="DataDir", Default:="UNDEF")
    VerificarDirectorioDatos = True
    
    Exit Function

ErrHandler:
    If Err.Number = cdlCancel Then
        Err.Clear
        VerificarDirectorioDatos = False
        mainForm.CommonDialog1.CancelError = False
        Exit Function
    End If

    ReportarError True, Err.Number, Err.Description, "mMain::VerificarDirectorioDatos"
    End

End Function

Public Sub PrepararEntorno()
Dim fLogin As LFGetUser, lrefPeriodo As Long

    DestruirAlmacenes
CheckDataDir:
    If Not VerificarDirectorioDatos Then
        If mainForm.Visible Then mainForm.Hide
        End
    End If

    On Error GoTo ErrHandler
    Set dbHandle = Workspaces(0).OpenDatabase(BuildDataPath("bo01.mdb", AppName))

    UsuarioActivo.Codigo = GetSetting("ClearLight", "General", "UserName", "")
    If UsuarioActivo.Codigo = "" Then
        mAdvertencia "Debe REGISTRAR el cdigo de usuario"
        End
    End If

    If Not lmUsuarios.LeerUsuario(UsuarioActivo.Codigo) Then
        mAdvertencia "Usuario no registrado"
        End
    End If
    UsuarioActivo = lmUsuarios.cUsuario

    InstanciarAlmacenes

    Set SesionActiva = New clsSesionPOS
    Set Sesiones = New clsSesionesPOS

    If Not SesionActiva.IniciarSesion(UsuarioActivo.Codigo) Then
        dbHandle.Close
        End
    End If

    lrefPeriodo = Empresa.AnhoMes2Periodo(Year(Date), Month(Date))
    If Empresa.UsaContabilidad Then
        If (Empresa.PeriodoCurso < lrefPeriodo) Then
            If VerificarUsuario("Abrir nuevo periodo contable") < 5 Then
                End
            End If
            Empresa.ActualizarUltimoPeriodo lrefPeriodo
        End If
    End If
    
    mainForm.Caption = "CLEAR, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
'     Printer.Font.Name = "Courier New"

    Exit Sub
ErrHandler:
    If Err.Number = 3024 Then
        mAdvertencia "ERROR: No puedo localizar la Base de Datos" & Chr(13) & _
                     "en la ubicacin especificada... Por favor, intentelo de nuevo" & Chr(13) & _
                     "(" & BuildDataPath("bo01.mdb", AppName) & ")"
        SaveSetting AppName, "General", "DataDir", "UNDEF"
        Resume CheckDataDir
    Else
        On Error GoTo 0
        Resume
    End If
End Sub

Sub Main()
Dim f As frmPOS

  vslib.AppName = "ClearLight"
  Splash.Show 1
  Unload Splash
  
  If Not isKeyValid(GetSetting(AppName, "General", "Serial", "INVALIDA")) Then
    mAdvertencia "Clave de activacin invlida"
    End
  End If
  Serial = vslib.Serial(GetSetting(AppName, "General", "Serial", "INVALIDA"))
  
  PrepararEntorno
  
  mainForm.Caption = "CLEAR, V" & App.Major & "." & App.Minor & "." & App.Revision & " - " & Empresa.NombreEmpresa
  mainForm.Show 0

  If Err.Number <> 0 Then
    If Err.Number = 429 Then
      If MsgBox("Debe instalar el control de Scripts de Microsoft" & vbCrLf & _
                "Si tiene el CD de instalacin, ejecute el programa sct10en.exe" & vbCrLf & _
                "que encontrar en la carpeta \ServicePacks. De lo contrario," & vbCrLf & _
                "deber descargarlo del sitio Web de Microsoft." & vbCrLf & _
                "Pulse 'Aceptar' si quiere descargarlo ahora.", vbOKCancel + vbCritical, "ERROR: Componente no instalado") = vbYes Then
        ShellExecute mainForm.hWnd, vbNullString, "http://www.msdn.microsoft.com/downloads/sample.asp?url=/msdn-files/027/001/732/msdncompositedoc.xml", vbNullString, CurDir, 1
      End If
    Else
      MsgBox "Por favor reporte este error:" & vbCrLf & _
             "Numero: " & Err.Number & vbCrLf & _
             "Descripcion: " & Err.Description & vbCrLf & _
             "Ubicacion: mMain::CreateObject(ScriptControl)", vbCritical
    End If
    mAdvertencia "No fue posible iniciar el control de Scripts." & vbCrLf & "El soporte para esta caracterstica ser deshabilitado"
  Else
    pScript.Language = "VBScript"
    pScript.Reset
  End If

  Set f = New frmPOS

  f.Show
  While f.Visible: DoEvents: Wend
  Unload f
  Set f = Nothing

  Unload mainForm
  Set mainForm = Nothing
  
  pScript.Reset
  Set pScript = Nothing
  DestruirAlmacenes

End Sub

