Attribute VB_Name = "mListaDiario"
' Este mdulo es una extensin no OO de clsListaMovsCuenta, agregada
' al vuelo para cumplir requerimiento del BCV.
Option Explicit

Const AnchoReporte = 153
Private isFirst As Boolean, totD As Double, totC As Double
Dim mstCuentaInicio As String, mstCuentaFinal As String, mlPeriodoInicio As Long, mlPeriodoFinal As Long

'Fecha    Cuenta      Ref.Comp Titulo Cuenta                            Concepto                                                 DEBE                HABER
'99/99/99 9.99.999.999.9 00000 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,###,##0.00 #,###,###,###,##0.00

Private Sub Encabezado(f As lfQuickView)
Dim sOut As String

    If isFirst Then
        isFirst = False
    Else
        If totD > 0 Or totC > 0 Then
            sOut = stFullLength("VAN ...", AnchoReporte - 41) & FormatNumero(totD, "#,###,###,###,##0.00", 20) & FormatNumero(totC, "#,###,###,###,##0.00", 21)
            f.Add sOut
        End If
        f.PageBreak
    End If
    f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    f.Add ""
    f.Add stMidAlign("Listado de movimientos por Fecha (Diario)", AnchoReporte)
    sOut = "Seleccin: "
    If mstCuentaInicio = "" And mstCuentaFinal <> "" Then
        sOut = sOut & "Hasta la cuenta " & mstCuentaFinal
    ElseIf mstCuentaInicio <> "" And mstCuentaFinal = "" Then
        sOut = sOut & "Desde la cuenta " & mstCuentaInicio
    ElseIf mstCuentaInicio = "" And mstCuentaFinal = "" Then
        sOut = "Todas las cuentas"
    Else
        sOut = "De la cuenta " & mstCuentaInicio & " a la cuenta " & mstCuentaFinal
    End If
    sOut = sOut & ". "
    sOut = stMidAlign(sOut & "Periodo: " & Str(mlPeriodoInicio) & " -" & Str(mlPeriodoFinal), AnchoReporte)
    f.Add sOut
    f.Add stRightAlign("Pagina" & Str(f.Pagina), AnchoReporte)
    f.Add ""
    f.Add String(AnchoReporte, "-")
    f.Add "Fecha    Cuenta      Ref.Comp Titulo Cuenta                            Concepto                                                 DEBE                HABER"
    f.Add String(AnchoReporte, "-")
    If totD > 0 Or totC > 0 Then
        sOut = stFullLength("...VIENEN", AnchoReporte - 41) & FormatNumero(totD, "#,###,###,###,##0.00", 20) & FormatNumero(totC, "#,###,###,###,##0.00", 21)
        f.Add sOut
    End If
End Sub

Public Sub GenerarListaDiario(stCuentaInicio As String, stCuentaFin As String, lPeriodoInicio As Long, lPeriodoFin As Long)
Dim rsHandle As Recordset, sqlQuery As String, stnComp As String, stnDet As String
Dim f As lfQuickView, instCuenta As clsCuenta, stOut As String, Deb As Double, Cred As Double

    mstCuentaInicio = stCuentaInicio
    mstCuentaFinal = stCuentaFin
    mlPeriodoInicio = lPeriodoInicio
    mlPeriodoFinal = lPeriodoFin
    isFirst = True
    stnComp = "Comprobantes"
    stnDet = "Detalles"
    sqlQuery = "SELECT " & stnDet & ".*, " & stnComp & ".Fecha, " & stnComp & ".CorrelativoPeriodo from " & stnDet & ", " & stnComp & " "
    sqlQuery = sqlQuery & "WHERE " & stnDet & ".RefPeriodo >=" & Str(lPeriodoInicio) & " AND " & stnDet & ".RefPeriodo <=" & Str(lPeriodoFin) & " "
    If stCuentaInicio <> "" Then
        sqlQuery = sqlQuery & " AND " & stnDet & ".Cuenta >='" & stCuentaInicio & "' "
        If stCuentaFin <> "" Then
            sqlQuery = sqlQuery & "AND "
        End If
    End If
    If stCuentaFin <> "" Then
        sqlQuery = sqlQuery & stnDet & ".Cuenta <= '" & stCuentaFin & "Z' "
    End If
    sqlQuery = sqlQuery & " AND " & stnComp & ".NumeroComprobante = " & stnDet & ".NumeroComprobante "
    sqlQuery = sqlQuery & " ORDER BY " & stnComp & ".Fecha, " & stnComp & ".Periodo, " & stnComp & ".CorrelativoPeriodo, " & stnDet & ".NumeroLinea;"
    
    Screen.MousePointer = vbHourglass
    Set rsHandle = dbHandle.Execute(sqlQuery)
    Screen.MousePointer = vbDefault

    With rsHandle
    If Not .BOF Then
        Screen.MousePointer = vbHourglass
        Set f = New lfQuickView
        f.SetReportWidth AnchoReporte
        f.Caption = "Lista de movimientos por fecha (Diario)"
        totD = 0#: totC = 0#
        Encabezado f
        Set instCuenta = New clsCuenta
        Do While Not .EOF
            If Not instCuenta.Load(.Fields("Cuenta")) Then
                instCuenta.Codigo = .Fields("Cuenta")
                instCuenta.Titulo = "DESAPARECIDA!"
            End If
            Deb = .Fields("Debe"): Cred = .Fields("Haber")
            stOut = Format(.Fields("Fecha"), "dd-mm-yy") & " "
            stOut = stOut & stFullLength(instCuenta.Codigo, 14) & " "
            stOut = stOut & Format(.Fields("CorrelativoPeriodo"), "00000") & " "
            stOut = stOut & stFullLength(instCuenta.Titulo, 40) & " "
            stOut = stOut & stFullLength(.Fields("Descripcion"), 40) & " "
            stOut = stOut & FormatNumero(Deb, "#,###,###,###,##0.00", 20) & " "
            stOut = stOut & FormatNumero(Cred, "#,###,###,###,##0.00", 20)
            If f.Linea > (f.LineasPagina - 5) Then Encabezado f
            f.Add stOut
            totD = totD + Deb: totC = totC + Cred
            .MoveNext
        Loop
        Set instCuenta = Nothing
        stOut = stFullLength("TOTAL", AnchoReporte - 41) & FormatNumero(totD, "#,###,###,###,##0.00", 20) & FormatNumero(totC, "#,###,###,###,##0.00", 21)
        f.Add String(AnchoReporte, "-")
        f.Add stOut
        Screen.MousePointer = vbDefault
        f.Show 0
        While f.Visible: DoEvents: Wend
        Unload f
        Set f = Nothing
    End If
    End With
    
    rsHandle.Close
    Set rsHandle = Nothing
End Sub

