Attribute VB_Name = "mKeyGenerator"
Option Explicit

Private Const Alfabeto As String = "LM4NK5JP3RH6UF2EV7WD1CX8YB0AZ9"

Private Function Transform(Base As Integer, liNumber As Long) As String
Dim sNextCh As String, sRetVal As String
Dim NextDiv As Long, iNextD As Integer, lCopia As Long

    lCopia = liNumber
    For NextDiv = 0 To 3
        iNextD = (lCopia Mod 30) + 1
        lCopia = lCopia \ 30
        iNextD = iNextD + Base
        If iNextD > 30 Then iNextD = iNextD - 30
        sNextCh = Mid(Alfabeto, iNextD, 1)
        sRetVal = sNextCh & sRetVal
    Next
    sRetVal = Mid(Alfabeto, Base, 1) & sRetVal
    Transform = sRetVal

End Function

Private Function Transform1(liNumber As Long) As String
Dim Base As Integer

    Base = 1 + Rnd * 30
    If Base > 30 Then Base = Base - 30
    Transform1 = Transform(Base, liNumber)

End Function

Private Function DeTransform(sKey As String, sExpr As String) As Long
Dim nKey As Integer, lRetVal As Long, nPos As Long, i As Integer, sChar As String

    nKey = InStr(1, Alfabeto, sKey)
    lRetVal = 0
    For i = 1 To Len(sExpr)
        sChar = Mid(sExpr, i, 1)
        nPos = InStr(1, Alfabeto, sChar) - 1
        nPos = nPos - nKey
        If nPos < 0 Then nPos = 30 + nPos
        lRetVal = lRetVal * 30 + nPos
    Next

    DeTransform = lRetVal

End Function

Private Function Detransform1(sExp As String) As Long
Dim sKey As String, sRest As String

    sKey = Left(sExp, 1)
    sRest = Right(sExp, Len(sExp) - 1)
    Detransform1 = DeTransform(sKey, sRest)

End Function

Private Function ClaveDerivada(sPart1 As String) As String
Dim sPart2 As String, Base As Integer, lNext As Long

    lNext = DeTransform(Left(sPart1, 1), Mid(sPart1, 4, 2))
    Do While (lNext < 27000)
        lNext = (lNext + 1) * 31
    Loop
    
    Base = InStr(1, Alfabeto, Left(sPart1, 1))
    sPart2 = Transform(Base, lNext)
    sPart2 = Right(sPart2, Len(sPart2) - 1)

    ClaveDerivada = sPart2

End Function

Public Function GenerateKey(lNumber As Long) As String
Dim sPart1 As String, sPart2 As String, lNext As Long
Dim Base As Integer

    sPart1 = Transform1(lNumber)
    sPart2 = ClaveDerivada(sPart1)
    GenerateKey = sPart1 & "-" & sPart2

End Function

Public Function isKeyValid(sKey As String) As Boolean
Dim sCopia As String, sPart1 As String, sPart2 As String
Dim posN As Integer

    sCopia = Trim(UCase(sKey))
    posN = InStr(1, sCopia, "-")
    If (posN <= 1) Then
        isKeyValid = False
        Exit Function
    End If

    If Len(sCopia) <> 10 Then
        isKeyValid = False
        Exit Function
    End If

    sPart1 = Left(sCopia, 5)
    sPart2 = Right(sCopia, 4)
    
    If sPart2 <> ClaveDerivada(sPart1) Then
        isKeyValid = False
    Else
        isKeyValid = True
    End If

End Function

Public Function Serial(sKey As String) As Long
Dim sPart1 As String, lResult As Long

    sPart1 = UCase(Left(sKey, 5))
    lResult = Detransform1(sPart1)
    If lResult > 27000 Then lResult = lResult - 27000 + 1

    Serial = lResult

End Function



#If Not isGenerate Then

Public Function CheckKey(AppName As String) As Boolean

    On Error Resume Next
    ExecWait "TestKey.exe " & AppName
    On Error GoTo 0

    If Not mKeyGenerator.isKeyValid(GetSetting(AppName, "General", "Serial", "INVALIDA")) Then
        mAdvertencia "Debe obtener una clave de activacin para usar el programa"
        CheckKey = False
    End If
    
    CheckKey = True

End Function

#End If

Public Function ActKey(strEmpresa As String, ByVal ilngSerial As Long) As Long
Dim lAcum As Long, i As Integer

    For i = 1 To Len(strEmpresa)
        lAcum = lAcum + (Asc(LCase(Mid(strEmpresa, i, 1))) Xor 127) * i
    Next

    lAcum = lAcum Mod 1001
    lAcum = lAcum * (ilngSerial + 27000)
    lAcum = lAcum Xor -1
    lAcum = Abs(lAcum)

    lAcum = lAcum / 1000
    lAcum = lAcum Mod 100000

    ActKey = lAcum

End Function

