Attribute VB_Name = "mCodigos"
Option Explicit

Function CodigoSubordinante(ByVal arg As String) As String
Dim p As Integer
    If Len(arg) < 3 Then    ' Un cdigo con uno o dos caracteres es una raiz
        CodigoSubordinante = ""
        Exit Function
    End If
    p = Len(arg) - 1
    Do While (Mid(arg, p, 1) <> Empresa.Separador) And (p > 1)
        p = p - 1
    Loop
    If p = 1 Then   ' Caso imposible
        CodigoSubordinante = ""
        Exit Function
    Else
        p = p - 1   ' Salta ltimo separador
    End If
    CodigoSubordinante = Left(arg, p)
End Function

Function EsSubordinado(ByVal Candidato As String, ByVal Subordinante As String) As Boolean
    If Len(Candidato) > Len(Subordinante) Then
        EsSubordinado = False
        Exit Function
    End If
    EsSubordinado = (Candidato = Left(Subordinante, Len(Candidato)))
End Function

Function NivelCuenta(ByVal Codigo As String) As Integer
Dim c As Integer, i As Integer, l As Integer
    c = 0: l = Len(Codigo)
    For i = 1 To l
        If Mid(Codigo, i, 1) = Empresa.Separador Then c = c + 1
    Next
    NivelCuenta = c + 1
End Function

Function ValidarEstructuraCodigo(Codigo As String, Mascara As String) As Boolean
Dim ci As String, cc As String, i As Integer, li As Integer, lc As Integer
Dim stc As String
    stc = Mascara
    li = Len(Codigo): lc = Len(stc)
    i = 1
    Do While i <= lc And i <= li
        ci = Mid(Codigo, i, 1)
        cc = Mid(stc, i, 1)
        If (cc = "9") Then
            If ci < "0" Or ci > "9" Then
                ValidarEstructuraCodigo = False
                Exit Function
            End If
        ElseIf (cc = "A") Then
            If (ci < "A" Or ci > "Z") And (ci <> "_") Then
                ValidarEstructuraCodigo = False
                Exit Function
            End If
        ElseIf (cc = "Z") Then
            If (ci < "A" Or ci > "Z") And (ci < "0" Or ci > "9") And (ci <> "_") Then
                ValidarEstructuraCodigo = False
                Exit Function
            End If
        Else
            If (ci <> cc) Then
                ValidarEstructuraCodigo = False
                Exit Function
            End If
        End If
        i = i + 1
    Loop
    
    If i <= lc Then
        cc = Mid(stc, i, 1)
        If (cc <> Empresa.Separador) Then
            ValidarEstructuraCodigo = False
            Exit Function
        End If
    End If
        
    ValidarEstructuraCodigo = True
End Function

Public Function MergeCodigoFormato(Codigo as String, Formato as String) As String
Dim Separador As String, _
    nCodigo As Integer, _
    nFormato As Integer, _
    nLen As Integer, _
    sRetVal As String, _
    nextChC As String, _
    nextChF As String
    
    Codigo = Trim(Codigo)
    Separador = Empresa.Separador
    nCodigo = 1: nFormato = 1: sRetVal = ""
    nLen = Len(Codigo): nCodigo = 1: nFormato = 1
    Do While nCodigo <= nLen
        nextChC = Mid(Codigo, nCodigo, 1)
        nextChF = Mid(Formato, nFormato, 1)
        If nextChC = Separador Then
            If nextChF = Separador Then
                sRetVal = sRetVal & nextChC
                nFormato = nFormato + 1
                nextChF = Mid(Formato, nFormato, 1)
            Else
                MergeCodigoFormato = sRetVal
                Exit Function
            End If
        Else
            If nextChF = Separador Then
                sRetVal = sRetVal & Separador
                nFormato = nFormato + 1
                nextChF = Mid(Formato, nFormato, 1)
            End If
            If (nextChF = "9" Or nextChF = "A") And nextChC >= "0" And nextChC <= "9" Then
                sRetVal = sRetVal & nextChC
                nFormato = nFormato + 1
            ElseIf (nextChF = "A" Or nextChF = "Z") And nextChC >= "A" And nextChC <= "Z" Then sRetVal = sRetVal & nextChC
                sRetVal = sRetVal & nextChC
                nFormato = nFormato + 1
            Else
                MergeCodigoFormato = sRetVal
                Exit Function
            End If
        End If
        nCodigo = nCodigo + 1
    Loop
    MergeCodigoFormato = sRetVal
End Function

